/*
**  support class for bspFile
**  (c) 1997 mike warren
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  (excuse the rather long ::read() inlined functions, but i didn't feel like
**   having lotsa .cc files :) )
**
*/


#ifndef _MODELS_H_
#define _MODELS_H_

#include "defines.h"
#include "mfile.h"
#include "vector.h"

class bspModel
{
  vector bboxMin;
  vector bboxMax;
  vector origin;
  int bspNodeId;		// root BSP node
  int clipNodeId0;		// first clip root node
  int clipNodeId1;		// second(?) clip root node
  int nodeId;			// unknown
  int numLeaves;
  int faceId;
  int faceNum;

  bspModel(){}

public:
  bspModel( mFile & mf ) { read( mf ); }
  ~bspModel(){}

  void read( mFile & mf ) { mf.readChunk( 24 ); origin.setx( mf.readLEfloat() ); origin.sety( mf.readLEfloat() ); origin.setz( mf.readLEfloat() ); bspNodeId=mf.readLEint(); clipNodeId0=mf.readLEint(); clipNodeId1=mf.readLEint(); nodeId=mf.readLEint(); numLeaves=mf.readLEint(); faceId=mf.readLEint(); faceNum=mf.readLEint(); }

  vector getBboxMin() { return bboxMin; }
  vector getBboxMax() { return bboxMax; }
  vector getOrigin() { return origin; }
  int getBspRoot() { return bspNodeId; }
  int getClipNodeRoot0() { return clipNodeId0; }
  int getClipNodeRoot1() { return clipNodeId1; }
  int getNode() { return nodeId; }
  int getNumLeaves() { return numLeaves; }
  int getFaceId() { return faceId; }
  int getFaceNum() { return faceNum; }

  void dump() { printf("%d %d %d\n", bspNodeId, faceId, faceNum ); }

};


class bspModels
{
  bspModel ** models;
  int loadedModels;

  bspModels(){}

public:

  bspModels( mFile & mf, int n ) { models=new bspModel*[ n ]; for( int i=0; i < n; i++) models[i]=0; loadedModels=0; read( mf, n ); }

  void read( mFile & mf, int n ) { for( int i=0; i < n; i++ ) models[i]=new bspModel( mf ); loadedModels=n; }

  bspModel * getModel( int x ) { if( x>=0 && x < loadedModels ) return models[x]; return 0; }
  int getNum() { return loadedModels; }

  void dump() { for( int i=0; i < loadedModels; i++) models[i]->dump(); }

};


#endif
  
