/*
**  MFILE class
**
**  (c) 1997 mike warren
**  encapsulates endianess convertion to/from files
**  compatible with .PAK file issues (i.e. minSize and maxSize)
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  TODO : allow writing ;)
**
*/


#include "mfile.h"

/*
**  ctor : opens file (or throw()s exception)
**
*/

mFile::mFile( char * fname, int min, int max )
{
#if !UNIX
  fd = open( fname, O_RDONLY|O_BINARY );
#else
  fd = open( fname, O_RDONLY );
#endif

  if( fd < 0 )
  {
#if !QTHROW
    perror("mFile::mFile()");
    exit( -1 );
#else
    throw( "mFile::mFile(): file open error" );
#endif
  }

  if( max != min )
    {
      minSize=min; 
      maxSize=max;
    }
  else
    {
      minSize=0;
      maxSize = determineSize();
    }

  setAbsoluteReadPos( minSize );

}

/*
**  setReadPos : sets position relative to beginning (minSize) of file
**
*/

void mFile::setReadPos( int x )
{ 
  if( x+minSize >= maxSize ) 
    {
      fprintf(stderr, "mFile::setReadPos(): %d beyond %d\n", x+minSize, maxSize);
      return; 
    }

  lseek( fd, (x+minSize), SEEK_SET ); 
  readPos=x+minSize; 
  refillBuffer(); 

}

/*
**  refillBuffer : does just that (checks for EOF, etc, comaptable with .PAK)
**
*/

int mFile::refillBuffer()
{ 
  int b = MF_BUFF_SIZE;
  if( (maxSize - readPos) < MF_BUFF_SIZE )
    b = (maxSize-readPos);

  bufferPointer=0; 
  bytesInBuff = read( fd, (char *)buff, b ); 

  if( bytesInBuff < 0 ) 
    {
      perror("mFile::refillBuffer()");
      return FALSE;
    } 
  
  if( bytesInBuff==0 || b == 0 ) 		// EOF
    {
      printf("mFile::refillBuffer(): EOF\n");
      return FALSE;
    }

  return TRUE;

}


/*
**  readByte : returns the next byte from buffer[]...refills buffer if needed
**
*/

unsigned char mFile::readByte()
{
  if( bufferPointer < bytesInBuff )
    {
      readPos++;
      return buff[ bufferPointer++ ];
    }

  if( !refillBuffer() )
    {
      if( isEOF() )
	return 0;
#if !QTHROW
      perror("mFile::readByte()");
      exit( -1 );
#else
      throw( "mFile::readByte(): file read error" );
#endif
    }
  
  readPos++;
  return buff[ bufferPointer++ ];
}

/*
**  determineSize : determines the size of the current file (MAKE SURE fd IS
**                  VALID BEFORE CALLING THIS)
**                  
*/

int mFile::determineSize()
{
  int r;

  r = (int)lseek( fd, 0, SEEK_END );

  return r;
}
  

  


/*
**  readChunk : reads a block of bytes
**
*/

unsigned char * mFile::readChunk( int n )
{
  unsigned char * p = new unsigned char[ n ];

  for( int i=0; i < n; i++ )
    if( (p[ i ] = readByte()) == 0 )
      if( isEOF() )
        break;

  return p;
}

/*
**  read{LE|BE}<type> functions return the number in the native machine's
**  endianess, assuming it is in {LE|BE} form in the file.
**
**  i.e. readLEint() returns an integer in this machines correct format on
**  the assumption it is in little-endian format in the file
**
*/

int mFile::readLEint()
{
#ifdef QBIG_ENDIAN
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
#else
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
#endif
  
  return *((int *)t1);
}

int mFile::readBEint()
{
#ifdef QBIG_ENDIAN
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
#else
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
#endif

  return *((int *)t1);
}

short mFile::readLEshort()
{
#ifdef QBIG_ENDIAN
  t1[1] = readByte();
  t1[0] = readByte();
#else
  t1[0] = readByte();
  t1[1] = readByte();
#endif

  return *(( short * ) t1 );
}

unsigned short mFile::readLEushort()
{
#ifdef QBIG_ENDIAN
  t1[1] = readByte();
  t1[0] = readByte();
#else
  t1[0] = readByte();
  t1[1] = readByte();
#endif

  return *((unsigned short * ) t1 );
}

short mFile::readBEshort()
{
#ifdef QBIG_ENDIAN
  t1[0] = readByte();
  t1[1] = readByte();
#else
  t1[1] = readByte();
  t1[0] = readByte();
#endif

  return *((short *)t1);
}

unsigned short mFile::readBEushort()
{
#ifdef QBIG_ENDIAN
  t1[0] = readByte();
  t1[1] = readByte();
#else
  t1[1] = readByte();
  t1[0] = readByte();
#endif

  return *((unsigned short *)t1);
}

float mFile::readLEfloat()
{
#ifdef QBIG_ENDIAN
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
#else
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
#endif

  return *((float *)t1);
}

float mFile::readBEfloat()
{
#ifdef QBIG_ENDIAN
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
#else
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
#endif
  
  return *((float *)t1);
}
