/*
**
**  global defines 
**  mikeBot 
**  (c) 1997, mike warren
**
**  make sure QBIG_ENDIAN and QLITTLE_ENDIAN are #defined correctly. Also 
**  ensure that UNIX, AIX, and WIN32 are #defined appropriatly for your system
**  (if you are on AIX, make sure *BOTH* UNIX and AIX are #defined to 1
**
**  QTHROW, if TRUE, enables throw()'s from (mainly) qsocket; make sure your
**  compiler knows about these (gcc needs -fhandle-exceptions)
**
**  #undef DEBUG, or #define DEBUG 0 to turn off all debug code. (recommended,
**  since this spews out a *lot* of information)
**
*/


#ifndef _DEFINES_H_
#define _DEFINES_H_

#include <stdlib.h>

#define UNIX 1			// machine type
#define AIX 0			// (AIX is a type of unix)
#define WIN 0			// windows 95

				// if none of WIN, UNIX or AIX is #defined
				// to any value, DOS is assumed


#if WIN
#undef QBIG_ENDIAN		// PC's are QLITTLE_ENDIAN
#undef MBIG_ENDIAN
#else
#define QBIG_ENDIAN
#define MBIG_ENDIAN
#endif

#if WIN
#include <io.h>
#define read _read
#define write _write
#define close _close
#define open _open
#define dup _dup
#endif


#define Q_MAX_STRING 1024	// pretty arbitrary; i think this is UNIX max
				// path length, too, though

#define QTHROW 0		// throw exceptions or not


#define MBOT_VERSION    "0.01"
#define MB_VEL           100.0	// mbot's target velocity CHANGE ME TO VAR.

		// qpacket defines

#define QP_MAX_PACKET_DATA 	 1032	// 8 bytes header, plus 1024 max data

		// qcs defines


#define QCS_MAX_TIMEOUTS         5	// times to retry when connect()ing
#define QCS_DEFAULT_SERVER	"0.0.0.0"
#define QCS_DEFAULT_PORT	 26000
#define QCS_MAX_MODELS           255	// don't change this; id's hard limit
#define QCS_MAX_SOUNDS           255	// don't change these; id hard limits
#define QCS_MAX_ENTITIES	 450	// nor this.
#define QCS_FRAGMENT_BUFFER      10240	// size of fragment buffer in QCS
#define QCS_MAX_WAIT             2	// seconds to try on each connect() ( * QCS_MAX_TIMEOUTS)
#define QCS_RECONNECT_STRING	"reconnect."
#define QCS_MAX_PLAYERS		 16	// and id said "unlimited" :)

#define QCS_BOT_NAME		"-=mikeBot=-"
#define QCS_BOT_COLORS	        "3 3"
#define QCS_GREETING1		"mikeBot version "MBOT_VERSION""
#define QCS_GREETING2		"www.ucalgary.ca/~mbwarren/mikeBot/"
#define QCS_GREETING3		"mbwarren@acs.ucalgary.ca"


				// indexs into playerstate array

#define PS_AMMO    3
#define PS_HEALTH 0
#define PS_CELLS 9
#define PS_SHELLS 6
#define PS_ROCKETS 8
#define PS_NAILS 7
#define PS_WEAPON 10
#define PS_ARMOR 4

				// for BSP loading stuff

#define BSPD_ENTITIES 0
#define BSPD_PLANES 1
#define BSPD_TEXTURES 2
#define BSPD_VERTICES 3
#define BSPD_VISILIST 4
#define BSPD_NODES 5
#define BSPD_TEXINFO 6
#define BSPD_FACES 7
#define BSPD_LIGHTMAPS 8
#define BSPD_CLIPNODES 9
#define BSPD_LEAVES 10
#define BSPD_FACELIST 11
#define BSPD_EDGES 12
#define BSPD_EDGELIST 13
#define BSPD_MODELS 14


#define BSP_PLANE_SIZE 20
#define BSP_VERTEX_SIZE 12
#define BSP_NODE_SIZE 24
#define BSP_FACE_SIZE 20
#define BSP_CLIPNODE_SIZE 8
#define BSP_LEAF_SIZE 28
#define BSP_FACELIST_SIZE 2
#define BSP_EDGELIST_SIZE 4
#define BSP_EDGE_SIZE 4
#define BSP_MODEL_SIZE 64
#define BSP_FACE_SIZE 20
#define BSP_ENTITY_SIZE 1

#define QACK_MAX                10 // max packets in ack queue
#define QACK_MAX_TIMEOUT        4000 


#ifndef TRUE
#define FALSE 0
#define TRUE !FALSE
#endif

		// debugging defines


#define DQP 	1		// debuging qpacket
#define DQS	2		// debuging qsocket
#define DQCS    4		// debuging qcs
#define DQACK   8		// ack queue
#define DMBF    16		// mbfire
#define DMBN    32		// mbnav
#define DMB     64		// mbot
#define DQX     128		// qproxy

		// (bitwise) OR together the things to be debuged

#define DEBUG  (DQX)



/*
**   prototypes
**
*/

extern void parseName( unsigned char * );
extern void printDefines();

#endif
