#define	API_OFS(x)	(int)&(((ModuleExchange *)0)->x)
#define Run_v(x) PLUGIN_v(API_OFS(x))
#define Run_q_et_pc(x, y, z) PLUGIN_qb_et_pc(API_OFS(x), y, z)

/* Structure of Function Pointers */
typedef struct MODULE_EXCHANGE	ModuleExchange;

/**********************************************************
 * MODULE_EXCHANGE
 *	
 *	Pointers and variables exchanged between the main game
 *	and modules.
 *	
 * This structure contains pointers to all of the main game
 * functions. None have been excluded. Fortunately, though
 * it looks like a LOT of stuff, it's just a single pointer
 * that is passed for the structure :)
 *********************************************************/
struct MODULE_EXCHANGE {
	/*******************************************************
	 *                 --===IMPORTANT===--                 *
	 * Do *NOT* modify this structure. It will break the   *
	 * module in the worst way. The macro above,           *
	 * shamelessy borrowed from id's FOFS() macro,         *
	 * determines the function's address within the        * 
	 * structure. The plugin module uses an identical      *
	 * structure for passing these functions around.       *
	 ******************************************************/
	int				iAPIVersion;				// Plugin API Version, this is set by the game shared lib
	int				iModVersion;				// Module API Version, this is set by the module
	char				*pcLibName;					// Keep track of what has already been loaded, set by game lib
	char				*pcModName;
	ModuleExchange	*NextAPI;
	
	game_import_t  gi;
	level_locals_t *level;
	game_export_t	*globals;
	game_locals_t	*game;
	gitem_t			*itemlist;

	void				(*PLUGIN_GetItemList)(gitem_t *);
	void           (*Init)(void);
	void           (*ShutDown)(void);

	qboolean       (*ClientConnect)(edict_t *peEnt, char *pcUserInfo);
	void           (*ClientBegin)(edict_t *peEnt);
	void           (*ClientUserInfoChanged)(edict_t *peEnt, char *pcUserInfo);
	void           (*ClientDisconnect)(edict_t *peEnt);
	void           (*ClientCommand)(edict_t *peEnt);
	void           (*ClientThink)(edict_t *peEnt, usercmd_t *pcmdCmd);
	void           (*RunFrame)(void);
	void           (*ServerCommand)(void);

	// From the quake2 engine itself
	// game_import_t  *giEngine;
	/**********************************************************
	 * g_utils.c
	 **********************************************************/
	// functions from g_utils.c
	void           (*G_ProjectSource)(vec3_t v3Point, vec3_t v3Distance, vec3_t v3Forward, vec3_t v3Right, vec3_t v3Result);
	edict_t        *(*G_Find)(edict_t *peFrom, int iFieldOffset, char *pcMatch);
	edict_t        *(*findradius)(edict_t *peFrom, vec3_t v3Origin, float fRadius);
	edict_t        *(*G_PickTarget)(char *pcTargetName);
	void           (*Think_Delay)(edict_t *peEntity);
	void           (*G_UseTargets)(edict_t *peEntity, edict_t *peActivator);
	float          *(*tv)(float fX, float fY, float fZ);  // TempVector
	char           *(*vtos)(vec3_t v3Vector); // VectorToString
	void           (*G_SetMovedir)(vec3_t v3Angles, vec3_t v3Movedir);
	float          (*vectoyaw)(vec3_t v3Vector);
	void           (*vectoangles)(vec3_t v3Vector, vec3_t v3Angles);
	char           *(*G_CopyString)(char *pcIn);
	void           (*G_InitEdict)(edict_t *peEdict);
	edict_t        *(*G_Spawn)(void);
	void           (*G_FreeEdict)(edict_t *peEdict);
	void           (*G_TouchTriggers)(edict_t *peEntity);
	void           (*G_TouchSolids)(edict_t *peEntity);
	qboolean       (*KillBox)(edict_t *peEntity);

	/***********************************************************
	  * g_items.c
	  *********************************************************/
	// globals
	void           (*PrecacheItem) (gitem_t *it);
	void           (*InitItems) (void);
	void           (*SetItemNames) (void);
	gitem_t        *(*FindItem) (char *pickup_name);
	gitem_t        *(*FindItemByClassname) (char *classname);
	edict_t        *(*Drop_Item) (edict_t *ent, gitem_t *item);
	void           (*SetRespawn) (edict_t *ent, float delay);
	void           (*ChangeWeapon) (edict_t *ent);
	void           (*SpawnItem) (edict_t *ent, gitem_t *item);
	void           (*Think_Weapon) (edict_t *ent);
	int            (*ArmorIndex) (edict_t *ent);
	int            (*PowerArmorType) (edict_t *ent);
	gitem_t        *(*GetItemByIndex) (int index);
	qboolean       (*Add_Ammo) (edict_t *ent, gitem_t *item, int count);
	void           (*Touch_Item) (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
	// local declarations in g_itemc.c
	qboolean       (*Pickup_Weapon) (edict_t *ent, edict_t *other);
	void           (*Use_Weapon) (edict_t *ent, gitem_t *inv);
	void           (*Drop_Weapon) (edict_t *ent, gitem_t *inv);
	void           (*Weapon_Blaster) (edict_t *ent);
	void           (*Weapon_Shotgun) (edict_t *ent);
	void           (*Weapon_SuperShotgun) (edict_t *ent);
	void           (*Weapon_Machinegun) (edict_t *ent);
	void           (*Weapon_Chaingun) (edict_t *ent);
	void           (*Weapon_HyperBlaster) (edict_t *ent);
	void           (*Weapon_RocketLauncher) (edict_t *ent);
	void           (*Weapon_Grenade) (edict_t *ent);
	void           (*Weapon_GrenadeLauncher) (edict_t *ent);
	void           (*Weapon_Railgun) (edict_t *ent);
	void           (*Weapon_BFG) (edict_t *ent);
	void 				(*Use_Quad) (edict_t *ent, gitem_t *item);
	
	int  				*quad_drop_timeout_hack;
	int     			*jacket_armor_index;
	int     			*combat_armor_index;
	int     			*body_armor_index;
	int     			*power_screen_index;
	int     			*power_shield_index;

	/**********************************************************
	 * g_cmds.c
	 *********************************************************/
	// g_cmds.c globals
	void           (*Cmd_Help_f) (edict_t *ent);
	void           (*Cmd_Score_f) (edict_t *ent);

	// g_cmds.c internals
	char           *(*ClientTeam) (edict_t *ent);
	qboolean       (*OnSameTeam) (edict_t *ent1, edict_t *ent2);
	void           (*SelectNextItem) (edict_t *ent, int itflags);
	void           (*SelectPrevItem) (edict_t *ent, int itflags);
	void           (*ValidateSelectedItem) (edict_t *ent);
	void           (*Cmd_Give_f) (edict_t *ent);
	void           (*Cmd_God_f) (edict_t *ent);
	void           (*Cmd_Notarget_f) (edict_t *ent);
	void           (*Cmd_Noclip_f) (edict_t *ent);
	void           (*Cmd_Use_f) (edict_t *ent);
	void           (*Cmd_Drop_f) (edict_t *ent);
	void           (*Cmd_Inven_f) (edict_t *ent);
	void           (*Cmd_InvUse_f) (edict_t *ent);
	void           (*Cmd_WeapPrev_f) (edict_t *ent);
	void           (*Cmd_WeapNext_f) (edict_t *ent);
	void           (*Cmd_WeapLast_f) (edict_t *ent);
	void           (*Cmd_InvDrop_f) (edict_t *ent);
	void           (*Cmd_Kill_f) (edict_t *ent);
	void           (*Cmd_PutAway_f) (edict_t *ent);
	void           (*Cmd_Players_f) (edict_t *ent);

	void           (*Cmd_Wave_f) (edict_t *ent);
	void           (*Cmd_Say_f) (edict_t *ent, qboolean team, qboolean arg0);
	/**********************************************************
	 * g_combat,c
	 *********************************************************/
	// g_combat.c globals
	qboolean       (*CanDamage) (edict_t *targ, edict_t *inflictor);
	void           (*T_Damage) (edict_t *targ, edict_t *inflictor, edict_t *attacker, vec3_t dir, vec3_t point, vec3_t normal, int damage, int knockback, int dflags, int mod);
	void           (*T_RadiusDamage) (edict_t *inflictor, edict_t *attacker, float damage, edict_t *ignore, float radius, int mod);
	
	// g_combat.c internals
	void           (*Killed) (edict_t *targ, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void           (*SpawnDamage) (int type, vec3_t origin, vec3_t normal, int damage);
	int     			(*CheckPowerArmor) (edict_t *ent, vec3_t point, vec3_t normal, int damage, int dflags);
	int     			(*CheckArmor) (edict_t *ent, vec3_t point, vec3_t normal, int damage, int te_sparks, int dflags);
	void           (*M_ReactToDamage) (edict_t *targ, edict_t *attacker);
	qboolean       (*CheckTeamDamage) (edict_t *targ, edict_t *attacker);

	/**********************************************************
	 * g_monster.c
	 *********************************************************/
	// g_monster.c globals
	void           (*monster_fire_bullet) (edict_t *self, vec3_t start, vec3_t dir, int damage, int kick, int hspread, int vspread, int flashtype);
	void           (*monster_fire_shotgun) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int flashtype);
	void           (*monster_fire_blaster) (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int flashtype, int effect);
	void           (*monster_fire_grenade) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, int flashtype);
	void           (*monster_fire_rocket) (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int flashtype);
	void           (*monster_fire_railgun) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int flashtype);
	void           (*monster_fire_bfg) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, int kick, float damage_radius, int flashtype);
	void           (*M_droptofloor) (edict_t *ent);
	void           (*monster_think) (edict_t *self);
	void           (*walkmonster_start) (edict_t *self);
	void           (*swimmonster_start) (edict_t *self);
	void           (*flymonster_start) (edict_t *self);
	void           (*AttackFinished) (edict_t *self, float time);
	void           (*monster_death_use) (edict_t *self);
	void           (*M_CatagorizePosition) (edict_t *ent);
	qboolean       (*M_CheckAttack) (edict_t *self);
	void           (*M_FlyCheck) (edict_t *self);
	void           (*M_CheckGround) (edict_t *ent);

	// g_monster.c internals
	void    			(*M_FliesOff) (edict_t *self);
	void    			(*M_FliesOn) (edict_t *self);
	void           (*M_WorldEffects) (edict_t *ent);
	void           (*M_SetEffects) (edict_t *ent);
	void           (*M_MoveFrame) (edict_t *self);
	void           (*monster_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*monster_start_go) (edict_t *self);
	void           (*monster_triggered_spawn) (edict_t *self);
	void           (*monster_triggered_spawn_use) (edict_t *self, edict_t *other, edict_t *activator);
	qboolean       (*monster_start) (edict_t *self);
	void           (*walkmonster_start_go) (edict_t *self);
	void           (*flymonster_start_go) (edict_t *self);
	void           (*swimmonster_start_go) (edict_t *self);

	/**********************************************************
	 * g_misc.c
	 *********************************************************/
	// g_misc.c globals
	void           (*ThrowHead) (edict_t *self, char *gibname, int damage, int type);
	void           (*ThrowClientHead) (edict_t *self, int damage);
	void           (*ThrowGib) (edict_t *self, char *gibname, int damage, int type);
	void           (*BecomeExplosion1)(edict_t *self);
	// g_misc.c internals
	void           (*Use_Areaportal) (edict_t *ent, edict_t *other, edict_t *activator);
	void           (*SP_func_areaportal) (edict_t *ent);
	void           (*VelocityForDamage) (int damage, vec3_t v);
	void           (*ClipGibVelocity) (edict_t *ent);
	void           (*gib_think) (edict_t *self);
	void           (*gib_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*gib_die) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void           (*debris_die) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void           (*BecomeExplosion2) (edict_t *self);
	void           (*path_corner_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*SP_path_corner) (edict_t *self);
	void           (*point_combat_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*SP_point_combat) (edict_t *self);
	void			   (*light_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_light) (edict_t *self);
	void           (*func_wall_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_func_wall) (edict_t *self);
	void           (*func_object_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*func_object_release) (edict_t *self);
	void           (*func_object_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_func_object) (edict_t *self);
	void           (*func_explosive_explode) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void           (*func_explosive_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*func_explosive_spawn) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_func_explosive) (edict_t *self);
	void           (*barrel_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*barrel_explode) (edict_t *self);
	void           (*barrel_delay) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void           (*SP_misc_explobox) (edict_t *self);
	void           (*misc_blackhole_use) (edict_t *ent, edict_t *other, edict_t *activator);
	void           (*misc_blackhole_think) (edict_t *self);
	void           (*SP_misc_blackhole) (edict_t *ent);
	void           (*misc_eastertank_think) (edict_t *self);
	void           (*SP_misc_eastertank) (edict_t *ent);
	void           (*misc_easterchick_think) (edict_t *self);
	void           (*SP_misc_easterchick) (edict_t *ent);
	void           (*misc_easterchick2_think) (edict_t *self);
	void           (*SP_misc_easterchick2) (edict_t *ent);
	void           (*commander_body_think) (edict_t *self);
	void           (*commander_body_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*commander_body_drop) (edict_t *self);
	void           (*SP_monster_commander_body) (edict_t *self);
	void           (*misc_banner_think) (edict_t *ent);
	void           (*SP_misc_banner) (edict_t *ent);
	void           (*misc_deadsoldier_die) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void           (*SP_misc_deadsoldier) (edict_t *ent);
	void           (*misc_viper_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_misc_viper) (edict_t *ent);
	void           (*SP_misc_bigviper) (edict_t *ent);
	void           (*misc_viper_bomb_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*misc_viper_bomb_prethink) (edict_t *self);
	void           (*misc_viper_bomb_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_misc_viper_bomb) (edict_t *self);
	void           (*misc_strogg_ship_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_misc_strogg_ship) (edict_t *ent);
	void           (*misc_satellite_dish_think) (edict_t *self);
	void           (*misc_satellite_dish_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_misc_satellite_dish) (edict_t *ent);
	void           (*SP_light_mine1) (edict_t *ent);
	void           (*SP_light_mine2) (edict_t *ent);
	void           (*SP_misc_gib_arm) (edict_t *ent);
	void           (*SP_misc_gib_leg) (edict_t *ent);
	void           (*SP_misc_gib_head) (edict_t *ent);
	void           (*SP_target_character) (edict_t *self);
	void           (*target_string_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_target_string) (edict_t *self);
	void    			(*func_clock_reset) (edict_t *self);
	void    			(*func_clock_format_countdown) (edict_t *self);
	void           (*func_clock_think) (edict_t *self);
	void           (*func_clock_use) (edict_t *self, edict_t *other, edict_t *activator);
	void           (*SP_func_clock) (edict_t *self);
	void           (*teleporter_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*SP_misc_teleporter) (edict_t *ent);
	void           (*SP_misc_teleporter_dest) (edict_t *ent);
	/**********************************************************
	 * g_ai.c
	 *********************************************************/
	// g_ai,c globals
	void           (*AI_SetSightClient) (void);
	void           (*ai_stand) (edict_t *self, float dist);
	void           (*ai_move) (edict_t *self, float dist);
	void           (*ai_walk) (edict_t *self, float dist);
	void           (*ai_turn) (edict_t *self, float dist);
	void           (*ai_run) (edict_t *self, float dist);
	void           (*ai_charge) (edict_t *self, float dist);
	int            (*range) (edict_t *self, edict_t *other);
	void           (*FoundTarget) (edict_t *self);
	qboolean       (*infront) (edict_t *self, edict_t *other);
	qboolean       (*visible) (edict_t *self, edict_t *other);
	qboolean       (*FacingIdeal)(edict_t *self);
	// g_ai.c internals
	qboolean       (*FindTarget) (edict_t *self);
	void           (*HuntTarget) (edict_t *self);
	void           (*ai_run_melee) (edict_t *self);
	void           (*ai_run_missile) (edict_t *self);
	void           (*ai_run_slide) (edict_t *self, float distance);
	qboolean       (*ai_checkattack) (edict_t *self, float dist);

	qboolean       *enemy_vis;
	qboolean       *enemy_infront;
	int            *enemy_range;
	float          *enemy_yaw;
	
	/**********************************************************
	 * g_weapon.c
	 *********************************************************/
	// g_weapon.c globals
	void           (*ThrowDebris) (edict_t *self, char *modelname, float speed, vec3_t origin);
	qboolean       (*fire_hit) (edict_t *self, vec3_t aim, int damage, int kick);
	void           (*fire_bullet) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int mod);
	void           (*fire_shotgun) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int mod);
	void           (*fire_blaster) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, int effect, qboolean hyper);
	void           (*fire_grenade) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
	void           (*fire_grenade2) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held);
	void           (*fire_rocket) (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage);
	void           (*fire_rail) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick);
	void           (*fire_bfg) (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius);
	void	    		(*check_dodge) (edict_t *self, vec3_t start, vec3_t dir, int speed);
	void    			(*fire_lead) (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int te_impact, int hspread, int vspread, int mod);
	void           (*blaster_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void    			(*Grenade_Explode) (edict_t *ent);
	void    			(*Grenade_Touch) (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*rocket_touch) (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*bfg_explode) (edict_t *self);
	void           (*bfg_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void           (*bfg_think) (edict_t *self);
	/**********************************************************
	 * p_trail.c
	 *********************************************************/
	// p_trail.c globals
	void           (*PlayerTrail_Init) (void);
	void           (*PlayerTrail_Add) (vec3_t spot);
	void           (*PlayerTrail_New) (vec3_t spot);
	edict_t        *(*PlayerTrail_PickFirst) (edict_t *self);
	edict_t        *(*PlayerTrail_PickNext) (edict_t *self);
	edict_t        *(*PlayerTrail_LastSpot) (void);

	/**********************************************************
	 * p_client.c
	 *********************************************************/
	void           (*respawn) (edict_t *ent);
	void           (*BeginIntermission) (edict_t *targ);
	void           (*PutClientInServer) (edict_t *ent);
	void           (*InitClientPersistant) (gclient_t *client);
	void           (*InitClientResp) (gclient_t *client);
	void           (*InitBodyQue) (void);
	void           (*ClientBeginServerFrame) (edict_t *ent);
	
	// p_client.c internals
	void           (*player_pain) (edict_t *self, edict_t *other, float kick, int damage);
	void           (*player_die) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);

	/**********************************************************
	 * p_view.c
	 *********************************************************/
	// p_view.c globals
	float				(*SV_CalcRoll) (vec3_t angles, vec3_t velocity);
	void           (*P_DamageFeedback) (edict_t *player);
	void           (*SV_CalcViewOffset) (edict_t *ent);
	void           (*SV_CalcGunOffset) (edict_t *ent);
	void           (*SV_AddBlend) (float r, float g, float b, float a, float *v_blend);
	void           (*SV_CalcBlend) (edict_t *ent);
	void           (*P_FallingDamage) (edict_t *ent);
	void           (*P_WorldEffects) (void);
	void           (*G_SetClientEffects) (edict_t *ent);
	void           (*G_SetClientEvent) (edict_t *ent);
	void           (*G_SetClientSound) (edict_t *ent);
	void           (*G_SetClientFrame) (edict_t *ent);
	void 				(*ClientEndServerFrame) (edict_t *ent);
	edict_t     	*current_player;
	gclient_t   	*current_client;
	vec3_t   		*forward;
	vec3_t			*right;
	vec3_t			*up;
	float          *xyspeed;
	float          *bobmove;
	int            *bobcycle;      // odd cycles are right foot going forward
	float          *bobfracsin;    // sin(bobfrac*M_PI)

	/**********************************************************
	 * p_hud.c
	 *********************************************************/
	// p_hud.c globals
	void           (*MoveClientToIntermission) (edict_t *client);
	void           (*G_SetStats) (edict_t *ent);
	void           (*DeathmatchScoreboardMessage) (edict_t *client, edict_t *killer);

	// p_hud.c internals
	void           (*DeathmatchScoreboard) (edict_t *ent);
	void           (*HelpComputer) (edict_t *ent);

	/**********************************************************
	 * p_weapon.c
	 *********************************************************/
	// p_pweapon.c globals
	void           (*PlayerNoise)(edict_t *who, vec3_t where, int type);

	// p_weapon.c internals
	void    			(*P_ProjectSource) (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
	void           (*NoAmmoWeaponChange) (edict_t *ent);
	void           (*Weapon_Generic) (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent));
	void           (*weapon_grenade_fire) (edict_t *ent, qboolean held);
	void           (*weapon_grenadelauncher_fire) (edict_t *ent);
	void           (*Weapon_RocketLauncher_Fire) (edict_t *ent);
	void           (*Blaster_Fire) (edict_t *ent, vec3_t g_offset, int damage, qboolean hyper, int effect);
	void           (*Weapon_Blaster_Fire) (edict_t *ent);
	void           (*Weapon_HyperBlaster_Fire) (edict_t *ent);
	void           (*Machinegun_Fire) (edict_t *ent);
	void           (*Chaingun_Fire) (edict_t *ent);
	void           (*weapon_shotgun_fire) (edict_t *ent);
	void           (*weapon_supershotgun_fire) (edict_t *ent);
	void           (*weapon_railgun_fire) (edict_t *ent);
	void           (*weapon_bfg_fire) (edict_t *ent);

	qboolean   		*is_quad;
	byte    			*is_silenced;
	/**********************************************************
	 * m_move.c
	 *********************************************************/
	// m_move.c globals
	qboolean       (*M_CheckBottom) (edict_t *ent);
	qboolean       (*M_walkmove) (edict_t *ent, float yaw, float dist);
	void           (*M_MoveToGoal) (edict_t *ent, float dist);
	void           (*M_ChangeYaw) (edict_t *ent);

	// m_move.c internals
	qboolean       (*SV_movestep) (edict_t *ent, vec3_t move, qboolean relink);
	qboolean       (*SV_StepDirection) (edict_t *ent, float yaw, float dist);
	void           (*SV_FixCheckBottom) (edict_t *ent);
	void           (*SV_NewChaseDir) (edict_t *actor, edict_t *enemy, float dist);
	qboolean       (*SV_CloseEnough) (edict_t *ent, edict_t *goal, float dist);

	int            *c_yes;
	int				*c_no;

	/**********************************************************
	 * g_phys.c
	 *********************************************************/
	// g_phys.c globals
	void           (*G_RunEntity) (edict_t *ent);

	// g_phys.c internals
	edict_t        *(*SV_TestEntityPosition) (edict_t *ent);
	void           (*SV_CheckVelocity) (edict_t *ent);
	qboolean       (*SV_RunThink) (edict_t *ent);
	void           (*SV_Impact) (edict_t *e1, trace_t *trace);
	int            (*ClipVelocity) (vec3_t in, vec3_t normal, vec3_t out, float overbounce);
	int            (*SV_FlyMove) (edict_t *ent, float time, int mask);
	void           (*SV_AddGravity) (edict_t *ent);
	trace_t        (*SV_PushEntity) (edict_t *ent, vec3_t push);
	qboolean       (*SV_Push) (edict_t *pusher, vec3_t move, vec3_t amove);
	void           (*SV_Physics_Pusher) (edict_t *ent);
	void           (*SV_Physics_None) (edict_t *ent);
	void           (*SV_Physics_Noclip) (edict_t *ent);
	void           (*SV_Physics_Toss) (edict_t *ent);
	void           (*SV_AddRotationalFriction) (edict_t *ent);
	void           (*SV_Physics_Step) (edict_t *ent);

	/*********************************************************
	 * g_main.c
	 ********************************************************/
	// g_main.c globals
	void           (*SaveClientData) (void);
	void           (*FetchClientEntData) (edict_t *ent);

	// g_main.c internals
	void           (*EndDMLevel) (void);
	void           (*CheckDMRules) (void);
	void           (*ExitLevel) (void);

	edict_t        *g_edicts;
	cvar_t         *deathmatch;
	cvar_t         *coop;
	cvar_t         *dmflags;
	cvar_t         *skill;
	cvar_t         *fraglimit;
	cvar_t         *timelimit;
	cvar_t         *password;
	cvar_t         *maxclients;
	cvar_t         *maxentities;
	cvar_t         *g_select_empty;
	cvar_t         *dedicated;
	cvar_t         *sv_maxvelocity;
	cvar_t         *sv_gravity;
	cvar_t         *sv_rollspeed;
	cvar_t         *sv_rollangle;
	cvar_t         *gun_x;
	cvar_t         *gun_y;
	cvar_t         *gun_z;
	cvar_t         *run_pitch;
	cvar_t         *run_roll;
	cvar_t         *bob_up;
	cvar_t         *bob_pitch;
	cvar_t         *bob_roll;
	cvar_t         *sv_cheats;

	// g_func.c
	void				(*Move_Done) (edict_t *ent);
	void				(*Move_Final) (edict_t *ent);
	void				(*Move_Begin) (edict_t *ent);
	void				(*Think_AccelMove) (edict_t *ent);
	void				(*Move_Calc) (edict_t *ent, vec3_t dest, void(*func)(edict_t*));
	void				(*AngleMove_Done) (edict_t *ent);
	void				(*AngleMove_Final) (edict_t *ent);
	void				(*AngleMove_Begin) (edict_t *ent);
	void				(*AngleMove_Calc) (edict_t *ent, void(*func)(edict_t*));
	void				(*plat_CalcAcceleratedMove)(moveinfo_t *moveinfo);
	void				(*plat_Accelerate) (moveinfo_t *moveinfo);
	void				(*plat_go_down) (edict_t *ent);
	void				(*plat_hit_top) (edict_t *ent);
	void				(*plat_hit_bottom) (edict_t *ent);
	void				(*plat_go_up) (edict_t *ent);
	void				(*plat_blocked) (edict_t *self, edict_t *other);
	void				(*Use_Plat) (edict_t *ent, edict_t *other, edict_t *activator);
	void				(*Touch_Plat_Center) (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*plat_spawn_inside_trigger) (edict_t *ent);
	void				(*SP_func_plat) (edict_t *ent);
	void				(*rotating_blocked) (edict_t *self, edict_t *other);
	void				(*rotating_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*rotating_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_func_rotating) (edict_t *ent);
	void				(*button_done) (edict_t *self);
	void				(*button_return) (edict_t *self);
	void				(*button_wait) (edict_t *self);
	void				(*button_fire) (edict_t *self);
	void				(*button_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*button_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*button_killed) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void				(*SP_func_button) (edict_t *ent);
	void				(*door_use_areaportals) (edict_t *self, qboolean open);
	void				(*door_go_down) (edict_t *self);
	void				(*door_hit_top) (edict_t *self);
	void				(*door_hit_bottom) (edict_t *self);
	void				(*door_go_up) (edict_t *self, edict_t *activator);
	void				(*door_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*Touch_DoorTrigger) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*Think_CalcMoveSpeed) (edict_t *self);
	void				(*Think_SpawnDoorTrigger) (edict_t *ent);
	void				(*door_blocked)  (edict_t *self, edict_t *other);
	void				(*door_killed) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void				(*door_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*SP_func_door) (edict_t *ent);
	void				(*SP_func_door_rotating) (edict_t *ent);
	void				(*SP_func_water) (edict_t *self);
	void				(*train_next) (edict_t *self);
	void				(*train_blocked) (edict_t *self, edict_t *other);
	void				(*train_wait) (edict_t *self);
	void				(*train_resume) (edict_t *self);
	void				(*func_train_find) (edict_t *self);
	void				(*train_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_func_train) (edict_t *self);
	void				(*trigger_elevator_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*trigger_elevator_init) (edict_t *self);
	void				(*SP_trigger_elevator) (edict_t *self);
	void				(*func_timer_think) (edict_t *self);
	void				(*func_timer_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_func_timer) (edict_t *self);
	void				(*func_conveyor_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_func_conveyor) (edict_t *self);
	void				(*door_secret_move1) (edict_t *self);
	void				(*door_secret_move2) (edict_t *self);
	void				(*door_secret_move3) (edict_t *self);
	void				(*door_secret_move4) (edict_t *self);
	void				(*door_secret_move5) (edict_t *self);
	void				(*door_secret_move6) (edict_t *self);
	void				(*door_secret_done) (edict_t *self);
	void				(*door_secret_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*door_secret_blocked)  (edict_t *self, edict_t *other);
	void				(*door_secret_die) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void				(*SP_func_door_secret) (edict_t *ent);
	void				(*use_killbox) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_func_killbox) (edict_t *ent);
	
	// g_target.c
	void				(*Use_Target_Tent) (edict_t *ent, edict_t *other, edict_t *activator);
	void				(*SP_target_temp_entity) (edict_t *ent);
	void				(*Use_Target_Speaker) (edict_t *ent, edict_t *other, edict_t *activator);
	void				(*SP_target_speaker) (edict_t *ent);
	void				(*Use_Target_Help) (edict_t *ent, edict_t *other, edict_t *activator);
	void				(*SP_target_help)(edict_t *ent);
	void				(*use_target_secret) (edict_t *ent, edict_t *other, edict_t *activator);
	void				(*SP_target_secret) (edict_t *ent);
	void				(*use_target_goal) (edict_t *ent, edict_t *other, edict_t *activator);
	void				(*SP_target_goal) (edict_t *ent);
	void				(*target_explosion_explode) (edict_t *self);
	void				(*use_target_explosion) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*use_target_changelevel) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_target_changelevel) (edict_t *ent);
	void				(*use_target_splash) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*ED_CallSpawn) (edict_t *ent);
	void				(*use_target_spawner) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_target_spawner) (edict_t *self);
	void				(*use_target_blaster) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_target_blaster) (edict_t *self);
	void				(*trigger_crosslevel_trigger_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_target_crosslevel_trigger) (edict_t *self);
	void				(*target_crosslevel_target_think) (edict_t *self);
	void				(*SP_target_crosslevel_target) (edict_t *self);
	void				(*target_laser_think) (edict_t *self);
	void				(*target_laser_on) (edict_t *self);
	void				(*target_laser_off) (edict_t *self);
	void				(*target_laser_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*target_laser_start) (edict_t *self);
	void				(*SP_target_laser) (edict_t *self);
	void				(*target_lightramp_think) (edict_t *self);
	void				(*target_lightramp_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_target_lightramp) (edict_t *self);
	void				(*target_earthquake_think) (edict_t *self);
	void				(*target_earthquake_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_target_earthquake) (edict_t *self);

	// g_trigger.c
	void				(*InitTrigger) (edict_t *self);
	void				(*multi_wait) (edict_t *ent);
	void				(*multi_trigger) (edict_t *ent);
	void				(*Use_Multi) (edict_t *ent, edict_t *other, edict_t *activator);
	void				(*Touch_Multi) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*trigger_enable) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_trigger_multiple) (edict_t *ent);
	void				(*SP_trigger_once) (edict_t *ent);
	void				(*trigger_relay_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_trigger_relay) (edict_t *self);
	void				(*trigger_key_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_trigger_key) (edict_t *self);
	void				(*trigger_counter_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*SP_trigger_counter) (edict_t *self);
	void				(*SP_trigger_always) (edict_t *ent);
	void				(*trigger_push_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*SP_trigger_push) (edict_t *self);
	void				(*hurt_use) (edict_t *self, edict_t *other, edict_t *activator);
	void				(*hurt_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*SP_trigger_hurt) (edict_t *self);
	void				(*trigger_gravity_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*SP_trigger_gravity) (edict_t *self);
	void				(*trigger_monsterjump_touch) (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	void				(*SP_trigger_monsterjump) (edict_t *self);

	// g_turret.c
	void           (*AnglesNormalize) (vec3_t vec);
	void           (*turret_blocked) (edict_t *self, edict_t *other);
	void           (*turret_breach_fire) (edict_t *self);
	void           (*turret_breach_think) (edict_t *self);
	void           (*turret_breach_finish_init) (edict_t *self);
	void           (*SP_turret_breach) (edict_t *self);
	void           (*SP_turret_base) (edict_t *self);
	void           (*turret_driver_die) (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
	void           (*turret_driver_think) (edict_t *self);
	void           (*turret_driver_link) (edict_t *self);
	void           (*SP_turret_driver) (edict_t *self);
	float 			(*SnapToEights) (float x);

	char				*pcExecutionMode;

	// q_shared.c
	void				(*RotatePointAroundVector) ( vec3_t dst, const vec3_t dir, const vec3_t point, float degrees );
	void				(*AngleVectors) (vec3_t angles, vec3_t forward, vec3_t right, vec3_t up);
	void				(*ProjectPointOnPlane) ( vec3_t dst, const vec3_t p, const vec3_t normal );
	void				(*PerpendicularVector) ( vec3_t dst, const vec3_t src );
	void				(*R_ConcatRotations) (float in1[3][3], float in2[3][3], float out[3][3]);
	void				(*R_ConcatTransforms) (float in1[3][4], float in2[3][4], float out[3][4]);
	float 			(*Q_fabs) (float f);
	float 			(*LerpAngle) (float a2, float a1, float frac);
	float 			(*anglemod) (float a);
	int 				(*BoxOnPlaneSide2) (vec3_t emins, vec3_t emaxs, struct cplane_s *p);
	int 				(*BoxOnPlaneSide) (vec3_t emins, vec3_t emaxs, struct cplane_s *p);
	void				(*ClearBounds) (vec3_t mins, vec3_t maxs);
	void				(*AddPointToBounds) (vec3_t v, vec3_t mins, vec3_t maxs);
	int 				(*VectorCompare) (vec3_t v1, vec3_t v2);
	vec_t 			(*VectorNormalize) (vec3_t v);
	vec_t 			(*VectorNormalize2) (vec3_t v, vec3_t out);
	void				(*VectorMA) (vec3_t veca, float scale, vec3_t vecb, vec3_t vecc);
	vec_t 			(*_DotProduct) (vec3_t v1, vec3_t v2);
	void				(*_VectorSubtract) (vec3_t veca, vec3_t vecb, vec3_t out);
	void				(*_VectorAdd) (vec3_t veca, vec3_t vecb, vec3_t out);
	void				(*_VectorCopy) (vec3_t in, vec3_t out);
	void				(*CrossProduct) (vec3_t v1, vec3_t v2, vec3_t cross);
	double 			(*sqrt) (double x);
	vec_t 			(*VectorLength) (vec3_t v);
	void				(*VectorInverse) (vec3_t v);
	void				(*VectorScale) (vec3_t in, vec_t scale, vec3_t out);
	int 				(*Q_log2) (int val);
	char 				*(*COM_SkipPath) (char *pathname);
	void				(*COM_StripExtension) (char *in, char *out);
	char 				*(*COM_FileExtension) (char *in);
	void				(*COM_FileBase) (char *in, char *out);
	void				(*COM_FilePath) (char *in, char *out);
	void				(*COM_DefaultExtension) (char *path, char *extension);
	short   			(*ShortSwap) (short l);
	short 			(*ShortNoSwap) (short l);
	int    			(*LongSwap) (int l);
	int   			(*LongNoSwap) (int l);
	float 			(*FloatSwap) (float f);
	float 			(*FloatNoSwap) (float f);
	void				(*Swap_Init) (void);
	char  			*(*va) (char *format, ...);
	char 				*(*COM_Parse) (char **data_p);
	void				(*Com_PageInMemory) (byte *buffer, int size);
	int 				(*Q_stricmp) (char *s1, char *s2);
	int 				(*Q_strncasecmp) (char *s1, char *s2, int n);
	int 				(*Q_strcasecmp) (char *s1, char *s2);
	void				(*Com_sprintf) (char *dest, int size, char *fmt, ...);
	char 				*(*Info_ValueForKey) (char *s, char *key);
	void				(*Info_RemoveKey) (char *s, char *key);
	qboolean 		(*Info_Validate) (char *s);
	void				(*Info_SetValueForKey) (char *s, char *key, char *value);
	
	vec3_t			*vec3_origin;
};

