#include "api_prototypes.h"
#include "api.h"
#include "module.h"
#include "module_functions.h"
#include <stdio.h>

/**********************************************************
 * GetModAPI(API)
 *
 * This does the real work for the loader. 
 *********************************************************/
ModuleExchange *GetModAPI(ModuleExchange *PluginAPI) {
	ModuleExchange	*RetVal;
	ImportedAPI = *PluginAPI;
	
  /********************************************************************/
  /* Don't change the next few lines                                  */
	RetVal = (ModuleExchange *)malloc(sizeof(ModuleExchange));
	memset(RetVal, 0, sizeof(ModuleExchange));
	pcExecutionMode = (char *)malloc(sizeof(ModuleExchange));
	memset(pcExecutionMode, 0, sizeof(ModuleExchange));
	RetVal->iModVersion = 1;
	RetVal->pcExecutionMode = pcExecutionMode;
	RetVal->pcModName = (char *)malloc(strlen(MODULE_NAME) + 1);
	strcpy(RetVal->pcModName, MODULE_NAME);
	MODULE_Initialize();
  /********************************************************************/
	

  /********************************************************************/
  /* User-Defined functions here                                      
   * This is where author-defined functions are passed back to the    
   * main game                                                        
	*																						 
	* example:																			 
	* RetVal->idFunctionName = ThisModFunctionName;							 
	*																						 
	* see included examples	
  /********************************************************************/

  /********************************************************************/
  /* Set the local function declarations to mirror id's functions     */
	MODULE_FixFunctions();
  /********************************************************************/
	return RetVal;
}

/*******************************************************************/
/* MODULE_Initialize
 *
 * Anything that has to happen when the plugin loads should be 
 * executed here.
 *
 * Be aware that the plugin can load at *any* point in the game, 
 * even after it has been running for hours!
/*******************************************************************/
void MODULE_Initialize(void) {

}


/*******************************************************************/
/* The next series of functions are for a special linked-list that
 * has been provided to "extend" data structures. The list is keyed
 * by a pointer to the structure that StructExt "extends". To 
 * extend the structure, simply add variables to the struct 
 * declaration in module.h. 
/*******************************************************************/
StructExt *LL_Append(StructExt *Data) {
	StructExt *temp;
	if(G_Extend) {
		temp = G_Extend->Head->Tail;	/* Tail is only stored in the head */
	} else {
		G_Extend = (StructExt *)malloc(sizeof(StructExt));
		temp = G_Extend;
		temp->Head = temp;
		temp->Head->Tail = temp;
	}
	temp->Next = (StructExt *)malloc(sizeof(StructExt));
	memcpy(temp->Next, Data, sizeof(StructExt));	/* Populate the element */
	temp->Head->Tail = temp->Next;
	temp->Next->Head = temp->Head;
	temp = temp->Next;
	return temp;
}

StructExt *LL_Set(StructExt *Data) {
	StructExt *temp;
	StructExt junk;
	StructExt *RetVal;
	
	RetVal = NULL;
	if(G_Extend) {
		temp=G_Extend->Head;
	} else {
		G_Extend = (StructExt *)malloc(sizeof(StructExt));
		temp = G_Extend;
		temp->Head = temp;
		temp->Head->Tail = temp;
		temp->Next = NULL;
	}
	while(temp) {
		if(temp->Key == Data->Key) {
			memcpy(&junk, temp, sizeof(StructExt));
			memcpy(temp, Data, sizeof(StructExt));
			temp->Key = junk.Key;
			temp->Head = junk.Head;
			if(junk.Next) {
				temp->Next = junk.Next;
				temp->Next->Next = NULL;
			} else {
				temp->Next = NULL;
			}
			temp->Prev = junk.Prev;
			RetVal = temp;
		}
		if(temp->Next) {
			/* Keep going until all occurences are settled */
			temp = temp->Next;
		} else {
			break;
		}
	}
	if(!RetVal) {
		RetVal = LL_Append(Data);
	}
	return RetVal;
}

StructExt *LL_Find(BYTE *Key) {
	StructExt *temp;
	if(!G_Extend) {
		return NULL;
	}
	if(G_Extend->Head) {
		temp = G_Extend->Head;
	} else {
		return NULL;
	}
	while(temp) {
		if(temp->Key == Key) {
			temp->Head->LastAccess = temp;
			return temp;
		}
		if(temp->Next) {
			temp = temp->Next;
		} else {
			return NULL;
		}
	}
	return NULL;
}
	
StructExt *LL_FindNext(BYTE *Key) {
	StructExt *temp;
	if(G_Extend->LastAccess) {
		temp = G_Extend->LastAccess;
	} else {
		temp = G_Extend->Head;
	}
	while(temp) {
		if(temp->Key == Key) {
			temp->Head->LastAccess = temp;
			return temp;
		}
		if(temp->Next) {
			temp = temp->Next;
		} else {
			return NULL;
		}
	}
	return NULL;
}

void LL_Del(BYTE *Key) {
	StructExt *temp;
	
	while(temp = LL_Find(Key)) {
		if(temp->Prev && temp->Prev->Next && temp->Next) {
			temp->Prev->Next = temp->Next;
		}
		if(temp->Prev && temp->Prev->Next && !temp->Next) {
			temp->Prev->Next = NULL;
		}
		if(temp->Next && temp->Next->Prev && temp->Prev) {
			temp->Next->Prev = temp->Prev;
		}
		if(temp->Next && temp->Next->Prev && !temp->Prev) {
			temp->Next->Prev = NULL;
		}
		if(temp->Head == temp) {
			/* Removing head data, just set key to 0 */
			temp->Key = NULL;
		}
		if(temp->Head->Tail == temp) {
			/* Removing tail structure */
			if(temp->Prev) {
				temp->Head->Tail = temp->Prev;
			}
		}
	}
}

	
