#include "api_prototypes.h"
#include "api.h"
#include "module.h"
#include "module_functions.h"
#include <stdio.h>

/*******************************************************************/
/* MyClientConnect
 *
 * Sample connect extention to the game.
 * See api_support.c, in function GetModAPI() for an example of
 * passing a pointer to this function back to the main game.
/*******************************************************************/
qboolean MyClientConnect(edict_t *client, char *pcUserInfo) {
	/* Declare an extention struct for the client
	 * See module.h for more info about the StructExt structure
	 */
	StructExt	MyData; 
	
	MyData.hookstate = 0;	/* Set a value for the hookstate */
	MyData.Key = (BYTE *)client; /* VERY important, key this element */
	LL_Set(&MyData); /* Now set up the structure element */
	
	return 1;
}

void HOOK_ClientCommand(edict_t *ent) {
	char *cmd;
	StructExt MyData;
	
	/* Check to see if this client was initialized 
	 * Remember, this plugin can be loaded *AFTER*
	 * the game has been started and clients connect,
	 * e.g. when an admin copies the dl to the plugins
	 * directory */
	if(!LL_Find((BYTE *)ent)) {
		MyData.hookstate = 0;
		MyData.Key = (BYTE *)ent;
		LL_Set(&MyData);
	}
	MODULE_SetGlobals();
	cmd = gi.argv(0);
	if(!Q_stricmp(cmd, "hook")) {
		Cmd_Hook_f(ent);	
		ToggleMode(ClientCommand, 1);
	}
}
