#include "api_prototypes.h"
#include "api.h"
#include "module.h"
#include "module_functions.h"
#include <stdio.h>

void HOME_ClientCommand(edict_t *ent) {
	char *cmd;

	MODULE_SetGlobals();
	cmd = gi.argv(0);
	if(!Q_stricmp(cmd, "homing")) {
		Cmd_Homing_f(ent);
		ToggleMode(ClientCommand, 1);
	}
}

void Cmd_Homing_f (edict_t *ent) {
	int	i;
	StructExt	*Homing;

	Homing = LL_Find((BYTE *)ent);
	i = atoi(gi.argv(1));

	switch(i) {
		case 0:
			gi.cprintf(ent, PRINT_HIGH, "Homing Missiles Off\n");
			Homing->homing_state = 0;
			break;
		case 1:
		default:
			gi.cprintf(ent, PRINT_HIGH, "HOMING MISSILES ACTIVE\n");
			Homing->homing_state = 1;
			break;
	}
}

void HOME_fire_rocket(edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage) {
	StructExt	*Homing;
	edict_t *rocket;


	Homing = LL_Find((BYTE *)self);
	if(self->client && Homing->homing_state && self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] >= 5) {
//	if(self->client && Homing->homing_state ) {
		rocket = G_Spawn();
		VectorCopy (start, rocket->s.origin);
		VectorCopy (dir, rocket->movedir);
		vectoangles (dir, rocket->s.angles);
		VectorScale (dir, speed, rocket->velocity);
		rocket->movetype = MOVETYPE_FLYMISSILE;
		rocket->clipmask = MASK_SHOT;
		rocket->solid = SOLID_BBOX;
		rocket->s.effects |= EF_ROCKET;
		VectorClear (rocket->mins);
		VectorClear (rocket->maxs);
		rocket->s.modelindex = gi.modelindex ("models/objects/rocket/tris.md2");
		rocket->owner = self;
		rocket->touch = rocket_touch;
		rocket->dmg = damage;
		rocket->radius_dmg = radius_damage;
		rocket->dmg_radius = damage_radius;
		rocket->s.sound = gi.soundindex ("weapons/rockfly.wav");
		rocket->classname = "rocket";
		self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 5;
		rocket->nextthink = level.time + .1;
		rocket->think = homing_think;
		if (self->client)
			check_dodge (self, rocket->s.origin, dir, speed);

		gi.linkentity (rocket);
		ToggleMode(fire_rocket, 1);
	} else {
		ToggleMode(fire_rocket, 0);
	}		
}
																										



			
void homing_think (edict_t *ent)
{
	edict_t	*target = NULL;
	edict_t *blip = NULL;
	vec3_t	targetdir, blipdir;
	vec_t	speed;

	while ((blip = findradius(blip, ent->s.origin, 1000)) != NULL)
	{
		if (!(blip->svflags & SVF_MONSTER) && !blip->client)
			continue;
		if (blip == ent->owner)
			continue;
		if (!blip->takedamage)
			continue;
		if (blip->health <= 0)
			continue;
		if (!visible(ent, blip))
			continue;
		if (!infront(ent, blip))
			continue;
		VectorSubtract(blip->s.origin, ent->s.origin, blipdir);
		blipdir[2] += 16;
		if ((target == NULL) || (VectorLength(blipdir) < VectorLength(targetdir)))
		{
			target = blip;
			VectorCopy(blipdir, targetdir);
		}
	}
		
	if (target != NULL)
	{
		// target acquired, nudge our direction toward it
		VectorNormalize(targetdir);
		VectorScale(targetdir, 0.2, targetdir);
		VectorAdd(targetdir, ent->movedir, targetdir);
		VectorNormalize(targetdir);
		VectorCopy(targetdir, ent->movedir);
		vectoangles(targetdir, ent->s.angles);
		speed = VectorLength(ent->velocity);
		VectorScale(targetdir, speed, ent->velocity);
	}

	ent->nextthink = level.time + .1;
}

