#define MODULE_NAME	"Pericle's swinging hook"
#define ToggleMode(x,y) ToggleExecMode(API_OFS(x),y)

#ifdef LITTLE_ENDIAN
#define BYTE unsigned char
#endif

typedef struct STRUCT_EXT StructExt;

/*******************************************************************/
/* StructExt declaration
 *
 * This is an important piece of the plugin API. Since it is not
 * possible to directly extend internal ID data structures, this
 * linked list, and the LL_xxx support functions are in place
 * to simulate extentions to the id internals.
 *
 * They BYTE *Key is what associates this structure with an id 
 * internal. Since each struct * is unique and static within id's own
 * game, it is safe to set Key to point at something like an instance
 * of an edict_t *.
 *
 * Have a look at Pericle's modified hook code in p_hook.c to see how
 * these functions and this structure are used to extend the game
 * for proprietary module data.
/*******************************************************************/
struct STRUCT_EXT {
  /*******************************************************************/
  /* Do not change this part of the structure, each of these are 
	* necessary for the LL_ support functions.
  /*******************************************************************/
	BYTE			*Key;				/* Location of the extended structure 	*/
	StructExt	*Next;			/* Next structure in the linked list 	*/
	StructExt	*Head;			/* Pointer to the head node				*/
	StructExt	*Tail;
	StructExt	*LastAccess;	/* Last Record Accessed						*/
	StructExt	*Prev;			/* Previous Node								*/
	
  /*******************************************************************/
  /* Author Extentions here
	*
	* In this example, the hook code only needed an int added to the
	* edict_t structure. So the StructExt->Key is associated with a 
	* player edict_t structure. A particular instance of StructExt
	* in the linked list is extracted with LL_Get(edict_t *player), and
	* hook state is referenced that way.
  /*******************************************************************/
	int	hookstate;
};



/*******************************************************************/
/* Everything else here is needed by the API. Most modifications
 * should either be made to the StructExt declaration above, or in
 * a separate header file, just to keep things clean.
/*******************************************************************/
int				iAPIVersion;
ModuleExchange ImportedAPI;
ModuleExchange *ExportedAPI;

StructExt		*G_Extend;

ModuleExchange *GetModAPI(ModuleExchange *PluginAPI);
void MODULE_Initialize(void);
void ToggleExecMode(int iOffset, char cMode);
StructExt *LL_Append(StructExt *Data);
StructExt *LL_Set(StructExt *Data);
StructExt *LL_Find(BYTE *Key);
StructExt *LL_FindNext(BYTE *Key);
void LL_Del(BYTE *Key);

