#include "api_prototypes.h"
#include "api.h"
#include "module.h"
#include <stdio.h>
#include "module_functions.h"
/**********************************************************
 * MODULE_FixFunctions()
 *
 * Runs through the global ImportedAPI structure, and 
 * references local function declarations for all imported
 * functions --this is purely cosmetic, since they are 
 * already available via ImportedAPI.FunctionName, 
 * but this keeps things pretty portable so calling 
 * this function will make everything look like  
 * actually coding with the main game source, rather
 * than a lightweight API
 *********************************************************/
gitem_t *FindItem(char *pickup_name) {
	int i;
	gitem_t *it;

	it = NULL;
	for(i=0;i<game.num_items;i++) {
		if(itemlist[i].pickup_name) {
			if(!Q_stricmp(itemlist[i].pickup_name, pickup_name)) {
				it = &itemlist[i];
			}
		}
	}
	return it;
}

void MODULE_FixFunctions(void) {
	iAPIVersion = ImportedAPI.iAPIVersion;
	Init = ImportedAPI.Init;
	ShutDown = ImportedAPI.ShutDown;
	ClientConnect = ImportedAPI.ClientConnect;
	ClientBegin = ImportedAPI.ClientBegin;
	ClientUserInfoChanged = ImportedAPI.ClientUserInfoChanged;
	ClientDisconnect = ImportedAPI.ClientDisconnect;
	ClientCommand = ImportedAPI.ClientCommand;
	ClientThink = ImportedAPI.ClientThink;
	RunFrame = ImportedAPI.RunFrame;
	ServerCommand = ImportedAPI.ServerCommand;
	gi = ImportedAPI.gi;
	G_ProjectSource = ImportedAPI.G_ProjectSource;
	G_Find = ImportedAPI.G_Find;
	findradius = ImportedAPI.findradius;
	G_PickTarget = ImportedAPI.G_PickTarget;
	Think_Delay = ImportedAPI.Think_Delay;
	G_UseTargets = ImportedAPI.G_UseTargets;
	tv = ImportedAPI.tv;
	vtos = ImportedAPI.vtos;
	G_SetMovedir = ImportedAPI.G_SetMovedir;
	vectoyaw = ImportedAPI.vectoyaw;
	vectoangles = ImportedAPI.vectoangles;
	G_CopyString = ImportedAPI.G_CopyString;
	G_InitEdict = ImportedAPI.G_InitEdict;
	G_Spawn = ImportedAPI.G_Spawn;
	G_FreeEdict = ImportedAPI.G_FreeEdict;
	G_TouchTriggers = ImportedAPI.G_TouchTriggers;
	G_TouchSolids = ImportedAPI.G_TouchSolids;
	KillBox = ImportedAPI.KillBox;
	PrecacheItem = ImportedAPI.PrecacheItem;
	InitItems = ImportedAPI.InitItems;
	SetItemNames = ImportedAPI.SetItemNames;
	/* FindItem = ImportedAPI.FindItem; */
	FindItemByClassname = ImportedAPI.FindItemByClassname;
	Drop_Item = ImportedAPI.Drop_Item;
	SetRespawn = ImportedAPI.SetRespawn;
	ChangeWeapon = ImportedAPI.ChangeWeapon;
	SpawnItem = ImportedAPI.SpawnItem;
	Think_Weapon = ImportedAPI.Think_Weapon;
	ArmorIndex = ImportedAPI.ArmorIndex;
	PowerArmorType = ImportedAPI.PowerArmorType;
	GetItemByIndex = ImportedAPI.GetItemByIndex;
	Add_Ammo = ImportedAPI.Add_Ammo;
	Touch_Item = ImportedAPI.Touch_Item;
	Pickup_Weapon = ImportedAPI.Pickup_Weapon;
	Use_Weapon = ImportedAPI.Use_Weapon;
	Drop_Weapon = ImportedAPI.Drop_Weapon;
	Weapon_Blaster = ImportedAPI.Weapon_Blaster;
	Weapon_Shotgun = ImportedAPI.Weapon_Shotgun;
	Weapon_SuperShotgun = ImportedAPI.Weapon_SuperShotgun;
	Weapon_Machinegun = ImportedAPI.Weapon_Machinegun;
	Weapon_Chaingun = ImportedAPI.Weapon_Chaingun;
	Weapon_HyperBlaster = ImportedAPI.Weapon_HyperBlaster;
	Weapon_RocketLauncher = ImportedAPI.Weapon_RocketLauncher;
	Weapon_Grenade = ImportedAPI.Weapon_Grenade;
	Weapon_GrenadeLauncher = ImportedAPI.Weapon_GrenadeLauncher;
	Weapon_Railgun = ImportedAPI.Weapon_Railgun;
	Weapon_BFG = ImportedAPI.Weapon_BFG;
/*	jacket_armor_index = ImportedAPI.jacket_armor_index;
	combat_armor_index = ImportedAPI.combat_armor_index;
	body_armor_index = ImportedAPI.body_armor_index;
	power_screen_index = ImportedAPI.power_screen_index;
	power_shield_index = ImportedAPI.power_shield_index;
*/
	Cmd_Help_f = ImportedAPI.Cmd_Help_f;
	Cmd_Score_f = ImportedAPI.Cmd_Score_f;
	ClientTeam = ImportedAPI.ClientTeam;
	OnSameTeam = ImportedAPI.OnSameTeam;
	SelectNextItem = ImportedAPI.SelectNextItem;
	SelectPrevItem = ImportedAPI.SelectPrevItem;
	ValidateSelectedItem = ImportedAPI.ValidateSelectedItem;
	Cmd_Give_f = ImportedAPI.Cmd_Give_f;
	Cmd_God_f = ImportedAPI.Cmd_God_f;
	Cmd_Notarget_f = ImportedAPI.Cmd_Notarget_f;
	Cmd_Noclip_f = ImportedAPI.Cmd_Noclip_f;
	Cmd_Use_f = ImportedAPI.Cmd_Use_f;
	Cmd_Drop_f = ImportedAPI.Cmd_Drop_f;
	Cmd_Inven_f = ImportedAPI.Cmd_Inven_f;
	Cmd_InvUse_f = ImportedAPI.Cmd_InvUse_f;
	Cmd_WeapPrev_f = ImportedAPI.Cmd_WeapPrev_f;
	Cmd_WeapNext_f = ImportedAPI.Cmd_WeapNext_f;
	Cmd_WeapLast_f = ImportedAPI.Cmd_WeapLast_f;
	Cmd_InvDrop_f = ImportedAPI.Cmd_InvDrop_f;
	Cmd_Kill_f = ImportedAPI.Cmd_Kill_f;
	Cmd_PutAway_f = ImportedAPI.Cmd_PutAway_f;
	Cmd_Players_f = ImportedAPI.Cmd_Players_f;
	Cmd_Wave_f = ImportedAPI.Cmd_Wave_f;
	Cmd_Say_f = ImportedAPI.Cmd_Say_f;
	CanDamage = ImportedAPI.CanDamage;
	T_Damage = ImportedAPI.T_Damage;
	T_RadiusDamage = ImportedAPI.T_RadiusDamage;
	Killed = ImportedAPI.Killed;
	SpawnDamage = ImportedAPI.SpawnDamage;
	CheckPowerArmor = ImportedAPI.CheckPowerArmor;
	CheckArmor = ImportedAPI.CheckArmor;
	M_ReactToDamage = ImportedAPI.M_ReactToDamage;
	CheckTeamDamage = ImportedAPI.CheckTeamDamage;
	monster_fire_bullet = ImportedAPI.monster_fire_bullet;
	monster_fire_shotgun = ImportedAPI.monster_fire_shotgun;
	monster_fire_blaster = ImportedAPI.monster_fire_blaster;
	monster_fire_grenade = ImportedAPI.monster_fire_grenade;
	monster_fire_rocket = ImportedAPI.monster_fire_rocket;
	monster_fire_railgun = ImportedAPI.monster_fire_railgun;
	monster_fire_bfg = ImportedAPI.monster_fire_bfg;
	M_droptofloor = ImportedAPI.M_droptofloor;
	monster_think = ImportedAPI.monster_think;
	walkmonster_start = ImportedAPI.walkmonster_start;
	swimmonster_start = ImportedAPI.swimmonster_start;
	flymonster_start = ImportedAPI.flymonster_start;
	AttackFinished = ImportedAPI.AttackFinished;
	monster_death_use = ImportedAPI.monster_death_use;
	M_CatagorizePosition = ImportedAPI.M_CatagorizePosition;
	M_CheckAttack = ImportedAPI.M_CheckAttack;
	M_FlyCheck = ImportedAPI.M_FlyCheck;
	M_CheckGround = ImportedAPI.M_CheckGround;
	M_FliesOff = ImportedAPI.M_FliesOff;
	M_FliesOn = ImportedAPI.M_FliesOn;
	M_WorldEffects = ImportedAPI.M_WorldEffects;
	M_SetEffects = ImportedAPI.M_SetEffects;
	M_MoveFrame = ImportedAPI.M_MoveFrame;
	monster_use = ImportedAPI.monster_use;
	monster_start_go = ImportedAPI.monster_start_go;
	monster_triggered_spawn = ImportedAPI.monster_triggered_spawn;
	monster_triggered_spawn_use = ImportedAPI.monster_triggered_spawn_use;
	monster_start = ImportedAPI.monster_start;
	walkmonster_start_go = ImportedAPI.walkmonster_start_go;
	flymonster_start_go = ImportedAPI.flymonster_start_go;
	swimmonster_start_go = ImportedAPI.swimmonster_start_go;
	ThrowHead = ImportedAPI.ThrowHead;
	ThrowClientHead = ImportedAPI.ThrowClientHead;
	ThrowGib = ImportedAPI.ThrowGib;
	BecomeExplosion1 = ImportedAPI.BecomeExplosion1;
	Use_Areaportal = ImportedAPI.Use_Areaportal;
	SP_func_areaportal = ImportedAPI.SP_func_areaportal;
	VelocityForDamage = ImportedAPI.VelocityForDamage;
	ClipGibVelocity = ImportedAPI.ClipGibVelocity;
	gib_think = ImportedAPI.gib_think;
	gib_touch = ImportedAPI.gib_touch;
	gib_die = ImportedAPI.gib_die;
	debris_die = ImportedAPI.debris_die;
	BecomeExplosion2 = ImportedAPI.BecomeExplosion2;
	path_corner_touch = ImportedAPI.path_corner_touch;
	SP_path_corner = ImportedAPI.SP_path_corner;
	point_combat_touch = ImportedAPI.point_combat_touch;
	SP_point_combat = ImportedAPI.SP_point_combat;
	light_use = ImportedAPI.light_use;
	SP_light = ImportedAPI.SP_light;
	func_wall_use = ImportedAPI.func_wall_use;
	SP_func_wall = ImportedAPI.SP_func_wall;
	func_object_touch = ImportedAPI.func_object_touch;
	func_object_release = ImportedAPI.func_object_release;
	func_object_use = ImportedAPI.func_object_use;
	SP_func_object = ImportedAPI.SP_func_object;
	func_explosive_explode = ImportedAPI.func_explosive_explode;
	func_explosive_use = ImportedAPI.func_explosive_use;
	func_explosive_spawn = ImportedAPI.func_explosive_spawn;
	SP_func_explosive = ImportedAPI.SP_func_explosive;
	barrel_touch = ImportedAPI.barrel_touch;
	barrel_explode = ImportedAPI.barrel_explode;
	barrel_delay = ImportedAPI.barrel_delay;
	SP_misc_explobox = ImportedAPI.SP_misc_explobox;
	misc_blackhole_use = ImportedAPI.misc_blackhole_use;
	misc_blackhole_think = ImportedAPI.misc_blackhole_think;
	SP_misc_blackhole = ImportedAPI.SP_misc_blackhole;
	misc_eastertank_think = ImportedAPI.misc_eastertank_think;
	SP_misc_eastertank = ImportedAPI.SP_misc_eastertank;
	misc_easterchick_think = ImportedAPI.misc_easterchick_think;
	SP_misc_easterchick = ImportedAPI.SP_misc_easterchick;
	misc_easterchick2_think = ImportedAPI.misc_easterchick2_think;
	SP_misc_easterchick2 = ImportedAPI.SP_misc_easterchick2;
	commander_body_think = ImportedAPI.commander_body_think;
	commander_body_use = ImportedAPI.commander_body_use;
	commander_body_drop = ImportedAPI.commander_body_drop;
	SP_monster_commander_body = ImportedAPI.SP_monster_commander_body;
	misc_banner_think = ImportedAPI.misc_banner_think;
	SP_misc_banner = ImportedAPI.SP_misc_banner;
	misc_deadsoldier_die = ImportedAPI.misc_deadsoldier_die;
	SP_misc_deadsoldier = ImportedAPI.SP_misc_deadsoldier;
	train_use = ImportedAPI.train_use;
	func_train_find = ImportedAPI.func_train_find;
	misc_viper_use = ImportedAPI.misc_viper_use;
	SP_misc_viper = ImportedAPI.SP_misc_viper;
	SP_misc_bigviper = ImportedAPI.SP_misc_bigviper;
	misc_viper_bomb_touch = ImportedAPI.misc_viper_bomb_touch;
	misc_viper_bomb_prethink = ImportedAPI.misc_viper_bomb_prethink;
	misc_viper_bomb_use = ImportedAPI.misc_viper_bomb_use;
	SP_misc_viper_bomb = ImportedAPI.SP_misc_viper_bomb;
	misc_strogg_ship_use = ImportedAPI.misc_strogg_ship_use;
	SP_misc_strogg_ship = ImportedAPI.SP_misc_strogg_ship;
	misc_satellite_dish_think = ImportedAPI.misc_satellite_dish_think;
	misc_satellite_dish_use = ImportedAPI.misc_satellite_dish_use;
	SP_misc_satellite_dish = ImportedAPI.SP_misc_satellite_dish;
	SP_light_mine1 = ImportedAPI.SP_light_mine1;
	SP_light_mine2 = ImportedAPI.SP_light_mine2;
	SP_misc_gib_arm = ImportedAPI.SP_misc_gib_arm;
	SP_misc_gib_leg = ImportedAPI.SP_misc_gib_leg;
	SP_misc_gib_head = ImportedAPI.SP_misc_gib_head;
	SP_target_character = ImportedAPI.SP_target_character;
	target_string_use = ImportedAPI.target_string_use;
	SP_target_string = ImportedAPI.SP_target_string;
	func_clock_reset = ImportedAPI.func_clock_reset;
	func_clock_format_countdown = ImportedAPI.func_clock_format_countdown;
	func_clock_think = ImportedAPI.func_clock_think;
	func_clock_use = ImportedAPI.func_clock_use;
	SP_func_clock = ImportedAPI.SP_func_clock;
	teleporter_touch = ImportedAPI.teleporter_touch;
	SP_misc_teleporter = ImportedAPI.SP_misc_teleporter;
	SP_misc_teleporter_dest = ImportedAPI.SP_misc_teleporter_dest;
	AI_SetSightClient = ImportedAPI.AI_SetSightClient;
	ai_stand = ImportedAPI.ai_stand;
	ai_move = ImportedAPI.ai_move;
	ai_walk = ImportedAPI.ai_walk;
	ai_run = ImportedAPI.ai_run;
	ai_turn = ImportedAPI.ai_turn;
	ai_charge = ImportedAPI.ai_charge;
	range = ImportedAPI.range;
	FoundTarget = ImportedAPI.FoundTarget;
	infront = ImportedAPI.infront;
	visible = ImportedAPI.visible;
	FacingIdeal = ImportedAPI.FacingIdeal;
	FindTarget = ImportedAPI.FindTarget;
	HuntTarget = ImportedAPI.HuntTarget;
	ai_run_melee = ImportedAPI.ai_run_melee;
	ai_run_missile = ImportedAPI.ai_run_missile;
	ai_run_slide = ImportedAPI.ai_run_slide;
	ai_checkattack = ImportedAPI.ai_checkattack;
/*	enemy_vis = ImportedAPI.enemy_vis;
	enemy_infront = ImportedAPI.enemy_infront;
	enemy_range = ImportedAPI.enemy_range;
	enemy_yaw = ImportedAPI.enemy_yaw;
*/
	ThrowDebris = ImportedAPI.ThrowDebris;
	fire_hit = ImportedAPI.fire_hit;
	fire_bullet = ImportedAPI.fire_bullet;
	fire_shotgun = ImportedAPI.fire_shotgun;
	fire_blaster = ImportedAPI.fire_blaster;
	fire_grenade = ImportedAPI.fire_grenade;
	fire_grenade2 = ImportedAPI.fire_grenade2;
	fire_rocket = ImportedAPI.fire_rocket;
	fire_rail = ImportedAPI.fire_rail;
	fire_bfg = ImportedAPI.fire_bfg;
	
	check_dodge = ImportedAPI.check_dodge;
	fire_lead = ImportedAPI.fire_lead;
	blaster_touch = ImportedAPI.blaster_touch;
	Grenade_Explode = ImportedAPI.Grenade_Explode;
	Grenade_Touch = ImportedAPI.Grenade_Touch;
	rocket_touch = ImportedAPI.rocket_touch;
	bfg_explode = ImportedAPI.bfg_explode;
	bfg_touch = ImportedAPI.bfg_touch;
	bfg_think = ImportedAPI.bfg_think;

	
	PlayerTrail_Init = ImportedAPI.PlayerTrail_Init;
	PlayerTrail_Add = ImportedAPI.PlayerTrail_Add;
	PlayerTrail_New = ImportedAPI.PlayerTrail_New;
	PlayerTrail_PickFirst = ImportedAPI.PlayerTrail_PickFirst;
	PlayerTrail_PickNext = ImportedAPI.PlayerTrail_PickNext;
	PlayerTrail_LastSpot = ImportedAPI.PlayerTrail_LastSpot;
	respawn = ImportedAPI.respawn;
	BeginIntermission = ImportedAPI.BeginIntermission;
	PutClientInServer = ImportedAPI.PutClientInServer;
	InitClientPersistant = ImportedAPI.InitClientPersistant;
	InitClientResp = ImportedAPI.InitClientResp;
	InitBodyQue = ImportedAPI.InitBodyQue;
	ClientBeginServerFrame = ImportedAPI.ClientBeginServerFrame;
	player_pain = ImportedAPI.player_pain;
	player_die = ImportedAPI.player_die;
	ClientEndServerFrame = ImportedAPI.ClientEndServerFrame;
	SV_CalcRoll = ImportedAPI.SV_CalcRoll;
	P_DamageFeedback = ImportedAPI.P_DamageFeedback;
	SV_CalcViewOffset = ImportedAPI.SV_CalcViewOffset;
	SV_CalcGunOffset = ImportedAPI.SV_CalcGunOffset;
	SV_AddBlend = ImportedAPI.SV_AddBlend;
	SV_CalcBlend = ImportedAPI.SV_CalcBlend;
	P_FallingDamage = ImportedAPI.P_FallingDamage;
	P_WorldEffects = ImportedAPI.P_WorldEffects;
	G_SetClientEffects = ImportedAPI.G_SetClientEffects;
	G_SetClientEvent = ImportedAPI.G_SetClientEvent;
	G_SetClientSound = ImportedAPI.G_SetClientSound;
	G_SetClientFrame = ImportedAPI.G_SetClientFrame;
	current_player = ImportedAPI.current_player;
	current_client = ImportedAPI.current_client;
//	forward = ImportedAPI.forward;
//	right = ImportedAPI.right;
//	up = ImportedAPI.up;
//	xyspeed = ImportedAPI.xyspeed;
//	bobmove = ImportedAPI.bobmove;
//	bobcycle = ImportedAPI.bobcycle;
//	bobfracsin = ImportedAPI.bobfracsin;
	MoveClientToIntermission = ImportedAPI.MoveClientToIntermission;
	G_SetStats = ImportedAPI.G_SetStats;
	ValidateSelectedItem = ImportedAPI.ValidateSelectedItem;
	DeathmatchScoreboardMessage = ImportedAPI.DeathmatchScoreboardMessage;
	HelpComputer = ImportedAPI.HelpComputer;
	PlayerNoise = ImportedAPI.PlayerNoise;
	P_ProjectSource = ImportedAPI.P_ProjectSource;
	NoAmmoWeaponChange = ImportedAPI.NoAmmoWeaponChange;
	Weapon_Generic = ImportedAPI.Weapon_Generic;
	weapon_grenade_fire = ImportedAPI.weapon_grenade_fire;
	weapon_grenadelauncher_fire = ImportedAPI.weapon_grenadelauncher_fire;
	Blaster_Fire = ImportedAPI.Blaster_Fire;
	Weapon_Blaster_Fire = ImportedAPI.Weapon_Blaster_Fire;
	Weapon_HyperBlaster_Fire = ImportedAPI.Weapon_HyperBlaster_Fire;
	Machinegun_Fire = ImportedAPI.Machinegun_Fire;
	Chaingun_Fire = ImportedAPI.Chaingun_Fire;
	weapon_shotgun_fire = ImportedAPI.weapon_shotgun_fire;
	weapon_supershotgun_fire = ImportedAPI.weapon_supershotgun_fire;
	weapon_railgun_fire = ImportedAPI.weapon_railgun_fire;
	weapon_bfg_fire = ImportedAPI.weapon_bfg_fire;
//	is_quad = ImportedAPI.is_quad;
//	is_silenced = ImportedAPI.is_silenced;
	M_CheckBottom = ImportedAPI.M_CheckBottom;
	M_walkmove = ImportedAPI.M_walkmove;
	M_MoveToGoal = ImportedAPI.M_MoveToGoal;
	M_ChangeYaw = ImportedAPI.M_ChangeYaw;
	SV_movestep = ImportedAPI.SV_movestep;
	SV_StepDirection = ImportedAPI.SV_StepDirection;
	SV_FixCheckBottom = ImportedAPI.SV_FixCheckBottom;
	SV_NewChaseDir = ImportedAPI.SV_NewChaseDir;
	SV_CloseEnough = ImportedAPI.SV_CloseEnough;
//	c_yes = ImportedAPI.c_yes;
//	c_no = ImportedAPI.c_no;
	G_RunEntity = ImportedAPI.G_RunEntity;
	SV_TestEntityPosition = ImportedAPI.SV_TestEntityPosition;
	SV_CheckVelocity = ImportedAPI.SV_CheckVelocity;
	SV_RunThink = ImportedAPI.SV_RunThink;
	SV_Impact = ImportedAPI.SV_Impact;
	ClipVelocity = ImportedAPI.ClipVelocity;
	SV_FlyMove = ImportedAPI.SV_FlyMove;
	SV_AddGravity = ImportedAPI.SV_AddGravity;
	SV_PushEntity = ImportedAPI.SV_PushEntity;
	SV_Push = ImportedAPI.SV_Push;
	SV_Physics_Pusher = ImportedAPI.SV_Physics_Pusher;
	SV_Physics_None = ImportedAPI.SV_Physics_None;
	SV_Physics_Noclip = ImportedAPI.SV_Physics_Noclip;
	SV_Physics_Toss = ImportedAPI.SV_Physics_Toss;
	SV_AddRotationalFriction = ImportedAPI.SV_AddRotationalFriction;
	SV_Physics_Step = ImportedAPI.SV_Physics_Step;
	SaveClientData = ImportedAPI.SaveClientData;
	FetchClientEntData = ImportedAPI.FetchClientEntData;
	EndDMLevel = ImportedAPI.EndDMLevel;
	CheckDMRules = ImportedAPI.CheckDMRules;
	ExitLevel = ImportedAPI.ExitLevel;
	g_edicts = ImportedAPI.g_edicts;
	deathmatch = ImportedAPI.deathmatch;
	coop = ImportedAPI.coop;
	dmflags = ImportedAPI.dmflags;
	skill = ImportedAPI.skill;
	fraglimit = ImportedAPI.fraglimit;
	timelimit = ImportedAPI.timelimit;
	password = ImportedAPI.password;
	maxclients = ImportedAPI.maxclients;
	maxentities = ImportedAPI.maxentities;
	g_select_empty = ImportedAPI.g_select_empty;
	dedicated = ImportedAPI.dedicated;
	sv_maxvelocity = ImportedAPI.sv_maxvelocity;
	sv_gravity = ImportedAPI.sv_gravity;
	sv_rollspeed = ImportedAPI.sv_rollspeed;
	sv_rollangle = ImportedAPI.sv_rollangle;
	gun_x = ImportedAPI.gun_x;
	gun_y = ImportedAPI.gun_y;
	gun_z = ImportedAPI.gun_z;
	run_pitch = ImportedAPI.run_pitch;
	run_roll = ImportedAPI.run_roll;
	bob_up = ImportedAPI.bob_up;
	bob_pitch = ImportedAPI.bob_pitch;
	bob_roll = ImportedAPI.bob_roll;
	sv_cheats = ImportedAPI.sv_cheats;
	Move_Done = ImportedAPI.Move_Done;
	Move_Final = ImportedAPI.Move_Final;
	Move_Begin = ImportedAPI.Move_Begin;
	Think_AccelMove = ImportedAPI.Think_AccelMove;
	Move_Calc = ImportedAPI.Move_Calc;
	AngleMove_Done = ImportedAPI.AngleMove_Done;
	AngleMove_Final = ImportedAPI.AngleMove_Final;
	AngleMove_Begin = ImportedAPI.AngleMove_Begin;
	AngleMove_Calc = ImportedAPI.AngleMove_Calc;
	plat_CalcAcceleratedMove = ImportedAPI.plat_CalcAcceleratedMove;
	plat_Accelerate = ImportedAPI.plat_Accelerate;
	Think_AccelMove = ImportedAPI.Think_AccelMove;
	plat_go_down = ImportedAPI.plat_go_down;
	plat_hit_top = ImportedAPI.plat_hit_top;
	plat_hit_bottom = ImportedAPI.plat_hit_bottom;
	plat_go_up = ImportedAPI.plat_go_up;
	plat_blocked  = ImportedAPI.plat_blocked ;
	Use_Plat = ImportedAPI.Use_Plat;
	Touch_Plat_Center = ImportedAPI.Touch_Plat_Center;
	plat_spawn_inside_trigger = ImportedAPI.plat_spawn_inside_trigger;
	SP_func_plat = ImportedAPI.SP_func_plat;
	rotating_blocked = ImportedAPI.rotating_blocked;
	rotating_touch = ImportedAPI.rotating_touch;
	rotating_use = ImportedAPI.rotating_use;
	SP_func_rotating = ImportedAPI.SP_func_rotating;
	button_done = ImportedAPI.button_done;
	button_return = ImportedAPI.button_return;
	button_wait = ImportedAPI.button_wait;
	button_fire = ImportedAPI.button_fire;
	button_use = ImportedAPI.button_use;
	button_touch = ImportedAPI.button_touch;
	button_killed = ImportedAPI.button_killed;
	SP_func_button = ImportedAPI.SP_func_button;
	door_use_areaportals = ImportedAPI.door_use_areaportals;
	door_go_down = ImportedAPI.door_go_down;
	door_hit_top = ImportedAPI.door_hit_top;
	door_hit_bottom = ImportedAPI.door_hit_bottom;
	door_go_up = ImportedAPI.door_go_up;
	door_use = ImportedAPI.door_use;
	Touch_DoorTrigger = ImportedAPI.Touch_DoorTrigger;
	Think_CalcMoveSpeed = ImportedAPI.Think_CalcMoveSpeed;
	Think_SpawnDoorTrigger = ImportedAPI.Think_SpawnDoorTrigger;
	door_blocked = ImportedAPI.door_blocked;
	door_killed = ImportedAPI.door_killed;
	door_touch = ImportedAPI.door_touch;
	SP_func_door = ImportedAPI.SP_func_door;
	SP_func_door_rotating = ImportedAPI.SP_func_door_rotating;
	SP_func_water = ImportedAPI.SP_func_water;
	train_next = ImportedAPI.train_next;
	train_blocked = ImportedAPI.train_blocked;
	train_wait = ImportedAPI.train_wait;
	train_resume = ImportedAPI.train_resume;
	func_train_find = ImportedAPI.func_train_find;
	train_use = ImportedAPI.train_use;
	SP_func_train = ImportedAPI.SP_func_train;
	trigger_elevator_use = ImportedAPI.trigger_elevator_use;
	trigger_elevator_init = ImportedAPI.trigger_elevator_init;
	SP_trigger_elevator = ImportedAPI.SP_trigger_elevator;
	func_timer_think = ImportedAPI.func_timer_think;
	func_timer_use = ImportedAPI.func_timer_use;
	SP_func_timer = ImportedAPI.SP_func_timer;
	func_conveyor_use = ImportedAPI.func_conveyor_use;
	SP_func_conveyor = ImportedAPI.SP_func_conveyor;
	door_secret_move1 = ImportedAPI.door_secret_move1;
	door_secret_move2 = ImportedAPI.door_secret_move2;
	door_secret_move3 = ImportedAPI.door_secret_move3;
	door_secret_move4 = ImportedAPI.door_secret_move4;
	door_secret_move5 = ImportedAPI.door_secret_move5;
	door_secret_move6 = ImportedAPI.door_secret_move6;
	door_secret_done = ImportedAPI.door_secret_done;
	door_secret_use = ImportedAPI.door_secret_use;
	door_secret_blocked = ImportedAPI.door_secret_blocked;
	door_secret_die = ImportedAPI.door_secret_die;
	SP_func_door_secret = ImportedAPI.SP_func_door_secret;
	use_killbox = ImportedAPI.use_killbox;
	SP_func_killbox = ImportedAPI.SP_func_killbox;
	Use_Target_Tent = ImportedAPI.Use_Target_Tent;
	SP_target_temp_entity = ImportedAPI.SP_target_temp_entity;
	Use_Target_Speaker = ImportedAPI.Use_Target_Speaker;
	SP_target_speaker = ImportedAPI.SP_target_speaker;
	Use_Target_Help = ImportedAPI.Use_Target_Help;
	SP_target_help = ImportedAPI.SP_target_help;
	use_target_secret = ImportedAPI.use_target_secret;
	SP_target_secret = ImportedAPI.SP_target_secret;
	use_target_goal = ImportedAPI.use_target_goal;
	SP_target_goal = ImportedAPI.SP_target_goal;
	target_explosion_explode = ImportedAPI.target_explosion_explode;
	use_target_explosion = ImportedAPI.use_target_explosion;
	use_target_changelevel = ImportedAPI.use_target_changelevel;
	SP_target_changelevel = ImportedAPI.SP_target_changelevel;
	use_target_splash = ImportedAPI.use_target_splash;
	use_target_spawner = ImportedAPI.use_target_spawner;
	ED_CallSpawn = ImportedAPI.ED_CallSpawn;
	SP_target_spawner = ImportedAPI.SP_target_spawner;
	use_target_blaster = ImportedAPI.use_target_blaster;
	SP_target_blaster = ImportedAPI.SP_target_blaster;
	trigger_crosslevel_trigger_use = ImportedAPI.trigger_crosslevel_trigger_use;
	SP_target_crosslevel_trigger = ImportedAPI.SP_target_crosslevel_trigger;
	target_crosslevel_target_think = ImportedAPI.target_crosslevel_target_think;
	SP_target_crosslevel_target = ImportedAPI.SP_target_crosslevel_target;
	target_laser_think = ImportedAPI.target_laser_think;
	target_laser_on = ImportedAPI.target_laser_on;
	target_laser_off = ImportedAPI.target_laser_off;
	target_laser_use = ImportedAPI.target_laser_use;
	target_laser_start = ImportedAPI.target_laser_start;
	SP_target_laser = ImportedAPI.SP_target_laser;
	target_lightramp_think = ImportedAPI.target_lightramp_think;
	target_lightramp_use = ImportedAPI.target_lightramp_use;
	SP_target_lightramp = ImportedAPI.SP_target_lightramp;
	target_earthquake_think = ImportedAPI.target_earthquake_think;
	target_earthquake_use = ImportedAPI.target_earthquake_use;
	SP_target_earthquake = ImportedAPI.SP_target_earthquake;
	InitTrigger = ImportedAPI.InitTrigger;
	multi_wait = ImportedAPI.multi_wait;
	multi_trigger = ImportedAPI.multi_trigger;
	Use_Multi = ImportedAPI.Use_Multi;
	Touch_Multi = ImportedAPI.Touch_Multi;
	trigger_enable = ImportedAPI.trigger_enable;
	Use_Multi = ImportedAPI.Use_Multi;
	Touch_Multi = ImportedAPI.Touch_Multi;
	trigger_enable = ImportedAPI.trigger_enable;
	SP_trigger_multiple = ImportedAPI.SP_trigger_multiple;
	SP_trigger_once = ImportedAPI.SP_trigger_once;
	trigger_relay_use = ImportedAPI.trigger_relay_use;
	SP_trigger_relay = ImportedAPI.SP_trigger_relay;
	trigger_key_use = ImportedAPI.trigger_key_use;
	SP_trigger_key = ImportedAPI.SP_trigger_key;
	trigger_counter_use = ImportedAPI.trigger_counter_use;
	SP_trigger_counter = ImportedAPI.SP_trigger_counter;
	SP_trigger_always = ImportedAPI.SP_trigger_always;
	trigger_push_touch = ImportedAPI.trigger_push_touch;
	SP_trigger_push = ImportedAPI.SP_trigger_push;
	hurt_use = ImportedAPI.hurt_use;
	hurt_touch = ImportedAPI.hurt_touch;
	SP_trigger_hurt = ImportedAPI.SP_trigger_hurt;
	trigger_gravity_touch = ImportedAPI.trigger_gravity_touch;
	SP_trigger_gravity = ImportedAPI.SP_trigger_gravity;
	trigger_monsterjump_touch = ImportedAPI.trigger_monsterjump_touch;
	SP_trigger_monsterjump = ImportedAPI.SP_trigger_monsterjump;
	AnglesNormalize = ImportedAPI.AnglesNormalize;
	turret_blocked = ImportedAPI.turret_blocked;
	turret_breach_fire = ImportedAPI.turret_breach_fire;
	turret_breach_think = ImportedAPI.turret_breach_think;
	turret_breach_finish_init = ImportedAPI.turret_breach_finish_init;
	SP_turret_breach = ImportedAPI.SP_turret_breach;
	SP_turret_base = ImportedAPI.SP_turret_base;
	turret_driver_die = ImportedAPI.turret_driver_die;
	turret_driver_think = ImportedAPI.turret_driver_think;
	turret_driver_link = ImportedAPI.turret_driver_link;
	SP_turret_driver = ImportedAPI.SP_turret_driver;
	SnapToEights = ImportedAPI.SnapToEights;
	// q_shared.c
	RotatePointAroundVector = ImportedAPI.RotatePointAroundVector;
	AngleVectors = ImportedAPI.AngleVectors;
	ProjectPointOnPlane = ImportedAPI.ProjectPointOnPlane;
	PerpendicularVector = ImportedAPI.PerpendicularVector;
	R_ConcatRotations = ImportedAPI.R_ConcatRotations;
	R_ConcatTransforms = ImportedAPI.R_ConcatTransforms;
	Q_fabs = ImportedAPI.Q_fabs;
	LerpAngle = ImportedAPI.LerpAngle;
	anglemod = ImportedAPI.anglemod;
	BoxOnPlaneSide2 = ImportedAPI.BoxOnPlaneSide2;
	BoxOnPlaneSide = ImportedAPI.BoxOnPlaneSide;
	ClearBounds = ImportedAPI.ClearBounds;
	AddPointToBounds = ImportedAPI.AddPointToBounds;
	VectorCompare = ImportedAPI.VectorCompare;
	VectorNormalize = ImportedAPI.VectorNormalize;
	VectorNormalize2 = ImportedAPI.VectorNormalize2;
	VectorMA = ImportedAPI.VectorMA;
	_DotProduct = ImportedAPI._DotProduct;
	_VectorSubtract = ImportedAPI._VectorSubtract;
	_VectorAdd = ImportedAPI._VectorAdd;
	_VectorCopy = ImportedAPI._VectorCopy;
	CrossProduct = ImportedAPI.CrossProduct;
	VectorLength = ImportedAPI.VectorLength;
	VectorInverse = ImportedAPI.VectorInverse;
	VectorScale = ImportedAPI.VectorScale;
	Q_log2 = ImportedAPI.Q_log2;
	COM_SkipPath = ImportedAPI.COM_SkipPath;
	COM_StripExtension = ImportedAPI.COM_StripExtension;
	COM_FileExtension = ImportedAPI.COM_FileExtension;
	COM_FileBase = ImportedAPI.COM_FileBase;
	COM_FilePath = ImportedAPI.COM_FilePath;
	COM_DefaultExtension = ImportedAPI.COM_DefaultExtension;
	ShortSwap = ImportedAPI.ShortSwap;
	ShortNoSwap = ImportedAPI.ShortNoSwap;
	LongSwap = ImportedAPI.LongSwap;
	LongNoSwap = ImportedAPI.LongNoSwap;
	FloatSwap = ImportedAPI.FloatSwap;
	FloatNoSwap = ImportedAPI.FloatNoSwap;
	Swap_Init = ImportedAPI.Swap_Init;
	va = ImportedAPI.va;
	COM_Parse = ImportedAPI.COM_Parse;
	Com_PageInMemory = ImportedAPI.Com_PageInMemory;
	Q_stricmp = ImportedAPI.Q_stricmp;
	Q_strncasecmp = ImportedAPI.Q_strncasecmp;
	Q_strcasecmp = ImportedAPI.Q_strcasecmp;
	Com_sprintf = ImportedAPI.Com_sprintf;
	Info_ValueForKey = ImportedAPI.Info_ValueForKey;
	Info_RemoveKey = ImportedAPI.Info_RemoveKey;
	Info_Validate = ImportedAPI.Info_Validate;
	Info_SetValueForKey = ImportedAPI.Info_SetValueForKey;

	
//	level ImportedAPI.level;
}

/**********************************************************
 * MODULE_SetGlobals()
 *
 * Called as the main plugin enters the shared library to
 * ensure that all global vars are in sync.
 *********************************************************/
void MODULE_SetGlobals(void) {
	int i;
	memcpy(&level, ImportedAPI.level, sizeof(level));
	memcpy(&globals, ImportedAPI.globals, sizeof(game_export_t));
	memcpy(&game, ImportedAPI.game, sizeof(game_locals_t));
	memcpy(&vec3_origin, ImportedAPI.vec3_origin, sizeof(vec3_t));
	itemlist = (gitem_t *)malloc(sizeof(gitem_t) * game.num_items);
	for(i=0;i<game.num_items;i++) {
		memcpy(&itemlist[i], &ImportedAPI.itemlist[i], sizeof(gitem_t));
	}
//	memcpy(itemlist, ImportedAPI.itemlist, sizeof(gitem_t) * game.num_items);
}

void ToggleExecMode(int iOffset, char cMode) {
	pcExecutionMode[iOffset] = cMode;
}


