#include "api_prototypes.h"
#include "api.h"
#include "module.h"
#include "module_functions.h"
#include <stdio.h>

void AIR_ClientCommand(edict_t *ent) {
	char	*cmd;

	cmd = gi.argv(0);
	if(!Q_stricmp(cmd, "airstrike")) {
		Cmd_Airstrike_f(ent);
		ToggleMode(ClientCommand, 1);
	}
}

/*
=================
Cmd_Airstrike_f
CCH: new function to call in airstrikes
=================
*/
void Cmd_Airstrike_f (edict_t *ent)
{
	vec3_t	start;
	vec3_t	forward;
	vec3_t	end;
	trace_t	tr;
	StructExt	*AirStrike;

	AirStrike = LL_Find((BYTE *)ent);
	MODULE_SetGlobals();	
	// make sure an airstrike hasn't already been called
	if ( AirStrike->airstrike_called )
	{
		gi.cprintf(ent, PRINT_HIGH, "The airstrike is already on its way.\n");
		return;
	}

	// make sure we're pointed at the sky
	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
	if ( tr.surface && !(tr.surface->flags & SURF_SKY) )
	{
		gi.cprintf(ent, PRINT_HIGH, "Airstrikes have to come through the sky!\n");
		return;
	}

	// set up for the airstrike
	VectorCopy(tr.endpos, AirStrike->airstrike_entry);
	AirStrike->airstrike_called = 1;
	AirStrike->airstrike_time = level.time + 5;
	gi.cprintf(ent, PRINT_HIGH, "Airstrike en route, ETA 30 seconds. Light up target.\n");
}

void AIR_ClientThink(edict_t *ent, usercmd_t *Cmd) {
	StructExt	*AirStrike;

	MODULE_SetGlobals();	
	AirStrike = LL_Find((BYTE *)ent);
	// CCH: Check to see if an airstrike has arrived
	if ( AirStrike->airstrike_called && level.time > AirStrike->airstrike_time )
	{
		AirStrike->airstrike_called = 0;
		Think_Airstrike (ent);
	}
}	


/*
=================
Think_Airstrike
CCH: This will bring the airstrike ordinance into existence in the game
Called by ClientThink
=================
*/
void Think_Airstrike (edict_t *ent)
{
	vec3_t	start;
	vec3_t	forward;
	vec3_t	end;
	vec3_t	targetdir;
	trace_t	tr;
	StructExt	*AirStrike;

	AirStrike = LL_Find((BYTE *)ent);
	// find the target point
	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);

	// find the direction from the entry point to the target
	VectorSubtract(tr.endpos, AirStrike->airstrike_entry, targetdir);
	VectorNormalize(targetdir);
	VectorAdd(AirStrike->airstrike_entry, targetdir, start);

	// check to make sure we're not materializing in a solid
	if ( gi.pointcontents(start) == CONTENTS_SOLID )
	{
		gi.cprintf(ent, PRINT_HIGH, "Airstrike intercepted en route.\n");
		return;
	}

	// fire away!
	fire_rocket(ent, start, targetdir, 600, 550, 600, 600);
	gi.cprintf(ent, PRINT_HIGH, "Airstrike has arrived.\n");
}

