/**********************************************************
Quake2 Cluster Project
An addition and modification of iD Software's Quake2 shared 
library sources which enable Quake2 servers running this 
library to interconnect other servers which speak the 
protocol developed under the Quake2 Cluster Project.
Copyright (c) 1998 Justin Randall and Todd Bliss

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be 
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more 
details. You should have received a copy of the GNU General 
Public License along with this program; if not, write to 
the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, 
Boston, MA  02111-1307, USA.
**********************************************************/
/**********************************************************
*	$Log: dbmain.c,v $
*	Revision 1.4  1998/01/29 23:26:34  logic
*	Fixed gibbable head bug.
*
*	Revision 1.3  1998/01/28 04:03:11  logic
*	I think the Big Fucking Memory Leak bug has been irradicated.
*
*	Fixed:
*	  ClusterListen, a persistant thread, was spinning ClusterMiniServer,
*	  a temporary worker thread, which would also spin some temporary and
*	  some semi-persistant threads. If those threads died, and ClusterMiniServer
*	  was no longer available, the allocated system resources would not clean
*	  up --hence the hosed servers in the morning.
*
*	  ToDo:
*	  Fix ClusterExit relinks from an entrance that is still sending keepalives.
*	   if the exit sends a keepalive to an exit that is not linked to it, then
*	   the exit should return a NACK to tell the damned thing to shutup and quit
*	   spamming the network.
*
*	  Fix the serverlist generation: it's sloppy, piggish, and doesn't take
*	    dead systems very well. Also slow and nowhere near real time. Flooding
*	    is a bad idea. I need to devise some link-state status update, perhaps
*	    by arrangning some peering capabilities --something like the "directly
*	    connected host" concept of OSPF --if a directly connect host dies, his
*	    peer(s) check their other directly connected hosts to see if they too
*	    are having problems, then a link-state advertisement (heh, LSA) can be
*	    propogated to the rest of the network advising the rest of the cluster
*	    servers that the system is not available. Likewise, when a peering
*	    arrangement is established, another LSA can advise the cluster that
*	    a new server is available. (Who said network geeks make bad programmers?)
*
*	  Add some RULES callbacks for cluster mod authors
*
*	  Add ClusterPlayerLocate() function to identify the location of a player
*	    in the cluster. (perhaps tracking his last known exit rather than
*	    flooding for his location?)
*
*	Revision 1.2  1998/01/26 23:49:55  logic
*	Autolog commenting added to original source files.
*
*	Found bugs but not yet fixed:
*	Windows95 system resources are consumed over a period of time.
*	Links die after a period of time ( > 12 hours)
*
**********************************************************/

#include "udp.h"
#include "g_local.h"
#include "windows.h"

#include <stdlib.h>
#include "cluster_globs.h"
#include "db.h"
/**********************************************************
	dbmain.c

	Main database thread.

	Don't depend on ANY of this stuff staying the same.
	I used plain english for the protocol for my own
	peace of mind. This is gonna get WAY trimmed down,
	with security added, and the whole parser is going
	away! Please, if you are coding against this source,
	use the query and registration functions I provided.
	Even then, I may change a lot about the messaging.
	This is the core of everything happening in the 
	cluster and it WILL change, I gaurantee.
**********************************************************/
int DBLinkExitSpawn(RecvMSG Packet, LinkRecord *Exits);

void SpinDBThread(void) {
	// Start the database server
	HANDLE hDBThread;
	long lThreadId;
	// G_ServerPort = 27910;	
	hDBThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) dbthread, NULL, CREATE_SUSPENDED, &lThreadId);
	if(hDBThread) {
		G_ActiveThreads++;
		if(G_ActiveThreads < 254)
			strcpy(ThreadList[G_ActiveThreads].ThreadName, "dbthread");
		SetThreadPriority(hDBThread, THREAD_PRIORITY_NORMAL);
		ResumeThread(hDBThread);
		} else {
			printf("Could not spin Master DB Thread!\n");
	}
}


void dbthread(void) {
	// Just some test crap for now, to see if my db stuff
	// is fast and stable
	int i, err;
	SOCKET sock;
	RecvMSG Client;
	ServerRecord Servers[MAX_SERVERS];
	LinkRecord Exits[MAX_LINKS];
	LinkRecord Enters[MAX_LINKS];

	// Initialize the structure array
	for(i = 0;i <= MAX_SERVERS; i++) {
		Servers[i].status = 0; // Clear the status
	}
	for(i = 0;i <= MAX_LINKS; i++) {
		memset(&Enters[i], 0, sizeof(LinkRecord));
	}

	//	Now for the main loop, listen for requests and updates (no security here yet!)
	sock = soListen(SERVER_PORT);
	
	if(sock == -1) {
		// Something really screwed up happened here
		printf("DB: This machine is already running a master.\n");
		closesocket(sock);
		G_ActiveThreads--;
		ExitThread(0);
	}
	printf("DB: Listening on port %d\n",SERVER_PORT);

	while(1) {
		// Check WSALastError to see if there are problems with the socket
		err = 0;
		if(sock == -1) {
			gi.bprintf(PRINT_HIGH, "DB: SOCKET ERROR. DB DYING!\n");	
			G_ActiveThreads--;
			ExitThread(0);
		}	
		err = GetMSG(sock, &Client);
		
		if((err < 0) || (sock < 0)) {
			printf("This computer already has a DB running\nKilling DB Process\n");
			closesocket(sock);
			ExitThread(0);
		}	

/**********************************************************
	Begin conversion
	 v0.2 - v0.3		
**********************************************************/
		if(ClusterCheckSig(Client.cData, G_ClusterKey, Client.lDataLen)) {
		} else {
			// My checksums are BROKEN bad. Don't quite know where yet
			// printf("\nDEBUG: Bad signature from %s, packet_id=%d\n", inet_ntoa(Client.saRemote.sin_addr), Client.cData[0]);
			// continue;
		}
		switch (Client.cData[0]) {
			case PKT_EXIT_SET:
				DBLinkExitSpawn(Client, Exits);
				break;
			case PKT_EXIT_GET:
				break;
			case PKT_CLIENT_SET:
				break;
			case PKT_CLIENT_GET:
				break;
			case PKT_SERVER_KEEPALIVE:
				break;
			case PKT_EXIT_KEEPALIVE:
				break;
			case PKT_ENTER_KEEPALIVE:
				break;
			case PKT_SEC_CHALLENGE:
				break;
			case PKT_SEC_RESPONSE:
				break;
			case PKT_SERVER_REG:
				DBRegServer(Client, Servers);
				break;
			case PKT_SERVER_REQ:
				// DBServerReq(Client);
				break;
			case PKT_ENTER_SET:
				DBEnterReg(Client, Enters);
				break;
			case PKT_ENTER_GET:
				DBEnterReq(Client, Enters);
				break;
			default:
				printf("DB:UNKNOWN PACKET RECEIVED\n");
				break;
		}
	}
}