/**********************************************************
Quake2 Cluster Project
An addition and modification of iD Software's Quake2 shared 
library sources which enable Quake2 servers running this 
library to interconnect other servers which speak the 
protocol developed under the Quake2 Cluster Project.
Copyright (c) 1998 Justin Randall and Todd Bliss

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be 
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more 
details. You should have received a copy of the GNU General 
Public License along with this program; if not, write to 
the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, 
Boston, MA  02111-1307, USA.
**********************************************************/
/**********************************************************
*	$Log: db.c,v $
*	Revision 1.3  1998/01/28 04:03:11  logic
*	I think the Big Fucking Memory Leak bug has been irradicated.
*
*	Fixed:
*	  ClusterListen, a persistant thread, was spinning ClusterMiniServer,
*	  a temporary worker thread, which would also spin some temporary and
*	  some semi-persistant threads. If those threads died, and ClusterMiniServer
*	  was no longer available, the allocated system resources would not clean
*	  up --hence the hosed servers in the morning.
*
*	  ToDo:
*	  Fix ClusterExit relinks from an entrance that is still sending keepalives.
*	   if the exit sends a keepalive to an exit that is not linked to it, then
*	   the exit should return a NACK to tell the damned thing to shutup and quit
*	   spamming the network.
*
*	  Fix the serverlist generation: it's sloppy, piggish, and doesn't take
*	    dead systems very well. Also slow and nowhere near real time. Flooding
*	    is a bad idea. I need to devise some link-state status update, perhaps
*	    by arrangning some peering capabilities --something like the "directly
*	    connected host" concept of OSPF --if a directly connect host dies, his
*	    peer(s) check their other directly connected hosts to see if they too
*	    are having problems, then a link-state advertisement (heh, LSA) can be
*	    propogated to the rest of the network advising the rest of the cluster
*	    servers that the system is not available. Likewise, when a peering
*	    arrangement is established, another LSA can advise the cluster that
*	    a new server is available. (Who said network geeks make bad programmers?)
*
*	  Add some RULES callbacks for cluster mod authors
*
*	  Add ClusterPlayerLocate() function to identify the location of a player
*	    in the cluster. (perhaps tracking his last known exit rather than
*	    flooding for his location?)
*
*	Revision 1.2  1998/01/26 23:49:54  logic
*	Autolog commenting added to original source files.
*
*	Found bugs but not yet fixed:
*	Windows95 system resources are consumed over a period of time.
*	Links die after a period of time ( > 12 hours)
*
**********************************************************/

#include "udp.h"
#include "g_local.h"
#include <time.h>
#include "cluster_globs.h"
#include "db.h"

/**********************************************************
	db.c

	Core database functions for servers acting as masters
	Sparse documentation right now. My apologies.
**********************************************************/

/**********************************************************
	v0.2 to v0.3 protocol conversion
**********************************************************/
int DBRegServer(RecvMSG Packet, ServerRecord *Servers) {
	int i, retval;
	ServerRegPacket Data;
	char addr[64];

	strcpy(addr, inet_ntoa(Packet.saRemote.sin_addr));
	retval = -1;
	memcpy(&Data, &Packet.cData, sizeof(ServerRegPacket));
	for(i = 0; i< MAX_SERVERS; i++) {
		// First pass, check for dupes
		if((stricmp(Servers[i].addr, addr) == 0) && Servers[i].port == ClusterCharToUS(Data.port)) {
			Servers[i].status = 1;
			strcpy(Servers[i].addr, inet_ntoa(Packet.saRemote.sin_addr));
			Servers[i].port = ClusterCharToUS(Data.port);
			Servers[i].comport = ClusterCharToUS(Data.comport);
			Servers[i].max_clients = Data.max_clients;
			Servers[i].clients = Data.clients;
			retval = i;
			break;
		}
	}
	if(retval < 0) {	// No duplicates found in first pass, locate empty record
		for(i = 0; i < MAX_SERVERS; i++) {
			if(Servers[i].status == 0) {
				Servers[i].status = 1;
				strcpy(Servers[i].addr, inet_ntoa(Packet.saRemote.sin_addr));
				Servers[i].port = ClusterCharToUS(Data.port);
				Servers[i].comport = ClusterCharToUS(Data.comport);
				Servers[i].max_clients = Data.max_clients;
				Servers[i].clients = Data.clients;
				retval = i;
				break;
			}
		}
	}
	return retval;
}

int DBLinkExitSpawn(RecvMSG Packet, LinkRecord *Exits) {
	// Needs work
	return 0;
}


void DBEnterReq(RecvMSG Packet, LinkRecord *Enters) {
	/*	A remote server exit has sent a request
		for an entrance entity on this server.
		Send a message to the local entrance
		entity, telling it to send heartbeats
		to the remote exit.
	*/

	char addr[17];			// return to addr
	unsigned short iPort;
	ServerReqPacket Request;
	char name[16];
	int i, use_index;
	unsigned char nack_response;
	ReqLinkHeartbeatPacket	hbRequest;
	char localaddr[64] = {"\0"};
	
	strcpy(localaddr, inet_ntoa(G_ServerAddr));
	i = 0;
	use_index = -1;
	memcpy(&Request, &Packet.cData, sizeof(ServerReqPacket));
	strcpy(addr, inet_ntoa(Packet.saRemote.sin_addr));
	iPort = ClusterCharToUS(Request.ms_port);
	strcpy(name, Request.link_dest);

	// Find the entrance entity with the requested name
	for(i = 0; i<=MAX_LINKS; i++) {

		if(stricmp(Enters[i].name, Request.link_dest) == 0) {
			// Found the entrance
			use_index = i;
			break;
		}
	}
	if(use_index > -1) {
		hbRequest.packet_id = PKT_ENTER_REQ_HB;
		ClusterIntToBytes(iPort, hbRequest.remote_ms_port);
		ClusterDDIPToBytes(addr, hbRequest.addr);
		// strcpy(hbRequest.addr, addr);
		strcpy(hbRequest.name, Request.link_dest);
		
		ClusterSendMSG(localaddr, Enters[use_index].my_ms_port, (unsigned char *)&hbRequest, sizeof(ReqLinkHeartbeatPacket), G_ClusterKey);
	} else {
		nack_response = PKT_ENTER_GET_NACK;
		ClusterSendMSG(addr, iPort, &nack_response, 1, G_ClusterKey);
	}
		
}

int DBEnterReg(RecvMSG Packet, LinkRecord *Enters) {
	/*	A server is registering an entrance entity
		with the database. 
	*/
	ClusterLinkRegPacket LinkPacket;
	int i, use_index;

	i = 0;
	use_index = -1;
	memcpy(&LinkPacket, &Packet.cData, sizeof(ClusterLinkRegPacket));

	// Search for duplicates
	for(i=0; i<=MAX_LINKS; i++) {
		if(stricmp(Enters[i].name, LinkPacket.name) == 0) {
			// Duplicate registration
			use_index = i;
			break;
		}
	}
	if(use_index < 0) {
		// Didn't find any dupes, search for an empty record
		for(i=0; i<=MAX_LINKS; i++) {
			if(Enters[i].status == 0) {
				// Got a blank, use this record
				use_index = i;
				break;
			}
		}
	}
	if(use_index > -1) {
		// One of the previous loops provided us with
		// a good record #
		Enters[use_index].status = 1;
		strcpy(Enters[use_index].myaddr, inet_ntoa(Packet.saRemote.sin_addr));
		Enters[use_index].my_ms_port = ClusterCharToUS(LinkPacket.ms_port);
		Enters[use_index].my_q2_port = ClusterCharToUS(LinkPacket.q2_port);
		if(sizeof(LinkPacket.name) < 17)	// Thwart hackers trying to crash box by overrunning data
			strcpy(Enters[use_index].name, LinkPacket.name);
	}
	return use_index;
}


