/**********************************************************
*	$Log: cluster_interpreter.c,v $
*	Revision 1.7  1998/02/01 16:51:48  logic
*	Moved RULES_SetInvinc to RULES_PutClientInServer2
*
*	Revision 1.6  1998/02/01 15:07:19  logic
*	Release 0.3
*
*	Revision 1.5  1998/01/31 09:53:57  logic
*	Added RULES_ClientUserInfoChanged for access to client variables.
*	Fixed the password bug
*	Fixed the looping respawn/telefrag bug
*	Added Invincibility functions to RULES
*	Added ClientThink2 to RULES
*	Added RULES_ClientCmd
*	Added cmd invincible to RULES
*	Added ()'s around player names on broadcast messages
*	Added MOTD motd-mapname.txt
*	Changed invincibility fx
*
*	Revision 1.4  1998/01/29 23:26:32  logic
*	Fixed gibbable head bug.
*
*	Revision 1.3  1998/01/28 04:03:09  logic
*	I think the Big Fucking Memory Leak bug has been irradicated.
*
*	Fixed:
*	  ClusterListen, a persistant thread, was spinning ClusterMiniServer,
*	  a temporary worker thread, which would also spin some temporary and
*	  some semi-persistant threads. If those threads died, and ClusterMiniServer
*	  was no longer available, the allocated system resources would not clean
*	  up --hence the hosed servers in the morning.
*
*	  ToDo:
*	  Fix ClusterExit relinks from an entrance that is still sending keepalives.
*	   if the exit sends a keepalive to an exit that is not linked to it, then
*	   the exit should return a NACK to tell the damned thing to shutup and quit
*	   spamming the network.
*
*	  Fix the serverlist generation: it's sloppy, piggish, and doesn't take
*	    dead systems very well. Also slow and nowhere near real time. Flooding
*	    is a bad idea. I need to devise some link-state status update, perhaps
*	    by arrangning some peering capabilities --something like the "directly
*	    connected host" concept of OSPF --if a directly connect host dies, his
*	    peer(s) check their other directly connected hosts to see if they too
*	    are having problems, then a link-state advertisement (heh, LSA) can be
*	    propogated to the rest of the network advising the rest of the cluster
*	    servers that the system is not available. Likewise, when a peering
*	    arrangement is established, another LSA can advise the cluster that
*	    a new server is available. (Who said network geeks make bad programmers?)
*
*	  Add some RULES callbacks for cluster mod authors
*
*	  Add ClusterPlayerLocate() function to identify the location of a player
*	    in the cluster. (perhaps tracking his last known exit rather than
*	    flooding for his location?)
*
*	Revision 1.2  1998/01/26 23:49:52  logic
*	Autolog commenting added to original source files.
*
*	Found bugs but not yet fixed:
*	Windows95 system resources are consumed over a period of time.
*	Links die after a period of time ( > 12 hours)
*
**********************************************************/

#include "udp.h"
#include "g_local.h"
#include "cluster_globs.h"

/**********************************************************
	This is run towards the bottom of g_cmds.c in 
	ClientCommand(), a fork in the game to add cluster
	specific commands.
**********************************************************/
int ClusterCommand(char *cmd, edict_t *ent) {
	int retval;

	retval = 1;
	if (Q_stricmp (cmd, "go_hook") == 0)
		StuffDefault(ent);
	else if (Q_stricmp(cmd, "list") == 0)
		ClusterCmdList(ent);
	else if (Q_stricmp(cmd, "spawn") == 0)
		ClusterCmdSpawn(ent);
	else if (Q_stricmp(cmd, "link") == 0)
		ClusterCmdLink(ent);
	else if (Q_stricmp(cmd, "delete") == 0)
		ClusterCmdDelete(ent);
	else if (Q_stricmp(cmd, "cluster_help") == 0)
		ClusterCmdHelp(ent);
	else if (Q_stricmp(cmd, "cluster_say") == 0)
		ClusterCmdBPrintf(ent);
	else if (Q_stricmp(cmd, "cluster_version") == 0)
		ClusterCmdVersion(ent);
	else if (RULES_ClientCMD(cmd, ent))
		retval = 1;
	else
		retval = 0;

	
	return retval;
	
}

/**********************************************************
ClusterCMDSpawn(client spawning entity)

	This function handles the various entities that are 
	spawned on the fly from the client console, such as 
	exit and entrance entities.
**********************************************************/
int ClusterCmdSpawn(edict_t *ent) {
	// Issued a cmd spawn
	char *command;
	char *token;
	int retval;
	
	if(!ValidateAdmin(ent)) {
		gi.cprintf(ent, PRINT_HIGH, "You are not authorized to spawn cluster entities\n");
		return 0;
	}
	retval = 1;
	token = (char *)malloc(128);
	if(token == NULL) {
		_sleep(50);
		token = (char *)malloc(128);
		if(token == NULL) {
			printf("cluster_interpreter.c:ClusterCmdSpawn():MALLOC FAILED!\n");
			retval = 0;
		}
	}
	memset(token, 0, 128);
	if(retval) {
		command = gi.args();
		token = strtok(command, " ");
		if(token != NULL) {
			// Commands go here
			if(stricmp(token, "exit") == 0) {
				// cmd spawn exit <named>
				token = strtok(NULL, " ");
				if(token != NULL) {
					// we have a name for our exit
					SP_LinkEntity(ent, token, LINK_EXIT);
					retval = 1;
				} else {
					gi.cprintf(ent, PRINT_HIGH, "Usage: cmd spawn exit <named>\n");
					retval = 0;
				}
			} else if (stricmp(token, "entrance") == 0) {
				// cmd spawn entrance <named>
				token = strtok(NULL, " ");
				if(token != NULL) {
					// we have a name for our entrance
					SP_LinkEntity(ent, token, LINK_ENTRANCE);
					retval = 1;
				} else {
					gi.cprintf(ent, PRINT_HIGH, "Usage: cmd spawn entrance <named>\n");
					retval = 0;
				}
			}
		} else {
			gi.cprintf(ent, PRINT_HIGH, "Usage: cmd spawn <ent> [<arg1> .. <argn>]\n");
		}
	}
	free(token);
	return retval;
}

/**********************************************************
ClusterCMDList(client requesting list)

	cmd list <something>
	e.g. cmd list links
	cmd list servers
	cmd list threads (debugging stuff)
**********************************************************/
int ClusterCmdList(edict_t *ent) {
	// cmd list <option1> [<option2> .. <optionN>]
	char *command;
	char *token;
	int retval, i;

	retval = 1;
	token = (char *)malloc(128);
	if(token == NULL) {
		_sleep(50);
		token = (char *)malloc(128);
		if(token == NULL) {
			printf("cluster_interpreter.c:ClusterCmdList():MALLOC FAILED!\n");
			retval = 0;
		}
	}
	if(retval) {
		command = gi.args();
		token = strtok(command, " ");
		if(token != NULL) {
			// Commands go here
			if(stricmp(token, "links") == 0) {
				// cmd list links
				ClusterListLinks(ent);
				retval = 1;
			} else if(!stricmp(token, "servers")) {
				ClusterCMDListServers(ent);
				retval = 1;
			} else if(!stricmp(token, "threads")) {
				for(i=0;i<=G_ActiveThreads;i++) {
					if(i < 254)
						gi.cprintf(ent, PRINT_HIGH, "DEBUG: %d %s\n", i-1, ThreadList[i].ThreadName);
				}
				gi.cprintf(ent, PRINT_HIGH, "DEBUG: %d active threads\n", G_ActiveThreads);
			} else {
				gi.cprintf(ent, PRINT_HIGH, "Usage: cmd list <option1> [<option2> .. <optionN>]\n");
				retval = 0;
			}
		}
		free(token);
	}
	return retval;
}

/**********************************************************
ClusterCMDLink(client issuing the cmd link <exit>)

	establishes an interserver link between an exit entity
	and an entrance entity on another server.
**********************************************************/
int ClusterCmdLink(edict_t *ent) {
	// cmd list <option1> [<option2> .. <optionN>]
	char *command;
	char *token;
	int retval;
	char	name[16];

	if(!ValidateAdmin(ent)) {
		gi.cprintf(ent, PRINT_HIGH, "You are not authorized to link cluster entities\n");
		return 0;
	}


	retval = 1;
	token = (char *)malloc(128);
	if(token == NULL) {
		_sleep(50);
		token = (char *)malloc(128);
		if(token == NULL) {
			printf("cluster_interpreter.c:ClusterCmdList():MALLOC FAILED!\n");
			retval = 0;
		}
	}
	if(retval) {
		command = gi.args();
		token = strtok(command, " ");
		if(token != NULL) {
			// We got the name of the link
			if(strlen(token) > 15) {
				gi.cprintf(ent, PRINT_HIGH, "Link entity names are < 15 characters!\n");
				retval = 0;
			} else {
				strcpy(name, token);
				token = strtok(NULL, " ");
				if(token != NULL) {
					// got a good command line, pass to
					ClusterLinkTo(ent, name, token);
					retval = 1;
				} else {
					retval = 0;
					gi.cprintf(ent, PRINT_HIGH, "Usage: cmd link <exit name> <dest_address>\n");
				}
			}
		} else {
			retval = 0;
			gi.cprintf(ent, PRINT_HIGH, "Usage: cmd link <name> <dest_address>\n");
		}
		free(token);
	}
	return retval;
}

/**********************************************************
	ClusterCmdDelete()

	Removes an entity
**********************************************************/
int ClusterCmdDelete(edict_t *ent) {
	char *command;
	char *token;
	int retval;

	if(!ValidateAdmin(ent)) {
		gi.cprintf(ent, PRINT_HIGH, "You are not authorized to delete cluster entities\n");
		return 0;
	}

	retval = 1;
	token = (char *)malloc(128);
	if(token == NULL) {
		_sleep(50);
		token = (char *)malloc(128);
		if(token == NULL) {
			printf("cluster_interpreter.c:ClusterCmdList():MALLOC FAILED!\n");
			retval = 0;
		}
	}
	if(retval) {
		command = gi.args();
		token = strtok(command, " ");
		if(token != NULL) {
			// Commands go here
			if(!stricmp(token, "link")) {
				// Removing a link entity
				token = strtok(NULL, " ");
				if(token != NULL) {
					// We have the link name
					ClusterRemoveLink(token);
					retval = 1;
				} else {
					gi.cprintf(ent, PRINT_HIGH, "Usage: cmd delete link <link-name>\n");
					retval = 0;
				}
			} else {
				gi.cprintf(ent, PRINT_HIGH, "Usage: cmd delete link <named>\n");
				retval = 0;
			}
		}
	}
	return retval;
}

/**********************************************************
ClusterCMDHelp(client asking for help)

	Sends a list of available cluster specific commands to 
	the requesting client
**********************************************************/
int ClusterCmdHelp(edict_t *ent) {
	// Issued a cmd spawn
	int retval;
	
	retval = 1;
	if(!ValidateAdmin(ent)) {
		gi.cprintf(ent, PRINT_HIGH, "cmd list servers\n");
		gi.cprintf(ent, PRINT_HIGH, "cmd cluster_say <message>\n");
		retval = 0;
	}
	if(retval == 1) {
		gi.cprintf(ent, PRINT_HIGH, "cmd list servers\n");
		gi.cprintf(ent, PRINT_HIGH, "cmd cluster_say <message>\n");
		gi.cprintf(ent, PRINT_HIGH, "cmd spawn [entrance | exit] <name>\n");
		gi.cprintf(ent, PRINT_HIGH, "cmd link <exit-name> <server_addr>\n");
		gi.cprintf(ent, PRINT_HIGH, "cmd delete <name>\n");
		gi.cprintf(ent, PRINT_HIGH, "cmd list links\n");
	}
	RULES_CmdHelp(ent);
	return retval;
};

/**********************************************************
ClusterCmdBPrintf(client sending the message)

	Broadcasts a printf to all servers in the cluster
**********************************************************/
int ClusterCmdBPrintf(edict_t *ent) {
	char *command;
	char msg[80] = {"\0"};
	int namelen, msglen, i;
	char buf[80] = {"\0"};
	
	if(RULES_CmdClusterSay(ent)) {
		command = gi.args();
		namelen = strlen(ent->client->pers.netname);
		msglen = strlen(command);
		if(msglen > 80) {
			gi.cprintf(ent, PRINT_HIGH, "No Spam Please!\n");
			return 1;
		}
		for(i=0;i< namelen + msglen; i = i + 75 - namelen) {
			strncpy(buf, &command[i], 77 - namelen);
			sprintf(msg, "(%s): %s", ent->client->pers.netname, buf);
			ClusterSendBPrintf(msg);
		}
	}
	return 1;
}

int ClusterCmdVersion(edict_t *ent) {
	gi.cprintf(ent, PRINT_HIGH, "Cluster Project v0.3 build %s\n", G_ClusterBuild);
	return 1;
}