#include "api_prototypes.h"
#include "api.h"
#include "module.h"
#include "module_functions.h"
#include <stdio.h>

// Brute force flare splutter effect by Paul Currie <paul@stud.cs.uit.no>

void flare_explode_final (edict_t *self)
{
	G_FreeEdict (self);
}

void flare_die(edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	flare_explode_final(self);
}

void flare_explode5 (edict_t *self)
{
	self->s.effects |= EF_BFG;
	self->s.renderfx |= RF_SHELL_GREEN;
	self->nextthink = level.time + 1;
	self->think = flare_explode_final;
}

void flare_explode4 (edict_t *self)
{
	self->s.effects ^= EF_BFG;
	self->s.renderfx ^= RF_SHELL_GREEN;
	self->nextthink = level.time + 3;
	self->think = flare_explode5;
}

void flare_explode3 (edict_t *self)
{
	self->s.effects ^= EF_TELEPORTER;
	self->nextthink = level.time + 5;
	self->think = flare_explode4;
}

void flare_explode2 (edict_t *self)
{
	self->s.effects |= EF_TELEPORTER;
	self->nextthink = level.time + 2;
	self->think = flare_explode3;
}

void flare_explode (edict_t *self)
{
	self->s.effects ^= EF_TELEPORTER;
	self->nextthink = level.time + 8;
	self->think = flare_explode2;
	gi.linkentity (self);
}

// Fire flare function by John Rittenhouse <cryect@captured.com>
// Modified with the BFG and TELEPORTER tags by Paul Currie <paul@stud.cs.uit.no>

void fire_flare (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{
	edict_t *grenade;
	vec3_t  dir;
	vec3_t  forward, right, up;

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_BFG | EF_TELEPORTER; // Looks much cooler :)
	grenade->s.renderfx |= RF_SHELL_GREEN;
	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	grenade->s.modelindex = gi.modelindex ("models/objects/grenade/tris.md2");
	grenade->owner = self;
	grenade->touch = Grenade_Touch; 
	grenade->nextthink = level.time + timer;
	grenade->think = flare_explode;
	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
	grenade->classname = "flare";
	// CCH: a few more attributes to let the grenade 'die'
	VectorSet(grenade->mins, -3, -3, 0);
	VectorSet(grenade->maxs, 3, 3, 6);
	grenade->mass = 2;
	grenade->health = 10;
	grenade->die = flare_die;
	grenade->takedamage = DAMAGE_YES;
	grenade->monsterinfo.aiflags = AI_NOSTEP;

	gi.linkentity (grenade);
}


// Let's modify the ClientCommand(edict_t *ent) function
// By Paul Currie <you know the mail address by now :->

void LIGHTS_ClientCommand (edict_t *ent)
{
	char	*cmd;

	if (!ent->client)
		return;

	cmd = gi.argv(0);

	if (Q_stricmp (cmd, "flare") == 0) {
		vec3_t	start, forward, right, offset;

		MODULE_SetGlobals();

		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorSet(offset, 0, 8,  ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

		fire_flare(ent, start, forward, 1, 250, 60, 1); // A 60 second lifespan should be enough
		ToggleMode(ClientCommand, 1);
	}
}
