//*************************************************************************************
//*************************************************************************************
// File: user.cpp
//*************************************************************************************
//*************************************************************************************

#include "stdafx.h"

#include "user.h"
#include "superdef.h"
#include "shared.h"

//*************************************************************************************
//*************************************************************************************
// Function: GetUserPath
//*************************************************************************************
//*************************************************************************************

char *CUser::GetUserPath( const char *folder, const char *player, char *buff )
{
	int  x;
	int  y;
	char str [ _MAX_PATH ];
	char gtr [ _MAX_PATH ];
	char path[ _MAX_PATH ];
	char *temp;

	strcpy( str, player );
	strcpy( gtr, player );

	for ( x = strlen( str ) - 1; x >= 0; x-- )
	{
		if ( str[x] == '_' )
		{
			strcpy( gtr, &str[ x + 1 ] );

		 	str[ x + 1 ] = 0;

			strcat( str, "0" );
			strcat( str, gtr );
		}
	}

	for ( y = 0; y < 9; y++ )
	{
		while ( ( temp = strchr( str, GBadChars[y] ) ) != NULL )
		{
			x = temp - str;			

			str[x] = '_';

 			strcpy( gtr, &str[ x + 1 ] );

		 	str[ x + 1 ] = 0;

			sprintf( path, "%c", 49 + y );

			strcat( str, path );
			strcat( str, gtr  );
		}
	}
	strcpy( buff, folder  );
	strcat( buff, str     );
	strcat( buff, ".kots" );

	return buff;
}

//*************************************************************************************
//*************************************************************************************
// Function: SetMax
//*************************************************************************************
//*************************************************************************************

void CUser::SetMax( long &value, long max )
{
	if ( value > max )
		value = max;

	if ( value < 0 )
		value = 0;
}

//*************************************************************************************
//*************************************************************************************
// Function: SetMaxItems
//*************************************************************************************
//*************************************************************************************

void CUser::SetMaxItems( unsigned char &value, unsigned char max )
{
	if ( value > max )
		value = max;

	if ( value < 0 )
		value = 0;
}

//*************************************************************************************
//*************************************************************************************
// Function: GetMaxArmor
//*************************************************************************************
//*************************************************************************************

int CUser::GetMaxArmor()
{
	int x = Level();

	x = KOTS_ARMOR_BASE + x * USER_ARMOR_LEVEL;

	return x;
}

//*************************************************************************************
//*************************************************************************************
// Function: GetAmmoMulti
//*************************************************************************************
//*************************************************************************************

int CUser::GetAmmoMulti()
{
	int x = 1;

	if ( Level() >= KOTS_STRENGTH_4XAMMO )
		x = 4;
	else if ( Level() >= KOTS_STRENGTH_3XAMMO )
		x = 3;
	else if ( Level() >= KOTS_STRENGTH_2XAMMO )
		x = 2;

	return x;
}

//*************************************************************************************
//*************************************************************************************
// Function: SetAllMax
//*************************************************************************************
//*************************************************************************************

void CUser::SetAllMax()
{
	int x;

	x = GetAmmoMulti();

	SetMax( m_blaster			, 1 );
	SetMax( m_shotgun			, 1 );
	SetMax( m_sshotgun		, 1 );
	SetMax( m_mgun				, 1 );
	SetMax( m_cgun				, 1 );
	SetMax( m_glauncher		, 1 );
	SetMax( m_rlauncher		, 1 );
	SetMax( m_hyperblaster, 1 );
	SetMax( m_rgun				, 1 );
	SetMax( m_bfg					, 1 );

	SetMax( m_bullets , x * USER_BASE_BULLETS  );
	SetMax( m_shells  , x * USER_BASE_SHELLS   );
	SetMax( m_rockets , x * USER_BASE_ROCKETS  );
	SetMax( m_grenades, x * USER_BASE_GRENADES );
	SetMax( m_cells   , x * USER_BASE_CELLS    );
	SetMax( m_slugs   , x * USER_BASE_SLUGS    );
	SetMax( m_power   , x * USER_BASE_POWER    );

	SetMax( m_tballz, USER_MAX_TBALLZ  );

	SetMax( m_barmor, GetMaxArmor () );
	SetMax( m_health, GetMaxHealth() );
}

//*************************************************************************************
//*************************************************************************************
// Function: Level
//*************************************************************************************
//*************************************************************************************

int CUser::Level( long *next )
{
	int  level = 0;
	long x     = USER_LEVEL_ONE;

	for ( ;; )
	{
		if ( m_points < x )
		{
			if ( next )
				*next = x;

			return level;
		}
		x *= 2;

		level++;	 
	}
	return 0;
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: CheckName
//*************************************************************************************************************
//*************************************************************************************************************

bool CUser::CheckName( const char *player )
{
	if ( strlen( m_name ) != strlen( player ) )
		return false;

	if ( _strnicmp( m_name, player, strlen( m_name ) ) != 0 )
		return false;

	return true;
}

//*************************************************************************************
//*************************************************************************************
// Function: Encrypt
//
// Put your encryption technique here, we took ours out because we may use it again
// we did leave in the password stuff cause it's kind of simple
//
//*************************************************************************************
//*************************************************************************************

void CUser::Encrypt()
{
	int x;

	for ( x = 0; x < NAMESIZE; x++ )														   
	{																														   
		if ( m_name[x] < 1 )																			   
			m_passstff[x] = ( 32 * m_password[x] );						   
		else																											   
			m_passstff[x] = ( m_name[x] * m_password[x] );		   
																															   
		m_password[x] = 0;																				   
	}																														   
}

//*************************************************************************************
//*************************************************************************************
// Function: Decrypt
//
// Put your decryption technique here
//
//*************************************************************************************
//*************************************************************************************

bool CUser::Decrypt()
{
	int x;

	for ( x = 0; x < NAMESIZE; x++ )
	{
		if ( m_passstff[x] == 0 )
			m_password[x] = 0;
		else if ( m_name[x] < 1 )
			m_password[x] = ( m_passstff[x] / 32 );
		else
			m_password[x] = ( m_passstff[x] / m_name[x] );
	}
	return true;
}

//*************************************************************************************
//*************************************************************************************
// Function: CheckVersion
//
// Here we can change things based on the version of the user player file
//
//*************************************************************************************
//*************************************************************************************

void CUser::CheckVersion()
{
	if ( m_version < 1 )
	{
	}
}

//*************************************************************************************
//*************************************************************************************
// Function: Load
//*************************************************************************************
//*************************************************************************************

int CUser::Load( const char *folder, const char *player )
{
	char path[ _MAX_PATH ];
	FILE *file;

	unsigned long word;

	if ( player != NULL )
		GetUserPath( folder, player, path );
	else
		strcpy( path, folder );

	memset( this, 0, sizeof CUser );

	if ( ( file = fopen( path, "rb" ) ) == NULL )
		return KOTS_NOFILE;

	word = fread( this, 1, sizeof CUser, file );

	m_bCheat = false;

	fclose( file );

	if ( word != sizeof CUser )
	{
		memset( this, 0, sizeof CUser );
		return KOTS_BAD_FORMAT;
	}

	if ( !Decrypt() )
	{
		memset( this, 0, sizeof CUser );
		return KOTS_BAD_FORMAT;
	}
	SetAllMax();

	if ( player != NULL )
	{
		if ( !CheckName( player ) )
		{
			memset( this, 0, sizeof CUser );
			return KOTS_BAD_FORMAT;
		}
	}
	CheckVersion();

	if ( m_health < 1 )
		SafeRespawn();

	return KOTS_SUCCESS;
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: Save
//*************************************************************************************************************
//*************************************************************************************************************

bool CUser::Save( const char *folder, bool bTime )
{
	FILE *file;
	char path[ _MAX_PATH ];

	GetUserPath( folder, m_name, path );

	if ( m_bCheat )
		return false;

	if ( bTime )
		time( &m_lastseen ); 

	if ( !m_firstseen )
		time( &m_firstseen ); 

	if ( ( file = fopen( path, "wb" ) ) == NULL )
		return false;

	CheckVersion();

	Encrypt();

	fwrite( this, 1, sizeof CUser, file );

	fclose( file );

	Decrypt();

	return true;
}

//*************************************************************************************
//*************************************************************************************
// Function: Score
//*************************************************************************************
//*************************************************************************************

long CUser::Score( long mod )
{
	long x = m_points;

	x -= m_hole;
	x += mod;

	if ( x < m_points )
	{
		m_hole = m_points - x;
	}
	else
	{
		m_hole   = 0;
		m_points = x;
	}
	return x;
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: Ratio
//*************************************************************************************************************
//*************************************************************************************************************

float CUser::Ratio()
{
	float ratio;

	ratio = (float)(m_kills + m_killed);

	if ( ratio < 1 )
		ratio = 0.0;
	else
	{
		ratio  = m_kills / ratio;
		ratio *= 100;
	}
	return ratio;
}

//*************************************************************************************
//*************************************************************************************
// Function: NextLevel
//*************************************************************************************
//*************************************************************************************

int CUser::NextLevel()
{
	long next;

	Level( &next );

	return next;
}

//*************************************************************************************
//*************************************************************************************
// Function: CheckPass
//*************************************************************************************
//*************************************************************************************

bool CUser::CheckPass( const char *pass )
{
	if ( strlen( m_password ) < 1 || !strcmp( m_password, USER_DEFPASS ) )
	{
		strcpy( m_password, pass );
	 
	 	return true;
	}

	if ( !strcmp( m_password, pass ) )
		return true;

	return false;
}

//*************************************************************************************
//*************************************************************************************
// Function: GetMaxHealth
//*************************************************************************************
//*************************************************************************************

long CUser::GetMaxHealth()
{
	long x;

	x = KOTS_HEALTH_BASE + Level() * USER_HEALTH_LEVEL;

	return x;
}

//*************************************************************************************
//*************************************************************************************
// Function: SafeRespawn
//*************************************************************************************
//*************************************************************************************

void CUser::SafeRespawn()
{
	int x;
	int level = Level();

	m_bullets  = 0;
	m_shells   = 0;
	m_cells    = 0;
	m_grenades = 0;
	m_slugs    = 0;
	m_rockets  = 0;

	if ( m_tballz < USER_START_TBALLZ )
		m_tballz = USER_START_TBALLZ;

	m_blaster      = 1;      
	m_shotgun      = 0;      
	m_sshotgun     = 0;     
	m_mgun         = 0;         
	m_cgun         = 0;         
	m_glauncher    = 0;     
	m_rlauncher    = 0;     
	m_hyperblaster = 0;  
	m_rgun         = 0;          
	m_bfg          = 0;

	if ( level >= KOTS_LEVEL_ARMOR )
		m_barmor = KOTS_LEVEL_ARMOR_BONUS;
	else
		m_barmor = 0;
	
	for ( x = 0; x < KOTS_ITEM_COUNT; x++ )
	{
		if ( level >= x * 2 )		
			m_items[x] = KOTS_SPECIAL_COUNT; 
	}
	m_health = GetMaxHealth();
}

//*************************************************************************************************************
//*************************************************************************************************************
// Function: KillsPerMin
//*************************************************************************************************************
//*************************************************************************************************************

float CUser::KillsPerMin()
{
	float x;

	if ( m_playtime < 1 )
		return 0.0;

	x = (float)( m_playtime / 60 );
	x = m_kills / x;

	return x;
}

//*************************************************************************************
//*************************************************************************************
//*************************************************************************************
//*************************************************************************************


