//*************************************************************************************
//*************************************************************************************
// File: server.cpp
//*************************************************************************************
//*************************************************************************************

#include "stdafx.h"

extern "C"
{
#include "g_local.h"
#include "exports.h"
}
#include "../shared/user.h"
#include "kotscpp.h"

//*************************************************************************************
//*************************************************************************************
// Function: KOTSPickup_Armor
//*************************************************************************************
//*************************************************************************************

int KOTSPickup_Armor( edict_t *ent, edict_t *other )
{
	int x;
	int	old_armor_index;
	int	body_armor_index;

	CUser *user = KOTSGetUser( other );

	if ( !user )
		return false;

	gitem_armor_t	*newinfo;

	// get info on new armor
	newinfo = (gitem_armor_t *)ent->item->info;

	old_armor_index = ArmorIndex (other);

	body_armor_index = ITEM_INDEX( FindItem( "Body Armor" ) );

	// handle armor shards specially
	if ( ent->item->tag == ARMOR_SHARD )
	{
		if ( !old_armor_index )
			other->client->pers.inventory[body_armor_index] = 2;
		else
			other->client->pers.inventory[body_armor_index] += 2;
	}
	// if player has no armor, just use it
	else if (!old_armor_index)
	{
		other->client->pers.inventory[body_armor_index] = newinfo->base_count;
	}
	else
	{
		x = other->client->pers.inventory[body_armor_index];

		if ( x >= user->GetMaxArmor() )
			return false;

		x += newinfo->base_count;

		if ( x > user->GetMaxArmor() )
			x = user->GetMaxArmor();

		other->client->pers.inventory[body_armor_index] = x;
	}

	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, 20);

	return true;
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSLevelChange
//*************************************************************************************
//*************************************************************************************

void KOTSChangeScore( CUser *user, int amount, int type )
{
	bool blevel;

	blevel = user->ModScore( amount, type );

	if ( blevel )
		gi.bprintf( PRINT_MEDIUM, "***************%s GAINED A LEVEL!!!!***************\n", user->m_ent->client->pers.netname );

	if ( type == USER_KILLED || type == USER_SUICIDE )
		KOTSPlayerDie( user );
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSScoring
//*************************************************************************************
//*************************************************************************************

int KOTSScoring( edict_t *self, edict_t *attacker, int type )
{
	long  lUser;
	long  lKiller;
	CUser *user;
	CUser *killer;
 
 	user = KOTSGetUser( self );

	if ( !user )
		return 1;

	self->kotssave++;

	switch ( type )
	{
		case KOTS_SELFKILL:
			lUser = 0;

			KOTSChangeScore( user, -lUser, USER_SUICIDE );
			break;
		case KOTS_NORMAL:
		 	killer = KOTSGetUser( attacker );

			if ( !killer )
				return 1;

			attacker->kotssave++;

			lUser   = 0;
			lKiller = 1;

			KOTSChangeScore( user, -lUser, USER_KILLED );

			KOTSChangeScore( killer, lKiller, USER_KILL );

 			break;	
	}
	return 1;
}

//*************************************************************************************
//*************************************************************************************
//*************************************************************************************
//*************************************************************************************

