//*************************************************************************************
//*************************************************************************************
// File: user.h
//*************************************************************************************
//*************************************************************************************

#ifndef __USER_H__
#define __USER_H__

struct edict_s;

#define NAMESIZE 30

#define GBadChars "\\/:*?\"<>|"

#define USER_DEFPASS "changeme"

#define USER_ARMOR_BASE 	200
#define USER_HEALTH_BASE 	100
#define USER_SPAWN_INVULN 15

#define USER_ARMOR_BONUS 	5
#define USER_HEALTH_BONUS	5

#define USER_MAX_GAIN 100
#define USER_MAX_LOSS 50

#define USER_BASE_BULLETS  200
#define USER_BASE_SHELLS   100
#define USER_BASE_ROCKETS  50
#define USER_BASE_GRENADES 50
#define USER_BASE_CELLS    200
#define USER_BASE_SLUGS    50

#define USER_NONE     0
#define USER_KILL     1
#define USER_KILLED   2
#define USER_SUICIDE  3
#define USER_TELEPORT 4
#define USER_LEVELWIN 5

//*************************************************************************************
//*************************************************************************************
// Union: UInt
//*************************************************************************************
//*************************************************************************************

#pragma warning(disable : 4201) 

union UInt
{ 
	struct 
	{
		unsigned long LowPart; 
		long HighPart; 
	};
  _int64 QuadPart;
}; 

//*************************************************************************************
//*************************************************************************************
// Class: CUser
//*************************************************************************************
//*************************************************************************************

#pragma pack(1)

class CUser
{
	public:
		int m_bUnused;

		edict_s *m_ent;

		char m_name[ NAMESIZE ];

		long HighPart;

		long m_blaster;
		long m_shotgun;
		long m_sshotgun;
		long m_mgun;
		long m_cgun;
		long m_glauncher;
		long m_rlauncher;
		long m_hyperblaster;
		long m_rgun;
		long m_bfg;
		
		char m_password[ NAMESIZE ];
		
		long m_bullets;
		long m_shells;
		long m_cells;
		long m_grenades;
		long m_rockets;
		long m_slugs;
		
		unsigned short m_passstff[ NAMESIZE ];
		
		char v_blank[ 8 ];
		long m_barmor;
		
		unsigned long LowPart;
		
		long m_health;
		long m_points;
		
		unsigned long m_suicide;
		unsigned long m_kills;
		unsigned long m_killed;
		unsigned long m_teles;
		
		long m_lastseen;

		unsigned long m_playtime;

		char v_blank1[ 12 ];

		long m_version;
		long m_hole;

		char v_blank2[ 25 ];

		long m_lastport;
		char m_lastip[16];

		long m_firstseen;

		char v_blank3[ 434 ];

	public: // user.cpp
		int  Load( const char *path, const char *player );
		bool Save( const char *path, bool bTime = true );
	
		int Level      ( long *next = NULL );
		int NextLevel  ();
		int GetMaxArmor();

		long Score( long mod = 0 );

		float Ratio();
		float KillsPerMin();

		void SafeRespawn();

		int GetAmmoMulti();

		void SetMax      ( long &value, long max );
		void SetAllMax   ();
		void CheckVersion();
		long GetMaxHealth();

		void Encrypt();
		bool Decrypt();

		static char *GetUserPath( const char *folder, const char *player, char *buff );

	public: // kotsuser.cpp
		bool SetItem( const char *name, long &value, bool bSet = true );

		bool GameSave( const char *path );

		bool ModScore    ( long mod, int killtype );
		long SetMaxHealth();

		bool CheckName( const char *path );
		bool CheckPass( const char *pass );

		void Init        ();
		void Uninit      ( bool bForce = false );
		void Respawn     ();
		void SetMaxAmmo  ();
};
#pragma pack()

#endif

//*************************************************************************************
//*************************************************************************************
//*************************************************************************************
//*************************************************************************************



