//*************************************************************************************
//*************************************************************************************
// File: kotshud.cpp
//*************************************************************************************
//*************************************************************************************

#include "stdafx.h"

#include "kotshud.h"

#include "../shared/user.h"

extern "C"
{
#include "g_local.h"
#include "exports.h"
#include "p_menu.h"
}
#include "menu.h"
#include "kotscpp.h"

//*************************************************************************************
//*************************************************************************************
// Function: KOTSWorldSpawn
//*************************************************************************************
//*************************************************************************************

void KOTSWorldSpawn()
{
	gi.configstring( CS_STATUSBAR, kots_statusbar );
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSVote
//*************************************************************************************
//*************************************************************************************

static void KOTSVote( edict_t *ent, SMenu *menu )
{
	PMenu_Close( ent );

	if ( !ent || !ent->client )
		return;
		
	ent->kots_vote = menu->arg;			

	gi.cprintf( ent, PRINT_HIGH, "your vote has been registered.\n" );
}

//*************************************************************************************
//*************************************************************************************
// Function: votemenu
//*************************************************************************************
//*************************************************************************************

SMenu votemenu[] = 
{
	{ "*Norb & Mother's",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*King of the Servers",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Vote for the next map", PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "1. ",	PMENU_ALIGN_LEFT, 1, KOTSVote },
	{ "2. ",	PMENU_ALIGN_LEFT, 2, KOTSVote },
	{ "3. ",	PMENU_ALIGN_LEFT, 3, KOTSVote },
	{ "4. ",	PMENU_ALIGN_LEFT, 4, KOTSVote },
	{ "5. ",	PMENU_ALIGN_LEFT, 5, KOTSVote },
	{ "6. ",	PMENU_ALIGN_LEFT, 6, KOTSVote },
	{ "7. ",	PMENU_ALIGN_LEFT, 7, KOTSVote },
	{ "8. ",	PMENU_ALIGN_LEFT, 8, KOTSVote },
	{ "9. ",	PMENU_ALIGN_LEFT, 9, KOTSVote },
	{ "10. ",	PMENU_ALIGN_LEFT, 10, KOTSVote }
};

//*************************************************************************************
//*************************************************************************************
// Function: KOTSCmd_Vote_f
//*************************************************************************************
//*************************************************************************************

void KOTSCmd_Vote_f( edict_t *ent )
{
	int   x = 5;
	char  *s, *t;
	CUser *user = KOTSGetUser( ent );

	static const char *seps = " ,\n\r";

	if ( !user )
		return;

	if ( ent->client->kots_menu )
	{
		PMenu_Close( ent );
		return;
	}

	if ( strlen( sv_maplist->string ) < 2 )
	{
		gi.cprintf( ent, PRINT_HIGH, "no maps to vote on.\n" );
		return;
	}

	if ( gi.argc() == 2 )
	{
		ent->kots_vote = atoi( gi.argv( 1 ) );

		gi.cprintf( ent, PRINT_HIGH, "your vote has been registered.\n" );

		return;
	}
	s = strdup( sv_maplist->string );
	t = strtok( s, seps );

	while ( t != NULL && x < 15 ) 
	{
		sprintf( votemenu[x].text, "%d: %s", x - 4, t );

		x++;

		t = strtok( NULL, seps );
	}
	free(s);

	PMenu_Open( ent, votemenu, 0, x );
}

//*************************************************************************************
//*************************************************************************************
// Function: infomenu
//*************************************************************************************
//*************************************************************************************

SMenu infomenu[] = 
{
	{ "*Norb & Mother's",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*King of the Servers",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Name",		PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Level",		PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Score",		PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Points",		PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Hole",		PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					  PMENU_ALIGN_LEFT, NULL, NULL },
	{ "(TAB to Return)",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
};

//*************************************************************************************
//*************************************************************************************
// Function: KOTSCmd_Info_f
//*************************************************************************************
//*************************************************************************************

void KOTSCmd_Info_f( edict_t *ent )
{
	int   x;
	char  sname[ 50 ];
	CUser *user = KOTSGetUser( ent );

	if ( !user )
		return;

	if ( ent->client->kots_menu )
	{
		PMenu_Close( ent );
		return;
	}
	x = 3;

	sprintf( sname, "Name    : %s", user->m_name );
	strcpy( infomenu[x++].text, sname );

	sprintf( sname, "Level   : %d", user->Level() );
	strcpy( infomenu[x++].text, sname );

	sprintf( sname, "Score   : %d", user->Score() );
	strcpy( infomenu[x++].text, sname );

	sprintf( sname, "Points  : %d", user->m_points );
	strcpy( infomenu[x++].text, sname );

	sprintf( sname, "Hole    : %d", user->m_hole );
	strcpy( infomenu[x++].text, sname );

	PMenu_Open( ent, infomenu, 0, sizeof infomenu / sizeof SMenu );
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSJoin
//*************************************************************************************
//*************************************************************************************

void KOTSJoin( edict_t *ent, SMenu * )
{
	PMenu_Close( ent );

	if ( !KOTSClientCanEnter( ent ) )
		return;

	ent->client->resp.kots_ingame = true;

	ent->svflags &= ~SVF_NOCLIENT;

	gi.bprintf( PRINT_HIGH, "%s Starts Their Reign\n", ent->client->pers.netname );

	PutClientInServer( ent );
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSChaseCam
//*************************************************************************************
//*************************************************************************************

void KOTSChaseCam( edict_t *ent, SMenu * )
{
	int i;
	edict_t *e;

	if ( ent->client->chase_target ) 
	{
		ent->client->chase_target = NULL;
		PMenu_Close(ent);
		return;
	}

	for ( i = 1; i <= maxclients->value; i++ ) 
	{
		e = g_edicts + i;
	
		if (e->inuse && e->solid != SOLID_NOT) 
		{
			ent->client->chase_target = e;
			PMenu_Close(ent);
			ent->client->update_chase = true;
			break;
		}
	}
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSBack
//*************************************************************************************
//*************************************************************************************

void KOTSBack( edict_t *ent, SMenu * )
{
	PMenu_Close( ent );

	KOTSOpenJoinMenu( ent );
}

//*************************************************************************************
//*************************************************************************************
// Function: Help
//*************************************************************************************
//*************************************************************************************

SMenu helpmenu[] = {
	{ "*King of the Server",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "At the console type:",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "set kots_password yp u",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Replace yp with",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "your own unique password.",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "type it twice.",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Select Start Reign.",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Back",		PMENU_ALIGN_LEFT, NULL, KOTSBack },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ENTER to select",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ESC to Exit Menu",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "(TAB to Return)",	PMENU_ALIGN_LEFT, NULL, NULL },
};

//*************************************************************************************
//*************************************************************************************
// Function: KOTSCredits
//*************************************************************************************
//*************************************************************************************

void KOTSHelp( edict_t *ent, SMenu * )
{
	PMenu_Close( ent );

	PMenu_Open( ent, helpmenu, 12, sizeof helpmenu / sizeof SMenu );
}

//*************************************************************************************
//*************************************************************************************
// Function: Credits
//*************************************************************************************
//*************************************************************************************

SMenu creditmenu[] = {
	{ "*King of the Server",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Code:    Norb",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Code:    Mother",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Artwork: ",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Website: sifl",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Testing: Lt. Jonmaster",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Back",		PMENU_ALIGN_LEFT, NULL, KOTSBack },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Use [ and ] to move cursor",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ENTER to select",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ESC to Exit Menu",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "(TAB to Return)",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
};

//*************************************************************************************
//*************************************************************************************
// Function: KOTSCredits
//*************************************************************************************
//*************************************************************************************

void KOTSCredits( edict_t *ent, SMenu * )
{
	PMenu_Close( ent );

	PMenu_Open( ent, creditmenu, 8, sizeof creditmenu / sizeof SMenu );
}

//*************************************************************************************
//*************************************************************************************
// Function: SMenu
//*************************************************************************************
//*************************************************************************************

SMenu joinmenu[] = {
	{ "*Quake II",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Norb & Mother's",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*King of the Server",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Start your Reign",		PMENU_ALIGN_LEFT, NULL, KOTSJoin },
	{ "Help",		      PMENU_ALIGN_LEFT, NULL, KOTSHelp },
	{ "Chase Camera",	PMENU_ALIGN_LEFT, NULL, KOTSChaseCam },
	{ "Credits",		  PMENU_ALIGN_LEFT, NULL, KOTSCredits },
	{ NULL,					  PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Use [ and ] to move cursor",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ENTER to select",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ESC to Exit Menu",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "(TAB to Return)",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
};

//*************************************************************************************
//*************************************************************************************
// Function: UpdateJoinMenu
//*************************************************************************************
//*************************************************************************************

void KOTSUpdateJoinMenu( edict_t *ent )
{
	static char levelname[ 32 ];

	if ( ent->client->chase_target )
		strcpy( joinmenu[7].text, "Leave Chase Camera" );
	else
		strcpy( joinmenu[7].text, "Chase Camera" );

	levelname[0] = '*';

	if ( g_edicts[0].message )
		strncpy( levelname+1, g_edicts[0].message, sizeof(levelname) - 2 );
	else
		strncpy( levelname+1, level.mapname, sizeof(levelname) - 2 );

	levelname[sizeof(levelname) - 1] = 0;

	strcpy( joinmenu[3].text, levelname );
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSOpenJoinMenu
//*************************************************************************************
//*************************************************************************************

void KOTSOpenJoinMenu( edict_t *ent )
{
	int team;

	KOTSUpdateJoinMenu( ent );

	if ( ent->client->chase_target )
		team = 7;
	else
		team = 5;

	PMenu_Open( ent, joinmenu, team, sizeof joinmenu / sizeof SMenu );
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSShowHUD
//*************************************************************************************
//*************************************************************************************

void KOTSShowHUD( edict_t *ent )
{
	int     i;
	int     rank  = 1;
	int     total = 1;
	int     index;
	CUser   *user = KOTSGetUser( ent );
	edict_t	*cl_ent;

	ent->client->ps.stats[ STAT_KOTS_RANK     ] = 0;
	ent->client->ps.stats[ STAT_KOTS_COUNT    ] = 0;
	ent->client->ps.stats[ STAT_KOTS_LEVEL    ] = 0;
	ent->client->ps.stats[ STAT_KOTS_ITEM     ] = 1;

	if ( !user )
		return;

 	for ( i = 0; i < game.maxclients; i++ )
	{
		cl_ent = g_edicts + 1 + i;

		if ( !cl_ent->inuse )
			continue;

		if ( cl_ent == ent )
			continue;

		if ( ent->client->resp.score < game.clients[i].resp.score )
			rank++;

		total++;
	}
	index = ent->client->pers.selected_item;
	index = ent->client->pers.inventory[ index ];

	ent->client->ps.stats[ STAT_KOTS_RANK  ] = rank;
	ent->client->ps.stats[ STAT_KOTS_COUNT ] = total;
	ent->client->ps.stats[ STAT_KOTS_LEVEL ] = user->Level();
	ent->client->ps.stats[ STAT_KOTS_ITEM  ] = index;
}

//*************************************************************************************
//*************************************************************************************
// Function: KOTSScoreboardMessage
//*************************************************************************************
//*************************************************************************************

void KOTSScoreboardMessage( edict_t *ent, edict_t * )
{
	char name  [15];
	char entry [1024];
	char string[1400];
	int	 len;
	int  ilevel;
	int  itotal;
	int	 i, j, k;
	int	 total = 0;
	int	 sorted[MAX_CLIENTS];
	int	 sortedscores[MAX_CLIENTS];
	int	 score;
	int  maxsize = 1024;

	CUser *user;

	edict_t		*cl_ent;
	gclient_t	*cl;

	PMenu_Close( ent );

 	for ( i = 0; i < game.maxclients; i++ )
	{
		cl_ent = g_edicts + 1 + i;

		if ( !cl_ent->inuse )
			continue;

		score = game.clients[i].resp.score;

		for ( j = 0; j < total; j++ )
		{
			if ( score > sortedscores[ j ] )
				break;
		}

		for ( k = total; k > j; k-- )
		{
			sorted      [k] = sorted      [k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j]        = i;
		sortedscores[j]  = score;

		total++;
	}

	// print level name and exit rules
	// add the clients in sorted order
	*string = 0;
	len     = 0;

	Com_sprintf( string, sizeof string, 
	       "xv 5 yv 15 string2 \"Player\" "
	       "xv 128 yv 15 string2 \"Game\" "	
	       "xv 168 yv 15 string2 \"Lvl\" "	
	       "xv 200 yv 15 string2 \"Score\" "	
	       "xv 248 yv 15 string2 \"Ping\" " 
			 );
	len = strlen( string );

	for ( i = 0; i < total; i++ )
	{
		*entry = 0;

		cl     = &game.clients[sorted[i]];
		cl_ent = g_edicts + 1 + sorted[i];

		user = KOTSGetUser( cl_ent );

		memset( name, 0, sizeof name );

		if ( !user )
		{
			strncpy( name, cl->pers.netname, 14 );
			itotal = 0;
			ilevel = 0;
		}
		else
		{
			strncpy( name, user->m_name, 14 );

			ilevel = user->Level();
			itotal = user->Score();
		}

		Com_sprintf( entry, sizeof entry,
	         "xv 5 yv %d string2 \"%s\" "
					 "xv 128 yv %i string \"%4i %3i %5i %4i\" ", 
		       25 + i * 8,
					 name,
		       25 + i * 8,
		       cl->resp.score,
					 ilevel,
		       itotal,
		       cl->ping > 999 ? 999 : cl->ping );

		if ( len + strlen( entry ) > maxsize ) 
			break;

		strcat( string, entry );
		len = strlen(string);
	}
	gi.WriteByte  ( svc_layout );
	gi.WriteString( string );
}

//*************************************************************************************
//*************************************************************************************
//*************************************************************************************
//*************************************************************************************

