
#include "g_local.h"

//ERASER
#include "bot_procs.h"

void	Svcmd_Test_f (void)
{
	safe_cprintf (NULL, PRINT_HIGH, "Svcmd_Test_f()\n");
}

void	Svcmd_Bots_f (void)
{
	int i=2, j, len;
	char	name[128];

	while (i < gi.argc())
	{
		strcpy(name, gi.argv(i));
		len = strlen(name);

		// convert '~' to ' '
		for (j=0; j<len; j++)
			if (name[j] == '~')
				name[j] = ' ';

		spawn_bot(name);

		i++;
	}
}

void	Svcmd_Teams_f (void)
{
	int arg=2, i;
	char	team[128];

	while (arg < gi.argc())
	{
		strcpy(team, gi.argv(arg));

		i=0;
		while (i<MAX_TEAMS)
		{
			if (!bot_teams[i])
				break;

#ifdef _WIN32
			if (!_stricmp(bot_teams[i]->teamname, team) || !_stricmp(bot_teams[i]->abbrev, team))
#else
			if (!strcasecmp(bot_teams[i]->teamname, team) || !strcasecmp(bot_teams[i]->abbrev, team))
#endif
			{	// found the team, so add the bots
				bot_teams[i]->ingame = true;	// bots will be added automatically (below)
				break;
			}

			i++;
		}

		arg++;
	}
}

int	force_team = CTF_NOTEAM;

void	Svcmd_Blueteam_f (void)
{
	int i=2;

	force_team = CTF_TEAM2;
	while (i < gi.argc())
	{
//gi.dprintf("Spawning: \"%s\"\n", gi.argv(i));
		spawn_bot(gi.argv(i));

		i++;
	}

	force_team = CTF_NOTEAM;
}

void	Svcmd_Redteam_f (void)
{
	int i=2;

	force_team = CTF_TEAM1;
	while (i < gi.argc())
	{
		spawn_bot(gi.argv(i));

		i++;
	}

	force_team = CTF_NOTEAM;
}
//ERASER

//K2:Ban
void	Svcmd_Ban_f (void)
{
	char	*ip = gi.argv(2);

	if (gi.argc() >= 3)
		K2_AddIPToBanList(ip);
	else
		gi.dprintf("USAGE: sv ban <ip address>\n");


}
void	Svcmd_UnBan_f (void)
{
	char	*ip = gi.argv(2);

	if (gi.argc() >= 3)
		K2_RemoveIPFromBanList(ip);
	else
		gi.dprintf("USAGE: sv unban <ip address>\n");

}
void	Svcmd_GetIP_f(void)
{
	char	*name = gi.argv(2);
	char	*ip = NULL;

	if (gi.argc() >= 3)
	{
		ip = K2_GetPlayerIP(name);
		if (ip)
			gi.dprintf("%s's IP address is %s\n",name,ip);
		else
			gi.dprintf("Unable to retrieve IP\n",name,ip);
	}
	else
		gi.dprintf("USAGE: sv getip <ip address>\n");

}
void	Svcmd_BanList_f(void)
{
	if(numbans)
		K2_PrintBanList();
	else
		gi.dprintf("The list is empty\n");
}

/*
=================
ServerCommand

ServerCommand will be called when an "sv" command is issued.
The game can issue gi.argc() / gi.argv() commands to get the rest
of the parameters
=================
*/
void	ServerCommand (void)
{
	char	*cmd;

	cmd = gi.argv(1);
	
	//ERASER
	if (Q_stricmp (cmd, "test") == 0)
		Svcmd_Test_f ();
	else if (Q_stricmp (cmd, "bots") == 0)
		Svcmd_Bots_f ();
	else if (Q_stricmp (cmd, "teams") == 0)
		Svcmd_Teams_f ();
	else if (Q_stricmp (cmd, "bluebots") == 0)
		Svcmd_Blueteam_f ();
	else if (Q_stricmp (cmd, "redbots") == 0)
		Svcmd_Redteam_f ();
	//K2:Begin - Banning
	else if (Q_stricmp (cmd, "ban") == 0)
		Svcmd_Ban_f ();
	else if (Q_stricmp (cmd, "unban") == 0)
		Svcmd_UnBan_f ();
	else if (Q_stricmp (cmd, "getip") == 0)
		Svcmd_GetIP_f ();
	else if (Q_stricmp (cmd, "banlist") == 0)
		Svcmd_BanList_f ();
	else
		safe_cprintf (NULL, PRINT_HIGH, "Unknown server command \"%s\"\n", cmd);
}

