/*
 * Decompiled with CFR 0.152.
 */
public class UserNode {
    User user;
    UserNode next;
    UserNode prev;
    static UserNode first;
    static UserNode last;
    static int active;

    public UserNode(User user) {
        this.user = user;
        if (first == null) {
            first = this;
            this.prev = null;
        } else {
            UserNode.last.next = this;
            this.prev = last;
        }
        last = this;
        this.next = null;
        ++active;
    }

    public static int countInChannel() {
        int n = 0;
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.getUser().isInChannel()) {
                ++n;
            }
            userNode = userNode.next;
        }
        return n;
    }

    public static int countNotInChannel() {
        int n = 0;
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.getUser().isntInChannel()) {
                ++n;
            }
            userNode = userNode.next;
        }
        return n;
    }

    public static int countOnline() {
        return UserNode.countOnline(0, 5);
    }

    public static int countOnline(int n, int n2) {
        int n3 = 0;
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.getUser().isOnline() && userNode.getUser().getGroup().getLevel() >= n && userNode.getUser().getGroup().getLevel() <= n2) {
                ++n3;
            }
            userNode = userNode.next;
        }
        return n3;
    }

    public static int countUsers() {
        return active;
    }

    public static int countUsersInGroup(int n) {
        Group group = GroupNode.getGroupByLevel(n);
        if (group == null) {
            return 0;
        }
        return UserNode.countUsersInGroup(group);
    }

    public static int countUsersInGroup(Group group) {
        int n = 0;
        UserNode userNode = first;
        while (userNode != null) {
            User user = userNode.getUser();
            Group group2 = user.getGroup();
            if (group2 == group) {
                ++n;
            }
            userNode = userNode.next;
        }
        return n;
    }

    public static int getActive() {
        return active;
    }

    public static UserNode getFirst() {
        return first;
    }

    public UserNode getNext() {
        return this.next;
    }

    public static UserNode getNode(User user) {
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.user == user) {
                return userNode;
            }
            userNode = userNode.next;
        }
        return null;
    }

    public User getUser() {
        return this.user;
    }

    public static User getUserByName(String string) {
        return UserNode.getUserByName(string, true);
    }

    public static User getUserByName(String string, boolean bl) {
        if (!bl) {
            return UserNode.getUserByName(string);
        }
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.getUser().getName().equalsIgnoreCase(string)) {
                return userNode.getUser();
            }
            userNode = userNode.next;
        }
        return null;
    }

    public static User[] getUsersInChannel() {
        User[] userArray = new User[UserNode.countInChannel()];
        int n = 0;
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.getUser().isInChannel()) {
                userArray[n] = userNode.user;
                ++n;
            }
            userNode = userNode.next;
        }
        return userArray;
    }

    public static User[] getUsersInGroup(Group group) {
        User[] userArray = new User[UserNode.countUsersInGroup(group)];
        int n = 0;
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.user.getGroup() == group) {
                userArray[n] = userNode.user;
                ++n;
            }
            userNode = userNode.next;
        }
        return userArray;
    }

    public static User[] getUsersOnline() {
        User[] userArray = new User[UserNode.countOnline()];
        int n = 0;
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.getUser().isOnline()) {
                userArray[n] = userNode.getUser();
                ++n;
            }
            userNode = userNode.next;
        }
        return userArray;
    }

    public void remove() {
        if (first == this) {
            first = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (last == this) {
            last = this.prev;
        } else {
            this.next.prev = this.prev;
        }
        --active;
    }

    public static void remove(User user) {
        UserNode.getNode(user).remove();
    }

    public static String userNames() {
        StringBuffer stringBuffer = new StringBuffer();
        UserNode userNode = first;
        while (userNode != null) {
            stringBuffer.append(" " + userNode.getUser().getName());
            userNode = userNode.next;
        }
        return stringBuffer.toString().trim();
    }

    public static String userNamesOnline() {
        return UserNode.userNamesOnline(0, 5);
    }

    public static String userNamesOnline(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        UserNode userNode = first;
        while (userNode != null) {
            if (userNode.getUser().isOnline() && userNode.getUser().getGroup().getLevel() >= n && userNode.getUser().getGroup().getLevel() <= n2) {
                stringBuffer.append(" " + userNode.getUser().getName());
            }
            userNode = userNode.next;
        }
        return stringBuffer.toString().trim();
    }
}

