/*
 * Decompiled with CFR 0.152.
 */
public class UserManager
implements Runnable {
    Bot bot;
    User statsUser;
    int[] stats = new int[3];
    int statsCount;

    public UserManager(Bot bot) {
        this.bot = bot;
    }

    protected void checkLoggedOff() {
        try {
            UserNode userNode = UserNode.getFirst();
            while (userNode != null) {
                User user = userNode.getUser();
                if (!user.checkState() && user.isOnline() && user.notifyOthers() && user.getGroup().notifyOthers()) {
                    this.loggedOff(user);
                }
                userNode = userNode.getNext();
            }
        }
        catch (Exception exception) {
            Bot.message(3, "Error in UserManager while checking users: " + exception);
        }
    }

    public void joinedChannel(User user) {
        try {
            Bot.message(1, "Joined: " + user.getName() + " - " + user.getGroup().getName());
            this.sendMemos(user);
            if (!user.isOnline()) {
                this.loggedOn(user);
            }
            user.setInChannel(true);
            User[] userArray = UserNode.getUsersOnline();
            int n = 0;
            while (n < userArray.length) {
                if (userArray[n].channelMonitoring() && !userArray[n].isInChannel() && userArray[n] != user) {
                    this.bot.send(2, "/msg " + userArray[n].getName() + " " + user.getName() + " " + new RandomString("has joined our channel/has join the club :)/is in my channel"));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Bot.message(3, "Exception in UserManager.joinedChannel(): " + exception);
        }
    }

    public void leftChannel(User user) {
        try {
            Bot.message(1, "Left: " + user.getName() + " - " + user.getGroup().getName());
            user.setInChannel(false);
            if (!user.notifyOthers()) {
                user.setOnline(false);
            }
            if (user.getGroup().autoRemove()) {
                UserNode.remove(user);
            }
            User[] userArray = UserNode.getUsersOnline();
            int n = 0;
            while (n < userArray.length) {
                if (userArray[n].channelMonitoring() && !userArray[n].isInChannel() && userArray[n] != user) {
                    this.bot.send(2, "/msg " + userArray[n].getName() + " " + user.getName() + " " + new RandomString("has left our channel/has left the club :)/is not in my channel any longer"));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Bot.message(3, "Exception in UserManager.leftChannel(): " + exception);
        }
    }

    public void loggedOff(User user) {
        try {
            Bot.message(2, "Logged off: " + user.getName() + " - " + user.getGroup().getName());
            user.setOnline(false);
            user.setSeen(System.currentTimeMillis() / 1000L);
            UserNode userNode = UserNode.getFirst();
            while (userNode != null) {
                if (userNode.getUser().isOnline() && userNode.getUser().notifyMe()) {
                    this.bot.send(2, "/msg " + userNode.getUser().getName() + " " + user.getName() + " " + new RandomString("has left us :(/has logged off :(/has left the building :(/is no longer with us :(/is gone :(/has been taken by aliens :(/has beamed up :("));
                }
                userNode = userNode.getNext();
            }
        }
        catch (Exception exception) {
            Bot.message(3, "Exception in UserManager.loggedOff(): " + exception);
        }
    }

    public void loggedOn(User user) {
        try {
            Bot.message(2, "Logged on: " + user.getName() + " - " + user.getGroup().getName());
            user.setCheckState(true);
            user.setOnline(true);
            if (!user.notifyOthers()) {
                return;
            }
            UserNode userNode = UserNode.getFirst();
            while (userNode != null) {
                User user2 = userNode.getUser();
                Group group = user2.getGroup();
                if (user2.isOnline() && user2.notifyMe()) {
                    if (user2 == user) {
                        if (UserNode.countOnline(3, 5) > 1) {
                            this.bot.send(2, "/msg " + user2.getName() + " " + new RandomString("These friends are online: /These friends are currently online: /Friends of mine right now are: ") + UserNode.userNamesOnline(3, 5));
                        } else {
                            this.bot.send(2, "/msg " + user2.getName() + " " + new RandomString("You are my only friend for the moment/You're the only one of my friends logged on right now/No one else is here, so it's up to you and me"));
                        }
                    } else {
                        this.bot.send(2, "/msg " + user2.getName() + " " + user.getName() + " " + new RandomString("has logged on! :)/has entered the building! :)/has joined us! :)/is online! :)/is here! :)/has beamed down :)"));
                    }
                }
                userNode = userNode.getNext();
            }
        }
        catch (Exception exception) {
            Bot.message(3, "Exception in UserManager.loggedOn(): " + exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        Bot.message(2, "Running UserManager");
        try {
            Thread.sleep(5000L);
            block2: while (true) {
                this.whoisAllUsers();
                if (!this.bot.threadStop()) ** GOTO lbl13
                Bot.message(2, "UserManager returning");
                return;
lbl-1000:
                // 1 sources

                {
                    if (this.bot.threadStop()) {
                        Bot.message(2, "UserManager returning");
                        return;
                    }
                    Thread.sleep(2000L);
lbl13:
                    // 2 sources

                    ** while (!this.bot.doneChecking())
                }
lbl14:
                // 1 sources

                this.checkLoggedOff();
                var1_1 = 0;
                while (true) {
                    if (var1_1 >= 10) continue block2;
                    if (this.bot.threadStop()) {
                        Bot.message(2, "UserManager returning");
                        return;
                    }
                    Thread.sleep(4000L);
                    ++var1_1;
                }
                break;
            }
        }
        catch (Exception var1_2) {
            Bot.message(3, "Error in UserManager.run(): " + var1_2);
            this.bot.restartUserManager();
            return;
        }
    }

    public void sendMemos(User user) {
        try {
            int n = Memo.countMemos(user.getName());
            if (n > 0) {
                if (n == 1) {
                    Bot.message(1, "Sending a memo to " + user.getName());
                } else {
                    Bot.message(1, "Sending " + n + " memos to " + user.getName());
                }
                if (n == 1) {
                    this.bot.send(2, "/msg " + user.getName() + new RandomString("You've got a memo!/Receiving incomming transmission.../I've got a memo for you!/You've got memo/").toString());
                } else {
                    this.bot.send(2, "/msg " + user.getName() + new RandomString(" You have / You've got / There are / Transmitting / ").toString() + n + " memos!");
                }
                Memo memo = (Memo)Node.getFirst();
                while (memo != null) {
                    if (memo.getTo().equals(user.getName())) {
                        if (memo.getTime() > 0L) {
                            this.bot.send(2, "/msg " + user.getName() + " Memo From: " + memo.getFrom() + " (" + new RelativeTime(memo.getTime()) + " ago)");
                        } else {
                            this.bot.send(2, "/msg " + user.getName() + " Memo From: " + memo.getFrom() + " (time unknown)");
                        }
                        this.bot.send(2, "/msg " + user.getName() + " " + memo.getText());
                        memo.remove();
                    }
                    memo = (Memo)memo.getNext();
                }
            }
        }
        catch (Exception exception) {
            Bot.message(3, "Error in UserManager.sendMemos(): " + exception);
        }
    }

    protected void whoisAllUsers() {
        UserNode userNode = UserNode.getFirst();
        int n = 0;
        try {
            while (userNode != null) {
                if (userNode.getUser().getGroup().notifyOthers()) {
                    userNode.getUser().setCheckState(false);
                    this.bot.send(0, "/whois " + userNode.getUser().getName());
                    ++n;
                    Thread.sleep(4000L);
                    if (this.bot.threadStop()) {
                        return;
                    }
                }
                userNode = userNode.getNext();
            }
            this.bot.totalChecked(n);
        }
        catch (Exception exception) {
            Bot.message(3, "Error in UserManager during notify checking: " + exception);
        }
    }
}

