/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

public class User {
    String name;
    Group group;
    String mode;
    String where;
    boolean online;
    boolean inChan;
    boolean checkState;
    boolean notifyMe;
    boolean notifyOthers;
    boolean channelMonitoring;
    long seen;
    long logoff;
    static final String SEPARATOR = "\t";

    public User() {
    }

    public User(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        this.name = stringTokenizer.nextToken();
        this.group = GroupNode.getGroupByName(stringTokenizer.nextToken());
        this.notifyMe = new Boolean(stringTokenizer.nextToken());
        this.notifyOthers = new Boolean(stringTokenizer.nextToken());
        this.channelMonitoring = new Boolean(stringTokenizer.nextToken());
        if (stringTokenizer.countTokens() == 10) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
        }
        this.where = stringTokenizer.nextToken();
        this.logoff = this.seen = Long.parseLong(stringTokenizer.nextToken());
        this.online = false;
        this.inChan = false;
        this.checkState = false;
    }

    public User(String string, Group group) {
        this.name = string;
        this.group = group;
        this.notifyMe = true;
        this.notifyOthers = true;
        this.online = false;
        this.inChan = false;
        this.checkState = false;
    }

    public boolean channelMonitoring() {
        if (this.group.overrideChannelMonitoring()) {
            return this.group.channelMonitoring();
        }
        return this.channelMonitoring;
    }

    public boolean checkState() {
        return this.checkState;
    }

    public Group getGroup() {
        return this.group;
    }

    public long getLogoff() {
        return this.logoff;
    }

    public String getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public long getSeen() {
        return this.seen;
    }

    public String getWhere() {
        return this.where;
    }

    public boolean isChannelMonitoring() {
        return this.channelMonitoring;
    }

    public boolean isInChannel() {
        return this.inChan && this.online;
    }

    public boolean isNotifyMe() {
        return this.notifyMe;
    }

    public boolean isNotifyOthers() {
        return this.notifyOthers();
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isntInChannel() {
        return !this.inChan && this.online;
    }

    public boolean notifyMe() {
        if (this.group.overrideNotifyMe()) {
            return this.group.notifyMe();
        }
        return this.notifyMe;
    }

    public boolean notifyOthers() {
        if (this.group.overrideNotifyOthers()) {
            return this.group.notifyOthers();
        }
        return this.notifyOthers;
    }

    public void setChannelMonitoring(boolean bl) {
        this.channelMonitoring = bl;
    }

    public void setCheckState(boolean bl) {
        this.checkState = bl;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setInChannel(boolean bl) {
        this.inChan = bl;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNotifyMe(boolean bl) {
        this.notifyMe = bl;
    }

    public void setNotifyOthers(boolean bl) {
        this.notifyOthers = bl;
    }

    public void setOnline(boolean bl) {
        this.online = bl;
        this.setCheckState(this.online);
    }

    public void setSeen(long l) {
        this.seen = l;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(SEPARATOR + this.group.getName());
        stringBuffer.append(SEPARATOR + String.valueOf(this.notifyMe));
        stringBuffer.append(SEPARATOR + String.valueOf(this.notifyOthers));
        stringBuffer.append(SEPARATOR + String.valueOf(this.channelMonitoring));
        stringBuffer.append(SEPARATOR + this.where);
        stringBuffer.append(SEPARATOR + String.valueOf(this.seen));
        return stringBuffer.toString();
    }
}

