/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Security {
    static Properties levels;
    static Properties allowances;

    protected Security() {
    }

    public static Enumeration getAllowances() {
        return allowances.propertyNames();
    }

    static String[][] getDefaultAllowances() {
        String[][] stringArray = new String[][]{{"whoAmI", "true"}, {"kickHigher", "false"}, {"banHigher", "false"}, {"changeHigherGroupLevel", "false"}, {"deleteUserWithHigherLevel", "false"}, {"changeGroupForHigher", "false"}, {"whoIsInHigherGroup", "false"}, {"notifyChangeHigher", "false"}, {"addUserWithHigherLevel", "false"}, {"flushMyMemos", "true"}, {"seenHigher", "true"}, {"memoGroup", "true"}, {"whoIsHigher", "true"}};
        return stringArray;
    }

    static String[][] getDefaultLevels() {
        String[][] stringArray = new String[][]{{"ban", "3"}, {"deleteUser", "3"}, {"raw", "5"}, {"flushAllMemos", "5"}, {"flushOwnerlessMemos", "4"}, {"whoIs", "3"}, {"goPublic", "3"}, {"whoAreYou", "3"}, {"whoHasBeenOnline", "3"}, {"whoIsOnline", "3"}, {"changeGroup", "4"}, {"changeHomeChannel", "5"}, {"kick", "3"}, {"memoAll", "4"}, {"goPrivate", "3"}, {"say", "4"}, {"shutDown", "5"}, {"flushMyMemos", "3"}, {"memoOnline", "3"}, {"newUser", "3"}, {"memoGroup", "3"}, {"reconnect", "4"}, {"seen", "3"}, {"flushMemosForSomeone", "4"}, {"who", "3"}, {"changeGroupLevel", "4"}, {"memo", "3"}, {"whoIsInGroup", "3"}, {"setRestricted", "4"}};
        return stringArray;
    }

    public static int getLevel(String string) throws NotSoSureAboutThatException {
        String string2 = levels.getProperty(string);
        if (string2 == null) {
            throw new NotSoSureAboutThatException();
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NotSoSureAboutThatException();
        }
        return n;
    }

    public static Enumeration getLevels() {
        return levels.propertyNames();
    }

    public static boolean isAllowed(String string) throws NotSoSureAboutThatException {
        String string2 = allowances.getProperty(string);
        if (string2 == null) {
            throw new NotSoSureAboutThatException();
        }
        return new Boolean(string2);
    }

    public static void listAllowances(PrintWriter printWriter) {
        allowances.list(printWriter);
    }

    public static void listLevels(PrintWriter printWriter) {
        levels.list(printWriter);
    }

    public static void load() throws FileNotFoundException, IOException {
        levels = new Properties();
        allowances = new Properties();
        levels.load(new FileInputStream("securitylevels.properties"));
        allowances.load(new FileInputStream("securityallowances.properties"));
    }

    public static void save() throws IOException, NotSoSureAboutThatException {
        String string;
        Enumeration<?> enumeration = levels.propertyNames();
        PrintWriter printWriter = new PrintWriter(new FileOutputStream("securitylevels.properties"));
        printWriter.println("# Security Levels for Java Battle.net Bot");
        printWriter.println("# The format of this file should be rather apparent. caseSensitive!");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            printWriter.println(String.valueOf(string) + " = " + Security.getLevel(string));
        }
        enumeration = allowances.propertyNames();
        printWriter.close();
        printWriter = new PrintWriter(new FileOutputStream("securityallowances.properties"));
        printWriter.println("# Security Allowances for Java Battle.net Bot");
        printWriter.println("# The format of this file should be rather apparent. caseSensitive!");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            printWriter.println(String.valueOf(string) + " = " + String.valueOf(Security.isAllowed(string)));
        }
        printWriter.close();
    }

    public static void setAllowed(String string, boolean bl) {
        ((Hashtable)allowances).put(string, String.valueOf(bl));
    }

    public static void setDefaultValues() {
        levels = new Properties();
        allowances = new Properties();
        String[][] stringArray = Security.getDefaultLevels();
        int n = 0;
        while (n < stringArray.length) {
            ((Hashtable)levels).put(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
        stringArray = Security.getDefaultAllowances();
        int n2 = 0;
        while (n2 < stringArray.length) {
            ((Hashtable)allowances).put(stringArray[n2][0], stringArray[n2][1]);
            ++n2;
        }
    }

    public static void setLevel(String string, int n) {
        ((Hashtable)levels).put(string, String.valueOf(n));
    }

    public static void verify() {
        String[][] stringArray = Security.getDefaultLevels();
        int n = 0;
        while (n < stringArray.length) {
            try {
                Security.getLevel(stringArray[n][0]);
            }
            catch (NotSoSureAboutThatException notSoSureAboutThatException) {
                ((Hashtable)levels).put(stringArray[n][0], stringArray[n][1]);
                System.out.println("Security level for " + stringArray[n][0] + " not found, set to default: " + stringArray[n][1] + " (nothing serious)");
            }
            ++n;
        }
        stringArray = Security.getDefaultAllowances();
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                Security.isAllowed(stringArray[n2][0]);
            }
            catch (NotSoSureAboutThatException notSoSureAboutThatException) {
                ((Hashtable)allowances).put(stringArray[n2][0], stringArray[n2][1]);
                System.out.println("Allowance for " + stringArray[n2][0] + " not found, set to default: " + stringArray[n2][1] + " (nothing serious)");
            }
            ++n2;
        }
    }
}

