/*
 * Decompiled with CFR 0.152.
 */
public class GroupNode {
    Group group;
    GroupNode next;
    GroupNode prev;
    static GroupNode first;
    static GroupNode last;
    static int active;

    public GroupNode(Group group) {
        this.group = group;
        if (first == null) {
            first = this;
            this.prev = null;
        } else {
            GroupNode.last.next = this;
            this.prev = last;
        }
        last = this;
        this.next = null;
        ++active;
    }

    public static int countGroups() {
        return active;
    }

    public static int countGroupsWithLevel(int n) {
        int n2 = 0;
        GroupNode groupNode = first;
        while (groupNode != null) {
            if (groupNode.getGroup().getLevel() == n) {
                ++n2;
            }
            groupNode = groupNode.next;
        }
        return n2;
    }

    public static int getActive() {
        return active;
    }

    public static GroupNode getFirst() {
        return first;
    }

    public Group getGroup() {
        return this.group;
    }

    public static Group getGroupByLevel(int n) {
        GroupNode groupNode = first;
        while (groupNode != null) {
            if (groupNode.group.getLevel() == n) {
                return groupNode.group;
            }
            groupNode = groupNode.getNext();
        }
        return null;
    }

    public static Group getGroupByName(String string) {
        GroupNode groupNode = first;
        while (groupNode != null) {
            if (groupNode.group.getName().equalsIgnoreCase(string)) {
                return groupNode.group;
            }
            groupNode = groupNode.next;
        }
        return null;
    }

    public static Group[] getGroups() {
        Group[] groupArray = new Group[active];
        int n = 0;
        GroupNode groupNode = first;
        while (groupNode != null) {
            groupArray[n] = groupNode.getGroup();
            ++n;
            groupNode = groupNode.next;
        }
        return groupArray;
    }

    public static Group[] getGroupsWithLevel(int n) {
        Group[] groupArray = new Group[GroupNode.countGroupsWithLevel(n)];
        if (groupArray.length > 0) {
            int n2 = 0;
            GroupNode groupNode = first;
            while (groupNode != null) {
                if (groupNode.getGroup().getLevel() == n) {
                    groupArray[n2] = groupNode.getGroup();
                    ++n2;
                }
                groupNode = groupNode.next;
            }
        }
        return groupArray;
    }

    public GroupNode getNext() {
        return this.next;
    }

    public static GroupNode getNode(Group group) {
        GroupNode groupNode = first;
        while (groupNode != null) {
            if (groupNode.getGroup() == group) {
                return groupNode;
            }
            groupNode = groupNode.next;
        }
        return null;
    }

    public static String groupNames() {
        StringBuffer stringBuffer = new StringBuffer();
        GroupNode groupNode = first;
        while (groupNode != null) {
            stringBuffer.append(" " + groupNode.group.getName());
            groupNode = groupNode.next;
        }
        return stringBuffer.toString().trim();
    }

    public void remove() {
        if (first == this) {
            first = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (last == this) {
            last = this.prev;
        } else {
            this.next.prev = this.prev;
        }
        --active;
    }

    public static void remove(Group group) {
        GroupNode.getNode(group).remove();
    }
}

