/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Connector {
    protected static final char CTRL_C = '\u0003';
    protected static final char CTRL_D = '\u0004';
    protected Socket sockan;
    protected PrintWriter out;
    protected BufferedReader in;
    protected Bot bot;
    protected String host;
    protected int port = 6112;

    public Connector(Bot bot) {
        this.bot = bot;
    }

    public void closeSocket() {
        try {
            this.sockan.close();
        }
        catch (IOException iOException) {
            Bot.message(3, "Error while trying to close socket: " + iOException);
        }
    }

    public boolean connect(String string, String string2, String string3) {
        this.host = string;
        Bot.message(2, "Connecting to " + string + "...");
        try {
            this.sockan = new Socket(string, this.port);
            this.out = new PrintWriter(this.sockan.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.sockan.getInputStream()));
        }
        catch (InterruptedIOException interruptedIOException) {
            Bot.message(2, "Too slow!");
            return false;
        }
        catch (NullPointerException nullPointerException) {
            Bot.message(2, "Nah, don't like that one!");
            return false;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            Bot.message(2, "Nopes, can't find a route to that!");
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            Bot.message(2, "Couldn't find " + string + ".");
            return false;
        }
        catch (ConnectException connectException) {
            Bot.message(2, "There's no answer!");
            return false;
        }
        catch (Exception exception) {
            Bot.message(3, "Error attempting to connect: " + exception);
            return false;
        }
        if (this.bot.threadStop()) {
            Bot.message(2, "Connector returning");
            return false;
        }
        try {
            this.sockan.setSoTimeout(this.bot.getTimeout());
        }
        catch (SocketException socketException) {
            Bot.message(3, "Could not set socket timeout.");
        }
        try {
            Bot.message(2, "Connected! Logging in...");
            boolean bl = true;
            this.out.print('\u0003');
            this.out.print('\u0004');
            this.out.println(String.valueOf(string2) + "\r\n" + string3 + "\r\n");
            while (bl) {
                String string4 = new String(this.in.readLine());
                Bot.message(0, string4);
                if (!string4.startsWith("2010")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                this.bot.setBnetName(stringTokenizer.nextToken());
                bl = false;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Bot.message(2, "Sorry, the server is lagging too much!");
            return false;
        }
        catch (NullPointerException nullPointerException) {
            Bot.message(2, "Connection refused!");
            return false;
        }
        catch (SocketException socketException) {
            Bot.message(2, "Connection refused!");
            return false;
        }
        catch (Exception exception) {
            Bot.message(3, "Error in login sequence: " + exception);
            return false;
        }
        Bot.message(2, "Logged in! Party on!");
        return true;
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public PrintWriter getOut() {
        return this.out;
    }
}

