/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

class BotSettingsMenu
extends Menu
implements ActionListener,
Observer {
    MenuItem config;
    MenuItem welcome;
    Bot bot;

    public BotSettingsMenu(Bot bot) {
        super("Bot");
        this.bot = bot;
        this.config = new MenuItem("Configuration...");
        this.welcome = new MenuItem("Greetings...");
        this.config.addActionListener(this);
        this.welcome.addActionListener(this);
        this.add(this.config);
        this.add(this.welcome);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.config) {
            AWTConfigurationEditor aWTConfigurationEditor = new AWTConfigurationEditor();
            aWTConfigurationEditor.addObserver(this);
        } else if (object == this.welcome) {
            new AWTWelcomingEditor();
        }
    }

    public void update(Observable observable, Object object) {
        try {
            String string = Settings.getSetting("homeChannel");
            if (!string.equalsIgnoreCase(this.bot.getHomeChannel())) {
                this.bot.newHomeChannel(string);
            } else {
                this.bot.setHomeChannel(string);
            }
            this.bot.setRestricted(Integer.parseInt(Settings.getSetting("restricted")));
            this.bot.setMessageLevel(Integer.parseInt(Settings.getSetting("msgLevel")));
            this.bot.setUsername(Settings.getSetting("username"));
            this.bot.setPassword(Settings.getSetting("password"));
            this.bot.setName(Settings.getSetting("name"));
            if (Settings.getSetting("logLevel").equals("noLogging")) {
                this.bot.setLogging(false);
            } else {
                this.bot.setLogLevel(Integer.parseInt(Settings.getSetting("logLevel")));
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in BotSettingsMenu.update(): " + exception + " - " + exception.getMessage());
        }
    }
}

