/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AWTWelcomingEditor
implements ItemListener {
    AWTLevelChoice lc;
    int level;
    TextField message;
    TextField action;
    TextField whisper;

    public AWTWelcomingEditor() {
        Frame frame = new Frame("Greetings Editor - Java Battle.net Bot");
        frame.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.add(new Label("Edit Greetings for Level: "));
        this.lc = new AWTLevelChoice();
        panel.add(this.lc);
        frame.add((Component)panel, "North");
        try {
            this.level = Integer.parseInt(this.lc.getSelectedItem().substring(0, this.lc.getSelectedItem().indexOf(32)));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("NumberFormatException in AWTWelcomingEditor");
        }
        this.message = new TextField(30);
        this.action = new TextField(30);
        this.whisper = new TextField(30);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(3, 1));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)new AWTHeaderLabel("Message"), "West");
        panel3.add((Component)this.message, "East");
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)new AWTHeaderLabel("Whisper"), "West");
        panel4.add((Component)this.whisper, "East");
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        panel5.add((Component)new AWTHeaderLabel("Action"), "West");
        panel5.add((Component)this.action, "East");
        panel2.add(panel3);
        panel2.add(panel4);
        panel2.add(panel5);
        frame.add((Component)panel2, "Center");
        this.setTexts();
        this.lc.addItemListener(this);
        Panel panel6 = new Panel();
        panel6.setLayout(new GridLayout(3, 1));
        panel6.add(new Label("A capital NAME or GROUP will be replaced"));
        panel6.add(new Label("with the user's name or group."));
        panel6.add(new Label("Greetings are sent when you enter channel."));
        frame.add((Component)panel6, "South");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AWTWelcomingEditor.this.save();
                try {
                    Settings.save();
                }
                catch (Exception exception) {
                    System.err.println("Couldn't save settings: " + exception);
                }
                Window window = windowEvent.getWindow();
                ((Component)window).setVisible(false);
                window.dispose();
            }
        });
        ((Component)frame).setBackground(Color.lightGray);
        frame.setResizable(false);
        frame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = frame.getSize();
        ((Component)frame).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)frame).setVisible(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.lc) {
            this.save();
            this.level = this.lc.getLevel();
            this.setTexts();
        }
    }

    protected void save() {
        Settings.setSetting("welcomeMessage" + this.level, this.message.getText());
        Settings.setSetting("welcomeWhisper" + this.level, this.whisper.getText());
        Settings.setSetting("welcomeAction" + this.level, this.action.getText());
    }

    protected void setTexts() {
        try {
            this.message.setText(Settings.getSetting("welcomeMessage" + this.level));
        }
        catch (NoSuchSettingException noSuchSettingException) {
            this.message.setText("");
        }
        try {
            this.whisper.setText(Settings.getSetting("welcomeWhisper" + this.level));
        }
        catch (NoSuchSettingException noSuchSettingException) {
            this.whisper.setText("");
        }
        try {
            this.action.setText(Settings.getSetting("welcomeAction" + this.level));
        }
        catch (NoSuchSettingException noSuchSettingException) {
            this.action.setText("");
        }
    }
}

