/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;

public class AWTUserEditor
extends Observable
implements ActionListener {
    User u;
    Group g;
    final Frame frame;
    final TextField nameField;
    final Choice groupChooser;
    final Label memoLabel;
    final Checkbox notifyMeCheck;
    final Checkbox notifyOthersCheck;
    final Checkbox channelMonitoringCheck;
    final Button doneButton;
    final Button flushButton;
    final Button abortButton;
    final Button deleteButton;

    public AWTUserEditor(User user) {
        this.u = user;
        this.g = user.getGroup();
        this.frame = new Frame("User " + user.getName() + " - Java Battle.net Bot");
        this.frame.setLayout(new BorderLayout());
        ((Component)this.frame).setBackground(new Color(206, 206, 206));
        this.nameField = new TextField(user.getName());
        this.groupChooser = new Choice();
        GroupNode groupNode = GroupNode.getFirst();
        while (groupNode != null) {
            this.groupChooser.add(groupNode.getGroup().getName());
            groupNode = groupNode.getNext();
        }
        this.groupChooser.select(this.g.getName());
        this.memoLabel = new Label(String.valueOf(Memo.countMemos(user.getName())));
        this.notifyMeCheck = new Checkbox("Notify Me", user.isNotifyMe());
        this.notifyOthersCheck = new Checkbox("Notify Others", user.isNotifyMe());
        this.channelMonitoringCheck = new Checkbox("Channel Monitoring", user.isChannelMonitoring());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(8, 2));
        panel.add(new AWTHeaderLabel("Name: "));
        panel.add(this.nameField);
        panel.add(new AWTHeaderLabel("Group: "));
        panel.add(this.groupChooser);
        panel.add(this.notifyMeCheck);
        if (this.g.overrideNotifyMe()) {
            panel.add(new Label("(group overrides)"));
        } else {
            panel.add(new Label("(no override)"));
        }
        panel.add(this.notifyOthersCheck);
        if (this.g.overrideNotifyOthers()) {
            panel.add(new Label("(group overrides)"));
        } else {
            panel.add(new Label("(no override)"));
        }
        panel.add(this.channelMonitoringCheck);
        if (this.g.overrideChannelMonitoring()) {
            panel.add(new Label("(group overrides)"));
        } else {
            panel.add(new Label("(no override)"));
        }
        panel.add(new AWTHeaderLabel("Unread memos:"));
        panel.add(this.memoLabel);
        panel.add(new AWTHeaderLabel("Last seen:"));
        if (user.getSeen() > 0L) {
            panel.add(new Label(new RelativeTime(user.getSeen()).toString()));
        } else {
            panel.add(new Label("Never"));
        }
        panel.add(new AWTHeaderLabel("Seen in:"));
        panel.add(new Label(user.getWhere()));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 4));
        this.doneButton = new Button("Done");
        this.flushButton = new Button("Flush memos");
        this.abortButton = new Button("Abort");
        this.deleteButton = new Button("Delete user");
        this.doneButton.addActionListener(this);
        this.flushButton.addActionListener(this);
        this.abortButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        panel2.add(this.flushButton);
        panel2.add(this.deleteButton);
        panel2.add(this.doneButton);
        panel2.add(this.abortButton);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                ((Component)window).setVisible(false);
                window.dispose();
            }
        });
        this.frame.add((Component)panel, "Center");
        this.frame.add((Component)panel2, "South");
        this.frame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.frame.getSize();
        ((Component)this.frame).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this.frame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.doneButton || object == this.abortButton || object == this.deleteButton) {
            if (object == this.doneButton) {
                String string = this.nameField.getText();
                int n = 0;
                UserNode userNode = UserNode.getFirst();
                while (userNode != null) {
                    if (userNode.getUser().getName().equals(string)) {
                        ++n;
                    }
                    userNode = userNode.getNext();
                }
                if (n > 1) {
                    string = String.valueOf(string) + n;
                }
                this.u.setName(string);
                this.u.setGroup(GroupNode.getGroupByName(this.groupChooser.getSelectedItem()));
                this.u.setNotifyMe(this.notifyMeCheck.getState());
                this.u.setNotifyOthers(this.notifyOthersCheck.getState());
                this.u.setChannelMonitoring(this.channelMonitoringCheck.getState());
                this.setChanged();
            } else if (object == this.deleteButton) {
                UserNode.remove(this.u);
                this.setChanged();
            }
            this.notifyObservers();
            ((Component)this.frame).setVisible(false);
            this.frame.dispose();
        } else if (object == this.flushButton) {
            Memo memo = (Memo)Node.getFirst();
            while (memo != null) {
                memo.remove();
                memo = (Memo)memo.getNext();
            }
            this.memoLabel.setText(String.valueOf(Memo.countMemos(this.u.getName())));
        }
    }
}

