/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;

public class AWTGroupEditor
extends Observable
implements ActionListener {
    Group g;
    final Frame frame;
    final TextField nameField;
    final TextField levelField;
    final Checkbox autoKickCheck;
    final Checkbox autoRemoveCheck;
    final Checkbox autoIgnoreCheck;
    final Checkbox notifyMeCheck;
    final Checkbox notifyOthersCheck;
    final Checkbox channelMonitoringCheck;
    final Checkbox notifyMeOverrideCheck;
    final Checkbox notifyOthersOverrideCheck;
    final Checkbox channelMonitoringOverrideCheck;
    final Button doneButton;
    final Button abortButton;
    final Button deleteButton;

    public AWTGroupEditor(Group group) {
        this.g = group;
        this.frame = new Frame("Group " + group.getName() + " - Java Battle.net Bot");
        this.frame.setLayout(new BorderLayout());
        ((Component)this.frame).setBackground(new Color(206, 206, 206));
        this.nameField = new TextField(group.getName());
        this.levelField = new TextField(String.valueOf(group.getLevel()));
        this.autoKickCheck = new Checkbox("Auto Kick", group.autoKick());
        this.autoRemoveCheck = new Checkbox("Auto Remove", group.autoRemove());
        this.autoIgnoreCheck = new Checkbox("Auto Ignore", group.autoIgnore());
        this.notifyMeCheck = new Checkbox("Notify Me", group.notifyMe());
        this.notifyOthersCheck = new Checkbox("Notify Others", group.notifyMe());
        this.channelMonitoringCheck = new Checkbox("Channel Monitoring", group.channelMonitoring());
        this.notifyMeOverrideCheck = new Checkbox("Override", group.overrideNotifyMe());
        this.notifyOthersOverrideCheck = new Checkbox("Override", group.overrideNotifyOthers());
        this.channelMonitoringOverrideCheck = new Checkbox("Override", group.overrideChannelMonitoring());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new AWTHeaderLabel("Name:"));
        panel.add(this.nameField);
        panel.add(new AWTHeaderLabel("Level:"));
        panel.add(this.levelField);
        panel.add(this.autoKickCheck);
        panel.add(this.autoRemoveCheck);
        panel.add(this.autoIgnoreCheck);
        panel.add(new Label());
        panel.add(new AWTHeaderLabel("User Defaults:"));
        panel.add(new AWTHeaderLabel("Override Users:"));
        panel.add(this.notifyMeCheck);
        panel.add(this.notifyMeOverrideCheck);
        panel.add(this.notifyOthersCheck);
        panel.add(this.notifyOthersOverrideCheck);
        panel.add(this.channelMonitoringCheck);
        panel.add(this.channelMonitoringOverrideCheck);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3));
        this.doneButton = new Button("Done");
        this.abortButton = new Button("Abort");
        this.deleteButton = new Button("Delete group");
        this.doneButton.addActionListener(this);
        this.abortButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        panel2.add(this.deleteButton);
        panel2.add(this.doneButton);
        panel2.add(this.abortButton);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                ((Component)window).setVisible(false);
                window.dispose();
            }
        });
        this.frame.add((Component)panel, "Center");
        this.frame.add((Component)panel2, "South");
        this.frame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.frame.getSize();
        ((Component)this.frame).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this.frame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.doneButton || object == this.abortButton || object == this.deleteButton) {
            if (object == this.doneButton) {
                String string = this.nameField.getText();
                int n = 0;
                GroupNode groupNode = GroupNode.getFirst();
                while (groupNode != null) {
                    if (groupNode.getGroup().getName().equals(string)) {
                        ++n;
                    }
                    groupNode = groupNode.getNext();
                }
                if (n > 1) {
                    string = String.valueOf(string) + n;
                }
                this.g.setName(string);
                try {
                    this.g.setLevel(Integer.parseInt(this.levelField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.frame.setTitle("Error: Level must be an Integer!");
                    return;
                }
                this.g.setAutoKick(this.autoKickCheck.getState());
                this.g.setAutoRemove(this.autoRemoveCheck.getState());
                this.g.setAutoIgnore(this.autoIgnoreCheck.getState());
                this.g.setNotifyMe(this.notifyMeCheck.getState());
                this.g.setNotifyOthers(this.notifyOthersCheck.getState());
                this.g.setChannelMonitoring(this.channelMonitoringCheck.getState());
                this.g.setOverrideNotifyMe(this.notifyMeOverrideCheck.getState());
                this.g.setOverrideNotifyOthers(this.notifyOthersOverrideCheck.getState());
                this.g.setOverrideChannelMonitoring(this.channelMonitoringOverrideCheck.getState());
                this.setChanged();
            } else if (object == this.deleteButton) {
                Group group = GroupNode.getGroupByName("none");
                if (group == null || group == this.g) {
                    group = GroupNode.getGroupByLevel(0);
                }
                if (group == null || group == this.g) {
                    group = new Group("groupless", 0);
                    new GroupNode(group);
                }
                UserNode userNode = UserNode.getFirst();
                while (userNode != null) {
                    if (userNode.getUser().getGroup() == this.g) {
                        userNode.getUser().setGroup(group);
                    }
                    userNode = userNode.getNext();
                }
                GroupNode.remove(this.g);
                this.setChanged();
            }
            ((Component)this.frame).setVisible(false);
            this.frame.dispose();
            this.notifyObservers();
        }
    }
}

