/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;

public class AWTConsole
implements Console,
ActionListener {
    Bot bot;
    Frame frame;
    final AWTHeaderLabel nameLabel = new AWTHeaderLabel();
    final AWTHeaderLabel chanLabel = new AWTHeaderLabel();
    final AWTHeaderLabel usersOnLabel = new AWTHeaderLabel();
    final AWTHeaderLabel inChanLabel = new AWTHeaderLabel();
    final AWTHeaderLabel gavelLabel = new AWTHeaderLabel();
    final AWTHeaderLabel lagLabel = new AWTHeaderLabel();
    final AWTHeaderLabel hostLabel = new AWTHeaderLabel();
    final AWTHeaderLabel memoLabel = new AWTHeaderLabel();
    final TextArea messages = new TextArea(15, 80);
    public final TextArea main = new TextArea(20, 80);
    public final List users = new List(15, false);
    int totalGroups;
    int totalUsers;
    MenuItem reconnectItem;
    MenuItem shutdownItem;
    MenuItem aboutItem;
    MenuItem feedbackItem;
    MenuItem chatItem;
    MenuItem updateItem;
    AWTUserMenu userMenu;
    AWTChat chat;
    Runtime runtime = Runtime.getRuntime();
    boolean isIcon;
    int infoView = 0;

    public AWTConsole(Bot bot) {
        this.bot = bot;
        Settings.setSetting("lag", "");
        this.frame = new Frame("Console - Java Battle.net Bot");
        this.isIcon = false;
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel.setLayout(new BorderLayout());
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.createInfoViewPanel(), "Center");
        panel.add((Component)panel2, "North");
        panel.add((Component)this.createMessagesPanel(), "Center");
        this.main.setFont(new Font("monospaced", 0, 12));
        this.main.setEditable(false);
        this.users.setBackground(new Color(206, 206, 206));
        this.frame.add(panel);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Bot");
        this.reconnectItem = new MenuItem("Reconnect");
        this.shutdownItem = new MenuItem("Shut Down");
        this.aboutItem = new MenuItem("About...");
        this.feedbackItem = new MenuItem("Feedback...");
        this.chatItem = new MenuItem("Chat...");
        this.updateItem = new MenuItem("Update...");
        this.reconnectItem.addActionListener(this);
        this.shutdownItem.addActionListener(this);
        this.aboutItem.addActionListener(this);
        this.feedbackItem.addActionListener(this);
        this.chatItem.addActionListener(this);
        this.updateItem.addActionListener(this);
        menu.add(this.reconnectItem);
        menu.add(this.shutdownItem);
        menu.addSeparator();
        menu.add(this.chatItem);
        menu.add(this.feedbackItem);
        menu.add(this.updateItem);
        menu.addSeparator();
        menu.add(this.aboutItem);
        menuBar.add(menu);
        menuBar.add(new SettingsMenu(bot));
        this.userMenu = new AWTUserMenu(this);
        menuBar.add(this.userMenu);
        this.frame.setMenuBar(menuBar);
        this.totalUsers = UserNode.getActive();
        this.totalGroups = GroupNode.getActive();
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AWTConsole.this.onClose();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                AWTConsole.this.onDeicon();
            }

            public void windowIconified(WindowEvent windowEvent) {
                AWTConsole.this.onIcon();
            }
        });
        ((Component)this.frame).setBackground(Color.lightGray);
        this.frame.setResizable(true);
        this.frame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.frame.getSize();
        ((Component)this.frame).setSize(dimension2.width, dimension2.height + 30);
        this.frame.pack();
        ((Component)this.frame).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this.frame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.reconnectItem) {
            this.bot.reconnect();
        }
        if (object == this.shutdownItem) {
            this.bot.shutdown();
        }
        if (object == this.chatItem && this.chat == null) {
            this.chat = new AWTChat(this);
        }
        if (object == this.feedbackItem) {
            new AWTFeedbackAgent(this.bot.getVersionID());
        }
        if (object == this.aboutItem) {
            new AWTAboutWindow();
        }
        if (object == this.updateItem) {
            new AWTUpdateChecker();
        }
    }

    public void closeChat() {
        this.chat = null;
    }

    Panel createInfoViewPanel() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        panel2.setLayout(new GridLayout(4, 2));
        panel3.setLayout(new GridLayout(4, 2));
        panel.setLayout(new GridLayout(1, 2));
        panel2.add(new Label("Name:"));
        panel2.add(this.nameLabel);
        panel2.add(new Label("Home Channel:"));
        panel2.add(this.chanLabel);
        panel2.add(new Label("Users In Channel:"));
        panel2.add(this.inChanLabel);
        panel2.add(new Label("Users Not In Channel:"));
        panel2.add(this.usersOnLabel);
        panel3.add(new Label("Battle.net Host:"));
        panel3.add(this.hostLabel);
        panel3.add(new Label("Memos to deliver:"));
        panel3.add(this.memoLabel);
        panel3.add(new Label("Has the Gavel:"));
        panel3.add(this.gavelLabel);
        panel3.add(new Label("Battle.net Lag:"));
        panel3.add(this.lagLabel);
        panel.add(panel2);
        panel.add(panel3);
        return panel;
    }

    Panel createMessagesPanel() {
        Panel panel = new Panel();
        this.messages.setFont(new Font("monospaced", 0, 12));
        this.messages.setForeground(Color.black);
        this.messages.setEditable(false);
        panel.add(this.messages);
        return panel;
    }

    public Bot getBot() {
        return this.bot;
    }

    public void message(int n, String string) {
        this.messages.append(String.valueOf(string) + "\n");
    }

    protected void onClose() {
        this.bot.shutdown();
    }

    public void onConnect() {
        this.nameLabel.setText(this.bot.getUsername());
        this.chanLabel.setText(this.bot.getHomeChannel());
        this.hostLabel.setText(this.bot.getCurrentHost());
    }

    protected void onDeicon() {
        this.isIcon = false;
        this.frame.setTitle("Console - Java Battle.net Bot");
    }

    public void onEmote(String string, String string2) {
        this.main.append("@ " + string + " " + string2 + "\n");
    }

    protected void onIcon() {
        this.isIcon = true;
    }

    public void onInfo(String string) {
        this.main.append("--- " + string + " ---\n");
    }

    public void onJoin(String string) {
        try {
            this.main.append("*** Joins: " + string + "\n");
            this.updateUsers();
        }
        catch (Exception exception) {
            Bot.message(3, "Error in AWTConsole.onJoin(): " + exception);
        }
    }

    public void onLeave(String string) {
        this.main.append("*** Leaves: " + string + "\n");
        this.updateUsers();
    }

    public void onTalk(String string, String string2) {
        this.main.append("<" + string + "> " + string2 + "\n");
    }

    public void onUser(String string) {
        this.updateUsers();
    }

    public void onWhisper(String string, String string2) {
        this.main.append("*" + string + "* " + string2 + "\n");
    }

    public void send(int n, String string) {
        this.bot.send(n, string);
    }

    public void updateInfo() {
        if (!this.isIcon) {
            if (this.bot.isOp()) {
                this.gavelLabel.setText("yes");
            } else {
                this.gavelLabel.setText("no");
            }
            String string = "";
            try {
                string = Settings.getSetting("lag");
            }
            catch (NoSuchSettingException noSuchSettingException) {}
            string = string.length() == 0 ? "unknown" : String.valueOf(string) + " seconds";
            this.lagLabel.setText(string);
            this.usersOnLabel.setText(String.valueOf(UserNode.countNotInChannel()));
            int n = UserNode.countInChannel() - 1;
            if (n < 0) {
                n = 0;
            }
            this.inChanLabel.setText(String.valueOf(n));
            this.memoLabel.setText(String.valueOf(Node.getActive()));
        } else {
            switch (this.infoView) {
                case 0: {
                    this.frame.setTitle("JavaBot 1.1");
                    ++this.infoView;
                    break;
                }
                case 1: {
                    this.frame.setTitle(String.valueOf(UserNode.countOnline() - 1) + " online/" + (UserNode.countInChannel() - 1) + " in chan");
                    this.infoView = 0;
                    break;
                }
            }
        }
        if (this.totalGroups != GroupNode.getActive() || this.totalUsers != UserNode.getActive()) {
            this.userMenu.update(new Observable(), "update");
            this.totalGroups = GroupNode.getActive();
            this.totalUsers = UserNode.getActive();
        }
    }

    void updateUsers() {
        try {
            this.users.removeAll();
            User[] userArray = UserNode.getUsersInChannel();
            int n = 0;
            while (n < userArray.length) {
                this.users.add(userArray[n].getName());
                ++n;
            }
        }
        catch (Exception exception) {
            Bot.message(3, "Error in AWTConsole.updateUsers(): " + exception);
        }
    }

    public void userMenuUpdated() {
        this.totalGroups = GroupNode.getActive();
        this.totalUsers = UserNode.getActive();
    }
}

