#include "q3la.h"

// still missing: per player info!!! kills by weapons!!!
// Netscape compatible???

output::output(resultdata* in_result, outputfile* in_out, configdata* in_config)
{
	config = in_config;
	result = in_result;
	out = in_out;
}

output::output(resultdata_total* in_result_total, outputfile* in_out, configdata* in_config, int in_gamecount)
{
	gamecount = in_gamecount;
	config = in_config;
	result_total = in_result_total;
	out = in_out;
}

output::~output()
{
}

void output::game_info() // extend!!!
{
	html::line (out, "<b>Game info</b>");
	html::table_header(out, "border=1 cellspacing=1 bordercolor=#000000");
	out->write ("<tr>\r\n");
	html::set_tdth ("bgcolor=#000080");
	html::table_entry_bold (out, "Map");
	html::set_tdth ("bgcolor=#606060");
	html::table_entry (out, "<p align=right>%s</p>", result->mapname);
	out->write ("</tr>\r\n");
	out->write ("<tr>\r\n");
	html::set_tdth ("bgcolor=#000080");
	html::table_entry_bold (out, "Timelimit");
	html::set_tdth ("bgcolor=#606060");
	html::table_entry (out, "<p align=right>%i</p>", result->timelimit);
	out->write ("</tr>\r\n");
	out->write ("<tr>\r\n");
	html::set_tdth ("bgcolor=#000080");
	html::table_entry_bold (out, "Fraglimit");
	html::set_tdth ("bgcolor=#606060");
	html::table_entry (out, "<p align=right>%i</p>", result->fraglimit);
	out->write ("</tr>\r\n");
	html::table_footer(out);
}

void output::table_kills_html(int weapon)
{
	html::set_tdth ("");
	if (result->get_total_kills(weapon) == 0) {
		return;
	}
	int i;
	int j;
	html::table_header(out, "border=1 cellspacing=0 bgcolor=#606060 bordercolor=#000000");
	out->write ("<tr bgcolor=000080>\r\n<td align=center colspan=%i><b>Killchart (%s)</b></td>\r\n</tr>\r\n", result->get_player_count()+3, weapon_name(weapon));
	out->write ("<tr>\r\n<td>&nbsp;</td>\r\n<td>&nbsp;</td>\r\n");
	for (i = 0; i < result->get_player_count(); i++) {
		out->write ("<td><p align=center><font color=#FF0000><b>%i</b></font></p></td>\r\n", i+1);
	}
	out->write ("<td><b>KILLS</b></td>\r\n");
	out->write ("</tr>\r\n");
	for (i = 0; i < result->get_player_count(); i++) {
		if (result->get_player(i)->get_name()[0] != 0) {
			out->write ("<tr>\r\n<td><b>%s</b></td>\r\n", diverse::funname_to_ascii(result->get_player(i)->get_name()));
		} else {
			out->write ("<tr>\r\n<td>&nbsp;</td>\r\n");
		}
		out->write ("<td width=20><p align=center><font color=#FF0000><b>%i</b></font></p></td>\r\n", i+1);
		for (j = 0; j < result->get_player_count(); j++) {
			if (i != j) {
				out->write ("<td width=20><p align=right>%i</p></td>\r\n", 
					result->get_kills(i,j,weapon));
			} else {
				out->write ("<td width=20><p align=right><font color=#0000FF>%i</font></p></td>\r\n", 
					result->get_kills(i,j,weapon));
			}
		}
		out->write ("<td><p align=right><b>%i</b></p></td>\r\n", 
			result->get_player_kills(i,weapon));
		out->write ("</tr>\r\n");
	}
	out->write ("<tr>\r\n<td><b>DEATHS</b></td>\r\n");
	out->write ("<td>&nbsp;</td>\r\n");
	for (i = 0; i < result->get_player_count(); i++) {
		out->write ("<td><p align=right><b>%i</b></p></td>\r\n", 
			result->get_player_killed(i,weapon));
	}
	out->write ("<td><p align=right><b>%i</b></p></td>\r\n", result->get_total_kills(weapon));
	out->write ("</tr>\r\n");
	html::table_footer(out);
	html::line_header(out); 
	html::line_footer(out);
}

void output::list_players_html()
{
	bool teamplay = false;
	if ((result->get_team_kills(1) > 0) || (result->get_team_kills(1) > 0)) {
		teamplay = true;
	}
	html::line (out, "<b>Players (sorted by %s)</b>", sortorder_string(config->sortorder_players));
	html::table_header(out, "border=1 cellspacing=0 bordercolor=#000000 bgcolor=#606060");
	out->write ("<tr align=right bgcolor=#000080>\r\n");
	html::set_tdth ("align=left width=20");
	html::table_entry_bold (out, "#");
	html::set_tdth ("align=left");
	html::table_entry_bold (out, "Name");
	if (teamplay) {
		html::table_entry_bold (out, "Team");
	}
	html::set_tdth ("");
	if (config->no_bots == false) {
		html::table_entry_bold (out, "Bot");
	}
	html::table_entry_bold (out, "Ratio");
	html::table_entry_bold (out, "Eff");
	html::table_entry_bold (out, "Skill");
	html::table_entry_bold (out, "Frags");
	html::table_entry_bold (out, "Kills");
	html::table_entry_bold (out, "Deaths");
	html::table_entry_bold (out, "Suicides");
	if (teamplay) {
		html::table_entry_bold (out, "Memberkills");
	}
	html::table_entry_bold (out, "MKIOL");
	html::table_entry_bold (out, "Avg. life");
	html::table_entry_bold (out, "FPM");
	html::table_entry_bold (out, "DPM");
	html::table_entry_bold (out, "Playtime");
	out->write ("</tr>\r\n");
	for (int i = 0; i < result->get_player_count(); i++) {
		if (i % 2 == 0) {
			out->write ("<tr align=right bgcolor=#808080>\r\n");
		} else {
			out->write ("<tr align=right>\r\n");
		}
		int kills = result->get_player_kills(i);
		int killed = result->get_player_killed(i);
		int suicides = result->get_player_suicides(i);
		int deaths = result->get_player(i)->deaths;
		int frags = result->get_player(i)->get_frags();
		int total_deaths = killed + deaths + suicides;
		int playtime = result->get_player(i)->playtime;
		html::set_tdth ("align=left");
		html::table_entry (out, "%i", i+1);
		html::table_entry (out, "<b>%s</b>", diverse::funname_to_html(result->get_player(i)->get_name()));
		if (teamplay) {
			switch (result->get_player(i)->team) {
			case 1:
				html::table_entry (out, "<b><font color=red>Red</font></b>");
				break;
			case 2:
				html::table_entry (out, "<b><font color=blue>Blue</font></b>");
				break;
			default:
				html::table_entry (out, "<b>%i</b>", i);
				break;
			}
		}
		html::set_tdth ("align=center");
		if (config->no_bots == false) {
			if (result->get_player(i)->botskill > -1) {
				html::table_entry (out, "(%i)", result->get_player(i)->botskill);
			} else {
				html::table_entry (out, "-");
			}
		}
		html::set_tdth ("");

		double ratio = result->get_player(i)->get_ratio();
		if ((ratio + 9999 < 0.001) && (ratio + 9999 > -0.001)) {
			html::table_entry (out, "ERR");
		} else {
			html::table_entry (out, "%.2f", ratio);
		}

		html::table_entry (out, "%.1f", result->get_player(i)->get_eff());
		html::table_entry (out, "%.2f", result->get_player(i)->get_skill());
		html::table_entry (out, "%i", frags);
		html::table_entry (out, "%i", kills);
		html::table_entry (out, "%i", killed);
		html::table_entry (out, "%i", suicides+deaths);
		if (teamplay) {
			html::table_entry (out, "%i", result->get_player(i)->get_memberkills());
		}
		if (result->get_player(i)->mkiol == 0) {
			html::set_tdth ("align=center");
			html::table_entry (out, "-");
			html::set_tdth ("");
		} else {
			html::table_entry (out, "%i (%s)", result->get_player(i)->mkiol, diverse::timestr_m (result->get_player(i)->mkiol_time));
		}
		html::table_entry (out, "%s", diverse::timestr_m (playtime / (killed + suicides +  deaths + 1)));
		if (playtime != 0) {
			html::table_entry (out, "%.2f", (double) frags * 60.0 / (double) playtime);
		} else {
			html::table_entry (out, "0.00");
		}
		if (playtime != 0) {
			html::table_entry (out, "%.2f", (double) total_deaths * 60.0 / (double) playtime);
		} else {
			html::table_entry (out, "0.00");
		}
		html::table_entry (out, "%s", diverse::timestr_hm (playtime));
		out->write ("</tr>\r\n");
	}
	html::table_footer(out);
}

void output::list_teams_html()
{
	if ((result->get_team_kills(1) == 0) && (result->get_team_kills(2) == 0)) {
		return;
	}
	html::line (out, "<b>Teams (sorted by frags)</b>");
	html::table_header(out, "border=1 cellspacing=0 bordercolor=#000000 bgcolor=#606060");
	out->write ("<tr align=right bgcolor=#000080>\r\n");
	html::set_tdth ("align=left");
	html::table_entry_bold (out, "Team");
	html::table_entry_bold (out, "Eff");
	html::table_entry_bold (out, "Skill");
	html::table_entry_bold (out, "Frags");
	html::table_entry_bold (out, "Kills");
	html::table_entry_bold (out, "Deaths");
	html::table_entry_bold (out, "Suicides");
	html::table_entry_bold (out, "Memberkills");
	out->write ("</tr>\r\n");
	int i;
	int frags1 = result->get_team(1)->get_frags() - result->get_team(1)->get_memberkills();
	int frags2 = result->get_team(2)->get_frags() - result->get_team(2)->get_memberkills();
	for (int j = 1; j <= MAX_TEAMS; j++) {
		if (j == 1) {
			if (frags1 > frags2) i = 1;
			else i = 2;
		} else {
			if (frags1 > frags2) i = 2;
			else i = 1;
		}
		out->write ("<tr align=right>\r\n");
		int kills = result->get_team_kills(i);
		int killed = result->get_team_killed(i);
		int suicides = result->get_team_suicides(i);
		int deaths = result->get_team(i)->deaths;
		int frags = result->get_team(i)->get_frags() - result->get_team(i)->get_memberkills();
		int total_deaths = killed + deaths + suicides;
		html::set_tdth ("align=left");
		switch (i) {
		case 1:
			html::table_entry (out, "<b><font color=red>Red</font></b>");
			break;
		case 2:
			html::table_entry (out, "<b><font color=blue>Blue</font></b>");
			break;
		default:
			html::table_entry (out, "<b>%i</b>", i);
			break;
		}
		html::set_tdth ("");
		html::table_entry (out, "%.1f", result->get_team(i)->get_eff());
		html::table_entry (out, "%.2f", result->get_team(i)->get_skill());
		html::table_entry (out, "%i", frags);
		html::table_entry (out, "%i", kills);
		html::table_entry (out, "%i", killed);
		html::table_entry (out, "%i", suicides+deaths);
		html::table_entry (out, "%i", result->get_team(i)->get_memberkills());
		out->write ("</tr>\r\n");
	}
	html::table_footer(out);
}

void output::list_players_total_html()
{
	html::html_header(out, config);
	if (config->homepage_address[0] != 0) {
		out->write ("<p class=title><a href=\"%s\"><font color=red>%s</font></a>", config->homepage_address, config->homepage_string);
	}
	out->write ("<p class=title><a href=\"games.htm\"><font color=red>Game list</font></a></p>");
	out->write ("<p class=title>Player ranking<br>(sorted by %s)</p>", sortorder_string(config->sortorder_players));
	
	// list limits 
	
	if (config->limits_used == true) {
		html::line_header(out);
		out->write ("<b><font size=3>Limits used:</font></b>");
		if (config->min_kills > 0) { // check min_kills
			out->write ("<br>min_kills: %i", config->min_kills);
		}
		if (config->min_games > 0) { // check min_games
			out->write ("<br>min_games: %i", config->min_games);
		}
		if (config->min_playtime > 0) { // check min_playtime
			out->write ("<br>min_playtime: %s", diverse::timestr_h(config->min_playtime));
		}
		if (config->max_players > 0) { // check max_players
			out->write ("<br>max_players: %i", config->max_players);
		}
		html::line_footer(out);
	}

	out->write ("<p class=title>Number of games: %i</p>", gamecount); // output # of games
	
	html::table_header(out, "border=1 cellspacing=0 bordercolor=#000000 bgcolor=#606060");
	out->write ("<tr align=right bgcolor=#000080>\r\n");
	html::set_tdth ("align=left width=20");
	html::table_entry_bold (out, "#");
	html::set_tdth ("align=left");
	html::table_entry_bold (out, "Name");
	if (config->no_bots == false) {
		html::table_entry_bold (out, "Bot");
	}
	html::set_tdth ("");
	html::table_entry_bold (out, "Ratio");
	html::table_entry_bold (out, "Eff");
	html::table_entry_bold (out, "Skill");
	html::table_entry_bold (out, "Frags");
	html::table_entry_bold (out, "Kills");
	html::table_entry_bold (out, "Deaths");
	html::table_entry_bold (out, "Suicides");
//	html::table_entry_bold (out, "Deaths");
	html::table_entry_bold (out, "FPM");
	html::table_entry_bold (out, "DPM");
	html::table_entry_bold (out, "Playtime");
	html::table_entry_bold (out, "Games");
	html::table_entry_bold (out, "Ping");
	out->write ("</tr>\r\n");
	int rank = 1;
	int pcount = 0;
	player_t* temp_player = result_total->get_player_first()->next;
	while (temp_player != 0) {

		pcount++;

		// check limits
		
		if (config->limits_used == true) {
			if (config->min_kills > 0) { // check min_kills
				if (temp_player->get_kills() < config->min_kills) {
					temp_player = temp_player->next;
					continue;
				}
			}
			if (config->min_games > 0) { // check min_games
				if (temp_player->game_count < config->min_games) {
					temp_player = temp_player->next;
					continue;
				}
			}
			if (config->min_playtime > 0) { // check min_playtime
				if (temp_player->playtime < config->min_playtime) {
					temp_player = temp_player->next;
					continue;
				}
			}
			if (config->max_players > 0) { // check max_players
				if (rank > config->max_players) {
					break;
				}
			}
		}

		temp_player->listed = true;
		
		if (rank % 2 == 0) {
			out->write ("<tr align=right bgcolor=#808080>\r\n");
		} else {
			out->write ("<tr align=right>\r\n");
		}
		html::set_tdth ("align=left");
		html::table_entry (out, "%i", rank);
		html::table_entry (out, "<b><a href=\"q3la_players/player_%i.htm\">%s</a></b>",
			pcount, diverse::funname_to_html(temp_player->get_name()));
		html::set_tdth ("align=center");
		if (config->no_bots == false) {
			if (temp_player->botskill > -1) {
				html::table_entry (out, "(%i)", temp_player->botskill);
			} else {
				html::table_entry (out, "-");
			}
		}
		html::set_tdth ("");

		double ratio = temp_player->get_ratio();
		if ((ratio + 9999 < 0.001) && (ratio + 9999 > -0.001)) {
			html::table_entry (out, "ERR");
		} else {
			html::table_entry (out, "%.2f", ratio);
		}

		html::table_entry (out, "%.1f", temp_player->get_eff());
		html::table_entry (out, "%.2f", temp_player->get_skill());
		html::table_entry (out, "%i", temp_player->get_kills() - temp_player->deaths - temp_player->get_suicides());
		html::table_entry (out, "%i", temp_player->get_kills());
		html::table_entry (out, "%i", temp_player->get_killed());
		html::table_entry (out, "%i", temp_player->get_suicides() + temp_player->deaths);
//		html::table_entry (out, "%i", temp_player->deaths);
		int frags = temp_player->get_frags();
		int total_deaths = temp_player->get_killed() + temp_player->deaths + temp_player->get_suicides();
		int playtime = temp_player->playtime;
		if (playtime != 0) {
			html::table_entry (out, "%.2f", (double) frags * 60.0 / (double) playtime);
		} else {
			html::table_entry (out, "0.00");
		}
		if (playtime != 0) {
			html::table_entry (out, "%.2f", (double) total_deaths * 60.0 / (double) playtime);
		} else {
			html::table_entry (out, "0.00");
		}
		html::table_entry (out, "%s", diverse::timestr_hm (temp_player->playtime));
		html::table_entry (out, "%i", temp_player->game_count);
		if (temp_player->ping_count > 0) {
			html::table_entry (out, "%i", temp_player->ping_sum / temp_player->ping_count);
		} else {
			html::table_entry (out, "-");
		}
		out->write ("</tr>\r\n");
		temp_player = temp_player->next;
		rank++;
	}
	html::table_footer(out);
	html::html_footer(out, true);
}

char* output::weapon_name(int weapon) // crap
{
	static char name[64];
	name[0] = 0;
	switch (weapon) {
	case 0:
		strcpy (name, "All weapons");
		break;
	case 1:
		strcpy (name, "Shotgun");
		break;
	case 2:
		strcpy (name, "Gauntlet");
		break;
	case 3:
		strcpy (name, "Machinegun");
		break;
	case 4:
		strcpy (name, "Grenade");
		break;
	case 5:
		strcpy (name, "Grenade splash");
		break;
	case 6:
		strcpy (name, "Rocket");
		break;
	case 7:
		strcpy (name, "Rocket splash");
		break;
	case 8:
		strcpy (name, "Plasma");
		break;
	case 9:
		strcpy (name, "Plasma splash");
		break;
	case 10:
		strcpy (name, "Railgun");
		break;
	case 11:
		strcpy (name, "Lightning gun");
		break;
	case 12:
		strcpy (name, "BFG");
		break;
	case 13:
		strcpy (name, "BFG splash");
		break;
	case 18:
		strcpy (name, "Telefrag");
		break;
	case 20:
		strcpy (name, "Suicide");
		break;
	default:
		sprintf (name, "weapon %i", weapon);
		break;
	}
	return name;
}

void output::game_data(int gamecount)
{
	outputfile gamedata;
	gamedata.open_append ("../q3ladata.txt");
	for (int i = 0; i < result->get_player_count(); i++) {
		gamedata.write ("%i", gamecount);
		gamedata.write (",%s", diverse::funname_to_ascii (result->get_player(i)->get_name()));
		gamedata.write (",%i", result->get_player_kills(i));
		gamedata.write (",%i", result->get_player_killed(i));
		gamedata.write (",%i", result->get_player_suicides(i));
		gamedata.write (",%i", result->get_player(i)->deaths);
		gamedata.write (",%s", diverse::timestr_h (result->get_player(i)->playtime));
		
		// kills
		gamedata.write (",%i", result->get_player_kills(i,1)); // Shotgun
		gamedata.write (",%i", result->get_player_kills(i,2)); // Gauntlet
		gamedata.write (",%i", result->get_player_kills(i,3)); // Machinegun
		gamedata.write (",%i", result->get_player_kills(i,4)); // Grenade Launcher
		gamedata.write (",%i", result->get_player_kills(i,6)); // Rocket Launcher
		gamedata.write (",%i", result->get_player_kills(i,8)); // Plasma
		gamedata.write (",%i", result->get_player_kills(i,10)); // Railgun
		gamedata.write (",%i", result->get_player_kills(i,11)); // Lightning Gun
		gamedata.write (",%i", result->get_player_kills(i,12)); // BFG
		gamedata.write (",%i", result->get_player_kills(i,18)); // Telefrag
		gamedata.write (",%i", result->get_player_kills(i,20)); // Suicide ("/kill" in console)
		
		// killed
		gamedata.write (",%i", result->get_player_killed(i,1)); // Shotgun
		gamedata.write (",%i", result->get_player_killed(i,2)); // Gauntlet
		gamedata.write (",%i", result->get_player_killed(i,3)); // Machinegun
		gamedata.write (",%i", result->get_player_killed(i,4)); // Grenade Launcher
		gamedata.write (",%i", result->get_player_killed(i,6)); // Rocket Launcher
		gamedata.write (",%i", result->get_player_killed(i,8)); // Plasma
		gamedata.write (",%i", result->get_player_killed(i,10)); // Railgun
		gamedata.write (",%i", result->get_player_killed(i,11)); // Lightning Gun
		gamedata.write (",%i", result->get_player_killed(i,12)); // BFG
		gamedata.write (",%i", result->get_player_killed(i,18)); // Telefrag
		gamedata.write (",%i", result->get_player_killed(i,20)); // Suicide ("/kill" in console)
		
		gamedata.write ("\r\n");
	}
	gamedata.close();
}

char* output::sortorder_string (sort_t order) // crap
{
	static char str[16];
	switch (order) {
	case so_frags:
		strcpy (str, "frags");
		break;
	case so_kills:
		strcpy (str, "kills");
		break;
	case so_name:
		strcpy (str, "name");
		break;
	case so_ratio:
		strcpy (str, "ratio");
		break;
	case so_eff:
		strcpy (str, "eff");
		break;
	case so_skill:
		strcpy (str, "skill");
		break;
	case so_playtime:
		strcpy (str, "playtime");
		break;
	default:
		strcpy (str, "?");
		break;
	}
	return str;
}

void output::player_weapon_stats(player_t* player)
{
	html::line (out, "<b>Weapon stats</b>");	
	html::set_tdth ("bgcolor=#000080");
	html::table_header(out, "border=1 cellspacing=0 bgcolor=#606060 bordercolor=#000000");
	out->write ("<tr bgcolor=000080>\r\n");
	html::table_entry_bold (out, "Weapon");
	html::set_tdth ("colspan=2 align=center bgcolor=#000080");
	html::table_entry_bold (out, "Kills");
	html::table_entry_bold (out, "Deaths");
	html::set_tdth ("");
	out->write ("</tr>\r\n");
	for (int i = 1; i < MAX_WEAPONS; i++) {
		if ((player->get_kills(i) == 0) && (player->get_killed(i) == 0)) {
			continue;
		}
		out->write ("<tr>\r\n");
		html::set_tdth ("width=120 align=left");
		html::table_entry_bold (out, "%s", weapon_name(i));
		html::set_tdth ("width=60 align=right");
		html::table_entry (out, "%i", player->get_kills(i));
		if (player->get_kills() > 0) {
			html::table_entry (out, "%i %%", 
				(int) (100.0 * (double) player->get_kills(i) / (double) player->get_kills() + 0.5));
		} else {
			html::table_entry (out, "0 %%");
		}
		html::table_entry (out, "%i", player->get_killed(i));
		if (player->get_killed() > 0) {
			html::table_entry (out, "%i %%", 
				(int) (100.0 * (double) player->get_killed(i) / (double) player->get_killed() + 0.5));
		} else {
			html::table_entry (out, "0 %%");
		}
		out->write ("</tr>\r\n");
	}
	out->write ("<tr>\r\n");
	html::set_tdth ("width=120 align=left");
	html::table_entry_bold (out, "TOTAL");
	html::set_tdth ("width=60 align=right");
	html::table_entry_bold (out, "%i", player->get_kills(0));
	html::table_entry_bold (out, "100 %%");
	html::table_entry_bold (out, "%i", player->get_killed(0));
	html::table_entry_bold (out, "100 %%");
	out->write ("</tr>\r\n");
	html::table_footer (out);
}
