#include "q3la.h"

char td_string[256] = "<td>";

void html::html_header(outputfile* out, configdata* config)
{
	out->write ("<html>\r\n");
	out->write ("<head>\r\n");
	out->write ("<title>Q3LA results</title>\r\n");
	if (config->q3la_css == true) {
		if (config->in_subdir == false) {
			out->write ("<LINK REL=StyleSheet HREF=\"q3la.css\" TYPE=\"text/css\">"); // link external stylesheets
		} else {
			out->write ("<LINK REL=StyleSheet HREF=\"../q3la.css\" TYPE=\"text/css\">"); // link external stylesheets
		}
	} else {
		out->write ("<style>\r\n<!--\r\n");
		out->write (".text { color: #FFFFFF; font-family: Arial; font-size: %spt; text-align: center }\r\n", 
			config->font_size_text);
		out->write (".title { color: #FFFFFF; font-family: Arial; font-size: %spt; text-align: center; font-weight: bold }\r\n", 
			config->font_size_title);
		out->write ("table td { color: #FFFFFF; font-family: Arial; font-size: %spt }\r\n", 
			config->font_size_text);
		out->write ("table th { color: #FFFFFF; font-family: Arial; font-size: %spt }\r\n", 
			config->font_size_text);
		out->write ("-->\r\n</style>\r\n");
	}
	out->write ("</head>\r\n");
	out->write ("<body text=#FFFFFF bgcolor=#000000 class=text link=#FFFFFF vlink=#FFFFFF alink=#FFFFFF>\r\n");
}

void html::html_footer(outputfile* out, bool output_legend)
{
	if (output_legend == true) {
		legend(out);
	}
	line_header(out);
	out->write ("<a href=\"http://www.planetquake.com/idda/\">");
	out->write ("<font color=#FF0000>Q3LA</font></a> %s, %s", version, date);
	out->write (" by <a href=\"mailto:spike@planetquake.com\">");
	out->write ("<font color=#FFFFFF>Fabian Huester</font>");
	line_footer(out);
	out->write ("\r\n</body>");
	out->write ("\r\n</html>");
}

void html::legend(outputfile* out) 
{
	line_header(out);
	out->write ("<b>Ratio</b> is calculated as (FPM - DPM)");
	out->write ("<br><b>Eff</b> is calculated as (100 * kills / (kills + total deaths))");
	out->write ("<br><b>Skill</b> is calculated as (kills / (total deaths + 1))");
	out->write ("<br><b>MKIOL</b> means \"Most Kills In One Life\"");
	out->write ("<br><b>FPM</b> is Frags Per Minute");
	out->write ("<br><b>DPM</b> is total Deaths Per Minute");
	out->write ("<br><b>Total deaths</b> is (deaths + suicides)");
	line_footer(out);
}

void html::table_header(outputfile* out, char* formatstring)
{
	out->write ("\r\n<table %s>\r\n", formatstring);
}

void html::table_footer(outputfile* out)
{
	out->write ("</table>\r\n");
}

void html::table_entry(outputfile* out, char* formatstring, ...)
{
	va_list arglist;
	static char tempstr[1024];
	va_start (arglist, formatstring);
	vsprintf (tempstr, formatstring, arglist);
	out->write ("<td %s>%s</td>\r\n", td_string, tempstr);
}

void html::table_entry_bold(outputfile* out, char* formatstring, ...)
{
	va_list arglist;
	static char tempstr[1024];
	va_start (arglist, formatstring);
	vsprintf (tempstr, formatstring, arglist);
	out->write ("<th %s>%s</th>\r\n", td_string, tempstr);
}

void html::line(outputfile* out, char* formatstring, ...)
{
	va_list arglist;
	char tempstr[1024];
	va_start (arglist, formatstring);
	vsprintf (tempstr, formatstring, arglist);

	line_header(out);
	out->write ("%s", tempstr);
	line_footer(out);
}

void html::line_header(outputfile* out)
{
	out->write ("<p>");
}

void html::line_footer(outputfile* out)
{
	out->write ("</p>");
}

void html::set_tdth(char* td_in)
{
	strcpy (td_string, td_in);
}
