/*
====================
HOLY WARS: Main file
====================
*/


// Declare that we are in hw_main.c (for hw_main.h)
#define IN_HW_MAIN
#include "g_local.h"

// HWv2.1
#include "stdlog.h"	//	StdLog - Mark Davies
#include "gslog.h"	//	StdLog - Mark Davies

// declations of extern functions:
qboolean IsFemale (edict_t *ent);

// end HWv2.1


// *****************
// global variables:
// *****************
hw_parameters_t hwpar;  // game parameters
hw_game_t hw;           // game globals
cvar_t  *hw_edit;       // console variable: toggle "editing mode"
cvar_t  *hw_debug;      // console variable: toggle "debug mode"


// HWv2.1 - moved NT entry point to qshared.c

// ***********************
// Inits the HolyWars game
// ***********************
void HW_InitGame(void)
{
        // console variables
        hw_edit = gi.cvar("hw_edit", "0", CVAR_SERVERINFO);
        hw_debug = gi.cvar("hw_debug", "0", CVAR_SERVERINFO);

// HWv2.1 - All the following lines have been moved to HW_InitLevel
}


// ***********************
// Inits an HolyWars level
// ***********************
void HW_InitLevel(void)
{

        // HWv2.1 - all the parameter stuff has been moved here from HW_InitGame
        //
        // ---------------
        // Init parameters
        // ---------------
        // defaults:
        hwpar.SCORE_NormalKill = 0;           // Normal frag value.
        hwpar.SCORE_HolyKill = 1;             // Frags for the Saint when killing someone else.
        hwpar.SCORE_KillHeretic = 1;          // Bonus frags when killing an heretic.
        hwpar.SCORE_KillSaint = 3;            // Frags when killing the Saint.
        hwpar.SCORE_TakeHalo = 2;             // Frags when taking the Halo.
// HWv2.1
		hwpar.SCORE_BecomeHeretic = -5;       // Frags for becoming an Heretic.
		hwpar.SCORE_Llama = -14;              // Get lower than this and your game is over.
// end HWv2.1
        hwpar.RULES_HeresyThreshold = 2.3;    // Threshold to pass to become an heretic.
        hwpar.HERESY_MeleeRange =  100.0;     // melee range for heresy calc.
        hwpar.HERESY_NearRange  =  400.0;     // near  range for heresy calc.
        hwpar.HERESY_FarRange   = 1000.0;     // far   range for heresy calc.
        hwpar.RULES_SinnerDamage = 1;         // True if sinners can always damage each other
        hwpar.TIMES_FirstSpawn = 40;          // Time before first halo spawn.
        hwpar.TIMES_Disappear = 30;           // Time before a fallen halo disappears.
        hwpar.TIMES_Respawn = 10;             // Time before halo respawns.
        hwpar.BONUS_HealthForEnemy = 30;      // Bonus health for the Saint for each enemy.
        hwpar.BONUS_ArmorForEnemy = 30;       // Bonus armor for the Saint for each enemy.
        hwpar.BONUS_Max = 200;                // The maximum total bonus allowed.
        hwpar.MISC_ReportFreq = 40;           // Frequency of on-screen reports.
        hwpar.MISC_SaintSound = 1;            // Saint shoot sound on/off.
// HWv2.1
        hwpar.MISC_UseBFG = 0;                // If false, all BFGs are turned into hyperblasters.
        hwpar.MISC_IntermissionTime = 25;     // Minimum pause for intermissions between levels.
// end HWv2.1
        hwpar.PHYS_HaloInertia = 0;           // Inertia effect for the halo on/off.
        hwpar.PHYS_HaloHeight = 25;           // The height of the halo over the Saint's eyes.
        hwpar.PHYS_HaloTolerance = 6;         // Tolerance for halo position control.
        hwpar.PHYS_HaloVelocity = 800;        // Maximum halo velocity (for each axis).
        hwpar.PHYS_HaloAccel[0] = 0.5;        // Halo accelerations.
        hwpar.PHYS_HaloAccel[1] = 0.5;        //
        hwpar.PHYS_HaloAccel[2] = 1;          //
        hwpar.PHYS_HaloBrake[0] = 6;          // Halo decelerations.
        hwpar.PHYS_HaloBrake[1] = 6;          //
        hwpar.PHYS_HaloBrake[2] = 6;          //
        hwpar.PHYS_CyclesForFrame = 3;        // Number of cycles for phisics calculations.
        hwpar.PHYS_HaloFall = 7;              // Multiplier of velocity for falling halo.
        // load values:
        CNF_LoadVariables();

        // No halo nor halo base yet:
        hw.halostatus = NONE;
// HWv2.1 - one line added and many deleted
		hw.halobase = NULL;
}


// HWv2.1 - The following function is new to this version

// *********************
// Creates the Halo base
// *********************
void HW_CreateHaloBase(void)
{
		if (hw.halobase != NULL)
			return;		// the base was already created

        // creates the halo base, places it into the right place
        // and uses it to generate the Halo at the right time.
        hw.halobase = G_Spawn();
        HW_BaseInLevel(hw.halobase);
        hw.halobase->classname = "halobase";
		hw.halobase->movetype = MOVETYPE_NOCLIP;
        hw.halobase->solid = SOLID_NOT;
        hw.halobase->svflags |= SVF_NOCLIENT;
        hw.halobase->nextthink = level.time + hwpar.TIMES_FirstSpawn;
        hw.halobase->think = HW_SpawnHalo;
        gi.linkentity(hw.halobase);
}


// ***************************************************************
// Given a killed player and a killer player, updates the score
// of the killer.
// ***************************************************************
// HWv2.1 - many parts of this function has been modified
void HW_Frag(edict_t *killed, edict_t *killer, int mod, char *weapon)
{
  if (killer == killed)
        return;         // Let ClientObituary manage suicides

  switch(killer->client->plstatus)
        {
  case SAINT:   // SAINT kills .....

        if (killed->client->plstatus == HERETIC)
		{
			// ---------------------
			// Saint killing heretic
			// ---------------------

            // Bonus for Saint killing Heretic:
			killer->client->resp.score += hwpar.SCORE_HolyKill + hwpar.SCORE_KillHeretic;

			// StdLog - log score for Saint killing Heretic
			sl_LogScore( &gi,
				 killer->client->pers.netname,
				 killed->client->pers.netname,
				 "Saint vs. Heretic",
				 weapon,
				 hwpar.SCORE_HolyKill + hwpar.SCORE_KillHeretic,
				 level.time );
		}
		else
		{
			// --------------------
			// Saint killing sinner
			// --------------------

		    killer->client->resp.score += hwpar.SCORE_HolyKill;

			// StdLog - log score for Saint killing Sinner
			sl_LogScore( &gi,
			 killer->client->pers.netname,
			 killed->client->pers.netname,
			 "Saint vs. Sinner",
			 weapon,
			 hwpar.SCORE_HolyKill,
			 level.time );
		}

		break;
  case HERETIC: // Heretics don't need points!
        break;
  default:      // SINNER
        switch(killed->client->plstatus)
                {
        case SAINT:  // sinner killing Saint
                killer->client->resp.score += hwpar.SCORE_KillSaint;

				// StdLog - log score
				sl_LogScore( &gi,
					 killer->client->pers.netname,
					 killed->client->pers.netname,
					 "Sinner vs. Saint",
					 weapon,
					 hwpar.SCORE_KillSaint,
					 level.time );

                killer->client->resp.killedsaints++;
                HW_Heresy_SaintKilled(killer); // if he kills the saint .. heresy bonus!
                break;
        case HERETIC:   // Sinner killing Heretic
                killer->client->resp.score += hwpar.SCORE_KillHeretic;

				// StdLog - log score
				sl_LogScore( &gi,
					 killer->client->pers.netname,
					 killed->client->pers.netname,
					 "Sinner vs. Heretic",
					 weapon,
					 hwpar.SCORE_KillHeretic,
					 level.time );

                break;
        default:  // The killed must be a Sinner: Sinner killing Sinner
                // "normal kill" score:
                killer->client->resp.score += hwpar.SCORE_NormalKill;

				// StdLog - log score
				sl_LogScore( &gi,
					 killer->client->pers.netname,
					 killed->client->pers.netname,
					 "Sinner vs. Sinner",
					 weapon,
					 hwpar.SCORE_NormalKill,
					 level.time );

                // There is a saint: see if it's time for punishment...
                if (hw.halostatus == OWNED)
                        HW_Heresy_MainCalc(killed, killer, mod);
                }
        }
}


// *****************************
// The player becomes an heretic
// *****************************
void HW_BecomeHeretic(edict_t *p)
{
        edict_t *swarm;
        gitem_t *it;

        p->client->plstatus = HERETIC;
        p->client->resp.llamaness++;    // HWv2.1

// HWv2.1
	    // scream:
        if (IsFemale(p))  // female player
                gi.sound(p, CHAN_VOICE, gi.soundindex("/players/female/pain100_1.wav"), 1, ATTN_NORM, 0);
        else  // male player
        {
                int r;
                r = rand() % 3;
                //Play a random male scream:
                if (r == 1)
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_her1.wav"), 1, ATTN_NORM, 0);
                else if (r == 2)
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_her2.wav"), 1, ATTN_NORM, 0);
                else
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_her3.wav"), 1, ATTN_NORM, 0);
        }

        // take out all armor, cells, slugs, grenades and rockets
		// (version 2.0 only took out cells)
        if (it = FindItem("Jacket Armor"))
        	p->client->pers.inventory[ITEM_INDEX(it)] = 0;
        if (it = FindItem("Combat Armor"))
        	p->client->pers.inventory[ITEM_INDEX(it)] = 0;
        if (it = FindItem("Body Armor"))
        	p->client->pers.inventory[ITEM_INDEX(it)] = 0;
        if (it = FindItem("Cells"))
        	p->client->pers.inventory[ITEM_INDEX(it)] = 0;
        if (it = FindItem("Slugs"))
        	p->client->pers.inventory[ITEM_INDEX(it)] = 0;
        if (it = FindItem("Grenades"))
        	p->client->pers.inventory[ITEM_INDEX(it)] = 0;
        if (it = FindItem("Rockets"))
        	p->client->pers.inventory[ITEM_INDEX(it)] = 0;

		// Reduce health to 50 max
        if (p->health > 50)
        	p->health = 50;

		// Loose frags:
		p->client->resp.score += hwpar.SCORE_BecomeHeretic;

		// StdLog - log score
		sl_LogScore( &gi,
			 p->client->pers.netname,
			 NULL,
			 "Become Heretic",
			 NULL,
			 hwpar.SCORE_BecomeHeretic,
			 level.time );

// end HWv2.1

        // Shame on you!
        HW_ReportNewHeretic(p);

        // Create a swarm of flies
        swarm = G_Spawn();
        swarm->classname = "swarm";
        gi.setmodel (swarm, "models/invis/tris.md2");    // HWv2.1
        swarm->s.sound = gi.soundindex ("infantry/inflies1.wav");
        swarm->movetype = MOVETYPE_NOCLIP;
        swarm->solid = SOLID_NOT;
        swarm->s.effects |= EF_FLIES;
        swarm->hwowner = p;
        VectorCopy (p->s.origin, swarm->s.origin);
        swarm->think = HW_SwarmThink;
        swarm->nextthink = level.time + 0.1;
        gi.linkentity(swarm);
}


// **************************
// The player becomes a Saint
// **************************
void HW_BecomeSaint(edict_t *p)
{
        int hbonus;       // Health bonus
        int abonus;       // Armor bonus
        edict_t *swarm;
        edict_t *rightswarm;

                if (p->client->plstatus == HERETIC)  // Forgive this Heretic
                {
                // find and kill the flies
                        // HWFIXME: make a function for this (it's also done in HW_PlayerDie)
            swarm = NULL;
            rightswarm = NULL;
            while ((swarm = G_Find (swarm, FOFS(classname), "swarm")) != NULL)
            {
                if (swarm->hwowner == p)
                        rightswarm = swarm;
                }
                if (rightswarm != NULL)
                {
                        G_FreeEdict(rightswarm);
                }
                }

        p->client->plstatus = SAINT;                         // there's a new Saint in town!
// HWv2.1
        p->client->resp.lasttakentime = level.time;          // memorize the current time (used for final stats)
        p->client->resp.takenhalos++;                        // increase number of halos taken
// end HWv2.1
        p->client->heresy = 0;                               // sanctity forgives all sins!
        p->client->resp.score += hwpar.SCORE_TakeHalo;       // increase picker's frag count.
// HWv2.1
		// StdLog - log score
		sl_LogScore( &gi,
			 p->client->pers.netname,
			 NULL,
			 "Become Saint",
			 NULL,
			 hwpar.SCORE_TakeHalo,
			 level.time );
// end HWv2.1

        // Laughter sound:
        if (IsFemale(p))  // female player
                gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_fpick.wav"), 1, ATTN_NORM, 0);
        else  // male player
        {
                int r;
                r = rand() % 5;
                //Play a random laugh:
                if (r == 1)
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_pick1.wav"), 1, ATTN_NORM, 0);
                else if (r == 2)
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_pick2.wav"), 1, ATTN_NORM, 0);
                else if (r == 3)
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_pick3.wav"), 1, ATTN_NORM, 0);
                else if (r == 4)
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_pick4.wav"), 1, ATTN_NORM, 0);
                else
                        gi.sound(p, CHAN_VOICE, gi.soundindex("hw/hw_pick5.wav"), 1, ATTN_NORM, 0);
        }

        // Reports the event to everybody:
        HW_ReportNewSaint(p);

        // -------
        // Bonuses
        // -------
        // Calc bonus for health:
        hbonus = HW_CountEnemies(p) * hwpar.BONUS_HealthForEnemy;
        if (hbonus > hwpar.BONUS_Max)
                hbonus = hwpar.BONUS_Max;
        if (hbonus < 0)      // Negative bonuses can happen in teamplay.
                hbonus = 0;
        // Add energy to the player:
        p->health += hbonus;
        // Calc bonus for armor:
        abonus = HW_CountEnemies(p) * hwpar.BONUS_ArmorForEnemy;
        if (abonus > hwpar.BONUS_Max)
                abonus = hwpar.BONUS_Max;
        if (abonus < 0)
                abonus = 0;
        // Add armor to the player:
        if (!ArmorIndex(p))
                p->client->pers.inventory[ITEM_INDEX(FindItem("Jacket Armor"))] = abonus;
        else
                p->client->pers.inventory[ArmorIndex(p)] += abonus;
}



// **************************
// Invoked when a player dies
// **************************
void HW_PlayerDie(edict_t *ent)
{
        edict_t *visiblehalo;
        edict_t *swarm;
        edict_t *rightswarm;

        // -----------------
        // forgive heretics:
        // -----------------
        ent->client->heresy = 0;
        if (ent->client->plstatus == HERETIC)
        {
                ent->client->plstatus = SINNER;

                // find and kill the flies
                swarm = NULL;
                rightswarm = NULL;
                while ((swarm = G_Find (swarm, FOFS(classname), "swarm")) != NULL)
                {
                        if (swarm->hwowner == ent)
                                rightswarm = swarm;
                }
                if (rightswarm != NULL)
                {
                        G_FreeEdict(rightswarm);
                }
        }

        // takes away all the effects from the body
        ent->s.effects &= ~(EF_FLAG1 | EF_FLAG2 | EF_FLIES);
        ent->s.renderfx &= ~RF_GLOW;

        if (ent->client->plstatus != SAINT)
                return;

        // --------------------------------------------------------
        // The following is only executed if the player was a saint
        // --------------------------------------------------------

        HW_DropHalo(ent);
        ent->client->plstatus = SINNER;
        ent->client->resp.sanctitytime += (level.time - ent->client->resp.lasttakentime);  // HWv2.1
        gi.sound(ent, CHAN_VOICE, gi.soundindex("hw/hw_death.wav"), 1, ATTN_NONE, 0);
        HW_ReportMartyr(ent);                                   // Tell everybody

        // find and destroy the visible halo thing
        if ((visiblehalo = G_Find (NULL, FOFS(classname), "visiblehalo")) != NULL)
        {
                G_FreeEdict(visiblehalo);
        }
}


// **********************
// A swarm of flies moves
// **********************
void HW_SwarmThink(edict_t *ent)
{
// HWFIXME: kill flies when underwater?

        VectorCopy(ent->hwowner->s.origin, ent->s.origin);
        ent->think = HW_SwarmThink;
        ent->nextthink = level.time + 0.1;
                gi.linkentity(ent);
}


// ***********************
// Sets effects for player
// ***********************
void HW_SetClientEffects(edict_t *player)
{
        if (player->client->plstatus == SAINT)
        {
                player->s.effects |= EF_FLAG2;
                player->s.renderfx |= RF_GLOW;
        }
        else if (player->client->plstatus == HERETIC)
        {
                // add some more flies (only visible by other players):
                player->s.effects |= EF_FLAG1;
                player->s.renderfx |= RF_GLOW;
        }
}


// -----------------------
// Sound of Saint shooting
// -----------------------
void HW_SaintShootSound(edict_t *ent)
{
        float volume;

        if (!ent->client)
                return;

        if (ent->client->silencer_shots)
                volume = 0.3;
        else
                volume = 0.7;

        if (level.time - ent->client->saintsoundtime > 1.3)
        {
                gi.sound(ent, CHAN_AUTO, gi.soundindex("hw/hw_saint.wav"), volume, ATTN_NORM, 0);
                ent->client->saintsoundtime = level.time;
        }
}


// ------------------
// End of level stuff
// ------------------
void HW_EndOfLevel(void)
{
        edict_t         *ent;

        // Destroy the visible halo:
        if ((ent = G_Find (NULL, FOFS(classname), "visiblehalo")) != NULL)
        {
                G_FreeEdict(ent);
        }

        // The halo disappears:
        if ((ent = G_Find (NULL, FOFS(classname), "halo")) != NULL)
        {
                G_FreeEdict(ent);
        }
        hw.halostatus = HEAVEN;

        // destroy all swarms:
        ent = NULL;
        while ((ent = G_Find (ent, FOFS(classname), "swarm")) != NULL)
        {
                G_FreeEdict(ent);
        }

        // scan players:
        ent = NULL;
        while ((ent = G_Find (ent, FOFS(classname), "player")) != NULL)
        {
                if (ent->client != NULL)
                {
                        // adjusts stats for the Saint:
                        if(ent->client->plstatus == SAINT)
                                ent->client->resp.sanctitytime += (level.time - ent->client->resp.lasttakentime);  // HWv2.1

                        ent->client->plstatus = SINNER;
                }
        }

}

