// Modified for HOLY WARS

#include "g_local.h"
#include "m_player.h"


char *ClientTeam (edict_t *ent)
{
	char		*p;
	static char	value[512];

	value[0] = 0;

	if (!ent->client)
		return value;

	strcpy(value, Info_ValueForKey (ent->client->pers.userinfo, "skin"));
	p = strchr(value, '/');
	if (!p)
		return value;

	if ((int)(dmflags->value) & DF_MODELTEAMS)
	{
		*p = 0;
		return value;
	}

	// if ((int)(dmflags->value) & DF_SKINTEAMS)
	return ++p;
}

qboolean OnSameTeam (edict_t *ent1, edict_t *ent2)
{
	char	ent1Team [512];
	char	ent2Team [512];

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		return false;

	strcpy (ent1Team, ClientTeam (ent1));
	strcpy (ent2Team, ClientTeam (ent2));

	if (strcmp(ent1Team, ent2Team) == 0)
		return true;
	return false;
}


void SelectNextItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

/*HK
// HOLY WARS
// HWv2.1
	// rocket arena menu stuff
	if (ent->client->showmenu)
	{
		MenuNext(ent);
		return;
	}
// end HOLY WARS
*/
	cl = ent->client;

//HK:Added for observer/chasecam menu
//ZOID
	if (cl->menu) {
		PMenu_Next(ent);
		return;
	} else if (cl->chase_target) {
		ChaseNext(ent);
		return;
	}
//ZOID

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void SelectPrevItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

/*HK
// HOLY WARS
// HWv2.1
	// rocket arena menu stuff
	if (ent->client->showmenu)
	{
		MenuPrev(ent);
		return;
	}
// end HOLY WARS
*/
	cl = ent->client;

//HK:Added for observer/chasecam menu
//ZOID
	if (cl->menu) {
		PMenu_Prev(ent);
		return;
	} else if (cl->chase_target) {
		ChasePrev(ent);
		return;
	}
//ZOID

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void ValidateSelectedItem (edict_t *ent)
{
	gclient_t	*cl;

	cl = ent->client;

	if (cl->pers.inventory[cl->pers.selected_item])
		return;		// valid

	SelectNextItem (ent, -1);
}


//=================================================================================

/*
==================
Cmd_Give_f

Give items to a client
==================
*/
void Cmd_Give_f (edict_t *ent)
{
	char		*name;
	gitem_t		*it;
	int			index;
	int			i;
	qboolean	give_all;
	edict_t		*it_ent;

	if (deathmatch->value && !sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	name = gi.args();

	if (Q_stricmp(name, "all") == 0)
		give_all = true;
	else
		give_all = false;

	if (give_all || Q_stricmp(gi.argv(1), "health") == 0)
	{
		if (gi.argc() == 3)
			ent->health = atoi(gi.argv(2));
		else
			ent->health = ent->max_health;
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "weapons") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_WEAPON))
				continue;

			//HK:Added for holykeys project.
			//K2:Begin - Don't give certain weapons and powerups if they are turned off
			if (Q_stricmp(it->pickup_name, "BFG10K") == 0)
			{
				if( nobfg->value )
				{
					continue;
				}

				//This is another id Software bug
				//If infinite ammo is on and cheats are on, and you give yourself the BFG
				//The server will crash
				if ( (int)dmflags->value & DF_INFINITE_AMMO )
				{
					continue;
				}

			}
			if ((Q_stricmp(it->pickup_name, "Shotgun") == 0) &&
				(noshotgun->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Super Shotgun") == 0) &&
				(nosupershotgun->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Machinegun") == 0) &&
				(nomachinegun->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Chaingun") == 0) &&
				(nochaingun->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Grenade Launcher") == 0) &&
				(nogrenadelauncher->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Rocket Launcher") == 0) &&
				(norocketlauncher->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Hyperblaster") == 0) &&
				(nohyperblaster->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Railgun") == 0) &&
				(norailgun->value) )
				continue;

			//K2:End

			ent->client->pers.inventory[i] += 1;
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "ammo") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_AMMO))
				continue;
			Add_Ammo (ent, it, 1000);
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "armor") == 0)
	{
		gitem_armor_t	*info;

		it = FindItem("Jacket Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Combat Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Body Armor");
		info = (gitem_armor_t *)it->info;
		ent->client->pers.inventory[ITEM_INDEX(it)] = info->max_count;

		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "Power Shield") == 0)
	{
		//HK:Added
		//K2:Begin - Fix DF_NO_ARMOR bug with Power Shield
		//           This is an id Software bug
		//           If not allowing armor, give all or give power shield results in crash
		if ( ((int)dmflags->value & DF_NO_ARMOR) == 0)
		{
			it = FindItem("Power Shield");
			it_ent = G_Spawn();
			it_ent->classname = it->classname;
			SpawnItem (it_ent, it);
			Touch_Item (it_ent, ent, NULL, NULL);
			if (it_ent->inuse)
				G_FreeEdict(it_ent);
		}
		else
			gi.dprintf ("You can't have the Power Shield\n");

		if (!give_all)
			return;
	}

	if (give_all)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (it->flags & (IT_ARMOR|IT_WEAPON|IT_AMMO))
				continue;

			//HK:Added
			//K2:Begin
			if ((Q_stricmp(it->pickup_name, "Quad Damage") == 0) &&
				(noquad->value) )
				continue;
			if ((Q_stricmp(it->pickup_name, "Invulnerability") == 0) &&
				(noinvulnerability->value) )
				continue;
			//K2:End

			ent->client->pers.inventory[i] = 1;
		}
		return;
	}

	it = FindItem (name);

	if (!it)
	{
		name = gi.argv(1);
		it = FindItem (name);
		if (!it)
		{
			gi.dprintf ("unknown item\n");
			return;
		}
	}

	if (!it->pickup)
	{
		gi.dprintf ("non-pickup item\n");
		return;
	}

	//HK:Added.
	//K2:Begin - Don't give weapons if nto included in game
	if (strcmp(it->pickup_name, "BFG10K") == 0)
	{
		if( nobfg->value )
		{
			gi.dprintf ("You can't have the BFG\n");
			return;
		}

		//This is another id Software bug
		//If infinite ammo is on and you give yourself the BFG
		//The server will crash
		if ( (int)dmflags->value & DF_INFINITE_AMMO )
		{
			gi.dprintf ("You can't have the BFG\n");
			return;
		}
	}
	if ((Q_stricmp(it->pickup_name, "Shotgun") == 0) &&
				(noshotgun->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Super Shotgun") == 0) &&
				(nosupershotgun->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Machinegun") == 0) &&
				(nomachinegun->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Chaingun") == 0) &&
				(nochaingun->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Grenade Launcher") == 0) &&
				(nogrenadelauncher->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Rocket Launcher") == 0) &&
				(norocketlauncher->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Hyperblaster") == 0) &&
				(nohyperblaster->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Railgun") == 0) &&
				(norailgun->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Quad Damage") == 0) &&
				(noquad->value) )
				return;
	if ((Q_stricmp(it->pickup_name, "Invulnerability") == 0) &&
				(noinvulnerability->value) )
				return;

	//K2:End

	index = ITEM_INDEX(it);

	if (it->flags & IT_AMMO)
	{
		if (gi.argc() == 3)
			ent->client->pers.inventory[index] = atoi(gi.argv(2));
		else
			ent->client->pers.inventory[index] += it->quantity;
	}
	else
	{
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);
	}
}


/*
==================
Cmd_God_f

Sets client to godmode

argv(0) god
==================
*/
void Cmd_God_f (edict_t *ent)
{
	char	*msg;

	if (deathmatch->value && !sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_GODMODE;
	if (!(ent->flags & FL_GODMODE) )
		msg = "godmode OFF\n";
	else
		msg = "godmode ON\n";

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Notarget_f

Sets client to notarget

argv(0) notarget
==================
*/
void Cmd_Notarget_f (edict_t *ent)
{
	char	*msg;

	if (deathmatch->value && !sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_NOTARGET;
	if (!(ent->flags & FL_NOTARGET) )
		msg = "notarget OFF\n";
	else
		msg = "notarget ON\n";

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Noclip_f

argv(0) noclip
==================
*/
void Cmd_Noclip_f (edict_t *ent)
{
	char	*msg;

	if (deathmatch->value && !sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	if (ent->movetype == MOVETYPE_NOCLIP)
	{
		ent->movetype = MOVETYPE_WALK;
		msg = "noclip OFF\n";
	}
	else
	{
		ent->movetype = MOVETYPE_NOCLIP;
		msg = "noclip ON\n";
	}

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Use_f

Use an inventory item
==================
*/
void Cmd_Use_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;

	s = gi.args();
	it = FindItem (s);
	if (!it)
	{
		gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}
	if (!it->use)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}
	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		gi.cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}

	it->use (ent, it);
}


/*
==================
Cmd_Drop_f

Drop an inventory item
==================
*/
void Cmd_Drop_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;

	s = gi.args();

	//HK:Added
	//K2:Begin - Drop Key command
	if (!strcmp(s,"key"))
	{
		if ( droppable->value && ent->client->key )
		{
			K2_DropKeyCommand(ent);
			K2_ResetClientKeyVars(ent);
		}
	else
		gi.cprintf(ent,PRINT_HIGH,"This server does not allow dropping of keys\n");
	return;
	}
	//K2:End

	it = FindItem (s);
	if (!it)
	{
		gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}
	if (!it->drop)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		gi.cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}

	it->drop (ent, it);
}


/*
=================
Cmd_Inven_f
=================
*/
void Cmd_Inven_f (edict_t *ent)
{
	int			i;
	gclient_t	*cl;

	cl = ent->client;

	cl->showscores = false;

// HOLY WARS
// HWv2.1
	ent->client->scoreboard == HW_NO_SCORES;
// end HOLY WARS
	cl->showhelp = false;

//HK:Added for Keys2 menu.
//ZOID
	if (ent->client->menu) {
		PMenu_Close(ent);
		ent->client->update_chase = true;
		return;
	}
//ZOID

/*
// HOLY WARS
// HWv2.1
	// rocket arena menu stuff
	if (cl->showmenu)
		cl->showmenu=false;
	else
		ent->client->showmenu = ent->client->curmenulink ? true : false;
	DisplayMenu(ent);
	return;
	//below is unused in menumod
// HOLY WARS
*/
	if (cl->showinventory)
	{
		cl->showinventory = false;
		K2_OpenJoinMenu(ent);
		return;
	}

	//HK:Added for menu
	//K2:Menu
	if(!ent->client->resp.inServer)
	{
		K2_OpenJoinMenu(ent);
		return;
	}

	cl->showinventory = true;

	gi.WriteByte (svc_inventory);
	for (i=0 ; i<MAX_ITEMS ; i++)
	{
		gi.WriteShort (cl->pers.inventory[i]);
	}
	gi.unicast (ent, true);
}

/*
=================
Cmd_InvUse_f
=================
*/
void Cmd_InvUse_f (edict_t *ent)
{
	gitem_t		*it;

/*HK
// HOLY WARS
// HWv2.1
	// rocket arena menu
	if (ent->client->showmenu)
	{
		UseMenu(ent, 1);
		return;
	}
// end HOLY WARS
*/

//HK:Added for menu
//ZOID
	if (ent->client->menu) {
		PMenu_Select(ent);
		return;
	}
//ZOID

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		gi.cprintf (ent, PRINT_HIGH, "No item to use.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->use)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}
	it->use (ent, it);
}

/*
=================
Cmd_WeapPrev_f
=================
*/
void Cmd_WeapPrev_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;

		//HK:Added
		//K2:Begin - Substitute Cycle_Weapon() for Use_Weapon()
		//it->use (ent, it);
		Cycle_Weapon(ent,it);
		//K2:End

		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapNext_f
=================
*/
void Cmd_WeapNext_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;

		//HK:Added
		//K2:Begin - Substitute Cycle_Weapon() for Use_Weapon()
		//it->use (ent, it);
		Cycle_Weapon(ent,it);
		//K2:End

		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapLast_f
=================
*/
void Cmd_WeapLast_f (edict_t *ent)
{
	gclient_t	*cl;
	int			index;
	gitem_t		*it;

	cl = ent->client;

	if (!cl->pers.weapon || !cl->pers.lastweapon)
		return;

	index = ITEM_INDEX(cl->pers.lastweapon);
	if (!cl->pers.inventory[index])
		return;
	it = &itemlist[index];
	if (!it->use)
		return;
	if (! (it->flags & IT_WEAPON) )
		return;

	//HK:Added
	//K2:Begin - Substitute Cycle_Weapon() for Use_Weapon()
	//it->use (ent, it);
	Cycle_Weapon(ent,it);
	//K2:End
}

/*
=================
Cmd_InvDrop_f
=================
*/
void Cmd_InvDrop_f (edict_t *ent)
{
	gitem_t		*it;

/*HK
// HOLY WARS
// HWv2.1
	// rocket arena menu stuff
	if (ent->client->showmenu)
	{
		UseMenu(ent, 0);
		return;
	}
// end HOLY WARS
*/
	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		gi.cprintf (ent, PRINT_HIGH, "No item to drop.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];

	//HK:Added
	//K2:Begin - Allow normal inventory dropping of keys as well as "drop key"
	if( droppable->value &&
		( strstr(it->pickup_name,"Key") || strstr(it->pickup_name,"BFK"))
      )
	{
		K2_DropKeyCommand(ent);
		K2_ResetClientKeyVars(ent);
		SelectPrevItem(ent, IT_POWERUP);
		return;
	}
	//K2:End

	if (!it->drop)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	it->drop (ent, it);
}

/*
=================
Cmd_Kill_f
=================
*/
void Cmd_Kill_f (edict_t *ent)
{
	if((level.time - ent->client->respawn_time) < 5)
		return;

//HK:Thanks
// HOLY WARS
	// HWFIXME: this is here in case of a future observer mode
	if (ent->solid == SOLID_NOT)
		return;

	// heretics can't suicide
	if (ent->client->plstatus == HERETIC)
		return;

	HW_PlayerDie(ent);
// end HOLY WARS

	ent->flags &= ~FL_GODMODE;
	ent->health = 0;
	meansOfDeath = MOD_SUICIDE;
	player_die (ent, ent, ent, 100000, vec3_origin);
	// don't even bother waiting for death frames
	ent->deadflag = DEAD_DEAD;
	respawn (ent);
}

/*
=================
Cmd_PutAway_f
=================
*/
void Cmd_PutAway_f (edict_t *ent)
{
	ent->client->showscores = false;
/*HK
// HOLY WARS
// HWv2.1
	ent->client->scoreboard == HW_NO_SCORES;
// end HOLY WARS
	ent->client->showhelp = false;
	ent->client->showinventory = false;
*/

//HK:Added for menu
//ZOID
	if (ent->client->menu)
		PMenu_Close(ent);
	ent->client->update_chase = true;
//ZOID

}


int PlayerSort (void const *a, void const *b)
{
	int		anum, bnum;

	anum = *(int *)a;
	bnum = *(int *)b;

	anum = game.clients[anum].ps.stats[STAT_FRAGS];
	bnum = game.clients[bnum].ps.stats[STAT_FRAGS];

	if (anum < bnum)
		return -1;
	if (anum > bnum)
		return 1;
	return 0;
}

/*
=================
Cmd_Players_f
=================
*/
void Cmd_Players_f (edict_t *ent)
{
	int		i;
	int		count;
	char	small[64];
	char	large[1280];
	int		index[256];

	count = 0;
	for (i = 0 ; i < maxclients->value ; i++)
		if (game.clients[i].pers.connected)
		{
			index[count] = i;
			count++;
		}

	// sort by frags
	qsort (index, count, sizeof(index[0]), PlayerSort);

	// print information
	large[0] = 0;

	for (i = 0 ; i < count ; i++)
	{
		Com_sprintf (small, sizeof(small), "%3i %s\n",
			game.clients[index[i]].ps.stats[STAT_FRAGS],
			game.clients[index[i]].pers.netname);
		if (strlen (small) + strlen(large) > sizeof(large) - 100 )
		{	// can't print all of them in one packet
			strcat (large, "...\n");
			break;
		}
		strcat (large, small);
	}

	gi.cprintf (ent, PRINT_HIGH, "%s\n%i players\n", large, count);
}

/*
=================
Cmd_Wave_f
=================
*/
void Cmd_Wave_f (edict_t *ent)
{
	int		i;

	i = atoi (gi.argv(1));

	// can't wave when ducked
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (ent->client->anim_priority > ANIM_WAVE)
		return;

	ent->client->anim_priority = ANIM_WAVE;

	switch (i)
	{
	case 0:
		gi.cprintf (ent, PRINT_HIGH, "flipoff\n");
		ent->s.frame = FRAME_flip01-1;
		ent->client->anim_end = FRAME_flip12;
		break;
	case 1:
		gi.cprintf (ent, PRINT_HIGH, "salute\n");
		ent->s.frame = FRAME_salute01-1;
		ent->client->anim_end = FRAME_salute11;
		break;
	case 2:
		gi.cprintf (ent, PRINT_HIGH, "taunt\n");
		ent->s.frame = FRAME_taunt01-1;
		ent->client->anim_end = FRAME_taunt17;
		break;
	case 3:
		gi.cprintf (ent, PRINT_HIGH, "wave\n");
		ent->s.frame = FRAME_wave01-1;
		ent->client->anim_end = FRAME_wave11;
		break;
	case 4:
	default:
		gi.cprintf (ent, PRINT_HIGH, "point\n");
		ent->s.frame = FRAME_point01-1;
		ent->client->anim_end = FRAME_point12;
		break;
	}
}

/*
==================
Cmd_Say_f
==================
*/
void Cmd_Say_f (edict_t *ent, qboolean team, qboolean arg0)
{
	int		j;
	edict_t	*other;
	char	*p;
	char	text[2048];


// HOLY WARS
	// llamas can't talk:
	if (ent->client->resp.score < hwpar.SCORE_Llama)
	{
        gi.centerprintf(ent, "Llamas can't talk.\n");
		return;
	}
// end HOLY WARS

	if (gi.argc () < 2 && !arg0)
		return;

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		team = false;

	if (team)
		Com_sprintf (text, sizeof(text), "(%s): ", ent->client->pers.netname);
	else
		Com_sprintf (text, sizeof(text), "%s: ", ent->client->pers.netname);

	if (arg0)
	{
		strcat (text, gi.argv(0));
		strcat (text, " ");
		strcat (text, gi.args());
	}
	else
	{
		p = gi.args();

		if (*p == '"')
		{
			p++;
			p[strlen(p)-1] = 0;
		}
		strcat(text, p);
	}

	// don't let text be too long for malicious reasons
	if (strlen(text) > 150)
		text[150] = 0;

	strcat(text, "\n");

	if (dedicated->value)
		gi.cprintf(NULL, PRINT_CHAT, "%s", text);

	for (j = 1; j <= game.maxclients; j++)
	{
		other = &g_edicts[j];
		if (!other->inuse)
			continue;
		if (!other->client)
			continue;
		if (team)
		{
			if (!OnSameTeam(ent, other))
				continue;
		}
		gi.cprintf(other, PRINT_CHAT, "%s", text);
	}
}

//HK:Begin - Added keys2 command functions
//K2:Begin

//Take Key
void Cmd_TakeKey_f (edict_t *ent)
{

	if (K2_IsAnti(ent))
		K2_TakePlayerKey(ent);
	else
		gi.cprintf(ent,PRINT_HIGH,"You need the Anti-Key to take someone's key\n");

}

//Flash Grenade
void Cmd_FlashGrenade_f(edict_t *ent)
{
	int			ammo;
	gitem_t		*it;

	it=FindItem("Grenades");
	//TODO:Check grenade ammo
	ammo = ent->client->pers.inventory[ITEM_INDEX(it)];
	if (!ammo)
	{
		gi.cprintf(ent,PRINT_HIGH,"No Grenades\n");
		return;
	}

	if (ent->client->grenadeType == GRENADE_NORMAL)
	{
		if( flashgrenades->value)
		{
			ent->client->grenadeType = GRENADE_FLASH;
			gi.centerprintf(ent,"Flash Grenades Selected\n");
		}
	}
	else
	{
		ent->client->grenadeType = GRENADE_NORMAL;
		gi.centerprintf(ent,"Standard Grenades Selected\n");
	}

	it->use(ent,it);
}

//Keys2_ commands
void Cmd_Keys2_f (edict_t *ent)
{
	char	*s;

	s = gi.args();

	if (Q_stricmp(s,"help") == 0)
	{
		gi.cprintf(ent,PRINT_HIGH,"Now close the console to view the help menu...\n");
		K2_OpenHelpMenu(ent, NULL);
		return;
	}

}

//Player "id" command
void Cmd_id_f (edict_t *ent)
{
	if (ent->client->resp.id_state) {
		gi.cprintf(ent, PRINT_HIGH, "Disabling player identication display.\n");
		ent->client->resp.id_state = false;
	} else {
		gi.cprintf(ent, PRINT_HIGH, "Activating player identication display.\n");
		ent->client->resp.id_state = true;
	}
}
//HK:End

/*
=================
ClientCommand
=================
*/
void ClientCommand (edict_t *ent)
{
	char	*cmd;

	if (!ent->client)
		return;		// not fully in game yet

	cmd = gi.argv(0);

	if (Q_stricmp (cmd, "players") == 0)
	{
		Cmd_Players_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "say") == 0)
	{
		Cmd_Say_f (ent, false, false);
		return;
	}
	if (Q_stricmp (cmd, "say_team") == 0)
	{
		Cmd_Say_f (ent, true, false);
		return;
	}
	if (Q_stricmp (cmd, "score") == 0)
	{
		Cmd_Score_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "help") == 0)
	{
		Cmd_Help_f (ent);
		return;
	}

	if (level.intermissiontime)
// HOLY WARS
// HWv2.1
	// there used to be just a "return" here... we changed it so that
	// any command is ignored, but the "say" function still works
	{
		// if this is not a command, then "say" it immediately
		if (	(Q_stricmp (cmd, "use"))		&&
				(Q_stricmp (cmd, "drop"))		&&
				(Q_stricmp (cmd, "give"))		&&
				(Q_stricmp (cmd, "god"))		&&
				(Q_stricmp (cmd, "notarget"))	&&
				(Q_stricmp (cmd, "noclip"))		&&
				(Q_stricmp (cmd, "inven"))		&&
				(Q_stricmp (cmd, "invnext"))	&&
				(Q_stricmp (cmd, "invprev"))	&&
				(Q_stricmp (cmd, "invnextw"))	&&
				(Q_stricmp (cmd, "invprevw"))	&&
				(Q_stricmp (cmd, "invnextp"))	&&
				(Q_stricmp (cmd, "invprevp"))	&&
				(Q_stricmp (cmd, "invuse"))		&&
				(Q_stricmp (cmd, "invdrop"))	&&
				(Q_stricmp (cmd, "weapprev"))	&&
				(Q_stricmp (cmd, "weapnext"))	&&
				(Q_stricmp (cmd, "weaplast"))	&&
				(Q_stricmp (cmd, "kill"))		&&
				(Q_stricmp (cmd, "putaway"))	&&
				(Q_stricmp (cmd, "wave"))		&&
				//HK:Added Keys2 commands
				(Q_stricmp (cmd, "id"))			&&
				(Q_stricmp (cmd, "flash"))		&&
				(Q_stricmp (cmd, "keys2"))		&&
				(Q_stricmp (cmd, "take"))		&&
				(Q_stricmp (cmd, "hw_newhalo"))	&&
				(Q_stricmp (cmd, "hw_base"))	&&
				(Q_stricmp (cmd, "hw_dump"))	)
			Cmd_Say_f (ent, false, true);

		// ignore commands
		return;
	}
// end HOLY WARS

	if (Q_stricmp (cmd, "use") == 0)
		Cmd_Use_f (ent);
	else if (Q_stricmp (cmd, "drop") == 0)
		Cmd_Drop_f (ent);
	else if (Q_stricmp (cmd, "give") == 0)
		Cmd_Give_f (ent);
	else if (Q_stricmp (cmd, "god") == 0)
		Cmd_God_f (ent);
	else if (Q_stricmp (cmd, "notarget") == 0)
		Cmd_Notarget_f (ent);
	else if (Q_stricmp (cmd, "noclip") == 0)
		Cmd_Noclip_f (ent);
	else if (Q_stricmp (cmd, "inven") == 0)
		Cmd_Inven_f (ent);
	else if (Q_stricmp (cmd, "invnext") == 0)
		SelectNextItem (ent, -1);
	else if (Q_stricmp (cmd, "invprev") == 0)
		SelectPrevItem (ent, -1);
	else if (Q_stricmp (cmd, "invnextw") == 0)
		SelectNextItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invprevw") == 0)
		SelectPrevItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invnextp") == 0)
		SelectNextItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invprevp") == 0)
		SelectPrevItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invuse") == 0)
		Cmd_InvUse_f (ent);
	else if (Q_stricmp (cmd, "invdrop") == 0)
		Cmd_InvDrop_f (ent);
	else if (Q_stricmp (cmd, "weapprev") == 0)
		Cmd_WeapPrev_f (ent);
	else if (Q_stricmp (cmd, "weapnext") == 0)
		Cmd_WeapNext_f (ent);
	else if (Q_stricmp (cmd, "weaplast") == 0)
		Cmd_WeapLast_f (ent);
	else if (Q_stricmp (cmd, "kill") == 0)
		Cmd_Kill_f (ent);
	else if (Q_stricmp (cmd, "putaway") == 0)
		Cmd_PutAway_f (ent);
	else if (Q_stricmp (cmd, "wave") == 0)
		Cmd_Wave_f (ent);
	//HK:Added to handle player id & keys2 stuff.
	//ZOID
	else if (Q_stricmp(cmd, "id") == 0) {
		CTFID_f (ent);
	}
	//ZOID
	//K2:Begin - Flash Grenade
	else if (Q_stricmp (cmd, "flash") == 0)
        Cmd_FlashGrenade_f (ent);
	//keys2_ command
	else if (Q_stricmp (cmd, "keys2") == 0)
        Cmd_Keys2_f (ent);
	//take key
	else if (Q_stricmp (cmd, "take") == 0)
        Cmd_TakeKey_f (ent);
	//K2:end

// HOLY WARS
	else if (Q_stricmp (cmd, "hw_newhalo") == 0)  // Restarts the halo.
	{
// HWv2.1 : modified next line
		if (hw_edit->value && (hw.halobase != NULL))
		{
			HW_HaloReset();
			// let everyone know:
			gi.bprintf(PRINT_HIGH, "*** The halo has been destroyed and recreated ***\n");
		}
		else
			gi.cprintf(ent, PRINT_HIGH, "Cannot reset halo - HW_EDIT is off\n");
	}
	else if (Q_stricmp (cmd, "hw_base") == 0)  // Sets the halo base in the level.
    {
		if (hw_edit->value)
		{
  			HW_SaveHaloPos(level.mapname, ent->s.origin);
			// let everyone know:
			gi.bprintf(PRINT_HIGH, "*** The halo base has been changed ***\n");
		}
		else
			gi.cprintf(ent, PRINT_HIGH, "Cannot set base - HW_EDIT is off\n");
	}
	else if (Q_stricmp (cmd, "hw_dump") == 0)  // Dumps all the entities on the console.
	{
		if (hw_edit->value)
			HW_DumpEntities();
		else
			gi.cprintf(ent, PRINT_HIGH, "Cannot dump - HW_EDIT is off\n");
	}
// HWv2.1 - "hw_motd" command obsolete - 2 lines commented out:
//	else if (Q_stricmp (cmd, "hw_motd") == 0)  // Reprints Message of the Day.
//		HW_PrintMOTD(ent);
// end HOLY WARS
	else	// anything that doesn't match a command will be a chat
		Cmd_Say_f (ent, false, true);
}
