// HOLY WARS: parameter loader

#include "g_local.h"

// --------------
// --- CNF_LOAD.c
// --------------
// - function that loads from file all the parameters specified in CNF_DEFS.c
// --------------
#define CNF_LOAD_FILE
#include "cnf_load.h"

// -- defined in CNF_DEFS.c
extern  char             *CNF_file_cnf_ini_name;
extern  CNF_load_struct_t desc_struct[];

//--------------------------------------------
// func. int CNF_LoadVariables(void)
// -------
// loads from CNF_file_cnf_ini_name the parameters declared in desc_struct
// ------- 15/1/98 --------------------------
// param        : load_struct_pnt       load_struct_descriptor
// returns      : > 0                   number of parameter loaded
//              : < 0                   error
//              : = 0                   no error BUT no parameter found
// R static var.: CNF_file_cnf_ini_name
// W static var.: none
//-------------------------------------------
 int CNF_LoadVariables(void)
 {
 int    var_int;
 float  var_float;
 char   var_string[256];
 FILE   *f;
 char   buff[512], buf2[512], nome[128];
 int    total_count = 0;
 char   *desc_str;

 if((f=fopen(CNF_file_cnf_ini_name, "r"))==NULL) return -1;

 while( fgets( buff, 511, f) != NULL)   // loads a line of text into buff
       {
       char *pnt = strstr(buff, "//");  // looks for comments (//)
       if(pnt != NULL) *pnt = '\0';     // if it finds comments, it cuts the string
	    // if the '{' is in the first position, scanf needs to explicitly ignore it
		// we use two different strings depending on this condition
       desc_str = (buff[0] == '{') ? "{%[^}]%*[^=]= %[^\n\0]" : "%*[^{]{%[^}]%*[^=]= %[^\n\0]";
       if( sscanf(buff, desc_str, nome, buf2) == 2)
                {
                int i;
                // found an entry -> check if it's the one we're looking for
                // scan the structure from element 0 to last
                for(i = 0; desc_struct[i].tipo != CNF_VOID_TYPE; i++)
                       if(stricmp (nome, desc_struct[i].nome) == 0)
                            {  // found variable -> load value
                            switch(desc_struct[i].tipo)
                                {
                            case CNF_INT_TYPE:  // an integer
                                                // (note: we don't deal with the case " {x} = qlo" -> x = 0)
                                var_int = atoi(buf2);
                                        // check limits
                                if( desc_struct[i].limite[1] < desc_struct[i].limite[0]
                                  || (  var_int >= desc_struct[i].limite[0]
                                     && var_int <= desc_struct[i].limite[1] ) )
                                        {
                                                // assign variable to global var
                                        *((int *) desc_struct[i].pnt_to_var) = var_int;
                                        total_count++;
                                        }
                                break;
                           case CNF_FLOAT_TYPE:
                                if( sscanf(buf2, " %f ", &var_float) != 1) break;
                                if( desc_struct[i].limite[1] < desc_struct[i].limite[0]
                                   || (  var_float >= (float) desc_struct[i].limite[0]
                                      && var_float <= (float) desc_struct[i].limite[1] ))
                                        {
                                        *((float *) desc_struct[i].pnt_to_var) = var_float;
                                        total_count++;
                                        }
                                break;
                           case CNF_STRING_TYPE:
                           case CNF_TEXT_TYPE:
                                {
                                int k;
                                        // same problem we had with '{'
                                const char *scanf_string = ( buf2[0] == '\"')
                                                        ? "\"%[^\"]"
                                                        : "%*[^\"]\"%[^\"]";
                                if( sscanf(buf2, scanf_string, var_string) != 1) break;
                                k = strlen(var_string);
                                if( desc_struct[i].limite[1] < desc_struct[i].limite[0]
                                   || (  k >= desc_struct[i].limite[0]
                                      && k <= desc_struct[i].limite[1] ))
                                        {
                                        if(desc_struct[i].tipo == CNF_TEXT_TYPE)
                                                { // if type is text, replace $ with \n

                                                for(k=0; var_string[k] != 0; k++)
                                                        if(var_string[k] == '$' )
                                                                var_string[k] = '\n';
                                                }
                                        strcpy( (char *) desc_struct[i].pnt_to_var, var_string);
                                        total_count++;
                                        }
                                }
                           default:
                                break;
                                }
                           break;       // end of struct vector scan "for" cicle
                           }
                }
       }
   // file scanning is over
 fclose(f);
 return total_count;
}


