// HOLY WARS: parameter loader definitions

#include "g_local.h"

#define CNF_LOAD_FILE
#include "cnf_load.h"

// parameter file:
char *CNF_file_cnf_ini_name = "holywars/config/param.ini";
extern hw_parameters_t hwpar;


// --------- me must create a static struct to store the variables with their descriptions
// --------- please note: the name of this struct is directly called from the function
// --------- note (2): limit between 0 and -1 means "no limit"

 CNF_load_struct_t desc_struct[] =
      { { "SCORE_NormalKill",    CNF_INT_TYPE,       &(hwpar.SCORE_NormalKill),    { 0, -1}      },
        { "SCORE_HolyKill",      CNF_INT_TYPE,       &(hwpar.SCORE_HolyKill),      { 0, -1}      },
        { "SCORE_KillHeretic",   CNF_INT_TYPE,       &(hwpar.SCORE_KillHeretic),   { 0, -1}      },
        { "SCORE_KillSaint",     CNF_INT_TYPE,       &(hwpar.SCORE_KillSaint),     { 0, -1}      },
        { "SCORE_TakeHalo",      CNF_INT_TYPE,       &(hwpar.SCORE_TakeHalo),      { 0, -1}      },
// HWv2.1
		{ "SCORE_BecomeHeretic", CNF_INT_TYPE,       &(hwpar.SCORE_BecomeHeretic), { -10000, 0}	 },
        { "SCORE_Llama",         CNF_INT_TYPE,       &(hwpar.SCORE_Llama),         { -10000, -1} },
// end HWv2.1
        { "HERESY_MeleeRange",   CNF_FLOAT_TYPE,     &(hwpar.HERESY_MeleeRange),   { 0,    1000} },
        { "HERESY_NearRange",    CNF_FLOAT_TYPE,     &(hwpar.HERESY_NearRange),    { 1,   10000} },
        { "HERESY_FarRange",     CNF_FLOAT_TYPE,     &(hwpar.HERESY_FarRange),     { 1, MAX_INT} },
        { "RULES_HeresyThreshold",CNF_FLOAT_TYPE,    &(hwpar.RULES_HeresyThreshold),{ 0, MAX_INT} },
        { "RULES_SinnerDamage",  CNF_INT_TYPE,       &(hwpar.RULES_SinnerDamage),  { 0, 1}       },
        { "PHYS_HaloInertia",    CNF_INT_TYPE,       &(hwpar.PHYS_HaloInertia),    { 0, 1}       },
        { "PHYS_HaloHeight",     CNF_INT_TYPE,       &(hwpar.PHYS_HaloHeight),     { 0, -1}      },
        { "PHYS_HaloTolerance",  CNF_INT_TYPE,       &(hwpar.PHYS_HaloTolerance),  { 0, MAX_INT} },
        { "PHYS_HaloVelocity",   CNF_INT_TYPE,       &(hwpar.PHYS_HaloVelocity),   { 1, MAX_INT} },
        { "PHYS_HaloAccel0",     CNF_FLOAT_TYPE,     &(hwpar.PHYS_HaloAccel[0]),   { 0.1, MAX_INT} },
        { "PHYS_HaloAccel1",     CNF_FLOAT_TYPE,     &(hwpar.PHYS_HaloAccel[1]),   { 0.1, MAX_INT} },
        { "PHYS_HaloAccel2",     CNF_FLOAT_TYPE,     &(hwpar.PHYS_HaloAccel[2]),   { 0.1, MAX_INT} },
        { "PHYS_HaloBrake0",     CNF_FLOAT_TYPE,     &(hwpar.PHYS_HaloBrake[0]),   { 1, MAX_INT} },
        { "PHYS_HaloBrake1",     CNF_FLOAT_TYPE,     &(hwpar.PHYS_HaloBrake[1]),   { 1, MAX_INT} },
        { "PHYS_HaloBrake2",     CNF_FLOAT_TYPE,     &(hwpar.PHYS_HaloBrake[2]),   { 1, MAX_INT} },
        { "PHYS_CyclesForFrame", CNF_INT_TYPE,       &(hwpar.PHYS_CyclesForFrame), { 1, MAX_INT} },
        { "PHYS_HaloFall",       CNF_INT_TYPE,       &(hwpar.PHYS_HaloFall),       { 1, MAX_INT} },
        { "TIMES_FirstSpawn",    CNF_INT_TYPE,       &(hwpar.TIMES_FirstSpawn),    { 2, MAX_INT} },
        { "TIMES_Disappear",     CNF_INT_TYPE,       &(hwpar.TIMES_Disappear),     { 0, MAX_INT} },
        { "TIMES_Respawn",       CNF_INT_TYPE,       &(hwpar.TIMES_Respawn),       { 0, MAX_INT} },
        { "BONUS_HealthForEnemy",CNF_INT_TYPE,       &(hwpar.BONUS_HealthForEnemy),{ 0, -1}      },
        { "BONUS_ArmorForEnemy", CNF_INT_TYPE,       &(hwpar.BONUS_ArmorForEnemy), { 0, -1}      },
        { "BONUS_Max",           CNF_INT_TYPE,       &(hwpar.BONUS_Max),           { 1, MAX_INT} },
        { "MISC_ReportFreq",     CNF_INT_TYPE,       &(hwpar.MISC_ReportFreq),     { 0, -1}      },
        { "MISC_SaintSound",     CNF_INT_TYPE,       &(hwpar.MISC_SaintSound),     { 0, 1}       },
// HWv2.1
		{ "MISC_UseBFG",         CNF_INT_TYPE,       &(hwpar.MISC_UseBFG),         { 0, 1}       },
		{ "MISC_IntermissionTime",CNF_INT_TYPE,      &(hwpar.MISC_IntermissionTime),{ 0, 3600}    },
// end HWv2.1
		{ "",                    CNF_VOID_TYPE,      NULL,                         { 0, -1}      }
      };

