
//**************************************************************************
//**
//** I_TIMER.C
//**
//** Version:		1.0
//** Last Build:	-?-
//** Author:		jk
//**
//** Timer routines.
//**
//**************************************************************************

// HEADER FILES ------------------------------------------------------------

#define WIN32_LEAN_AND_MEAN

#include <stdlib.h>
#include <windows.h>
#include <mmsystem.h>
//#include "h2def.h"
#include "dd_share.h"
#include "i_mus.h"

// MACROS ------------------------------------------------------------------

#define TIMER_RES	7	// Timer resolution.
#define TIMER_SUB_TICS 4

// TYPES -------------------------------------------------------------------

// EXTERNAL FUNCTION PROTOTYPES --------------------------------------------

// PUBLIC FUNCTION PROTOTYPES ----------------------------------------------

// PRIVATE FUNCTION PROTOTYPES ---------------------------------------------

// EXTERNAL DATA DECLARATIONS ----------------------------------------------

// PUBLIC DATA DEFINITIONS -------------------------------------------------

int timerID;
boolean			timerInstalled = false;
volatile int	ticcount = 0, subtic = 0;
int				savedtime;

// PRIVATE DATA DEFINITIONS ------------------------------------------------

// CODE --------------------------------------------------------------------

//==========================================================================
//
// I_TimerISR
//
//==========================================================================

void CALLBACK I_TimerISR(UINT id, UINT msg, DWORD user, DWORD dw1, DWORD dw2)
{
	// Call the song player.
	MUS_SongPlayer();
	// Is it time to advance to the next tick?
	if(--subtic <= 0)
	{
		ticcount++;
		subtic = TIMER_SUB_TICS;
	}
}

//==========================================================================
//
// I_ShutdownTimer
//
//==========================================================================

void I_ShutdownTimer (void)
{
	if(timerInstalled)
	{
		timerInstalled = false;
		timeKillEvent(timerID);
		timeEndPeriod(TIMER_RES);
	}
}

//==========================================================================
//
// I_StartupTimer
//
//==========================================================================

void I_StartupTimer (void)
{
#ifndef NOTIMER
	//ST_Message("  I_StartupTimer...\n");
	timeBeginPeriod(TIMER_RES);
	timerID = timeSetEvent(1000/140, TIMER_RES, I_TimerISR, 0, TIME_PERIODIC);
	timerInstalled = true;
	atexit(I_ShutdownTimer);
#endif
}

//==========================================================================
//
// I_GetTime
//
// Returns time in 1/35th second tics.
//
//==========================================================================

int I_GetTime (void)
{
#ifdef NOTIMER
	ticcount++;
#endif
	return ticcount;
}

//==========================================================================
//
// I_SaveTime
//
//==========================================================================

void I_SaveTime(void)
{
	savedtime = ticcount;
}

//==========================================================================
//
// I_RestoreTime
//
//==========================================================================

void I_RestoreTime(void)
{
	ticcount = savedtime;
}

//==========================================================================
//
//
//
//==========================================================================
