
//**************************************************************************
//**
//** r_draw.c : Heretic 2 : Raven Software, Corp.
//**
//** $RCSfile: r_draw.c,v $
//** $Revision: 1.11 $
//** $Date: 96/01/06 18:37:37 $
//** $Author: bgokey $
//**
//**************************************************************************

//#include "h2def.h"
//#include "r_local.h"
#include "dd_def.h"
#include "gl_def.h"

/*

All drawing to the view buffer is accomplished in this file.  The other refresh
files only know about ccordinates, not the architecture of the frame buffer.

*/

byte *viewimage;

// The view window.
int viewwidth, viewheight, viewwindowx, viewwindowy;

enum // A logical ordering (twice around).
{
	BG_BACKGROUND,
	BG_TOP,
	BG_RIGHT,
	BG_BOTTOM,
	BG_LEFT,
	BG_TOPLEFT,
	BG_TOPRIGHT,
	BG_BOTTOMRIGHT,
	BG_BOTTOMLEFT
};

// The view border graphics.
char borderGfx[9][9];

byte *dc_translation;
byte *translationtables;


void R_SetBorderGfx(char *gfx[9])
{
	int		i;
	for(i=0; i<9; i++)
		if(gfx[i]) 
			strcpy(borderGfx[i], gfx[i]);
		else
			strcpy(borderGfx[i], "-");
}					

//--------------------------------------------------------------------------
//
// PROC R_InitTranslationTables
//
//--------------------------------------------------------------------------

void R_InitTranslationTables (void)
{
	int i;
	byte *transLump;

	// Load tint table (I don't need this -jk).
	//tinttable = W_CacheLumpName("TINTTAB", PU_STATIC);

	// Allocate translation tables
	translationtables = Z_Malloc(256*3*(MAXPLAYERS-1)+255, 
		PU_REFRESHTRANS, 0);
	translationtables = (byte *)(((int)translationtables+255)&~255);

	for(i = 0; i < 3*(MAXPLAYERS-1); i++)
	{
		// If this can't be found, it's reasonable to expect that the game dll
		// will initialize the translation tables as it wishes.
		if(W_CheckNumForName("trantbl0") < 0) break;

		transLump = W_CacheLumpNum(W_GetNumForName("trantbl0")+i, PU_STATIC);
		memcpy(translationtables+i*256, transLump, 256);
		Z_Free(transLump);
	}
}

void R_UpdateTranslationTables (void)
{
	Z_FreeTags(PU_REFRESHTRANS, PU_REFRESHTRANS);
	R_InitTranslationTables();
}


/*
================
=
= R_InitBuffer
=
=================
*/

void R_InitBuffer (int width, int height)
{
}


/*
==================
=
= R_DrawViewBorder
=
= Draws the border around the view for different size windows
==================
*/

boolean BorderNeedRefresh;

void R_DrawViewBorder (void)
{
	int		lump;

	if(viewwidth == 320 && viewheight == 200) return;
/*	if((scaledviewwidth == 320 && sbarscale == 20) ||
		(sbarscale != 20 && viewheight == 200))
		return;*/

	// View background.
	GL_SetColorAndAlpha(1,1,1,1);
	GL_SetFlat(R_FlatNumForName(borderGfx[BG_BACKGROUND]));
	//GL_DrawRectTiled(0, 0, SCREENWIDTH, SCREENHEIGHT-SBARHEIGHT, 64, 64);
	GL_DrawCutRectTiled(0, 0, 320, 200 /*- (sbarscale==20? SBARHEIGHT : 0)*/, 64, 64,
		viewwindowx-4, viewwindowy-4, viewwidth+8, viewheight+8);

	// The border top.
	GL_SetPatch(lump=W_GetNumForName(borderGfx[BG_TOP]));
	GL_DrawRectTiled(viewwindowx, viewwindowy-4, viewwidth, 
		lumptexsizes[lump].h, 16, lumptexsizes[lump].h);
	// Border bottom.
	GL_SetPatch(lump=W_GetNumForName(borderGfx[BG_BOTTOM]));
	GL_DrawRectTiled(viewwindowx, viewwindowy+viewheight, viewwidth, 
		lumptexsizes[lump].h, 16, lumptexsizes[lump].h);

	// Left view border.
	GL_SetPatch(lump=W_GetNumForName(borderGfx[BG_LEFT]));
	GL_DrawRectTiled(viewwindowx-4, viewwindowy, lumptexsizes[lump].w,
		viewheight, lumptexsizes[lump].w, 16);
	// Right view border.
	GL_SetPatch(lump=W_GetNumForName(borderGfx[BG_RIGHT]));
	GL_DrawRectTiled(viewwindowx+viewwidth, viewwindowy, lumptexsizes[lump].w,
		viewheight, lumptexsizes[lump].w, 16);

	GL_DrawPatch(viewwindowx-4, viewwindowy-4, W_GetNumForName(borderGfx[BG_TOPLEFT]));
	GL_DrawPatch(viewwindowx+viewwidth, viewwindowy-4, W_GetNumForName(borderGfx[BG_TOPRIGHT]));
	GL_DrawPatch(viewwindowx+viewwidth, viewwindowy+viewheight, W_GetNumForName(borderGfx[BG_BOTTOMRIGHT]));
	GL_DrawPatch(viewwindowx-4, viewwindowy+viewheight, W_GetNumForName(borderGfx[BG_BOTTOMLEFT]));
}

/*
==================
=
= R_DrawTopBorder
=
= Draws the top border around the view for different size windows
==================
*/

boolean BorderTopRefresh;

void R_DrawTopBorder (void)
{
	if (viewwidth == 320 && viewheight == 200)
		return;

	GL_SetColorAndAlpha(1,1,1,1);
	GL_SetFlat(R_FlatNumForName(borderGfx[BG_BACKGROUND]));
	
	GL_DrawRectTiled(0, 0, 320, 64, 64, 64);
	if(viewwindowy < 65)
	{
		int lump;
		GL_SetPatch(lump=W_GetNumForName(borderGfx[BG_TOP]));
		GL_DrawRectTiled(viewwindowx, viewwindowy-4, viewwidth, 
			lumptexsizes[lump].h, 16, lumptexsizes[lump].h);

		GL_DrawPatch(viewwindowx-4, viewwindowy, W_GetNumForName(borderGfx[BG_LEFT]));
		GL_DrawPatch(viewwindowx+viewwidth, viewwindowy, W_GetNumForName(borderGfx[BG_RIGHT]));
		GL_DrawPatch(viewwindowx-4, viewwindowy+16, W_GetNumForName(borderGfx[BG_LEFT]));
		GL_DrawPatch(viewwindowx+viewwidth, viewwindowy+16, W_GetNumForName(borderGfx[BG_RIGHT]));

		GL_DrawPatch(viewwindowx-4, viewwindowy-4, W_GetNumForName(borderGfx[BG_TOPLEFT]));
		GL_DrawPatch(viewwindowx+viewwidth, viewwindowy-4, W_GetNumForName(borderGfx[BG_TOPRIGHT]));//, PU_CACHE));
	}
}




