
// D_main.c

#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include "DoomDef.h"
#include "P_local.h"
#include "soundst.h"
#include "settings.h"

game_import_t	gi;
game_export_t	gx;
gl_export_t		gl;

boolean shareware = false;		// true if only episode 1 present
boolean ExtendedWAD = false;	// true if episodes 4 and 5 present

boolean nomonsters;			// checkparm of -nomonsters
boolean respawnparm;		// checkparm of -respawn
boolean debugmode;			// checkparm of -debug
boolean ravpic;				// checkparm of -ravpic
boolean cdrom;				// true if cd-rom mode active
boolean singletics;			// debug flag to cancel adaptiveness
boolean noartiskip;			// whether shift-enter skips an artifact

skill_t startskill;
int startepisode;
int startmap;
boolean autostart;
extern boolean automapactive;

boolean advancedemo;

static boolean devMap;

FILE *debugfile;

void G_BuildTiccmd(ticcmd_t *cmd);
void D_DoAdvanceDemo(void);
void D_PageDrawer (void);
void D_AdvanceDemo (void);
void F_Drawer(void);
void H_ConsoleRegistration();
void R_DrawPlayerSprites(ddplayer_t *viewplr);
void R_SetDoomsdayFlags();
void R_DrawRingFilter();
void X_Drawer();
int H_PrivilegedResponder(event_t *event);
void H_DefaultBindings();

// Networking.
int H_NetServerOpen(int before);
int H_NetServerClose(int before);
int H_NetServerStarted(int before);
int H_NetConnect(int before);
int H_NetDisconnect(int before);
int H_NetPlayerEvent(int plrNumber, int peType, void *data);


//---------------------------------------------------------------------------
//
// FUNC FixedDiv
//
//---------------------------------------------------------------------------

fixed_t FixedDiv(fixed_t a, fixed_t b)
{
	if((abs(a)>>14) >= abs(b))
	{
		return((a^b)<0 ? MININT : MAXINT);
	}
	return(FixedDiv2(a, b));
}

//---------------------------------------------------------------------------
//
// PROC D_Display
//
// Draw current display, possibly wiping it from the previous.
//
//---------------------------------------------------------------------------

void R_ExecuteSetViewSize(void);

extern boolean finalestage;

void D_Display(void)
{
	extern boolean MenuActive;
	extern boolean askforquit;

	// Change the view size if needed
	if(setsizeneeded)
	{
		setsizeneeded = false;
		if(setblocks > 10)
		{
			// Full screen.
			gi.ViewWindow(0, 0, 320, 200);
		}
		else
		{
			int w = setblocks*32;
			int h = setblocks*(200-SBARHEIGHT*sbarscale/20)/10;
			gi.ViewWindow(160-(w>>1), (200-SBARHEIGHT*sbarscale/20-h)>>1, w, h);
		}
	}

//
// do buffered drawing
//
	switch (gamestate)
	{
	case GS_LEVEL:
		if (!gametic)
			break;
		if (automapactive)
			AM_Drawer ();
		else
		{
			// Set flags for the renderer.
			R_SetDoomsdayFlags();
			// The display player cannot be seen.
			players[displayplayer].plr->mo->ddflags |= DDMF_DONTDRAW;
			// With invulnerability, we want fullbright lighting.
			gi.Set(DD_FULLBRIGHT, players[displayplayer].powers[pw_invulnerability]);
			gi.RenderPlayerView(players[displayplayer].plr);
			if(players[displayplayer].powers[pw_invulnerability])
				R_DrawRingFilter();
			X_Drawer();
		}
		CT_Drawer();
		gi.Update(DDUF_FULLVIEW);
		SB_Drawer();
		break;
	case GS_INTERMISSION:
		IN_Drawer ();
		break;
	case GS_FINALE:
		F_Drawer ();
		break;
	case GS_DEMOSCREEN:
		D_PageDrawer ();
		break;
	}

	if(paused && !MenuActive && !askforquit)
	{
		if(!netgame)
		{
			gi.GL_DrawPatch(160, gi.Get(DD_VIEWWINDOW_Y)+5, W_GetNumForName("PAUSED"));
		}
		else
		{
			gi.GL_DrawPatch(160, 70, W_GetNumForName("PAUSED"));
		}
	}
}

/*
===============================================================================

						DEMO LOOP

===============================================================================
*/

int             demosequence;
int             pagetic;
char            *pagename;


/*
================
=
= D_PageTicker
=
= Handles timing for warped projection
=
================
*/

void D_PageTicker (void)
{
	if (--pagetic < 0)
		D_AdvanceDemo ();
}


/*
================
=
= D_PageDrawer
=
================
*/

extern boolean MenuActive;

void D_PageDrawer(void)
{
	//V_DrawRawScreen(W_CacheLumpName(pagename, PU_CACHE));
	gi.GL_DrawRawScreen(W_GetNumForName(pagename));
	if(demosequence == 1)
	{
		//V_DrawPatch(4, 160, W_CacheLumpName("ADVISOR", PU_CACHE));
		gi.GL_DrawPatch(4, 160, W_GetNumForName("ADVISOR"));
	}
	gi.Update(DDUF_FULLSCREEN);
}

/*
=================
=
= D_AdvanceDemo
=
= Called after each demo or intro demosequence finishes
=================
*/

void D_AdvanceDemo (void)
{
	advancedemo = true;
}

void D_DoAdvanceDemo (void)
{
	players[consoleplayer].playerstate = PST_LIVE;  // don't reborn
	advancedemo = false;
	usergame = false;               // can't save / end game here
	paused = false;
	gameaction = ga_nothing;
	demosequence = (demosequence+1)%7;
	switch (demosequence)
	{
		case 0:
			pagetic = 210;
			gamestate = GS_DEMOSCREEN;
			pagename = "TITLE";
			S_StartSong(mus_titl, false);
			break;
		case 1:
			pagetic = 140;
			gamestate = GS_DEMOSCREEN;
			pagename = "TITLE";
			break;
		case 2:
			/*BorderNeedRefresh = true;
			UpdateState |= I_FULLSCRN;*/
			gi.Update(DDUF_BORDER | DDUF_FULLSCREEN);
			G_DeferedPlayDemo ("demo1");
			break;
		case 3:
			pagetic = 200;
			gamestate = GS_DEMOSCREEN;
			pagename = "CREDIT";
			break;
		case 4:
			/*BorderNeedRefresh = true;
			UpdateState |= I_FULLSCRN;*/
			gi.Update(DDUF_BORDER | DDUF_FULLSCREEN);
			G_DeferedPlayDemo ("demo2");
			break;
		case 5:
			pagetic = 200;
			gamestate = GS_DEMOSCREEN;
			if(shareware)
			{
				pagename = "ORDER";
			}
			else
			{
				pagename = "CREDIT";
			}
			break;
		case 6:
			/*BorderNeedRefresh = true;
			UpdateState |= I_FULLSCRN;*/
			gi.Update(DDUF_BORDER | DDUF_FULLSCREEN);
			G_DeferedPlayDemo ("demo3");
			break;
	}
}


/*
=================
=
= D_StartTitle
=
=================
*/

void D_StartTitle (void)
{
	gameaction = ga_nothing;
	demosequence = -1;
	D_AdvanceDemo ();
}


/*
==============
=
= D_CheckRecordFrom
=
= -recordfrom <savegame num> <demoname>
==============
*/

void D_CheckRecordFrom (void)
{
	int     p;
	char    file[256];

	p = M_CheckParm ("-recordfrom");
	if (!p || p > myargc-2)
		return;

	if(cdrom)
	{
		sprintf(file, SAVEGAMENAMECD"%c.hsg",gi.Argv(p+1)[0]);
	}
	else
	{
		sprintf(file, SAVEGAMENAME"%c.hsg",gi.Argv(p+1)[0]);
	}
	G_LoadGame (file);
	G_DoLoadGame ();    // load the gameskill etc info from savegame

	G_RecordDemo (gameskill, 1, gameepisode, gamemap, gi.Argv(p+2));
}

/*
===============
=
= D_AddFile
=
===============
*/

#define MAXWADFILES 20

// MAPDIR should be defined as the directory that holds development maps
// for the -wart # # command

#ifdef __NeXT__
#define MAPDIR "/Novell/Heretic/data/"
#define SHAREWAREWADNAME "/Novell/Heretic/source/heretic1.wad"
char *wadfiles[MAXWADFILES] =
{
	"/Novell/Heretic/source/heretic.wad",
	"/Novell/Heretic/data/texture1.lmp",
	"/Novell/Heretic/data/texture2.lmp",
	"/Novell/Heretic/data/pnames.lmp"
};
#else

#define MAPDIR "\\data\\"

#define SHAREWAREWADNAME "heretic1.wad"

char *wadfiles[MAXWADFILES] =
{
	"heretic.wad",
	"texture1.lmp",
	"texture2.lmp",
	"pnames.lmp"
};

#endif

char *basedefault = "heretic.cfg";

char exrnwads[80];
char exrnwads2[80];

void wadprintf(void)
{
	if(debugmode)
	{
		return;
	}
	#ifdef __WATCOMC__
	_settextposition(23, 2);
	_setbkcolor(1);
	_settextcolor(0);
	_outtext(exrnwads);
	_settextposition(24, 2);
	_outtext(exrnwads2);
	#endif
}

void D_AddFile(char *file)
{
	int numwadfiles;
	char *new;
//	char text[256];

	for(numwadfiles = 0; wadfiles[numwadfiles]; numwadfiles++);
	new = malloc(strlen(file)+1);
	strcpy(new, file);
	if(strlen(exrnwads)+strlen(file) < 78)
	{
		if(strlen(exrnwads))
		{
			strcat(exrnwads, ", ");
		}
		else
		{
			strcpy(exrnwads, "External Wadfiles: ");
		}
		strcat(exrnwads, file);
	}
	else if(strlen(exrnwads2)+strlen(file) < 79)
	{
		if(strlen(exrnwads2))
		{
			strcat(exrnwads2, ", ");
		}
		else
		{
			strcpy(exrnwads2, "     ");
			strcat(exrnwads, ",");
		}
		strcat(exrnwads2, file);
	}
	wadfiles[numwadfiles] = new;
}

//==========================================================
//
//  Startup Thermo code
//
//==========================================================
/*#define MSG_Y       9
//#define THERM_X 15
//#define THERM_Y 16
//#define THERMCOLOR  3
#define THERM_X     14
#define THERM_Y     14

int thermMax;
int thermCurrent;
char    *startup;           // * to text screen
char smsg[80];      // status bar line

//
//  Heretic startup screen shit
//

byte *hscreen;

void hgotoxy(int x,int y)
{
	hscreen = (byte *)(0xb8000 + y*160 + x*2);
}

void hput(unsigned char c, unsigned char a)
{
	*hscreen++ = c;
	*hscreen++ = a;
}

void hprintf(char *string, unsigned char a)
{
#ifdef __WATCOMC__
	int i;

	if(debugmode)
	{
		puts(string);
		return;
	}
	for(i = 0; i < strlen(string); i++)
	{
		hput(string[i], a);
	}
#endif
}

void drawstatus(void)
{
	if(debugmode)
	{
		return;
	}
	#ifdef __WATCOMC__
	_settextposition(25, 2);
	_setbkcolor(1);
	_settextcolor(15);
	_outtext(smsg);
	_settextposition(25, 1);
	#endif
}

void status(char *string)
{
	strcat(smsg,string);
	drawstatus();
}

void DrawThermo(void)
{
	#ifdef __WATCOMC__
	unsigned char       *screen;
	int     progress;
	int     i;

	if(debugmode)
	{
		return;
	}
#if 0
	progress = (98*thermCurrent)/thermMax;
	screen = (char *)0xb8000 + (THERM_Y*160 + THERM_X*2);
	for (i = 0;i < progress/2; i++)
	{
		switch(i)
		{
			case 4:
			case 9:
			case 14:
			case 19:
			case 29:
			case 34:
			case 39:
			case 44:
				*screen++ = 0xb3;
				*screen++ = (THERMCOLOR<<4)+15;
				break;
			case 24:
				*screen++ = 0xba;
				*screen++ = (THERMCOLOR<<4)+15;
				break;
			default:
				*screen++ = 0xdb;
				*screen++ = 0x40 + THERMCOLOR;
				break;
		}
	}
	if (progress&1)
	{
		*screen++ = 0xdd;
		*screen++ = 0x40 + THERMCOLOR;
	}
#else
	progress = (50*thermCurrent)/thermMax+2;
//  screen = (char *)0xb8000 + (THERM_Y*160 + THERM_X*2);
	hgotoxy(THERM_X,THERM_Y);
	for (i = 0; i < progress; i++)
	{
//      *screen++ = 0xdb;
//      *screen++ = 0x2a;
		hput(0xdb,0x2a);
	}
#endif
	#endif
}

#ifdef __WATCOMC__
void blitStartup(void)
{
	byte *textScreen;

	if(debugmode)
	{
		return;
	}

	// Blit main screen
	textScreen = (byte *)0xb8000;
	memcpy(textScreen, startup, 4000);

	// Print version string
	_setbkcolor(4); // Red
	_settextcolor(14); // Yellow
	_settextposition(3, 47);
	_outtext(VERSION_TEXT);

	// Hide cursor
	_settextcursor(0x2000);
}
#endif

char tmsg[300];
void tprintf(char *msg,int initflag)
{
#if 0
	#ifdef __WATCOMC__
	char    temp[80];
	int start;
	int add;
	int i;
	#endif

	if(debugmode)
	{
		printf(msg);
		return;
	}
	#ifdef __WATCOMC__
	if (initflag)
		tmsg[0] = 0;
	strcat(tmsg,msg);
	blitStartup();
	DrawThermo();
	_setbkcolor(4);
	_settextcolor(15);
	for (add = start = i = 0; i <= strlen(tmsg); i++)
		if ((tmsg[i] == '\n') || (!tmsg[i]))
		{
			memset(temp,0,80);
			strncpy(temp,tmsg+start,i-start);
			_settextposition(MSG_Y+add,40-strlen(temp)/2);
			_outtext(temp);
			start = i+1;
			add++;
		}
	_settextposition(25,1);
	drawstatus();
	#else
	printf(msg);
	#endif
#endif
}

void CheckAbortStartup(void)
{
#ifdef __WATCOMC__
	extern int lastpress;

	if(lastpress == 1)
	{ // Abort if escape pressed
		CleanExit();
	}
#endif
}

void IncThermo(void)
{
	thermCurrent++;
	DrawThermo();
	CheckAbortStartup();
}

void InitThermo(int max)
{
	thermMax = max;
	thermCurrent = 0;
}

#ifdef __WATCOMC__
void CleanExit(void)
{
	union REGS regs;

	I_ShutdownKeyboard();
	regs.x.eax = 0x3;
	int386(0x10, &regs, &regs);
	printf("Exited from HERETIC.\n");
	exit(1);
}
#endif
*/

char *borderLumps[] =
{
	"FLAT513",	// background
	"bordt",	// top
	"bordr",	// right
	"bordb",	// bottom
	"bordl",	// left
	"bordtl",	// top left
	"bordtr",	// top right
	"bordbr",	// bottom right
	"bordbl"	// bottom left
};

void H_PreInit(void)
{
	int		i, p, e, m;
	char	file[256];

	if(gi.version < DOOMSDAY_VERSION) 
		gi.Error("JHeretic requires at least Doomsday "DOOMSDAY_VERSION_TEXT"!\n");

	// Setup the players.
	for(i=0; i<MAXPLAYERS; i++)
	{
		players[i].plr = gi.GetPlayer(i);
		players[i].plr->extradata = (void*) &players[i];
	}
	gi.SetSpriteNameList(sprnames);
	gi.Set(DD_SKYFLAT_NAME, (int) "F_SKY1");
	gi.SetConfigFile("JHeretic.cfg");
	gi.SetBorderGfx(borderLumps);
	gi.DefineActions(actions);
	// Add the JHexen cvars and ccmds to the console databases.
	H_ConsoleRegistration();

	// The startup WADs.
	gi.AddStartupWAD("heretic.wad");

//	M_FindResponseFile();
//	setbuf(stdout, NULL);
	nomonsters = M_CheckParm("-nomonsters");
	respawnparm = M_CheckParm("-respawn");
	ravpic = M_CheckParm("-ravpic");
	noartiskip = M_CheckParm("-noartiskip");
	debugmode = M_CheckParm("-debug");
	startskill = sk_medium;
	startepisode = 1;
	startmap = 1;
	autostart = false;

	// Check for -CDROM
	cdrom = false;
	if(M_CheckParm("-cdrom"))
	{
		cdrom = true;
		_mkdir("c:\\heretic.cd");
	}

	// -DEVMAP <episode> <map>
	// Adds a map wad from the development directory to the wad list,
	// and sets the start episode and the start map.
	devMap = false;
	p = M_CheckParm("-devmap");
	if(p && p < myargc-2)
	{
		e = gi.Argv(p+1)[0];
		m = gi.Argv(p+2)[0];
		sprintf(file, MAPDIR"E%cM%c.wad", e, m);
		D_AddFile(file);
		printf("DEVMAP: Episode %c, Map %c.\n", e, m);
		startepisode = e-'0';
		startmap = m-'0';
		autostart = true;
		devMap = true;
	}

	p = M_CheckParm("-playdemo");
	if(!p)
	{
		p = M_CheckParm("-timedemo");
	}
	if (p && p < myargc-1)
	{
		sprintf(file, "%s.lmp", gi.Argv(p+1));
		D_AddFile(file);
		printf("Playing demo %s.lmp.\n", gi.Argv(p+1));
	}

//
// get skill / episode / map from parms
//
	if(M_CheckParm("-deathmatch"))
	{
		deathmatch = true;
	}

	p = M_CheckParm("-skill");
	if(p && p < myargc-1)
	{
		startskill = gi.Argv(p+1)[0]-'1';
		autostart = true;
	}

	p = M_CheckParm("-episode");
	if(p && p < myargc-1)
	{
		startepisode = gi.Argv(p+1)[0]-'0';
		startmap = 1;
		autostart = true;
	}

	p = M_CheckParm("-warp");
	if(p && p < myargc-2)
	{
		startepisode = gi.Argv(p+1)[0]-'0';
		startmap = gi.Argv(p+2)[0]-'0';
		autostart = true;
	}
}

void status(char *msg)
{
	gi.Message( "%s\n", msg);
}

//---------------------------------------------------------------------------
//
// PROC D_DoomMain
//
//---------------------------------------------------------------------------

void H_PostInit(void)
{
	int p;
	char file[256];

	gi.Message("--- JHeretic Init ---\n%s\n", VERSIONTEXT);

	// Set the default bindings, if needed.
	H_DefaultBindings();

	// Init the view.
	R_SetViewSize(screenblocks, 0);

	gi.Message("S_Init...\n");
	S_Init();

	if(W_CheckNumForName("E2M1") == -1)
	{ // Can't find episode 2 maps, must be the shareware WAD
		shareware = true;
		borderLumps[0] = "FLOOR04";
		gi.SetBorderGfx(borderLumps);
	}
	else if(W_CheckNumForName("EXTENDED") != -1)
	{ // Found extended lump, must be the extended WAD
		ExtendedWAD = true;
	}

	//
	//  Build status bar line!
	//
	if (deathmatch)
		status("DeathMatch...");
	if (nomonsters)
		status("No Monsters...");
	if (respawnparm)
		status("Respawning...");
	if (autostart)
	{
		gi.Message("Warp to Episode %d, Map %d, Skill %d\n",
			startepisode, startmap, startskill+1);
	}
//	wadprintf(); // print the added wadfiles

	gi.Message("MN_Init: Init menu system.\n");
	MN_Init();
	CT_Init();

	/*tprintf("R_Init: Init Heretic refresh daemon.",1);
	hgotoxy(17,7);
	hprintf("Loading graphics",0x3f);
	R_Init();*/

	gi.Message("P_Init: Init Playloop state.\n");
/*	hgotoxy(17,8);
	hprintf("Init game engine.",0x3f);*/
	P_Init();
	//IncThermo();

/*	tprintf("I_Init: Setting up machine state.\n",1);
	I_Init();
	IncThermo();*/

/*	tprintf("D_CheckNetGame: Checking network game status.\n",1);
	hgotoxy(17,9);
	hprintf("Checking network game status.", 0x3f);
	D_CheckNetGame();
	IncThermo();*/

	gi.Message("SB_Init: Loading patches.\n");
	SB_Init();

//
// start the apropriate game based on parms
//

	D_CheckRecordFrom();

	p = M_CheckParm("-record");
	if(p && p < myargc-1)
	{
		G_RecordDemo(startskill, 1, startepisode, startmap, gi.Argv(p+1));
		return;
	}

	p = M_CheckParm("-playdemo");
	if(p && p < myargc-1)
	{
		singledemo = true; // Quit after one demo
		G_DeferedPlayDemo(gi.Argv(p+1));
		return;
	}

	p = M_CheckParm("-timedemo");
	if(p && p < myargc-1)
	{
		G_TimeDemo(gi.Argv(p+1));
		return;
	}

	p = M_CheckParm("-loadgame");
	if(p && p < myargc-1)
	{
		if(cdrom)
		{
			sprintf(file, SAVEGAMENAMECD"%c.hsg", gi.Argv(p+1)[0]);
		}
		else
		{
			sprintf(file, SAVEGAMENAME"%c.hsg", gi.Argv(p+1)[0]);
		}
		G_LoadGame(file);
	}

	// Check valid episode and map
	if((autostart || netgame) && (devMap == false))
	{
		if(M_ValidEpisodeMap(startepisode, startmap) == false)
		{
			startepisode = 1;
			startmap = 1;
		}
	}

	if(gameaction != ga_loadgame)
	{
		/*UpdateState |= I_FULLSCRN;
		BorderNeedRefresh = true;*/
		gi.Update(DDUF_BORDER | DDUF_FULLSCREEN);
		if(autostart || netgame)
		{
			G_InitNew(startskill, startepisode, startmap);
		}
		else
		{
			D_StartTitle();
		}
	}
}

void H_Ticker(void)
{
	if(advancedemo) D_DoAdvanceDemo();
	MN_Ticker();
}

void G_ModifyDupTiccmd(ticcmd_t *cmd)
{
	if(cmd->buttons & BT_SPECIAL) cmd->buttons = 0;
}

void H_UpdateState(int step)
{
	if(step == DD_PRE)
	{
		// Do a sound reset.
		//S_Reset();
	}
	else if(step == DD_POST)
	{
		P_Init();
		SB_Init(); // Updates the status bar patches.
		MN_Init();
	}
}

char *H_GetString(int id)
{
	switch(id)
	{
	case DD_VERSION_SHORT:
		return VERSION_TEXT;

	case DD_VERSION_LONG:
		return VERSIONTEXT"\nJHeretic is based on Heretic v1.3.";
	
	default:
		break;
	}
	return "";
}

void H_EndFrame(void)
{
	S_UpdateSounds(players[displayplayer].plr->mo);
}

void H_ConsoleBg(int *width, int *height)
{
	extern int consoleFlat;
	extern float consoleZoom;

	gi.GL_SetFlat(consoleFlat);
	*width = (int) (64 * consoleZoom);
	*height = (int) (64 * consoleZoom);
}

game_export_t *GetGameAPI(game_import_t *imports)
{
	// Take a copy of the imports.
	gi = *imports;
	gl = *(gl_export_t*) imports->GetDGL();

	memset(&gx, 0, sizeof(gx));

	// Fill in the data for the exports.
	gx.PreInit = H_PreInit;
	gx.PostInit = H_PostInit;
//	gx.Shutdown = H2_Shutdown;
	gx.BuildTiccmd = G_BuildTiccmd;
	gx.ModifyDupTiccmd = G_ModifyDupTiccmd;
	gx.G_Ticker = G_Ticker;
	gx.G_Drawer = D_Display;
	gx.MN_Ticker = H_Ticker;
	gx.MN_Drawer = MN_Drawer;
	gx.PrivilegedResponder = H_PrivilegedResponder;
	gx.MN_Responder = MN_Responder;
	gx.G_Responder = G_Responder;
	gx.MobjThinker = P_MobjThinker;
	gx.EndFrame = H_EndFrame;
	gx.ConsoleBackground = H_ConsoleBg;
	gx.UpdateState = H_UpdateState;
	gx.DrawPlayerSprites = R_DrawPlayerSprites;
	gx.GetString = H_GetString;

	gx.R_Init = R_Init;

	gx.NetServerOpen = H_NetServerOpen;
	gx.NetServerStart = H_NetServerStarted;
	gx.NetServerStop = H_NetServerClose;
	gx.NetServerClose = H_NetServerClose;
	gx.NetConnect = H_NetConnect;
	gx.NetDisconnect = H_NetDisconnect;
	gx.NetPlayerEvent = H_NetPlayerEvent;
//	gx.HandlePacket = SB_HandleCheatNotification;

	// The structure sizes.
	gx.ticcmd_size = sizeof(ticcmd_t);
	gx.vertex_size = sizeof(vertex_t);
	gx.seg_size = sizeof(seg_t);
	gx.sector_size = sizeof(sector_t);
	gx.subsector_size = sizeof(subsector_t);
	gx.node_size = sizeof(node_t);
	gx.line_size = sizeof(line_t);
	gx.side_size = sizeof(side_t);

	return &gx;
}
