#include "DoomDef.h"
#include "R_local.h"
#include "P_local.h"
#include "i_sound.h"
#include "soundst.h"

boolean S_StopSoundID(int sound_id, int priority);

/*
===============================================================================

		MUSIC & SFX API

===============================================================================
*/

#define DDVOL(x)	((1000*x)/127)
#define DDPAN(x)	((500*x)/128)
#define DDPITCH(x)	((1000*x)/127)

static channel_t channel[MAX_CHANNELS];

static int rs; //the current registered song.
int mus_song = -1;
int mus_lumpnum;
void *mus_sndptr;
byte *soundCurve;
int s_CDTrack = 0;

extern sfxinfo_t S_sfx[];
extern musicinfo_t S_music[];

//extern int snd_DesiredMusicDevice;
//extern int snd_DesiredSfxDevice;
//extern int snd_MaxVolume;
//extern int snd_MusicVolume;
int snd_Channels = 8;

extern int startepisode;
extern int startmap;

int AmbChan;

void S_Start(void)
{
	int i;

	S_StartSong((gameepisode-1)*9 + gamemap-1, true);

	//stop all sounds
	for(i=0; i < snd_Channels; i++)
	{
		if(channel[i].handle)
		{
			gi.StopSound(channel[i].handle);
			if(S_sfx[channel[i].sound_id].usefulness > 0)
			{
				S_sfx[channel[i].sound_id].usefulness--;
			}
			channel[i].handle = 0;
			channel[i].mo = NULL;
			if(AmbChan == i)
			{
				AmbChan = -1;
			}
		}
	}
	memset(channel, 0, 8*sizeof(channel_t));
}

void S_StartSong(int song, boolean loop)
{
	if(song == mus_song)
	{ // don't replay an old song
		return;
	}
	if(rs)
	{
		/*I_StopSong(rs);
		I_UnRegisterSong(rs);*/
		gi.StopSong();
		//Z_ChangeTag(lumpcache[mus_lumpnum], PU_CACHE);
		gi.W_ChangeCacheTag(mus_lumpnum, PU_CACHE);		
		/*#ifdef __WATCOMC__
			_dpmi_unlockregion(mus_sndptr, lumpinfo[mus_lumpnum].size);
		#endif*/
	}
	if(song < mus_e1m1 || song > NUMMUSIC)
	{
		return;
	}
	mus_lumpnum = W_GetNumForName(S_music[song].name);
	mus_sndptr = W_CacheLumpNum(mus_lumpnum, PU_MUSIC);
/*	#ifdef __WATCOMC__
		_dpmi_lockregion(mus_sndptr, lumpinfo[mus_lumpnum].size);
	#endif*/
	//rs = gi.RegisterSong(mus_sndptr);
	//I_PlaySong(rs, loop); //'true' denotes endless looping.
	gi.PlaySong(mus_sndptr, W_LumpLength(mus_lumpnum), true);
	mus_song = song;
}

int I_GetSfxLumpNum(sfxinfo_t *sound)
{
//	char namebuf[9];

	if(sound->name == 0)
		return 0;
	if (sound->link) sound = sound->link;
//  sprintf(namebuf, "d%c%s", snd_prefixen[snd_SfxDevice], sound->name);
	return W_GetNumForName(sound->name);
}

void S_StartSound(mobj_t *origin, int sound_id)
{
	int dist = 0, vol;
	int i;
//	int sound;
	int priority;
	int sep;
	int angle;
	int absx;
	int absy;
	mobj_t *plrmo = players[displayplayer].plr->mo;

	static int sndcount = 0;
	int chan;

	if(sound_id==0 || snd_MaxVolume == 0)
		return;
	if(origin == NULL)
	{
		origin = plrmo;
	}

// calculate the distance before other stuff so that we can throw out
// sounds that are beyond the hearing range.
	if(origin && plrmo)
	{
		absx = abs(origin->x - plrmo->x);
		absy = abs(origin->y - plrmo->y);
		dist = absx+absy-(absx > absy ? absy>>1 : absx>>1);
		dist >>= FRACBITS;
	
		if(dist >= MAX_SND_DIST)
		{
			return; //sound is beyond the hearing range...
		}
		if(dist < 0)
		{
			dist = 0;
		}
	}
	priority = S_sfx[sound_id].priority;
	priority *= (10 - (dist/160));
	if(!S_StopSoundID(sound_id, priority))
	{
		return; // other sounds have greater priority
	}
	for(i=0; origin && i<snd_Channels; i++)
	{
		if(origin->player)
		{
			i = snd_Channels;
			break; // let the player have more than one sound.
		}
		if(origin == channel[i].mo)
		{ // only allow other mobjs one sound
			S_StopSound(channel[i].mo);
			break;
		}
	}
	if(i >= snd_Channels)
	{
		if(sound_id >= sfx_wind)
		{
			if(AmbChan != -1 && S_sfx[sound_id].priority <=
				S_sfx[channel[AmbChan].sound_id].priority)
			{
				return; //ambient channel already in use
			}
			else
			{
				AmbChan = -1;
			}
		}
		for(i=0; i<snd_Channels; i++)
		{
			if(channel[i].mo == NULL)
			{
				break;
			}
		}
		if(i >= snd_Channels)
		{
			//look for a lower priority sound to replace.
			sndcount++;
			if(sndcount >= snd_Channels)
			{
				sndcount = 0;
			}
			for(chan=0; chan < snd_Channels; chan++)
			{
				i = (sndcount+chan)%snd_Channels;
				if(priority >= channel[i].priority)
				{
					chan = -1; //denote that sound should be replaced.
					break;
				}
			}
			if(chan != -1)
			{
				return; //no free channels.
			}
			else //replace the lower priority sound.
			{
				if(channel[i].handle)
				{
					if(gi.SoundIsPlaying(channel[i].handle))
					{
						gi.StopSound(channel[i].handle);
					}
					if(S_sfx[channel[i].sound_id].usefulness > 0)
					{
						S_sfx[channel[i].sound_id].usefulness--;
					}

					if(AmbChan == i)
					{
						AmbChan = -1;
					}
				}
			}
		}
	}
	if(S_sfx[sound_id].lumpnum == 0)
	{
		S_sfx[sound_id].lumpnum = I_GetSfxLumpNum(&S_sfx[sound_id]);
	}
	if(S_sfx[sound_id].snd_ptr == NULL)
	{
		S_sfx[sound_id].snd_ptr = W_CacheLumpNum(S_sfx[sound_id].lumpnum,
			PU_SOUND);
	}

	// calculate the volume based upon the distance from the sound origin.
//      vol = (snd_MaxVolume*16 + dist*(-snd_MaxVolume*16)/MAX_SND_DIST)>>9;
	vol = soundCurve[dist];

	if(origin == plrmo || !origin || !plrmo)
	{
		sep = 128;
	}
	else
	{
		angle = R_PointToAngle2(plrmo->x, plrmo->y, origin->x, origin->y);
		angle = (angle-viewangle)>>24;
		sep = angle*2-128;
		if(sep < 64)
			sep = -sep;
		if(sep > 192)
			sep = 512-sep;
	}

	channel[i].pitch = (byte)(127+(M_Random()&7)-(M_Random()&7));
	channel[i].handle = gi.PlaySound(S_sfx[sound_id].snd_ptr, DDVOL(vol), DDPAN(sep), 
		DDPITCH(channel[i].pitch));
	channel[i].mo = origin;
	channel[i].sound_id = sound_id;
	channel[i].priority = priority;
	if(sound_id >= sfx_wind)
	{
		AmbChan = i;
	}
	if(S_sfx[sound_id].usefulness == -1)
	{
		S_sfx[sound_id].usefulness = 1;
	}
	else
	{
		S_sfx[sound_id].usefulness++;
	}
}

void S_StartSoundAtVolume(mobj_t *origin, int sound_id, int volume)
{
//	int dist;
	int i;
//	int sep;
	mobj_t *plrmo = players[displayplayer].plr->mo;

	static int sndcount;
//	int chan;

	if(sound_id == 0 || snd_MaxVolume == 0)
		return;
	if(origin == NULL)
	{
		origin = plrmo;
	}

	//gi.Message( "S_StartSoundAtVolume: origin:%p\n", origin);

	if(volume == 0)
	{
		return;
	}
	volume = (volume*(snd_MaxVolume+1)*8)>>7;

// no priority checking, as ambient sounds would be the LOWEST.
	for(i=0; i<snd_Channels; i++)
	{
		if(channel[i].mo == NULL)
		{
			break;
		}
	}
	if(i >= snd_Channels)
	{
		return;
	}
	if(S_sfx[sound_id].lumpnum == 0)
	{
		S_sfx[sound_id].lumpnum = I_GetSfxLumpNum(&S_sfx[sound_id]);
	}
	if(S_sfx[sound_id].snd_ptr == NULL)
	{
		S_sfx[sound_id].snd_ptr = W_CacheLumpNum(S_sfx[sound_id].lumpnum,
			PU_SOUND);
		/*#ifdef __WATCOMC__
		_dpmi_lockregion(S_sfx[sound_id].snd_ptr,
			lumpinfo[S_sfx[sound_id].lumpnum].size);
		#endif*/
	}
	channel[i].pitch = (byte)(127-(M_Random()&3)+(M_Random()&3));
	channel[i].handle = gi.PlaySound(S_sfx[sound_id].snd_ptr, 
		DDVOL(volume), DDPAN(128), DDPITCH(channel[i].pitch));
	channel[i].mo = origin;
	channel[i].sound_id = sound_id;
	channel[i].priority = 1; //super low priority.
	if(S_sfx[sound_id].usefulness == -1)
	{
		S_sfx[sound_id].usefulness = 1;
	}
	else
	{
		S_sfx[sound_id].usefulness++;
	}
	//gi.Message( "S_StartSoundAtVolume: ends!\n", origin);
}

boolean S_StopSoundID(int sound_id, int priority)
{
	int i;
	int lp; //least priority
	int found;

	if(S_sfx[sound_id].numchannels == -1)
	{
		return(true);
	}
	lp = -1; //denote the argument sound_id
	found = 0;
	for(i=0; i<snd_Channels; i++)
	{
		if(channel[i].sound_id == sound_id && channel[i].mo)
		{
			found++; //found one.  Now, should we replace it??
			if(priority >= channel[i].priority)
			{ // if we're gonna kill one, then this'll be it
				lp = i;
				priority = channel[i].priority;
			}
		}
	}
	if(found < S_sfx[sound_id].numchannels)
	{
		return(true);
	}
	else if(lp == -1)
	{
		return(false); // don't replace any sounds
	}
	if(channel[lp].handle)
	{
		if(gi.SoundIsPlaying(channel[lp].handle))
		{
			gi.StopSound(channel[lp].handle);
		}
		if(S_sfx[channel[i].sound_id].usefulness > 0)
		{
			S_sfx[channel[i].sound_id].usefulness--;
		}
		channel[lp].mo = NULL;
	}
	return(true);
}

void S_StopSound(mobj_t *origin)
{
	int i;

	for(i=0;i<snd_Channels;i++)
	{
		if(channel[i].mo == origin)
		{
			gi.StopSound(channel[i].handle);
			if(S_sfx[channel[i].sound_id].usefulness > 0)
			{
				S_sfx[channel[i].sound_id].usefulness--;
			}
			channel[i].handle = 0;
			channel[i].mo = NULL;
			if(AmbChan == i)
			{
				AmbChan = -1;
			}
		}
	}
}

void S_SoundLink(mobj_t *oldactor, mobj_t *newactor)
{
	int i;

	for(i=0;i<snd_Channels;i++)
	{
		if(channel[i].mo == oldactor)
			channel[i].mo = newactor;
	}
}

void S_PauseSound(void)
{
	gi.PauseSong();
}

void S_ResumeSound(void)
{
	gi.ResumeSong();
}

static int nextcleanup;

void S_UpdateSounds(mobj_t *listener)
{
	int i, dist, vol;
	int angle;
	int sep;
	int priority;
	int absx;
	int absy;

	listener = players[displayplayer].plr->mo;
	if(!listener) return;
	if(snd_MaxVolume == 0)
	{
		return;
	}
	if(nextcleanup < gametic)
	{
		for(i=0; i < NUMSFX; i++)
		{
			if(S_sfx[i].usefulness == 0 && S_sfx[i].snd_ptr)
			{
				gi.W_ChangeCacheTag(S_sfx[i].lumpnum, PU_CACHE);
				/*if(lumpcache[S_sfx[i].lumpnum])
				{
					if(((memblock_t *)((byte *)(lumpcache[S_sfx[i].lumpnum])-
						sizeof(memblock_t)))->id == 0x1d4a11)
					{ // taken directly from the Z_ChangeTag macro
						Z_ChangeTag2(lumpcache[S_sfx[i].lumpnum], PU_CACHE);
						#ifdef __WATCOMC__
							_dpmi_unlockregion(S_sfx[i].snd_ptr, lumpinfo[S_sfx[i].lumpnum].size);
						#endif
					}
				}*/
				S_sfx[i].usefulness = -1;
				S_sfx[i].snd_ptr = NULL;
			}
		}
		nextcleanup = gametic+35; //CLEANUP DEBUG cleans every second
	}
	for(i=0;i<snd_Channels;i++)
	{
		if(!channel[i].handle || S_sfx[channel[i].sound_id].usefulness == -1)
		{
			continue;
		}
		if(!gi.SoundIsPlaying(channel[i].handle))
		{
			if(S_sfx[channel[i].sound_id].usefulness > 0)
			{
				S_sfx[channel[i].sound_id].usefulness--;
			}
			channel[i].handle = 0;
			channel[i].mo = NULL;
			channel[i].sound_id = 0;
			if(AmbChan == i)
			{
				AmbChan = -1;
			}
		}
		if(channel[i].mo == NULL || channel[i].sound_id == 0
			|| channel[i].mo == listener)
		{
			continue;
		}
		else
		{
			absx = abs(channel[i].mo->x - listener->x);
			absy = abs(channel[i].mo->y - listener->y);
			dist = absx+absy-(absx > absy ? absy>>1 : absx>>1);
			dist >>= FRACBITS;
//          dist = P_AproxDistance(channel[i].mo->x-listener->x, channel[i].mo->y-listener->y)>>FRACBITS;

			if(dist >= MAX_SND_DIST)
			{
				S_StopSound(channel[i].mo);
				continue;
			}
			if(dist < 0)
				dist = 0;

// calculate the volume based upon the distance from the sound origin.
//          vol = (*((byte *)W_CacheLumpName("SNDCURVE", PU_CACHE)+dist)*(snd_MaxVolume*8))>>7;
			vol = soundCurve[dist];

			angle = R_PointToAngle2(listener->x, listener->y, channel[i].mo->x, channel[i].mo->y);
			angle = (angle-viewangle)>>24;
			sep = angle*2-128;
			if(sep < 64)
				sep = -sep;
			if(sep > 192)
				sep = 512-sep;
			gi.UpdateSound(channel[i].handle, DDVOL(vol), DDPAN(sep), DDPITCH(channel[i].pitch));
			priority = S_sfx[channel[i].sound_id].priority;
			priority *= (10 - (dist>>8));
			channel[i].priority = priority;
		}
	}
}

void S_Init(void)
{
	soundCurve = Z_Malloc(MAX_SND_DIST, PU_STATIC, NULL);
//	I_StartupSound();
	if(snd_Channels > 8)
	{
		snd_Channels = 8;
	}
/*	I_SetChannels(snd_Channels);
	I_SetMusicVolume(snd_MusicVolume);*/
	S_SetMaxVolume(true);
}

void S_GetChannelInfo(SoundInfo_t *s)
{
	int i;
	ChanInfo_t *c;

	s->channelCount = snd_Channels;
	s->musicVolume = snd_MusicVolume;
	s->soundVolume = snd_MaxVolume;
	for(i = 0; i < snd_Channels; i++)
	{
		c = &s->chan[i];
		c->id = channel[i].sound_id;
		c->priority = channel[i].priority;
		c->name = S_sfx[c->id].name;
		c->mo = channel[i].mo;
		if(c->mo)
			c->distance = P_AproxDistance(c->mo->x-gi.Get(DD_VIEWX), c->mo->y-gi.Get(DD_VIEWY))
				>>FRACBITS;
		else
			c->distance = 0;
	}
}

void S_SetMaxVolume(boolean fullprocess)
{
	int i;

	if(!fullprocess)
	{
		soundCurve[0] = (*((byte *)W_CacheLumpName("SNDCURVE", PU_CACHE))*(snd_MaxVolume*8))>>7;
	}
	else
	{
		for(i = 0; i < MAX_SND_DIST; i++)
		{
			soundCurve[i] = (*((byte *)W_CacheLumpName("SNDCURVE", PU_CACHE)+i)*(snd_MaxVolume*8))>>7;
		}
	}
}

static boolean musicPaused;

void S_SetMusicVolume(void)
{
	gi.SetMIDIVolume(snd_MusicVolume);
	if(snd_MusicVolume == 0)
	{
		gi.PauseSong();
		musicPaused = true;
	}
	else if(musicPaused)
	{
		musicPaused = false;
		gi.ResumeSong();
	}
}

void S_ShutDown(void)
{
	/*extern int tsm_ID;
	if(tsm_ID != -1)
	{
  		gi.StopSong();
  		I_UnRegisterSong(rs);
  		I_ShutdownSound();
	}*/
}


//==========================================================================
//
// CONSOLE COMMANDS
//
//==========================================================================

int CCmdCD(int argc, char **argv)
{
	if(argc > 1)
	{
		if(!strcmpi(argv[1], "init"))
		{
			if(!gi.CD(DD_INIT,0))
				gi.conprintf( "CD init successful.\n");
			else
				gi.conprintf( "CD init failed.\n");
		}
		else if(!strcmpi(argv[1], "info") && argc == 2)
		{
			int secs = gi.CD(DD_GET_TIME_LEFT,0);//i_CDMusicLength/35;
			gi.conprintf( "CD available: %s\n", gi.CD(DD_AVAILABLE,0)? "yes" : "no");
			gi.conprintf( "First track: %d\n", gi.CD(DD_GET_FIRST_TRACK,0));
			gi.conprintf( "Last track: %d\n", gi.CD(DD_GET_LAST_TRACK,0));
			gi.conprintf( "Current track: %d\n", gi.CD(DD_GET_CURRENT_TRACK,0));
			gi.conprintf( "Time left: %d:%02d\n", secs/60, secs%60);
			gi.conprintf( "Play mode: ");
			if(musicPaused)
				gi.conprintf( "paused\n");
			else if(s_CDTrack)
				gi.conprintf( "looping track %d\n", s_CDTrack);
			else
				gi.conprintf( "map track\n");
			return true;
		}
		else if(!strcmpi(argv[1], "play") && argc == 3)
		{
			s_CDTrack = atoi(argv[2]);
			if(!gi.CD(DD_PLAY_LOOP, s_CDTrack)) 
			{
				gi.conprintf( "Playing track %d.\n", s_CDTrack);
			}
			else
			{
				gi.conprintf( "Error playing track %d.\n", s_CDTrack);
				return false;
			}
		}
		else if(!strcmpi(argv[1], "stop") && argc == 2)
		{
			gi.CD(DD_STOP,0);
			gi.conprintf( "CD stopped.\n");
		}
		else if(!strcmpi(argv[1], "resume") && argc == 2)
		{
			gi.CD(DD_RESUME,0);//I_CDMusResume();
			gi.conprintf( "CD resumed.\n");
		}
		else
			gi.conprintf( "Bad command. Try 'cd'.\n");
	}
	else
	{
		gi.conprintf( "CD player control. Usage: CD (cmd)\n");
		gi.conprintf( "Commands are: init, info, play (track#), map, map (#), stop, resume.\n");
	}
	return true;
}

int CCmdMidi(int argc, char **argv)
{
	if(argc == 1)
	{
		gi.conprintf( "Usage: midi (cmd)\n");
		gi.conprintf( "Commands are: reset, play (name), map, map (num).\n");
		return true;
	}
	if(argc == 2)
	{
		if(!strcmpi(argv[1], "reset"))
		{
			if(rs)
			{
				gi.StopSong();
				gi.W_ChangeCacheTag(mus_lumpnum, PU_CACHE);
				rs = 0;
			}
			mus_song = -1;
			gi.conprintf( "MIDI has been reset.\n");
		}
		else if(!strcmpi(argv[1], "map")) 
		{
			gi.conprintf( "Playing the song of the current map (%d).\n", gamemap);
			S_StartSong(gamemap, true);
		}
		else
			return false;
	}
	else if(argc == 3)
	{
/*		if(!strcmpi(argv[1], "play"))
		{
			gi.conprintf( "Playing song '%s'.\n", argv[2]);
			S_StartSongName(argv[2], true);
		}*/
		if(!strcmpi(argv[1], "map"))
		{
			gi.conprintf( "Playing song for map %d.\n", atoi(argv[2]));
			S_StartSong(atoi(argv[2]), true);
		}
		else
			return false;
	}
	else 
		return false;
	// Oh, we're done.
	return true;
}
