
// P_tick.c

#include "DoomDef.h"
#include "P_local.h"

int leveltime;
int TimerGame;

//==========================================================================
//
// SV_MobjConverter
//
// Converts mobj_t to savemobj_t, which can be directly written to a
// savegame file (or vice versa).
//
//==========================================================================

void SV_MobjConverter(mobj_t *mobj, savemobj_t *savemobj, boolean saving)
{
	if(saving) // Convert the mobj into a savemobj.
	{
		memset(savemobj, 0, sizeof(*savemobj));
		// Only copy the data we need.
		savemobj->thinker = mobj->thinker;
		savemobj->x = mobj->x;
		savemobj->y = mobj->y;
		savemobj->z = mobj->z;
		savemobj->angle = mobj->angle;
		savemobj->sprite = mobj->sprite;
		savemobj->frame = mobj->frame;
		savemobj->snext = mobj->snext;
		savemobj->sprev = mobj->sprev;
		savemobj->bnext = mobj->bnext;
		savemobj->bprev = mobj->bprev;
		savemobj->radius = mobj->radius;
		savemobj->height = mobj->height;
		savemobj->momx = mobj->momx;
		savemobj->momy = mobj->momy;
		savemobj->momz = mobj->momz;
		savemobj->validcount = mobj->validcount;
		savemobj->type = mobj->type;
		savemobj->info = mobj->info;
		savemobj->tics = mobj->tics;
		savemobj->state = mobj->state;
		savemobj->damage = mobj->damage;
		savemobj->flags = mobj->flags;
		savemobj->flags2 = mobj->flags2;
		savemobj->special1 = mobj->special1;
		savemobj->special2 = mobj->special2;
		savemobj->health = mobj->health;
		savemobj->movedir = mobj->movedir;
		savemobj->movecount = mobj->movecount;
		savemobj->target = mobj->target;
		savemobj->reactiontime = mobj->reactiontime;
		savemobj->threshold = mobj->threshold;
		savemobj->player = mobj->player;
		savemobj->lastlook = mobj->lastlook;
		savemobj->spawnpoint = mobj->spawnpoint;
	}
	else
	{
		memset(mobj, 0, sizeof(*mobj));
		mobj->thinker = savemobj->thinker;
		mobj->x = savemobj->x;
		mobj->y = savemobj->y;
		mobj->z = savemobj->z;
		mobj->angle = savemobj->angle;
		mobj->sprite = savemobj->sprite;
		mobj->frame = savemobj->frame;
		mobj->snext = savemobj->snext;
		mobj->sprev = savemobj->sprev;
		mobj->bnext = savemobj->bnext;
		mobj->bprev = savemobj->bprev;
		mobj->radius = savemobj->radius;
		mobj->height = savemobj->height;
		mobj->momx = savemobj->momx;
		mobj->momy = savemobj->momy;
		mobj->momz = savemobj->momz;
		mobj->validcount = savemobj->validcount;
		mobj->type = savemobj->type;
		mobj->info = savemobj->info;
		mobj->tics = savemobj->tics;
		mobj->state = savemobj->state;
		mobj->damage = savemobj->damage;
		mobj->flags = savemobj->flags;
		mobj->flags2 = savemobj->flags2;
		mobj->special1 = savemobj->special1;
		mobj->special2 = savemobj->special2;
		mobj->health = savemobj->health;
		mobj->movedir = savemobj->movedir;
		mobj->movecount = savemobj->movecount;
		mobj->target = savemobj->target;
		mobj->reactiontime = savemobj->reactiontime;
		mobj->threshold = savemobj->threshold;
		mobj->player = savemobj->player;
		mobj->lastlook = savemobj->lastlook;
		mobj->spawnpoint = savemobj->spawnpoint;
	}
}

//==========================================================================
//
// SV_PlayerConverter
//
// Converts player_t to saveplayer_t, which can be directly written to
// a savegame file (or vice versa).
//
//==========================================================================

void SV_PlayerConverter(player_t *plr, saveplayer_t *saveplr, boolean saving)
{
	if(saving)
	{
		saveplr->mo = plr->plr->mo;
		saveplr->playerstate = plr->playerstate;
		saveplr->cmd = plr->cmd;
		saveplr->viewz = plr->plr->viewz;
		saveplr->viewheight = plr->viewheight;
		saveplr->deltaviewheight = plr->deltaviewheight;
		saveplr->bob = plr->bob;
		saveplr->flyheight = plr->flyheight;
		saveplr->lookdir = plr->plr->lookdir;
		saveplr->centering = plr->centering;
		saveplr->health = plr->health;
		saveplr->armorpoints = plr->armorpoints;
		saveplr->armortype = plr->armortype;
		memcpy(saveplr->inventory, plr->inventory, sizeof(plr->inventory));
		saveplr->readyArtifact = plr->readyArtifact;
		saveplr->artifactCount = plr->artifactCount;
		saveplr->inventorySlotNum = plr->inventorySlotNum;
		memcpy(saveplr->powers, plr->powers, sizeof(plr->powers));
		memcpy(saveplr->keys, plr->keys, sizeof(plr->keys));
		saveplr->backpack = plr->backpack;
		memcpy(saveplr->frags, plr->plr->frags, sizeof(plr->plr->frags));
		saveplr->readyweapon = plr->readyweapon;
		saveplr->pendingweapon = plr->pendingweapon;
		memcpy(saveplr->weaponowned, plr->weaponowned, sizeof(plr->weaponowned));
		memcpy(saveplr->ammo, plr->ammo, sizeof(plr->ammo));
		memcpy(saveplr->maxammo, plr->maxammo, sizeof(plr->maxammo));
		saveplr->attackdown = plr->attackdown;
		saveplr->usedown = plr->usedown;
		saveplr->cheats = plr->cheats;
		saveplr->refire = plr->refire;
		saveplr->killcount = plr->killcount;
		saveplr->itemcount = plr->itemcount;
		saveplr->secretcount = plr->secretcount;
		saveplr->message = plr->message;
		saveplr->messageTics = plr->messageTics;
		saveplr->damagecount = plr->damagecount;
		saveplr->bonuscount = plr->bonuscount;
		saveplr->flamecount = plr->flamecount;				// for flame thrower duration
		saveplr->attacker = plr->attacker;
		saveplr->extralight = plr->plr->extralight;
		saveplr->fixedcolormap = plr->plr->fixedcolormap;
		saveplr->colormap = plr->colormap;
		memcpy(saveplr->psprites, plr->psprites, sizeof(plr->psprites));
		saveplr->didsecret = plr->didsecret;
		saveplr->chickenTics = plr->chickenTics;
		saveplr->chickenPeck = plr->chickenPeck;
		saveplr->rain1 = plr->rain1;
		saveplr->rain2 = plr->rain2;
	}
	else
	{
		plr->plr->mo = saveplr->mo;
		plr->playerstate = saveplr->playerstate;
		plr->cmd = saveplr->cmd;
		plr->plr->viewz = saveplr->viewz;
		plr->viewheight = saveplr->viewheight;
		plr->deltaviewheight = saveplr->deltaviewheight;
		plr->bob = saveplr->bob;
		plr->flyheight = saveplr->flyheight;
		plr->plr->lookdir = saveplr->lookdir;
		plr->centering = saveplr->centering;
		plr->health = saveplr->health;
		plr->armorpoints = saveplr->armorpoints;
		plr->armortype = saveplr->armortype;
		memcpy(plr->inventory, saveplr->inventory, sizeof(plr->inventory));
		plr->readyArtifact = saveplr->readyArtifact;
		plr->artifactCount = saveplr->artifactCount;
		plr->inventorySlotNum = saveplr->inventorySlotNum;
		memcpy(plr->powers, saveplr->powers, sizeof(plr->powers));
		memcpy(plr->keys, saveplr->keys, sizeof(plr->keys));
		plr->backpack = saveplr->backpack;
		memcpy(plr->plr->frags, saveplr->frags, sizeof(plr->plr->frags));
		plr->readyweapon = saveplr->readyweapon;
		plr->pendingweapon = saveplr->pendingweapon;
		memcpy(plr->weaponowned, saveplr->weaponowned, sizeof(plr->weaponowned));
		memcpy(plr->ammo, saveplr->ammo, sizeof(plr->ammo));
		memcpy(plr->maxammo, saveplr->maxammo, sizeof(plr->maxammo));
		plr->attackdown = saveplr->attackdown;
		plr->usedown = saveplr->usedown;
		plr->cheats = saveplr->cheats;
		plr->refire = saveplr->refire;
		plr->killcount = saveplr->killcount;
		plr->itemcount = saveplr->itemcount;
		plr->secretcount = saveplr->secretcount;
		plr->message = saveplr->message;
		plr->messageTics = saveplr->messageTics;
		plr->damagecount = saveplr->damagecount;
		plr->bonuscount = saveplr->bonuscount;
		plr->flamecount = saveplr->flamecount;				// for flame thrower duration
		plr->attacker = saveplr->attacker;
		plr->plr->extralight = saveplr->extralight;
		plr->plr->fixedcolormap = saveplr->fixedcolormap;
		plr->colormap = saveplr->colormap;
		memcpy(plr->psprites, saveplr->psprites, sizeof(plr->psprites));
		plr->didsecret = saveplr->didsecret;
		plr->chickenTics = saveplr->chickenTics;
		plr->chickenPeck = saveplr->chickenPeck;
		plr->rain1 = saveplr->rain1;
		plr->rain2 = saveplr->rain2;
	}
}

/*
====================
=
= P_ArchivePlayers
=
====================
*/

void P_ArchivePlayers(void)
{
	int i;
	int j;
	saveplayer_t dest;

	for(i = 0; i < MAXPLAYERS; i++)
	{
		if(!players[i].plr->ingame)
		{
			continue;
		}
		SV_PlayerConverter(players + i, &dest, true);
		for(j = 0; j < NUMPSPRITES; j++)
		{
			if(dest.psprites[j].state)
			{
				dest.psprites[j].state =
					(state_t *)(dest.psprites[j].state-states);
			}
		}
		SV_Write(&dest, sizeof(dest));
	}
}

/*
====================
=
= P_UnArchivePlayers
=
====================
*/

void P_UnArchivePlayers (void)
{
	int				i,j;

	for (i=0 ; i<MAXPLAYERS ; i++)
	{
		if (!players[i].plr->ingame)
			continue;
		SV_PlayerConverter(players+i, (saveplayer_t*) save_p, false);
		save_p += sizeof(saveplayer_t);
		players[i].plr->mo = NULL;		// will be set when unarc thinker
		players[i].message = NULL;
		players[i].attacker = NULL;
		for (j=0 ; j<NUMPSPRITES ; j++)
			if (players[i].psprites[j].state)
				players[i].psprites[j].state = &states[ (int)players[i].psprites[j].state ];
	}
}

//=============================================================================


/*
====================
=
= P_ArchiveWorld
=
====================
*/

void P_ArchiveWorld(void)
{
	int i, j;
	sector_t *sec;
	line_t *li;
	side_t *si;

	// Sectors
	for(i = 0, sec = sectors; i < numsectors; i++, sec++)
	{
		SV_WriteWord(sec->floorheight>>FRACBITS);
		SV_WriteWord(sec->ceilingheight>>FRACBITS);
		SV_WriteWord(sec->floorpic);
		SV_WriteWord(sec->ceilingpic);
		SV_WriteWord(sec->lightlevel);
		SV_WriteWord(sec->special); // needed?
		SV_WriteWord(sec->tag); // needed?
	}

	// Lines
	for(i = 0, li = lines; i < numlines; i++, li++)
	{
		SV_WriteWord(li->flags);
		SV_WriteWord(li->special);
		SV_WriteWord(li->tag);
		for(j = 0; j < 2; j++)
		{
			if(li->sidenum[j] == -1)
			{
				continue;
			}
			si = &sides[li->sidenum[j]];
			SV_WriteWord(si->textureoffset>>FRACBITS);
			SV_WriteWord(si->rowoffset>>FRACBITS);
			SV_WriteWord(si->toptexture);
			SV_WriteWord(si->bottomtexture);
			SV_WriteWord(si->midtexture);
		}
	}
}

/*
====================
=
= P_UnArchiveWorld
=
====================
*/

void P_UnArchiveWorld (void)
{
	int			i,j;
	sector_t	*sec;
	line_t		*li;
	side_t		*si;
	short		*get;
	
	get = (short *)save_p;
		
//
// do sectors
//
	for (i=0, sec = sectors ; i<numsectors ; i++,sec++)
	{
		sec->floorheight = *get++ << FRACBITS;
		sec->ceilingheight = *get++ << FRACBITS;
		sec->floorpic = *get++;
		sec->ceilingpic = *get++;
		sec->lightlevel = *get++;
		sec->special = *get++;	// needed?
		sec->tag = *get++;		// needed?
		sec->specialdata = 0;
		sec->soundtarget = 0;
	}	

//
// do lines
//
	for (i=0, li = lines ; i<numlines ; i++,li++)
	{
		li->flags = *get++;
		li->special = *get++;
		li->tag = *get++;
		for (j=0 ; j<2 ; j++)
		{
			if (li->sidenum[j] == -1)
				continue;
			si = &sides[li->sidenum[j]];
			si->textureoffset = *get++ << FRACBITS;
			si->rowoffset = *get++ << FRACBITS;
			si->toptexture = *get++;
			si->bottomtexture = *get++;
			si->midtexture = *get++;
		}
	}
		
	save_p = (byte *)get;	
}

//=============================================================================

typedef enum
{
	tc_end,
	tc_mobj
} thinkerclass_t;

/*
====================
=
= P_ArchiveThinkers
=
====================
*/

void P_ArchiveThinkers(void)
{
	thinker_t *th;
	savemobj_t mobj;

	for(th = thinkercap.next; th != &thinkercap; th = th->next)
	{
		if(th->function == P_MobjThinker)
		{
			SV_WriteByte(tc_mobj);
			SV_MobjConverter( (mobj_t*) th, &mobj, true);
			mobj.state = (state_t *)(mobj.state-states);
			if(mobj.player)
			{
				mobj.player = (player_t *)((mobj.player-players)+1);
			}
			SV_Write(&mobj, sizeof(mobj));
			continue;
		}
		//I_Error("P_ArchiveThinkers: Unknown thinker function");
	}

	// Add a terminating marker
	SV_WriteByte(tc_end);
}

/*
====================
=
= P_UnArchiveThinkers
=
====================
*/

void P_UnArchiveThinkers (void)
{
	byte		tclass;
	thinker_t	*currentthinker, *next;
	mobj_t		*mobj;
	
//
// remove all the current thinkers
//
	currentthinker = thinkercap.next;
	while (currentthinker != &thinkercap)
	{
		next = currentthinker->next;
		if (currentthinker->function == P_MobjThinker)
			P_RemoveMobj ((mobj_t *)currentthinker);
		else
			Z_Free (currentthinker);
		currentthinker = next;
	}
	P_InitThinkers ();
	
// read in saved thinkers
	while (1)
	{
		tclass = *save_p++;
		switch (tclass)
		{
		case tc_end:
			return;			// end of list
			
		case tc_mobj:
			mobj = Z_Malloc (sizeof(*mobj), PU_LEVEL, NULL);
			SV_MobjConverter(mobj, (savemobj_t*) save_p, false);
			save_p += sizeof(savemobj_t);
			mobj->state = &states[(int)mobj->state];
			mobj->target = NULL;
			if (mobj->player)
			{
				mobj->player = &players[(int)mobj->player-1];
				mobj->player->plr->mo = mobj;
			}
			P_SetThingPosition (mobj);
			mobj->info = &mobjinfo[mobj->type];
			mobj->floorz = mobj->subsector->sector->floorheight;
			mobj->ceilingz = mobj->subsector->sector->ceilingheight;
			mobj->thinker.function = P_MobjThinker;
			P_AddThinker (&mobj->thinker);
			break;
			
		default:
			I_Error ("Unknown tclass %i in savegame",tclass);
		}
	
	}

}

//=============================================================================


/*
====================
=
= P_ArchiveSpecials
=
====================
*/
enum
{
	tc_ceiling,
	tc_door,
	tc_floor,
	tc_plat,
	tc_flash,
	tc_strobe,
	tc_glow,
	tc_endspecials
} specials_e;	

void P_ArchiveSpecials(void)
{
/*
T_MoveCeiling, (ceiling_t: sector_t * swizzle), - active list
T_VerticalDoor, (vldoor_t: sector_t * swizzle),
T_MoveFloor, (floormove_t: sector_t * swizzle),
T_LightFlash, (lightflash_t: sector_t * swizzle),
T_StrobeFlash, (strobe_t: sector_t *),
T_Glow, (glow_t: sector_t *),
T_PlatRaise, (plat_t: sector_t *), - active list
*/

	thinker_t *th;
	ceiling_t ceiling;
	vldoor_t door;
	floormove_t floor;
	plat_t plat;
	lightflash_t flash;
	strobe_t strobe;
	glow_t glow;

	for(th = thinkercap.next; th != &thinkercap; th = th->next)
	{
		if(th->function == T_MoveCeiling)
		{
			SV_WriteByte(tc_ceiling);
			memcpy(&ceiling, th, sizeof(ceiling_t));
			ceiling.sector = (sector_t *)(ceiling.sector-sectors);
			SV_Write(&ceiling, sizeof(ceiling_t));
			continue;
		}
		if(th->function == T_VerticalDoor)
		{
			SV_WriteByte(tc_door);
			memcpy(&door, th, sizeof(vldoor_t));
			door.sector = (sector_t *)(door.sector-sectors);
			SV_Write(&door, sizeof(vldoor_t));
			continue;
		}
		if(th->function == T_MoveFloor)
		{
			SV_WriteByte(tc_floor);
			memcpy(&floor, th, sizeof(floormove_t));
			floor.sector = (sector_t *)(floor.sector-sectors);
			SV_Write(&floor, sizeof(floormove_t));
			continue;
		}
		if(th->function == T_PlatRaise)
		{
			SV_WriteByte(tc_plat);
			memcpy(&plat, th, sizeof(plat_t));
			plat.sector = (sector_t *)(plat.sector-sectors);
			SV_Write(&plat, sizeof(plat_t));
			continue;
		}
		if(th->function == T_LightFlash)
		{
			SV_WriteByte(tc_flash);
			memcpy(&flash, th, sizeof(lightflash_t));
			flash.sector = (sector_t *)(flash.sector-sectors);
			SV_Write(&flash, sizeof(lightflash_t));
			continue;
		}
		if(th->function == T_StrobeFlash)
		{
			SV_WriteByte(tc_strobe);
			memcpy(&strobe, th, sizeof(strobe_t));
			strobe.sector = (sector_t *)(strobe.sector-sectors);
			SV_Write(&strobe, sizeof(strobe_t));
			continue;
		}
		if(th->function == T_Glow)
		{
			SV_WriteByte(tc_glow);
			memcpy(&glow, th, sizeof(glow_t));
			glow.sector = (sector_t *)(glow.sector-sectors);
			SV_Write(&glow, sizeof(glow_t));
			continue;
		}
	}
	// Add a terminating marker
	SV_WriteByte(tc_endspecials);
}

/*
====================
=
= P_UnArchiveSpecials
=
====================
*/

void P_UnArchiveSpecials (void)
{
	byte		tclass;
	ceiling_t	*ceiling;
	vldoor_t	*door;
	floormove_t	*floor;
	plat_t		*plat;
	lightflash_t *flash;
	strobe_t	*strobe;
	glow_t		*glow;
	
	
// read in saved thinkers
	while (1)
	{
		tclass = *save_p++;
		switch (tclass)
		{
			case tc_endspecials:
				return;			// end of list
			
			case tc_ceiling:
				ceiling = Z_Malloc (sizeof(*ceiling), PU_LEVEL, NULL);
				memcpy (ceiling, save_p, sizeof(*ceiling));
				save_p += sizeof(*ceiling);
				ceiling->sector = &sectors[(int)ceiling->sector];
				ceiling->sector->specialdata = T_MoveCeiling;
				if (ceiling->thinker.function)
					ceiling->thinker.function = T_MoveCeiling;
				P_AddThinker (&ceiling->thinker);
				P_AddActiveCeiling(ceiling);
				break;

			case tc_door:
				door = Z_Malloc (sizeof(*door), PU_LEVEL, NULL);
				memcpy (door, save_p, sizeof(*door));
				save_p += sizeof(*door);
				door->sector = &sectors[(int)door->sector];
				door->sector->specialdata = door;
				door->thinker.function = T_VerticalDoor;
				P_AddThinker (&door->thinker);
				break;

			case tc_floor:
				floor = Z_Malloc (sizeof(*floor), PU_LEVEL, NULL);
				memcpy (floor, save_p, sizeof(*floor));
				save_p += sizeof(*floor);
				floor->sector = &sectors[(int)floor->sector];
				floor->sector->specialdata = T_MoveFloor;
				floor->thinker.function = T_MoveFloor;
				P_AddThinker (&floor->thinker);
				break;
				
			case tc_plat:
				plat = Z_Malloc (sizeof(*plat), PU_LEVEL, NULL);
				memcpy (plat, save_p, sizeof(*plat));
				save_p += sizeof(*plat);
				plat->sector = &sectors[(int)plat->sector];
				plat->sector->specialdata = T_PlatRaise;
				if (plat->thinker.function)
					plat->thinker.function = T_PlatRaise;
				P_AddThinker (&plat->thinker);
				P_AddActivePlat(plat);
				break;
				
			case tc_flash:
				flash = Z_Malloc (sizeof(*flash), PU_LEVEL, NULL);
				memcpy (flash, save_p, sizeof(*flash));
				save_p += sizeof(*flash);
				flash->sector = &sectors[(int)flash->sector];
				flash->thinker.function = T_LightFlash;
				P_AddThinker (&flash->thinker);
				break;
				
			case tc_strobe:
				strobe = Z_Malloc (sizeof(*strobe), PU_LEVEL, NULL);
				memcpy (strobe, save_p, sizeof(*strobe));
				save_p += sizeof(*strobe);
				strobe->sector = &sectors[(int)strobe->sector];
				strobe->thinker.function = T_StrobeFlash;
				P_AddThinker (&strobe->thinker);
				break;
				
			case tc_glow:
				glow = Z_Malloc (sizeof(*glow), PU_LEVEL, NULL);
				memcpy (glow, save_p, sizeof(*glow));
				save_p += sizeof(*glow);
				glow->sector = &sectors[(int)glow->sector];
				glow->thinker.function = T_Glow;
				P_AddThinker (&glow->thinker);
				break;
				
			default:
				I_Error ("P_UnarchiveSpecials:Unknown tclass %i "
							"in savegame",tclass);
		}
	
	}

}




//----------------------------------------------------------------------------
//
// PROC P_Ticker
//
//----------------------------------------------------------------------------

void P_Ticker(void)
{
	int i;

	if(paused)
	{
		return;
	}
	for(i = 0; i < MAXPLAYERS; i++)
	{
		if(players[i].plr->ingame)
		{
			P_PlayerThink(&players[i]);
		}
	}
	if(TimerGame)
	{
		if(!--TimerGame)
		{
			G_ExitLevel();
		}
	}
	gi.RunThinkers();
	P_UpdateSpecials();
	P_AmbientSound();
	leveltime++;
}
