
// MN_menu.c

#include <ctype.h>
#include "DoomDef.h"
#include "P_local.h"
#include "R_local.h"
#include "soundst.h"
#include "settings.h"

// Macros

#define LEFT_DIR 0
#define RIGHT_DIR 1
#define ITEM_HEIGHT 20
#define SELECTOR_XOFFSET (-28)
#define SELECTOR_YOFFSET (-1)
#define SLOTTEXTLEN     16
#define ASCII_CURSOR '['

// Control flags.
#define CLF_ACTION		0x1		// The control is an action (+/- in front).
#define CLF_REPEAT		0x2		// Bind down + repeat.

// Types

typedef enum
{
	ITT_EMPTY,
	ITT_EFUNC,
	ITT_LRFUNC,
	ITT_SETMENU,
	ITT_INERT
} ItemType_t;

typedef enum
{
	MENU_MAIN,
	MENU_EPISODE,
	MENU_SKILL,
	MENU_OPTIONS,
	MENU_OPTIONS2,
	MENU_GAMEPLAY,
	MENU_GRAPHICS,
	MENU_EFFECTS,
	MENU_RESOLUTION,
	MENU_CONTROLS,
	MENU_MOUSEOPTS,
	MENU_JOYCONFIG,
	MENU_FILES,
	MENU_LOAD,
	MENU_SAVE,
	MENU_NONE
} MenuType_t;

typedef struct
{
	ItemType_t type;
	char *text;
	boolean (*func)(int option);
	int option;
	MenuType_t menu;
} MenuItem_t;

typedef struct
{
	int x;
	int y;
	void (*drawFunc)(void);
	int itemCount;
	MenuItem_t *items;
	int oldItPos;
	MenuType_t prevMenu;
	// Enhancements. -jk
	void (*textDrawer)(char*,int,int);
	int	itemHeight;
	// For multipage menus.
	int firstItem, numVisItems;
} Menu_t;

typedef struct
{
	int	width, height;
} MenuRes_t;

typedef struct
{
	char		*command;		// The command to execute.
	int			flags;
	int			defKey;			// 
	int			defMouse;		// Zero means there is no default.
	int			defJoy;			//
} Control_t;

// Private Functions

static void InitFonts(void);
static void SetMenu(MenuType_t menu);
static boolean SCNetCheck(int option);
static boolean SCQuitGame(int option);
static boolean SCEpisode(int option);
static boolean SCSkill(int option);
static boolean SCSfxVolume(int option);
static boolean SCMusicVolume(int option);
static boolean SCScreenSize(int option);
static boolean SCLoadGame(int option);
static boolean SCSaveGame(int option);
static boolean SCMessages(int option);
static boolean SCEndGame(int option);
static boolean SCInfo(int option);

static boolean SCMouseXSensi(int option);
static boolean SCMouseYSensi(int option);
static boolean SCMouseLook(int option);
static boolean SCMouseLookInverse(int option);
static boolean SCInverseY(int option);
static boolean SCJoyLook(int option);
static boolean SCPOVLook(int option);
static boolean SCInverseJoyLook(int option);
static boolean SCFullscreenMana(int option);
static boolean SCLookSpring(int option);
static boolean SCAutoAim(int option);
static boolean SCSkyDetail(int option);
static boolean SCMipmapping(int option);
static boolean SCLinearRaw(int option);
static boolean SCForceTexReload(int option);
static boolean SCResSelector(int option);
static boolean SCResMakeCurrent(int option);
static boolean SCResMakeDefault(int option);
static boolean SCStatusBarSize(int option);
static boolean SCMusicDevice(int option);
static boolean SCAlwaysRun(int option);
static boolean SCControlConfig(int option);
static boolean SCJoySensi(int option);
static boolean SCCrosshair(int option);
static boolean SCCrosshairSize(int option);
static boolean SCBorderUpdate(int option);
static boolean SCTexQuality(int option);
static boolean SCFPSCounter(int option);
static boolean SCIceCorpse(int option);
static boolean SCDynLights(int option);
static boolean SCDLBlend(int option);
static boolean SCDLIntensity(int option);
static boolean SCFlares(int option);
static boolean SCFlareIntensity(int option);
static boolean SCFlareSize(int option);
static boolean SCSpriteAlign(int option);
static boolean SCSpriteBlending(int option);
static boolean SCSpriteLight(int option);

//static boolean SC3DSounds(int option);
//static boolean SCReverbVolume(int option);
static boolean SCSfxFrequency(int option);
static boolean SCSfx16bit(int option);

static void DrawMainMenu(void);
static void DrawEpisodeMenu(void);
static void DrawSkillMenu(void);
static void DrawOptionsMenu(void);
static void DrawOptions2Menu(void);
static void DrawGameplayMenu(void);
static void DrawGraphicsMenu(void);
static void DrawEffectsMenu(void);
static void DrawResolutionMenu(void);
static void DrawMouseOptsMenu(void);
static void DrawControlsMenu(void);
static void DrawJoyConfigMenu(void);
static void DrawFileSlots(Menu_t *menu);
static void DrawFilesMenu(void);
static void MN_DrawInfo(void);
static void DrawLoadMenu(void);
static void DrawSaveMenu(void);
static void DrawSlider(Menu_t *menu, int item, int width, int slot);

/*static void InitFonts(void);
static void SetMenu(MenuType_t menu);
static void SCQuitGame(int option);
static void SCClass(int option);
static void SCSkill(int option);
static void SCMouseXSensi(int option);
static void SCMouseYSensi(int option);
static void SCMouseLook(int option);
static void SCMouseLookInverse(int option);
static void SCInverseY(int option);
static void SCJoyLook(int option);
static void SCPOVLook(int option);
static void SCInverseJoyLook(int option);
static void SCFullscreenMana(int option);
static void SCLookSpring(int option);
static void SCAutoAim(int option);
static void SCSkyDetail(int option);
static void SCMipmapping(int option);
static void SCLinearRaw(int option);
static void SCForceTexReload(int option);
static void SCResSelector(int option);
static void SCResMakeCurrent(int option);
static void SCResMakeDefault(int option);
static void SCSfxVolume(int option);
static void SCMusicVolume(int option);
static void SCCDVolume(int option);
static void SCScreenSize(int option);
static void SCStatusBarSize(int option);
static void SCMusicDevice(int option);
static boolean SCNetCheck(int option);
static void SCNetCheck2(int option);
static void SCLoadGame(int option);
static void SCSaveGame(int option);
static void SCMessages(int option);
static void SCAlwaysRun(int option);
static void SCControlConfig(int option);
static void SCJoySensi(int option);
static void SCEndGame(int option);
static void SCInfo(int option);
static void SCCrosshair(int option);
static void SCCrosshairSize(int option);

static void SCBorderUpdate(int option);
static void SCTexQuality(int option);
static void SCFPSCounter(int option);
static void SCIceCorpse(int option);
static void SCDynLights(int option);
static void SCDLBlend(int option);
static void SCDLIntensity(int option);
static void SCFlares(int option);
static void SCFlareIntensity(int option);
static void SCFlareSize(int option);
static void SCSpriteAlign(int option);
static void SCSpriteBlending(int option);
static void SCSpriteLight(int option);

static void SC3DSounds(int option);
static void SCReverbVolume(int option);
static void SCSfxFrequency(int option);
static void SCSfx16bit(int option);

static void DrawMainMenu(void);
static void DrawClassMenu(void);
static void DrawSkillMenu(void);
static void DrawOptionsMenu(void);
static void DrawOptions2Menu(void);
static void DrawGameplayMenu(void);
static void DrawGraphicsMenu(void);
static void DrawEffectsMenu(void);
static void DrawResolutionMenu(void);
static void DrawMouseOptsMenu(void);
static void DrawControlsMenu(void);
static void DrawJoyConfigMenu(void);
static void DrawFileSlots(Menu_t *menu);
static void DrawFilesMenu(void);
static void MN_DrawInfo(void);
static void DrawLoadMenu(void);
static void DrawSaveMenu(void);
static void DrawSlider(Menu_t *menu, int item, int width, int slot);
*/

void MN_LoadSlotText(void);

// External Data

boolean F_Responder(event_t *ev);

//extern int detailLevel;
extern int screenblocks;

// Public Data

boolean MenuActive;
int InfoType;
boolean messageson;

// Private Data

static MenuRes_t resolutions[] =
{
	320, 240,
	640, 480,
	800, 600,
	1024, 768,
	1152, 864,
	1280, 1024,
	1600, 1200,
	0, 0	// The terminator.
};
static int selRes = 0;	// Will be determined when needed.

//
// !!! Add new controls to the end, the existing indices must remain unchanged !!!
//
static Control_t controls[] =
{
	// Actions (must be first so the H2A_* constants can be used).
	"left",			CLF_ACTION,		DDKEY_LEFTARROW, 0, 0,
	"right",		CLF_ACTION,		DDKEY_RIGHTARROW, 0, 0,
	"forward",		CLF_ACTION,		DDKEY_UPARROW, 0, 0,
	"backward",		CLF_ACTION,		DDKEY_DOWNARROW, 0, 0,
	"strafel",		CLF_ACTION,		',', 0, 0,
	"strafer",		CLF_ACTION,		'.', 0, 0,
	"fire",			CLF_ACTION,		DDKEY_RCTRL, 1, 1,
	"use",			CLF_ACTION,		' ', 0, 4,
	"strafe",		CLF_ACTION,		DDKEY_RALT, 3, 2,
	"speed",		CLF_ACTION,		DDKEY_RSHIFT, 0, 3,

	"flyup",		CLF_ACTION,		DDKEY_PGUP, 0, 8,
	"flydown",		CLF_ACTION,		DDKEY_INS, 0, 9,
	"falldown",		CLF_ACTION,		DDKEY_HOME, 0, 0,
	"lookup",		CLF_ACTION,		DDKEY_PGDN, 0, 6,
	"lookdown",		CLF_ACTION,		DDKEY_DEL, 0, 7,
	"lookcntr",		CLF_ACTION,		DDKEY_END, 0, 0,
	"usearti",		CLF_ACTION,		DDKEY_ENTER, 0, 0,
	"mlook",		CLF_ACTION,		'm', 0, 0,
	"jlook",		CLF_ACTION,		'j', 0, 0,
	"nextwpn",		CLF_ACTION,		0, 0, 0,

	"prevwpn",		CLF_ACTION,		0, 0, 0,
	"weapon1",		CLF_ACTION,		'1', 0, 0,
	"weapon2",		CLF_ACTION,		'2', 0, 0,
	"weapon3",		CLF_ACTION,		'3', 0, 0,
	"weapon4",		CLF_ACTION,		'4', 0, 0,
	"weapon5",		CLF_ACTION,		'5', 0, 0,
	"weapon6",		CLF_ACTION,		'6', 0, 0,
	"weapon7",		CLF_ACTION,		'7', 0, 0,
	"weapon8",		CLF_ACTION,		'8', 0, 0,
	"weapon9",		CLF_ACTION,		'9', 0, 0,

	"cantdie",		CLF_ACTION,		0, 0, 0,
	"invisib",		CLF_ACTION,		0, 0, 0,
	"health",		CLF_ACTION,		0, 0, 0,
	"superhlt",		CLF_ACTION,		0, 0, 0,
	"tomepwr",		CLF_ACTION,		DDKEY_BACKSPACE, 0, 0,
	"torch",		CLF_ACTION,		0, 0, 0,
	"firebomb",		CLF_ACTION,		0, 0, 0,
	"egg",			CLF_ACTION,		0, 0, 0,
	"wings",		CLF_ACTION,		0, 0, 0,
	"teleport",		CLF_ACTION,		0, 0, 0,

	"panic",		CLF_ACTION,		0, 0, 0,
	"stopdemo",		CLF_ACTION,		'o', 0, 0,

	// Menu hotkeys (default: F1 - F12).
/*42*/"infoscreen",	0,				DDKEY_F1, 0, 0,
	"loadgame",		0,				DDKEY_F2, 0, 0,
	"savegame",		0,				DDKEY_F3, 0, 0,
	"soundmenu",	0,				DDKEY_F4, 0, 0,
	"quicksave",	0,				DDKEY_F6, 0, 0,
	"endgame",		0,				DDKEY_F7, 0, 0,
	"togglemsgs",	0,				DDKEY_F8, 0, 0,
	"quickload",	0,				DDKEY_F9, 0, 0,
	"quit",			0,				DDKEY_F10, 0, 0,
	"togglegamma",	0,				DDKEY_F11, 0, 0,
	"spy",			0,				DDKEY_F12, 0, 0,

	// Inventory.
	"invleft",		CLF_REPEAT,		'[', 0, 0,
	"invright",		CLF_REPEAT,		']', 0, 0,

	// Screen controls.
	"viewsize +",	CLF_REPEAT,		'=', 0, 0,
	"viewsize -",	CLF_REPEAT,		'-', 0, 0,
	"sbsize +",		CLF_REPEAT,		0, 0, 0,
	"sbsize -",		CLF_REPEAT,		0, 0, 0,

	// Misc.
	"pause",		0,				'p', 0, 0,
	"",				0,				0, 0, 0		// terminator
};
static Control_t *grabbing = NULL;

static float menuDark = 0;	// Background darkening.
static float menuDarkMax = 0.5f, menuDarkSpeed = 1 / 15.0f;
static int menuDarkDir = 0;	

static int FontABaseLump;
static int FontBBaseLump;
static int SkullBaseLump;
static Menu_t *CurrentMenu;
static int CurrentItPos;
static int MenuEpisode;
static int MenuTime;
static boolean soundchanged;

boolean askforquit;
boolean typeofask;
static boolean FileMenuKeySteal;
static boolean slottextloaded;
static char SlotText[6][SLOTTEXTLEN+2];
static char oldSlotText[SLOTTEXTLEN+2];
static int SlotStatus[6];
static int slotptr;
static int currentSlot;
static int quicksave;
static int quickload;

static MenuItem_t MainItems[] =
{
	{ ITT_EFUNC, "NEW GAME", SCNetCheck, 1, MENU_EPISODE },
	{ ITT_SETMENU, "OPTIONS", NULL, 0, MENU_OPTIONS },
	{ ITT_SETMENU, "GAME FILES", NULL, 0, MENU_FILES },
	{ ITT_EFUNC, "INFO", SCInfo, 0, MENU_NONE },
	{ ITT_EFUNC, "QUIT GAME", SCQuitGame, 0, MENU_NONE }
};

static Menu_t MainMenu =
{
	110, 56,
	DrawMainMenu,
	5, MainItems,
	0,
	MENU_NONE,
	MN_DrTextB_CS, ITEM_HEIGHT, 
	0, 5
};

static MenuItem_t EpisodeItems[] =
{
	{ ITT_EFUNC, "CITY OF THE DAMNED", SCEpisode, 1, MENU_NONE },
	{ ITT_EFUNC, "HELL'S MAW", SCEpisode, 2, MENU_NONE },
	{ ITT_EFUNC, "THE DOME OF D'SPARIL", SCEpisode, 3, MENU_NONE },
	{ ITT_EFUNC, "THE OSSUARY", SCEpisode, 4, MENU_NONE },
	{ ITT_EFUNC, "THE STAGNANT DEMESNE", SCEpisode, 5, MENU_NONE }
};

static Menu_t EpisodeMenu =
{
	80, 50,
	DrawEpisodeMenu,
	3, EpisodeItems,
	0,
	MENU_MAIN,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 3
};

static MenuItem_t FilesItems[] =
{
	{ ITT_EFUNC, "LOAD GAME", SCNetCheck, 2, MENU_LOAD },
	{ ITT_SETMENU, "SAVE GAME", NULL, 0, MENU_SAVE }
};

static Menu_t FilesMenu =
{
	110, 60,
	DrawFilesMenu,
	2, FilesItems,
	0,
	MENU_MAIN,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 2
};

static MenuItem_t LoadItems[] =
{
	{ ITT_EFUNC, NULL, SCLoadGame, 0, MENU_NONE },
	{ ITT_EFUNC, NULL, SCLoadGame, 1, MENU_NONE },
	{ ITT_EFUNC, NULL, SCLoadGame, 2, MENU_NONE },
	{ ITT_EFUNC, NULL, SCLoadGame, 3, MENU_NONE },
	{ ITT_EFUNC, NULL, SCLoadGame, 4, MENU_NONE },
	{ ITT_EFUNC, NULL, SCLoadGame, 5, MENU_NONE }
};

static Menu_t LoadMenu =
{
	70, 30,
	DrawLoadMenu,
	6, LoadItems,
	0,
	MENU_FILES,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 6
};

static MenuItem_t SaveItems[] =
{
	{ ITT_EFUNC, NULL, SCSaveGame, 0, MENU_NONE },
	{ ITT_EFUNC, NULL, SCSaveGame, 1, MENU_NONE },
	{ ITT_EFUNC, NULL, SCSaveGame, 2, MENU_NONE },
	{ ITT_EFUNC, NULL, SCSaveGame, 3, MENU_NONE },
	{ ITT_EFUNC, NULL, SCSaveGame, 4, MENU_NONE },
	{ ITT_EFUNC, NULL, SCSaveGame, 5, MENU_NONE }
};

static Menu_t SaveMenu =
{
	70, 30,
	DrawSaveMenu,
	6, SaveItems,
	0,
	MENU_FILES,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 6
};

static MenuItem_t SkillItems[] =
{
	{ ITT_EFUNC, "THOU NEEDETH A WET-NURSE", SCSkill, sk_baby, MENU_NONE },
	{ ITT_EFUNC, "YELLOWBELLIES-R-US", SCSkill, sk_easy, MENU_NONE },
	{ ITT_EFUNC, "BRINGEST THEM ONETH", SCSkill, sk_medium, MENU_NONE },
	{ ITT_EFUNC, "THOU ART A SMITE-MEISTER", SCSkill, sk_hard, MENU_NONE },
	{ ITT_EFUNC, "BLACK PLAGUE POSSESSES THEE",
		SCSkill, sk_nightmare, MENU_NONE }
};

static Menu_t SkillMenu =
{
	38, 30,
	DrawSkillMenu,
	5, SkillItems,
	2,
	MENU_EPISODE,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 5
};

static MenuItem_t OptionsItems[] =
{
	{ ITT_EFUNC, "END GAME", SCEndGame, 0, MENU_NONE },
	{ ITT_SETMENU, "GAMEPLAY...", NULL, 0, MENU_GAMEPLAY },
	{ ITT_SETMENU, "GRAPHICS...", NULL, 0, MENU_GRAPHICS },
	{ ITT_SETMENU, "SOUND...", NULL, 0, MENU_OPTIONS2 },
	{ ITT_SETMENU, "CONTROLS...", NULL, 0, MENU_CONTROLS },
	{ ITT_SETMENU, "MOUSE OPTIONS...", NULL, 0, MENU_MOUSEOPTS },
	{ ITT_SETMENU, "JOYSTICK OPTIONS...", NULL, 0, MENU_JOYCONFIG }
};

static Menu_t OptionsMenu =
{
	110, 80,
	DrawOptionsMenu,
	7, OptionsItems,
	0,
	MENU_MAIN,
	MN_DrTextA_CS, 9,
	0, 7
};

static MenuItem_t Options2Items[] =
{
	{ ITT_LRFUNC, "SFX VOLUME", SCSfxVolume, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_LRFUNC, "MIDI VOLUME", SCMusicVolume, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
/*	{ ITT_LRFUNC, "CD VOLUME", SCCDVolume, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },*/
	{ ITT_LRFUNC, "MUSIC DEVICE :", SCMusicDevice, 0, MENU_NONE },
/*	{ ITT_EFUNC, "3D SOUNDS :", SC3DSounds, 0, MENU_NONE },
	{ ITT_LRFUNC, "REVERB VOLUME :", SCReverbVolume, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },*/
	{ ITT_LRFUNC, "SFX FREQUENCY :", SCSfxFrequency, 0, MENU_NONE },
	{ ITT_EFUNC, "16 BIT INTERPOLATION :", SCSfx16bit, 0, MENU_NONE }
};

static Menu_t Options2Menu =
{
	70, 55,
	DrawOptions2Menu,
	9, Options2Items,
	0,
	MENU_OPTIONS,
	MN_DrTextA_CS, 10,
	0, 9
};

static MenuItem_t GameplayItems[] =
{
	{ ITT_EFUNC, "MESSAGES :", SCMessages, 0, MENU_NONE },
	{ ITT_EFUNC, "ALWAYS RUN :", SCAlwaysRun, 0, MENU_NONE },
	{ ITT_EFUNC, "LOOKSPRING :", SCLookSpring, 0, MENU_NONE },
	{ ITT_EFUNC, "NO AUTOAIM :", SCAutoAim, 0, MENU_NONE },
	{ ITT_EFUNC, "FULLSCREEN AMMO :", SCFullscreenMana, 0, MENU_NONE },
	{ ITT_LRFUNC, "CROSSHAIR :", SCCrosshair, 0, MENU_NONE },
	{ ITT_LRFUNC, "CROSSHAIR SIZE :", SCCrosshairSize, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_LRFUNC, "SCREEN SIZE", SCScreenSize, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_LRFUNC, "STATUS BAR SIZE", SCStatusBarSize, 0, MENU_NONE},
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE }
};

static Menu_t GameplayMenu =
{
	72, 25,
	DrawGameplayMenu,
	15, GameplayItems,
	0,
	MENU_OPTIONS,
	MN_DrTextA_CS, 10,
	0, 15
};

static MenuItem_t GraphicsItems[] = 
{
	{ ITT_LRFUNC, "SKY DETAIL", SCSkyDetail, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_LRFUNC, "MIPMAPPING :", SCMipmapping, 0, MENU_NONE },
	{ ITT_EFUNC, "SMOOTH GFX :", SCLinearRaw, 0, MENU_NONE },
	{ ITT_EFUNC, "UPDATE BORDERS :", SCBorderUpdate, 0, MENU_NONE },
	{ ITT_LRFUNC, "TEX QUALITY :", SCTexQuality, 0, MENU_NONE },
	{ ITT_EFUNC, "FORCE TEX RELOAD", SCForceTexReload, 0, MENU_NONE },
	{ ITT_SETMENU, "EFFECTS...", NULL, 0, MENU_EFFECTS },
	{ ITT_SETMENU, "RESOLUTION...", NULL, 0, MENU_RESOLUTION }
};

static Menu_t GraphicsMenu =
{
	58, 10,
	DrawGraphicsMenu,
	9, GraphicsItems,
	0,
	MENU_OPTIONS,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 9
};

static MenuItem_t EffectsItems[] =
{
	{ ITT_EFUNC, "FPS COUNTER :", SCFPSCounter, 0, MENU_NONE },
//	{ ITT_EFUNC, "FROZEN THINGS TRANSLUCENT :", SCIceCorpse, 0, MENU_NONE },
	{ ITT_EFUNC, "DYNAMIC LIGHTS :", SCDynLights, 0, MENU_NONE },
	{ ITT_LRFUNC, "DYNLIGHT BLENDING :", SCDLBlend, 0, MENU_NONE },
	{ ITT_EFUNC, "LIGHTS ON SPRITES :", SCSpriteLight, 0, MENU_NONE },
	{ ITT_LRFUNC, "DYNLIGHT INTENSITY :", SCDLIntensity, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_LRFUNC, "LENS FLARES :", SCFlares, 0, MENU_NONE },
	{ ITT_LRFUNC, "FLARE INTENSITY :", SCFlareIntensity, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_LRFUNC, "FLARE SIZE :", SCFlareSize, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "ALIGN SPRITES TO :", SCSpriteAlign, 0, MENU_NONE },
	{ ITT_EFUNC, "SPRITE BLENDING :", SCSpriteBlending, 0, MENU_NONE }
};

static Menu_t EffectsMenu =
{
	60, 20,
	DrawEffectsMenu,
	16, EffectsItems,
	0,
	MENU_GRAPHICS,
	MN_DrTextA_CS, 10,
	0, 16
};

static MenuItem_t ResolutionItems[] =
{
	{ ITT_LRFUNC, "RESOLUTION :", SCResSelector, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "MAKE CURRENT", SCResMakeCurrent, 0, MENU_NONE },
	{ ITT_EFUNC, "MAKE DEFAULT", SCResMakeDefault, 0, MENU_NONE }
};

static Menu_t ResolutionMenu =
{
	88, 60,
	DrawResolutionMenu,
	4, ResolutionItems,
	0,
	MENU_GRAPHICS,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 4
};

static MenuItem_t ControlsItems[] =
{
	{ ITT_EMPTY, "PLAYER ACTIONS", NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "LEFT :", SCControlConfig, HA_TURNLEFT, MENU_NONE },
	{ ITT_EFUNC, "RIGHT :", SCControlConfig, HA_TURNRIGHT, MENU_NONE },
	{ ITT_EFUNC, "FORWARD :", SCControlConfig, HA_FORWARD, MENU_NONE },
	{ ITT_EFUNC, "BACKWARD :", SCControlConfig, HA_BACKWARD, MENU_NONE },
	{ ITT_EFUNC, "STRAFE LEFT :", SCControlConfig, HA_STRAFELEFT, MENU_NONE },
	{ ITT_EFUNC, "STRAFE RIGHT :", SCControlConfig, HA_STRAFERIGHT, MENU_NONE },
	{ ITT_EFUNC, "FIRE :", SCControlConfig, HA_FIRE, MENU_NONE },
	{ ITT_EFUNC, "USE :", SCControlConfig, HA_USE, MENU_NONE },	
	{ ITT_EFUNC, "STRAFE :", SCControlConfig, HA_STRAFE, MENU_NONE },
	{ ITT_EFUNC, "SPEED :", SCControlConfig, HA_SPEED, MENU_NONE },
	{ ITT_EFUNC, "FLY UP :", SCControlConfig, HA_FLYUP, MENU_NONE },
	{ ITT_EFUNC, "FLY DOWN :", SCControlConfig, HA_FLYDOWN, MENU_NONE },
	{ ITT_EFUNC, "FALL DOWN :", SCControlConfig, HA_FLYCENTER, MENU_NONE },
	{ ITT_EFUNC, "LOOK UP :", SCControlConfig, HA_LOOKUP, MENU_NONE },
	{ ITT_EFUNC, "LOOK DOWN :", SCControlConfig, HA_LOOKDOWN, MENU_NONE },
	{ ITT_EFUNC, "LOOK CENTER :", SCControlConfig, HA_LOOKCENTER, MENU_NONE },
	{ ITT_EFUNC, "MOUSE LOOK :", SCControlConfig, HA_MLOOK, MENU_NONE },
	{ ITT_EFUNC, "JOYSTICK LOOK :", SCControlConfig, HA_JLOOK, MENU_NONE },
	{ ITT_EFUNC, "NEXT WEAPON :", SCControlConfig, HA_NEXTWEAPON, MENU_NONE },
	{ ITT_EFUNC, "PREV WEAPON :", SCControlConfig, HA_PREVIOUSWEAPON, MENU_NONE },
	{ ITT_EFUNC, "STAFF/GAUNTLETS :", SCControlConfig, HA_WEAPON1, MENU_NONE },
	{ ITT_EFUNC, "ELVENWAND :", SCControlConfig, HA_WEAPON2, MENU_NONE },
	{ ITT_EFUNC, "CROSSBOW :", SCControlConfig, HA_WEAPON3, MENU_NONE },
	{ ITT_EFUNC, "DRAGON CLAW :", SCControlConfig, HA_WEAPON4, MENU_NONE },
	{ ITT_EFUNC, "HELLSTAFF :", SCControlConfig, HA_WEAPON5, MENU_NONE },
	{ ITT_EFUNC, "PHOENIX ROD :", SCControlConfig, HA_WEAPON6, MENU_NONE },
	{ ITT_EFUNC, "FIREMACE :", SCControlConfig, HA_WEAPON7, MENU_NONE },
	{ ITT_EFUNC, "PANIC :", SCControlConfig, HA_PANIC, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, "ARTIFACTS", NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "INVINCIBILITY :", SCControlConfig, HA_INVULNERABILITY, MENU_NONE },
	{ ITT_EFUNC, "SHADOWSPHERE :", SCControlConfig, HA_INVISIBILITY, MENU_NONE },
	{ ITT_EFUNC, "QUARTZ FLASK :", SCControlConfig, HA_HEALTH, MENU_NONE },
	{ ITT_EFUNC, "MYSTIC URN :", SCControlConfig, HA_SUPERHEALTH, MENU_NONE },
	{ ITT_EFUNC, "TOME OF POWER:", SCControlConfig, HA_TOMEOFPOWER, MENU_NONE },
	{ ITT_EFUNC, "TORCH :", SCControlConfig, HA_TORCH, MENU_NONE },
	{ ITT_EFUNC, "TIME BOMB :", SCControlConfig, HA_FIREBOMB, MENU_NONE },
	{ ITT_EFUNC, "MORPH OVUM :", SCControlConfig, HA_EGG, MENU_NONE },
	{ ITT_EFUNC, "WINGS OF WRATH :", SCControlConfig, HA_FLY, MENU_NONE },
	{ ITT_EFUNC, "CHAOS DEVICE :", SCControlConfig, HA_TELEPORT, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, "INVENTORY", NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "INVENTORY LEFT :", SCControlConfig, 53, MENU_NONE },
	{ ITT_EFUNC, "INVENTORY RIGHT :", SCControlConfig, 54, MENU_NONE },
	{ ITT_EFUNC, "USE ARTIFACT :", SCControlConfig, HA_USEARTIFACT, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, "MENU HOTKEYS", NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "INFO :", SCControlConfig, 42, MENU_NONE },
	{ ITT_EFUNC, "SOUND MENU :", SCControlConfig, 45, MENU_NONE },
	{ ITT_EFUNC, "LOAD GAME :", SCControlConfig, 43, MENU_NONE },
	{ ITT_EFUNC, "SAVE GAME :", SCControlConfig, 44, MENU_NONE },
	{ ITT_EFUNC, "QUICK LOAD :", SCControlConfig, 49, MENU_NONE },
	{ ITT_EFUNC, "QUICK SAVE :", SCControlConfig, 46, MENU_NONE },
//	{ ITT_EFUNC, "SUICIDE :", SCControlConfig, 44, MENU_NONE },
	{ ITT_EFUNC, "END GAME :", SCControlConfig, 47, MENU_NONE },
	{ ITT_EFUNC, "QUIT :", SCControlConfig, 50, MENU_NONE },
	{ ITT_EFUNC, "MESSAGES ON/OFF:", SCControlConfig, 48, MENU_NONE },
	{ ITT_EFUNC, "GAMMA CORRECTION :", SCControlConfig, 51, MENU_NONE },
	{ ITT_EFUNC, "SPY MODE :", SCControlConfig, 52, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, "SCREEN", NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "SMALLER VIEW :", SCControlConfig, 56, MENU_NONE },
	{ ITT_EFUNC, "LARGER VIEW :", SCControlConfig, 55, MENU_NONE },
	{ ITT_EFUNC, "SMALLER STATBAR :", SCControlConfig, 58, MENU_NONE },
	{ ITT_EFUNC, "LARGER STATBAR :", SCControlConfig, 57, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EMPTY, "MISCELLANEOUS", NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "STOP DEMO :", SCControlConfig, HA_STOPDEMO, MENU_NONE },
	{ ITT_EFUNC, "PAUSE :", SCControlConfig, 59, MENU_NONE }
};

static Menu_t ControlsMenu =
{
	32, 26,
	DrawControlsMenu,
	69, ControlsItems,
	1,
	MENU_OPTIONS,
	MN_DrTextA_CS, 9,
	0, 18
};

static MenuItem_t MouseOptsItems[] =
{
	{ ITT_EFUNC, "INVERSE Y :", SCInverseY, 0, MENU_NONE },
	{ ITT_EFUNC, "MOUSE LOOK :", SCMouseLook, 0, MENU_NONE },
	{ ITT_EFUNC, "INVERSE MLOOK :", SCMouseLookInverse, 0, MENU_NONE },
	{ ITT_LRFUNC, "X SENSITIVITY", SCMouseXSensi, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_LRFUNC, "Y SENSITIVITY", SCMouseYSensi, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
};

static Menu_t MouseOptsMenu = 
{
	72, 30,
	DrawMouseOptsMenu,
	7, MouseOptsItems,
	0,
	MENU_OPTIONS,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 7
};

static MenuItem_t JoyConfigItems[] =
{
	{ ITT_LRFUNC, "SENSITIVITY", SCJoySensi, 0, MENU_NONE },
	{ ITT_EMPTY, NULL, NULL, 0, MENU_NONE },
	{ ITT_EFUNC, "JOY LOOK :", SCJoyLook, 0, MENU_NONE },
	{ ITT_EFUNC, "INVERSE LOOK :", SCInverseJoyLook, 0, MENU_NONE },
	{ ITT_EFUNC, "POV LOOK :", SCPOVLook, 0, MENU_NONE }
};

static Menu_t JoyConfigMenu =
{
	80, 50,
	DrawJoyConfigMenu,
	5, JoyConfigItems,
	0,
	MENU_OPTIONS,
	MN_DrTextB_CS, ITEM_HEIGHT,
	0, 5
};

static Menu_t *Menus[] =
{
	&MainMenu,
	&EpisodeMenu,
	&SkillMenu,
	&OptionsMenu,
	&Options2Menu,
	&GameplayMenu,
	&GraphicsMenu,
	&EffectsMenu,
	&ResolutionMenu,
	&ControlsMenu,
	&MouseOptsMenu,
	&JoyConfigMenu,
	&FilesMenu,
	&LoadMenu,
	&SaveMenu
};

//---------------------------------------------------------------------------
//
// PROC MN_Init
//
//---------------------------------------------------------------------------

static int findRes(int w, int h)
{
	int i;

	for(i=0; resolutions[i].width; i++)
		if(resolutions[i].width == w && resolutions[i].height == h)
			return i;
	return -1;
}

void MN_Init(void)
{
	InitFonts();
	MenuActive = false;
	messageson = true;
	SkullBaseLump = W_GetNumForName("M_SKL00");
	if(ExtendedWAD)
	{ // Add episodes 4 and 5 to the menu
		EpisodeMenu.itemCount = EpisodeMenu.numVisItems = 5;
		EpisodeMenu.y = 50-ITEM_HEIGHT;
	}
	// Find the correct resolution.
	selRes = findRes(gi.Get(DD_SCREEN_WIDTH), gi.Get(DD_SCREEN_HEIGHT));
}

//---------------------------------------------------------------------------
//
// PROC InitFonts
//
//---------------------------------------------------------------------------

static void InitFonts(void)
{
	FontABaseLump = W_GetNumForName("FONTA_S")+1;
	FontBBaseLump = W_GetNumForName("FONTB_S")+1;
}

//---------------------------------------------------------------------------
//
// PROC MN_TextFilter
//
//---------------------------------------------------------------------------

void MN_TextFilter(char *text)
{
	int		k;

	for(k=0; text[k]; k++)
	{
		char ch = toupper(text[k]);
		if(ch == '_') ch = '[';	// Mysterious... (from save slots).
		else if(ch == '\\') ch = '/';
		// Check that the character is printable.
		else if(ch < 32 || ch > 'Z') ch = 32; // Character out of range.
		text[k] = ch;			
	}
}

//---------------------------------------------------------------------------
//
// PROC MN_DrTextA
//
// Draw text using font A.
//
//---------------------------------------------------------------------------

void MN_DrTextA(char *text, int x, int y)
{
	char c;
	patch_t *p;

	while((c = *text++) != 0)
	{
		if(c < 33)
		{
			x += 5;
		}
		else
		{
			p = W_CacheLumpNum(FontABaseLump+c-33, PU_CACHE);
			gi.GL_DrawPatch(x, y, FontABaseLump+c-33);
			x += p->width-1;
		}
	}
}

//---------------------------------------------------------------------------
//
// PROC MN_DrTextA_CS
//
// Draw text using font A, in the current rendering state.
//
//---------------------------------------------------------------------------

void MN_DrTextA_CS(char *text, int x, int y)
{
	char c;
	patch_t *p;

	while((c = *text++) != 0)
	{
		if(c < 33)
		{
			x += 5;
		}
		else
		{
			p = W_CacheLumpNum(FontABaseLump+c-33, PU_CACHE);
			gi.GL_DrawPatchCS(x, y, FontABaseLump+c-33);
			x += p->width-1;
		}
	}
}

//---------------------------------------------------------------------------
//
// FUNC MN_TextAWidth
//
// Returns the pixel width of a string using font A.
//
//---------------------------------------------------------------------------

int MN_TextAWidth(char *text)
{
	char c;
	int width;
	patch_t *p;

	width = 0;
	while((c = *text++) != 0)
	{
		if(c < 33)
		{
			width += 5;
		}
		else
		{
			p = W_CacheLumpNum(FontABaseLump+c-33, PU_CACHE);
			width += p->width-1;
		}
	}
	return(width);
}

//---------------------------------------------------------------------------
//
// PROC MN_DrTextB
//
// Draw text using font B.
//
//---------------------------------------------------------------------------

void MN_DrTextB(char *text, int x, int y)
{
	char c;
	patch_t *p;

	while((c = *text++) != 0)
	{
		if(c < 33)
		{
			x += 8;
		}
		else
		{
			p = W_CacheLumpNum(FontBBaseLump+c-33, PU_CACHE);
			gi.GL_DrawPatch(x, y, FontBBaseLump+c-33);
			x += p->width-1;
		}
	}
}

//---------------------------------------------------------------------------
//
// PROC MN_DrTextB_CS
//
// Draw text using font B, in the current state.
//
//---------------------------------------------------------------------------

void MN_DrTextB_CS(char *text, int x, int y)
{
	char c;
	patch_t *p;

	while((c = *text++) != 0)
	{
		if(c < 33)
		{
			x += 8;
		}
		else
		{
			p = W_CacheLumpNum(FontBBaseLump+c-33, PU_CACHE);
			gi.GL_DrawPatchCS(x, y, FontBBaseLump+c-33);
			x += p->width-1;
		}
	}
}

//---------------------------------------------------------------------------
//
// FUNC MN_TextBWidth
//
// Returns the pixel width of a string using font B.
//
//---------------------------------------------------------------------------

int MN_TextBWidth(char *text)
{
	char c;
	int width;
	patch_t *p;

	width = 0;
	while((c = *text++) != 0)
	{
		if(c < 33)
		{
			width += 5;
		}
		else
		{
			p = W_CacheLumpNum(FontBBaseLump+c-33, PU_CACHE);
			width += p->width-1;
		}
	}
	return(width);
}

//---------------------------------------------------------------------------
//
// PROC MN_Ticker
//
//---------------------------------------------------------------------------

void MN_Ticker(void)
{
	// Background darkening. First choose the right direction.
	if(MenuActive)
	{
		if(menuDark < menuDarkMax) menuDarkDir = 1;
	}
	else
	{
		if(menuDark > 0) menuDarkDir = -1;
	}
	// Make a modification, if needed.
	if(menuDarkDir)
	{
		menuDark += menuDarkDir * menuDarkSpeed;
		if(menuDark < 0) menuDark = 0;
		if(menuDark > menuDarkMax) menuDark = menuDarkMax;
	}

	if(!MenuActive) return;
	MenuTime++;
}

//---------------------------------------------------------------------------
//
// PROC DrawMessage
//
//---------------------------------------------------------------------------

void DrawMessage(void)
{
	player_t *player;

	player = &players[consoleplayer];
	if(player->messageTics <= 0 || !player->message)
	{ // No message
		return;
	}
	MN_DrTextA(player->message, 160-MN_TextAWidth(player->message)/2, 1);
}

//---------------------------------------------------------------------------
//
// PROC MN_Drawer
//
//---------------------------------------------------------------------------

char *QuitEndMsg[] =
{
	"ARE YOU SURE YOU WANT TO QUIT?",
	"ARE YOU SURE YOU WANT TO END THE GAME?",
	"DO YOU WANT TO QUICKSAVE THE GAME NAMED",
	"DO YOU WANT TO QUICKLOAD THE GAME NAMED"
};

void MN_Drawer(void)
{
	int i;
	int x;
	int y;
	MenuItem_t *item;
	char *selName;
	float alpha = menuDark/menuDarkMax;

	DrawMessage();

/*	if(players[displayplayer].plr->mo)
	{
		char buff[80];
		sprintf(buff, "%i, %i", players[displayplayer].plr->mo->x >> 16,
			players[displayplayer].plr->mo->y >> 16);
		MN_DrTextA(buff, 0, 10);
	}*/

	// FPS.
	if(showFPS)
	{
		char fpsbuff[80];
		sprintf(fpsbuff, "%d FPS", gi.FrameRate());
		MN_DrTextA(fpsbuff, 320-MN_TextAWidth(fpsbuff), 0);
		gi.Update(DDUF_TOP);
	}

	// Does the background need to be darkened?
	if(menuDark > 0)
	{
		gi.Update(DDUF_FULLSCREEN | DDUF_BORDER);
		gi.GL_SetNoTexture();
		gi.GL_DrawRect(0, 0, 320, 200, 0, 0, 0, menuDark);
	}

	if(MenuActive == false)
	{
		if(askforquit)
		{
			gl.Color4f(1, 1, 1, 1-alpha);
			MN_DrTextA_CS(QuitEndMsg[typeofask-1], 160-
				MN_TextAWidth(QuitEndMsg[typeofask-1])/2, 80);
			if(typeofask == 3)
			{
				MN_DrTextA_CS(SlotText[quicksave-1], 160-
					MN_TextAWidth(SlotText[quicksave-1])/2, 90);
				MN_DrTextA_CS("?", 160+
					MN_TextAWidth(SlotText[quicksave-1])/2, 90);
			}
			if(typeofask == 4)
			{
				MN_DrTextA_CS(SlotText[quickload-1], 160-
					MN_TextAWidth(SlotText[quickload-1])/2, 90);
				MN_DrTextA_CS("?", 160+
					MN_TextAWidth(SlotText[quickload-1])/2, 90);
			}
			gi.Update(DDUF_FULLSCREEN);
		}
	}
	if(MenuActive || menuDark > 0)
	{
		gl.Color4f(1, 1, 1, alpha);
		gi.Update(DDUF_FULLSCREEN);
		if(InfoType)
		{
			MN_DrawInfo();
			return;
		}
		if(screenblocks < 10)
		{
			gi.Update(DDUF_BORDER);
		}
		if(CurrentMenu->drawFunc != NULL)
		{
			CurrentMenu->drawFunc();
		}
/*		x = CurrentMenu->x;
		y = CurrentMenu->y;
		for(i=0, item=CurrentMenu->items + CurrentMenu->firstItem; 
			i<CurrentMenu->numVisItems && CurrentMenu->firstItem + i < CurrentMenu->itemCount; 
			i++, y += CurrentMenu->itemHeight, item++)
		{
			if(item->type != ITT_EMPTY || item->text)
			{
				// Decide which color to use.
				if(item->type == ITT_EMPTY)
					gi.GL_SetColorAndAlpha(.95f, 0, 0, alpha); // Red for titles.
				else
					gi.GL_SetColorAndAlpha(1, 1, 1, alpha);

				if(item->text)
					CurrentMenu->textDrawer(item->text, x, y);
			}
		}
		// Back to normal color.
		gi.GL_SetColorAndAlpha(1, 1, 1, alpha);
*/
		x = CurrentMenu->x;
		y = CurrentMenu->y;
/*		item = CurrentMenu->items;
		for(i = 0; i < CurrentMenu->itemCount; i++)
		{
			if(item->type != ITT_EMPTY && item->text)
			{
				MN_DrTextB(item->text, x, y);
			}
			y += ITEM_HEIGHT;
			item++;
		}*/
		for(i=0, item = CurrentMenu->items + CurrentMenu->firstItem; 
			i < CurrentMenu->numVisItems && CurrentMenu->firstItem + i < CurrentMenu->itemCount; 
			i++, y += CurrentMenu->itemHeight, item++)
		{
			if(item->type != ITT_EMPTY || item->text)
			{
				// Decide which color to use.
				if(item->type == ITT_EMPTY)
					gl.Color4f(.4f, .8f, .4f, alpha); // Green for titles.
				else
					gl.Color4f(1, 1, 1, alpha);

				if(item->text)
					CurrentMenu->textDrawer(item->text, x, y);
			}
		}
		// Back to normal color.
		gl.Color4f(1, 1, 1, alpha);

		y = CurrentMenu->y + ((CurrentItPos-CurrentMenu->firstItem) * CurrentMenu->itemHeight) 
			+ SELECTOR_YOFFSET - (10 - CurrentMenu->itemHeight/2);
		selName = MenuTime&16 ? "M_SLCTR1" : "M_SLCTR2";
		gi.GL_DrawPatchCS(x+SELECTOR_XOFFSET, y, W_GetNumForName(selName));
	}
}

//---------------------------------------------------------------------------
//
// PROC DrawMainMenu
//
//---------------------------------------------------------------------------

static void DrawMainMenu(void)
{
	int frame;

	frame = (MenuTime/3)%18;
	gi.GL_DrawPatchCS(88, 0, W_GetNumForName("M_HTIC"));
	gi.GL_DrawPatchCS(40, 10, SkullBaseLump+(17-frame));
	gi.GL_DrawPatchCS(232, 10, SkullBaseLump+frame);
}

//---------------------------------------------------------------------------
//
// PROC DrawEpisodeMenu
//
//---------------------------------------------------------------------------

static void DrawEpisodeMenu(void)
{
}

//---------------------------------------------------------------------------
//
// PROC DrawSkillMenu
//
//---------------------------------------------------------------------------

static void DrawSkillMenu(void)
{
}

//---------------------------------------------------------------------------
//
// PROC DrawFilesMenu
//
//---------------------------------------------------------------------------

static void DrawFilesMenu(void)
{
// clear out the quicksave/quickload stuff
	quicksave = 0;
	quickload = 0;
	players[consoleplayer].message = NULL;
	players[consoleplayer].messageTics = 1;
}

//---------------------------------------------------------------------------
//
// PROC DrawLoadMenu
//
//---------------------------------------------------------------------------

static void DrawLoadMenu(void)
{
	MN_DrTextB_CS("LOAD GAME", 160-MN_TextBWidth("LOAD GAME")/2, 10);
	if(!slottextloaded)
	{
		MN_LoadSlotText();
	}
	DrawFileSlots(&LoadMenu);
}

//---------------------------------------------------------------------------
//
// PROC DrawSaveMenu
//
//---------------------------------------------------------------------------

static void DrawSaveMenu(void)
{
	MN_DrTextB_CS("SAVE GAME", 160-MN_TextBWidth("SAVE GAME")/2, 10);
	if(!slottextloaded)
	{
		MN_LoadSlotText();
	}
	DrawFileSlots(&SaveMenu);
}

//===========================================================================
//
// MN_LoadSlotText
//
//              Loads in the text message for each slot
//===========================================================================

void MN_LoadSlotText(void)
{
	FILE *fp;
	int             count;
	int             i;
	char    name[256];

	for (i = 0; i < 6; i++)
	{
		if(cdrom)
		{
			sprintf(name, SAVEGAMENAMECD"%d.hsg", i);
		}
		else
		{
			sprintf(name, SAVEGAMENAME"%d.hsg", i);
		}
		fp = fopen(name, "rb+");
		if (!fp)
		{
			SlotText[i][0] = 0; // empty the string
			SlotStatus[i] = 0;
			continue;
		}
		count = fread(&SlotText[i], SLOTTEXTLEN, 1, fp);
		fclose(fp);
		SlotStatus[i] = 1;
	}
	slottextloaded = true;
}

//---------------------------------------------------------------------------
//
// PROC DrawFileSlots
//
//---------------------------------------------------------------------------

static void DrawFileSlots(Menu_t *menu)
{
	int i;
	int x;
	int y;

	x = menu->x;
	y = menu->y;
	for(i = 0; i < 6; i++)
	{
		gi.GL_DrawPatchCS(x, y, W_GetNumForName("M_FSLOT"));
		if(SlotStatus[i])
		{
			MN_DrTextA_CS(SlotText[i], x+5, y+5);
		}
		y += ITEM_HEIGHT;
	}
}

//---------------------------------------------------------------------------
//
// PROC DrawOptionsMenu
//
//---------------------------------------------------------------------------

static void DrawOptionsMenu(void)
{
/*	if(messageson)
	{
		MN_DrTextB("ON", 196, 50);
	}
	else
	{
		MN_DrTextB("OFF", 196, 50);
	}
	DrawSlider(&OptionsMenu, 3, 10, mouseSensitivityX);*/

	gi.GL_DrawPatchCS(88, 0, W_GetNumForName("M_HTIC"));
	MN_DrTextB_CS("OPTIONS", 154-MN_TextBWidth("OPTIONS")/2, 56);
}

//---------------------------------------------------------------------------
//
// PROC DrawOptions2Menu
//
//---------------------------------------------------------------------------

static void DrawOptions2Menu(void)
{
/*	DrawSlider(&Options2Menu, 1, 9, screenblocks-3);
	DrawSlider(&Options2Menu, 3, 16, snd_MaxVolume);
	DrawSlider(&Options2Menu, 5, 16, snd_MusicVolume);*/

	Menu_t *menu = &Options2Menu;
	char *musDevStr[3] = { "NONE", "MIDI", "CD" };
	char *freqStr[4] = { "11 KHZ", "22 KHZ", "INVALID!", "44 KHZ" };
	//int temp = (int) (*(float*) gi.GetCVar("s_reverbVol")->ptr * 10 + .5f);

	DrawSlider(menu, 1, 18, gi.Get(DD_SFX_VOLUME)/15);
	DrawSlider(menu, 4, 18, gi.Get(DD_MIDI_VOLUME)/15);
//	DrawSlider(menu, 7, 18, gi.CD(DD_GET_VOLUME,0)/15);
	MN_DrTextA_CS(musDevStr[gi.Get(DD_MUSIC_DEVICE)], menu->x + 
		MN_TextAWidth("MUSIC DEVICE : "), menu->y + menu->itemHeight*6);
/*	MN_DrTextA_CS(*(int*) gi.GetCVar("s_3d")->ptr? "ON" : "OFF",
		menu->x + MN_TextAWidth("3D SOUNDS : "), menu->y + menu->itemHeight*10);
	DrawSlider(menu, 12, 11, temp);*/
	MN_DrTextA_CS(freqStr[*(int*) gi.GetCVar("s_resample")->ptr - 1], 
		menu->x + MN_TextAWidth("SFX FREQUENCY : "), menu->y + menu->itemHeight*7);
	MN_DrTextA_CS(*(int*) gi.GetCVar("s_16bit")->ptr? "ON" : "OFF",
		menu->x + MN_TextAWidth("16 BIT INTERPOLATION : "), menu->y + menu->itemHeight*8);
}

static boolean SCMusicDevice(int option)
{
	int snd_MusicDevice = gi.Get(DD_MUSIC_DEVICE);
	
	if(option == RIGHT_DIR)
	{
		if(snd_MusicDevice < 1) snd_MusicDevice++;
	}
	else if(snd_MusicDevice > 0) snd_MusicDevice--;

	// Setup the music.
	gi.SetMusicDevice(snd_MusicDevice);
	
	// Restart the song of the current map.
	S_StartSong(gamemap, true);
	return true;
}

static void DrawGameplayMenu(void)
{
	Menu_t *menu = &GameplayMenu;
	char *xhairnames[7] = { "NONE", "CROSS", "ANGLES", "SQUARE",
		"OPEN SQUARE", "DIAMOND", "V" };
	
	MN_DrTextA_CS(messageson? "YES" : "NO", 
		menu->x+MN_TextAWidth("MESSAGES : "), menu->y);
	MN_DrTextA_CS((alwaysRun)? "YES" : "NO", 
		menu->x+MN_TextAWidth("ALWAYS RUN : "), menu->y+menu->itemHeight);
	MN_DrTextA_CS((lookSpring)? "YES" : "NO", 
		menu->x+MN_TextAWidth("LOOKSPRING : "), menu->y + menu->itemHeight*2);
	MN_DrTextA_CS((noAutoAim)? "YES" : "NO", 
		menu->x+MN_TextAWidth("NO AUTOAIM : "), menu->y + menu->itemHeight*3);
	MN_DrTextA_CS((showFullscreenMana)? "YES" : "NO", 
		menu->x+MN_TextAWidth("FULLSCREEN AMMO : "), menu->y + menu->itemHeight*4);
	MN_DrTextA_CS(xhairnames[xhair], 
		menu->x+MN_TextAWidth("CROSSHAIR : "), menu->y + menu->itemHeight*5);
	DrawSlider(menu, 7, 9, xhairSize);
	DrawSlider(menu, 10, 9, screenblocks-3);
	DrawSlider(menu, 13, 20, sbarscale-1);
}

static void DrawGraphicsMenu(void)
{
	char *mipStr[6] = 
	{
		"N", "L", "N, MIP N", "L, MIP N", "N, MIP L", "L, MIP L"
	};
	char *texQStr[9] =
	{
		"0 - MINIMUM",
		"1 - VERY LOW",
		"2 - LOW",
		"3 - POOR",
		"4 - AVERAGE",
		"5 - GOOD",
		"6 - HIGH",
		"7 - VERY HIGH",
		"8 - MAXIMUM"
	};
	Menu_t *menu = &GraphicsMenu;
	cvar_t *cv = gi.GetCVar("r_texquality");

	DrawSlider(menu, 1, 5, gi.Get(DD_SKY_DETAIL)-3);
	MN_DrTextB_CS(mipStr[gi.Get(DD_MIPMAPPING)], menu->x+MN_TextBWidth("MIPMAPPING : ")+8,
		menu->y+menu->itemHeight*2);
	MN_DrTextB_CS(gi.Get(DD_SMOOTH_IMAGES)? "YES" : "NO",
		menu->x+MN_TextBWidth("SMOOTH GFX : ")+8, menu->y+menu->itemHeight*3);
	
	MN_DrTextB_CS(*(int*) gi.GetCVar("borderupd")->ptr? "YES" : "NO",
		menu->x+MN_TextBWidth("UPDATE BORDERS : ")+8, menu->y+menu->itemHeight*4);
	
	MN_DrTextB_CS(texQStr[*(int*) cv->ptr], menu->x+MN_TextBWidth("TEX QUALITY : ")+8, 
		menu->y+menu->itemHeight*5);

	// This isn't very good programming, but here we can reset the 
	// current resolution selection.
	selRes = findRes(gi.Get(DD_SCREEN_WIDTH), gi.Get(DD_SCREEN_HEIGHT));
}

static void DrawEffectsMenu(void)
{
	char	*dlblendStr[3] = { "MULTIPLY", "ADD", "NONE" };
	char	*flareStr[6] = { "OFF", "1", "2", "3", "4", "5" };
	Menu_t	*menu = &EffectsMenu;
	int		x = menu->x + 140, y = menu->y, h = menu->itemHeight;
	int		temp;

	MN_DrTextA_CS(showFPS? "YES" : "NO", x, y);
/*	MN_DrTextA_CS(translucentIceCorpse? "YES" : "NO", 
		menu->x + MN_TextAWidth("FROZEN THINGS TRANSLUCENT : "), y+h);*/
	MN_DrTextA_CS(*(int*) gi.GetCVar("dynlights")->ptr? "ON" : "OFF", x, y+h);
	MN_DrTextA_CS(dlblendStr[*(int*) gi.GetCVar("dlblend")->ptr], x, y+h*2);
	MN_DrTextA_CS(*(int*) gi.GetCVar("sprlight")->ptr? "YES" : "NO", x, y+h*3);
	temp = (int) (*(float*) gi.GetCVar("dlfactor")->ptr * 10 + .5f);
	DrawSlider(menu, 5, 11, temp);
	MN_DrTextA_CS(flareStr[*(int*) gi.GetCVar("flares")->ptr], x, y+h*7);
	DrawSlider(menu, 9, 11, *(int*) gi.GetCVar("flareintensity")->ptr / 10);
	DrawSlider(menu, 12, 11, *(int*) gi.GetCVar("flaresize")->ptr);
	MN_DrTextA_CS(*(int*) gi.GetCVar("spralign")->ptr? "VIEW PLANE" : "CAMERA", x, y+h*14);
	MN_DrTextA_CS(*(int*) gi.GetCVar("sprblend")->ptr? "ON" : "OFF", x, y+h*15);
}

static void DrawResolutionMenu(void)
{
	char buffer[40];
	Menu_t *menu = &ResolutionMenu;
	
	if(selRes == -1)
		strcpy(buffer, "NOT AVAILABLE");
	else
	{
		sprintf(buffer, "%d X %d%s",
			resolutions[selRes].width,
			resolutions[selRes].height,
			selRes == findRes(gi.Get(DD_DEFAULT_RES_X), gi.Get(DD_DEFAULT_RES_Y))? 
				" (DEFAULT)" : "");			
	}
	MN_DrTextA_CS(buffer, menu->x+8, menu->y+menu->itemHeight+4);
}

static boolean SCResSelector(int option)
{
	if(option == RIGHT_DIR)
	{
		if(resolutions[selRes+1].width)
			selRes++;
	}
	else if(selRes > 0) selRes--;
	return true;
}

static boolean SCResMakeCurrent(int option)
{
	if(gi.ChangeResolution(resolutions[selRes].width, resolutions[selRes].height))
		P_SetMessage(&players[consoleplayer], "RESOLUTION CHANGED", true);
	else
		P_SetMessage(&players[consoleplayer], "RESOLUTION CHANGE FAILED", true);
	return true;
}

static boolean SCResMakeDefault(int option)
{
	gi.Set(DD_DEFAULT_RES_X, resolutions[selRes].width);
	gi.Set(DD_DEFAULT_RES_Y, resolutions[selRes].height);
	return true;
}

static boolean SCLookSpring(int option)
{
	lookSpring ^= 1;
	if(lookSpring)
		P_SetMessage(&players[consoleplayer], "USING LOOKSPRING", true);
	else
		P_SetMessage(&players[consoleplayer], "NO LOOKSPRING", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCAutoAim(int option)
{
	P_SetMessage(&players[consoleplayer], (noAutoAim^=1)? "NO AUTOAIM" : "AUTOAIM ON", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCFullscreenMana(int option)
{
	showFullscreenMana ^= 1;
	if(showFullscreenMana)
	{
		P_SetMessage(&players[consoleplayer], "AMMO SHOWN IN FULLSCREEN VIEW", true);
	}
	else
	{
		P_SetMessage(&players[consoleplayer], "NO AMMO IN FULLSCREEN VIEW", true);
	}
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCCrosshair(int option)
{
	xhair += option==RIGHT_DIR? 1 : -1;
	if(xhair < 0) xhair = 0;
	if(xhair > NUM_XHAIRS) xhair = NUM_XHAIRS;
	return true;
}

static boolean SCCrosshairSize(int option)
{
	xhairSize += option==RIGHT_DIR? 1 : -1;
	if(xhairSize < 0) xhairSize = 0;
	if(xhairSize > 9) xhairSize = 9;
	return true;
}

static boolean SCSkyDetail(int option)
{
	int skyDetail = gi.Get(DD_SKY_DETAIL);

	if(option == RIGHT_DIR)
	{
		if(skyDetail < 7)
		{
			skyDetail++;
		}
	}
	else if(skyDetail > 3)
	{
		skyDetail--;
	}
	gi.SkyParams(DD_SKY, DD_COLUMNS, skyDetail);
	return true;
}

static boolean SCMipmapping(int option)
{
	int mipmapping = gi.Get(DD_MIPMAPPING);

	if(option == RIGHT_DIR)
	{
		if(mipmapping < 5) mipmapping++;
	}
	else if(mipmapping > 0) mipmapping--;

	gi.GL_TexFilterMode(DD_TEXTURES, mipmapping);
	return true;
}

static boolean SCLinearRaw(int option)
{
	int linearRaw = gi.Get(DD_SMOOTH_IMAGES);

	linearRaw ^= 1;
	if(linearRaw)
	{
		P_SetMessage(&players[consoleplayer], "GRAPHICS SCREENS USE LINEAR INTERPOLATION", true);
	}
	else
	{
		P_SetMessage(&players[consoleplayer], "GRAPHICS SCREENS AREN'T INTERPOLATED", true);
	}
	S_StartSound(NULL, sfx_chat);
	gi.GL_TexFilterMode(DD_RAWSCREENS, linearRaw);
	return true;
}

static boolean SCBorderUpdate(int option)
{
	cvar_t	*cv = gi.GetCVar("borderupd");

	P_SetMessage(&players[consoleplayer], (*(int*) cv->ptr ^= 1)? 
		"BORDERS UPDATED EVERY FRAME" : "BORDERS UPDATED WHEN NEEDED", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static void ChangeIntCVar(char *name, int delta)
{
	cvar_t	*cv = gi.GetCVar(name);
	int		val = *(int*) cv->ptr;

	val += delta;
	if(val > cv->max) val = cv->max;
	if(val < cv->min) val = cv->min;
	*(int*) cv->ptr = val;
}

static boolean SCTexQuality(int option)
{
	ChangeIntCVar("r_texquality", option==RIGHT_DIR? 1 : -1);
	return true;
}

static boolean SCForceTexReload(int option)
{
	gi.GL_ClearTextureMem();
	P_SetMessage(&players[consoleplayer], "ALL TEXTURES DELETED", true);
	return true;
}

static boolean SCFPSCounter(int option)
{
	showFPS ^= 1;
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCDynLights(int option)
{
	cvar_t	*cvDL = gi.GetCVar("dynlights");

	P_SetMessage(&players[consoleplayer], (*(int*) cvDL->ptr ^= 1)? 
		"DYNAMIC LIGHTS ENABLED" : "DYNAMIC LIGHTS DISABLED", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCDLBlend(int option)
{
	ChangeIntCVar("dlblend", option==RIGHT_DIR? 1 : -1);
	return true;
}

static boolean SCDLIntensity(int option)
{
	cvar_t	*cv = gi.GetCVar("dlfactor");
	float	val = *(float*) cv->ptr;

	val += option==RIGHT_DIR? .1f : -.1f;
	if(val > cv->max) val = cv->max;
	if(val < cv->min) val = cv->min;
	*(float*) cv->ptr = val;
	return true;
}

static boolean SCFlares(int option)
{
	ChangeIntCVar("flares", option==RIGHT_DIR? 1 : -1);
	return true;
}

static boolean SCFlareIntensity(int option)
{
	ChangeIntCVar("flareintensity", option==RIGHT_DIR? 10 : -10);
	return true;
}

static boolean SCFlareSize(int option)
{
	ChangeIntCVar("flaresize", option==RIGHT_DIR? 1 : -1);
	return true;
}

static boolean SCSpriteAlign(int option)
{
	cvar_t *cv = gi.GetCVar("spralign");

	P_SetMessage(&players[consoleplayer], (*(int*) cv->ptr ^= 1)? 
		"SPRITES ALIGNED TO VIEW PLANE" : "SPRITES ALIGNED TO CAMERA", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCSpriteBlending(int option)
{
	cvar_t *cv = gi.GetCVar("sprblend");

	P_SetMessage(&players[consoleplayer], (*(int*) cv->ptr ^= 1)? 
		"ADDITIVE BLENDING FOR EXPLOSIONS" : "NO SPRITE BLENDING", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCSpriteLight(int option)
{
	cvar_t *cv = gi.GetCVar("sprlight");

	P_SetMessage(&players[consoleplayer], (*(int*) cv->ptr ^= 1)? 
		"SPRITES LIT BY DYNAMIC LIGHTS" : "SPRITES NOT LIGHT BY LIGHTS", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

//---------------------------------------------------------------------------
//
// PROC DrawMouseOptsMenu
//
//---------------------------------------------------------------------------

static void DrawMouseOptsMenu(void)
{
	Menu_t *menu = &MouseOptsMenu;

	MN_DrTextB_CS((gi.Get(DD_MOUSE_INVERSE_Y))? "YES" : "NO", menu->x+
		MN_TextBWidth(menu->items[0].text)+12, menu->y);
	MN_DrTextB_CS((usemlook)? "YES" : "NO", menu->x+
		MN_TextBWidth(menu->items[1].text)+12, menu->y+menu->itemHeight);
	MN_DrTextB_CS((mlookInverseY)? "YES" : "NO", menu->x+
		MN_TextBWidth(menu->items[2].text)+12, menu->y+menu->itemHeight*2);
	DrawSlider(&MouseOptsMenu, 4, 18, mouseSensitivityX);
	DrawSlider(&MouseOptsMenu, 6, 18, mouseSensitivityY);
}

static boolean SCControlConfig(int option)
{
	if(grabbing != NULL) gi.Error("SCControlConfig: grabbing is not NULL!!!\n");
	
	grabbing = controls + option;
	return true;
}

void spacecat(char *str, const char *catstr)
{
	if(str[0]) strcat(str, " ");
	
	// Also do some filtering.
	switch(catstr[0])
	{
	case '\\':
		strcat(str, "bkslash");
		break;
	
	case '[':
		strcat(str, "sqbtopen");
		break;

	case ']':
		strcat(str, "sqbtclose");
		break;

	default:
		strcat(str, catstr);
	}
}

static void DrawControlsMenu(void)
{
	int			i, k;
	char		controlCmd[80];
	char		buff[80], prbuff[80], *token;
	Menu_t		*menu = CurrentMenu;
	MenuItem_t	*item = menu->items + menu->firstItem;
	Control_t	*ctrl;

	MN_DrTextB_CS("CONTROLS", 120, 4);

	// Draw the page arrows.
	token = (!menu->firstItem || MenuTime&8)? "invgeml2" : "invgeml1";
	gi.GL_DrawPatchCS(menu->x, menu->y-16, W_GetNumForName(token));
	token = (menu->firstItem+menu->numVisItems >= menu->itemCount || MenuTime&8)? 
		"invgemr2" : "invgemr1";
	gi.GL_DrawPatchCS(312-menu->x, menu->y-16, W_GetNumForName(token));

	for(i=0; i<menu->numVisItems && menu->firstItem+i < menu->itemCount; i++, item++)
	{
		if(item->type == ITT_EMPTY) continue;
		
		ctrl = controls + item->option;
		strcpy(buff, "");
		if(ctrl->flags & CLF_ACTION)
			sprintf(controlCmd, "+%s", ctrl->command);
		else
			strcpy(controlCmd, ctrl->command);
		// Let's gather all the bindings for this command.
		if(!gi.BindingsForCommand(controlCmd, buff))
			strcpy(buff, "NONE");
	
		// Now we must interpret what the bindings string says.
		// It may contain characters we can't print.
		strcpy(prbuff, "");
		token = strtok(buff, " ");
		while(token)
		{
			if(token[0] == '+')
				spacecat(prbuff, token+1);
			if(token[0] == '*' && !(ctrl->flags & CLF_REPEAT) || token[0] == '-')
				spacecat(prbuff, token);
			token = strtok(NULL, " ");
		}
		strupr(prbuff);
		for(k=0; prbuff[k]; k++)
			if(prbuff[k] < 32 || prbuff[k] > 'Z')
				prbuff[k] = ' ';

		if(grabbing == ctrl)
		{
			// We're grabbing for this control.
			spacecat(prbuff, "...");
		}

		MN_DrTextA_CS(prbuff, menu->x+134, menu->y + i*menu->itemHeight);
	}
}

static boolean SCJoySensi(int option)
{
	if(option == RIGHT_DIR)
	{
		if(joySensitivity < 9) joySensitivity++;
	}
	else if(joySensitivity > 1) joySensitivity--;
	return true;
}

static void DrawJoyConfigMenu()
{
	Menu_t	*menu = &JoyConfigMenu;

	DrawSlider(menu, 1, 9, joySensitivity-1);	
	MN_DrTextB_CS((usejlook)? "YES" : "NO", menu->x+MN_TextBWidth(menu->items[2].text)+12, 
		menu->y+menu->itemHeight*2);
	MN_DrTextB_CS((jlookInverseY)? "YES" : "NO", menu->x+MN_TextBWidth(menu->items[3].text)+12, 
		menu->y+menu->itemHeight*3);
	MN_DrTextB_CS(povLookAround? "YES" : "NO", menu->x+MN_TextBWidth(menu->items[4].text)+12,
		menu->y+menu->itemHeight*4);
}

//---------------------------------------------------------------------------
//
// PROC SCNetCheck
//
//---------------------------------------------------------------------------

static boolean SCNetCheck(int option)
{
	if(!netgame)
	{ // okay to go into the menu
		return true;
	}
	switch(option)
	{
		case 1:
			P_SetMessage(&players[consoleplayer],
				"YOU CAN'T START A NEW GAME IN NETPLAY!", true);
			break;
		case 2:
			P_SetMessage(&players[consoleplayer],
				"YOU CAN'T LOAD A GAME IN NETPLAY!", true);
			break;
		default:
			break;
	}
	MenuActive = false;
	return false;
}

//---------------------------------------------------------------------------
//
// PROC SCQuitGame
//
//---------------------------------------------------------------------------

static boolean SCQuitGame(int option)
{
	gi.OpenConsole(false);
	MenuActive = false;
	askforquit = true;
	typeofask = 1; //quit game
	if(!netgame && !demoplayback)
	{
		paused = true;
	}
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCEndGame
//
//---------------------------------------------------------------------------

static boolean SCEndGame(int option)
{
	if(demoplayback || netgame)
	{
		return false;
	}
	MenuActive = false;
	askforquit = true;
	typeofask = 2; //endgame
	if(!netgame && !demoplayback)
	{
		paused = true;
	}
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCMessages
//
//---------------------------------------------------------------------------

static boolean SCMessages(int option)
{
	messageson ^= 1;
	if(messageson)
	{
		P_SetMessage(&players[consoleplayer], "MESSAGES ON", true);
	}
	else
	{
		P_SetMessage(&players[consoleplayer], "MESSAGES OFF", true);
	}
	S_StartSound(NULL, sfx_chat);
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCLoadGame
//
//---------------------------------------------------------------------------

static boolean SCLoadGame(int option)
{
	char name[256];

	if(!SlotStatus[option])
	{ // slot's empty...don't try and load
		return false;
	}
	if(cdrom)
	{
		sprintf(name, SAVEGAMENAMECD"%d.hsg", option);
	}
	else
	{
		sprintf(name, SAVEGAMENAME"%d.hsg", option);
	}
	G_LoadGame(name);
	MN_DeactivateMenu();
	//BorderNeedRefresh = true;
	gi.Update(DDUF_BORDER);
	if(quickload == -1)
	{
		quickload = option+1;
		players[consoleplayer].message = NULL;
		players[consoleplayer].messageTics = 1;
	}
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCSaveGame
//
//---------------------------------------------------------------------------

static boolean SCSaveGame(int option)
{
	char *ptr;

	if(!FileMenuKeySteal)
	{
		FileMenuKeySteal = true;
		strcpy(oldSlotText, SlotText[option]);
		ptr = SlotText[option];
		while(*ptr)
		{
			ptr++;
		}
		*ptr = '[';
		*(ptr+1) = 0;
		SlotStatus[option]++;
		currentSlot = option;
		slotptr = ptr-SlotText[option];
		return false;
	}
	else
	{
		G_SaveGame(option, SlotText[option]);
		FileMenuKeySteal = false;
		MN_DeactivateMenu();
	}
	//BorderNeedRefresh = true;
	gi.Update(DDUF_BORDER);
	if(quicksave == -1)
	{
		quicksave = option+1;
		players[consoleplayer].message = NULL;
		players[consoleplayer].messageTics = 1;
	}
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCEpisode
//
//---------------------------------------------------------------------------

static boolean SCEpisode(int option)
{
	if(shareware && option > 1)
	{
		P_SetMessage(&players[consoleplayer],
			"ONLY AVAILABLE IN THE REGISTERED VERSION", true);
	}
	else
	{
		MenuEpisode = option;
		SetMenu(MENU_SKILL);
	}
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCSkill
//
//---------------------------------------------------------------------------

static boolean SCSkill(int option)
{
	G_DeferedInitNew(option, MenuEpisode, 1);
	MN_DeactivateMenu();
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCMouseSensi
//
//---------------------------------------------------------------------------

static boolean SCMouseSensi(int option)
{
	if(option == RIGHT_DIR)
	{
		if(mouseSensitivityX < 9)
		{
			mouseSensitivityX++;
		}
	}
	else if(mouseSensitivityX)
	{
		mouseSensitivityX--;
	}
	mouseSensitivityY = mouseSensitivityX;
	return true;
}

/*//---------------------------------------------------------------------------
//
// PROC SCSfxVolume
//
//---------------------------------------------------------------------------

static boolean SCSfxVolume(int option)
{
	if(option == RIGHT_DIR)
	{
		if(snd_MaxVolume < 15)
		{
			snd_MaxVolume++;
		}
	}
	else if(snd_MaxVolume)
	{
		snd_MaxVolume--;
	}
	S_SetMaxVolume(false); // don't recalc the sound curve, yet
	soundchanged = true; // we'll set it when we leave the menu
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCMusicVolume
//
//---------------------------------------------------------------------------

static boolean SCMusicVolume(int option)
{
	if(option == RIGHT_DIR)
	{
		if(snd_MusicVolume < 15)
		{
			snd_MusicVolume++;
		}
	}
	else if(snd_MusicVolume)
	{
		snd_MusicVolume--;
	}
	S_SetMusicVolume();
	return true;
}*/

static boolean SCSfxVolume(int option)
{
	int vol = gi.Get(DD_SFX_VOLUME);

	vol += option==RIGHT_DIR? 15 : -15;
	//soundchanged = true; // we'll set it when we leave the menu
	gi.SetSfxVolume(vol);
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCMusicVolume
//
//---------------------------------------------------------------------------

static boolean SCMusicVolume(int option)
{
	int vol = gi.Get(DD_MIDI_VOLUME);

	vol += option==RIGHT_DIR? 15 : -15;
	gi.SetMIDIVolume(vol);
	return true;
}

static boolean SCSfxFrequency(int option)
{
	cvar_t	*cv = gi.GetCVar("s_resample");
	int		oldval = *(int*) cv->ptr, val = oldval;
	
	val += option==RIGHT_DIR? 1 : -1;
	if(val > 4) val = 4;
	if(val < 1) val = 1;
	if(val == 3)
	{
		if(oldval == 4) 
			val = 2; 
		else 
			val = 4;
	}
	*(int*) cv->ptr = val;
	return true;
}

static boolean SCSfx16bit(int option)
{
	cvar_t	*cv = gi.GetCVar("s_16bit");

	P_SetMessage(&players[consoleplayer], (*(int*) cv->ptr ^= 1)? 
		"16 BIT INTERPOLATION" : "8 BIT INTERPOLATION", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCStatusBarSize
//
//---------------------------------------------------------------------------

static boolean SCStatusBarSize(int option)
{
	if(option == RIGHT_DIR)
	{
		if(sbarscale < 20) sbarscale++;
	}
	else 
		if(sbarscale > 1) sbarscale--;

	R_SetViewSize(screenblocks, 0);
	return true;
}


//---------------------------------------------------------------------------
//
// PROC SCScreenSize
//
//---------------------------------------------------------------------------

static boolean SCScreenSize(int option)
{
	if(option == RIGHT_DIR)
	{
		if(screenblocks < 11)
		{
			screenblocks++;
		}
	}
	else if(screenblocks > 3)
	{
		screenblocks--;
	}
	R_SetViewSize(screenblocks, 0);//detailLevel);
	return true;
}

static boolean SCAlwaysRun(int option)
{
	alwaysRun ^= 1;
	if(alwaysRun)
	{
		P_SetMessage(&players[consoleplayer], "ALWAYS RUNNING", true);
	}
	else
	{
		P_SetMessage(&players[consoleplayer], "NORMAL RUNNING", true);
	}
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCMouseLook(int option)
{
	usemlook ^= 1;
	if(usemlook)
	{
		P_SetMessage(&players[consoleplayer], "MOUSE LOOK ON", true);
	}
	else
	{
		P_SetMessage(&players[consoleplayer], "MOUSE LOOK OFF", true);
	}
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCJoyLook(int option)
{
	P_SetMessage(&players[consoleplayer], (usejlook^=1)? "JOYSTICK LOOK ON" : "JOYSTICK LOOK OFF", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCPOVLook(int option)
{
	P_SetMessage(&players[consoleplayer], (povLookAround^=1)? "POV LOOK ON" : "POV LOOK OFF", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCInverseJoyLook(int option)
{
	P_SetMessage(&players[consoleplayer], (jlookInverseY^=1)? "INVERSE JOYLOOK" : "NORMAL JOYLOOK", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCMouseLookInverse(int option)
{
	mlookInverseY ^= 1;
	if(mlookInverseY)
		P_SetMessage(&players[consoleplayer], "INVERSE MOUSE LOOK", true);
	else
		P_SetMessage(&players[consoleplayer], "NORMAL MOUSE LOOK", true);
	S_StartSound(NULL, sfx_chat);
	return true;
}

static boolean SCInverseY(int option)
{
	int val = gi.Get(DD_MOUSE_INVERSE_Y);
		
	P_SetMessage(&players[consoleplayer], 
		(val^=1)? "INVERSE MOUSE Y AXIS" : "NORMAL MOUSE Y AXIS", true);
	gi.Set(DD_MOUSE_INVERSE_Y, val);
	S_StartSound(NULL, sfx_chat);
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCMouseXSensi
//
//---------------------------------------------------------------------------

static boolean SCMouseXSensi(int option)
{
	if(option == RIGHT_DIR)
	{
		if(mouseSensitivityX < 17)
		{
			mouseSensitivityX++;
		}
	}
	else if(mouseSensitivityX)
	{
		mouseSensitivityX--;
	}
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCMouseYSensi
//
//---------------------------------------------------------------------------

static boolean SCMouseYSensi(int option)
{
	if(option == RIGHT_DIR)
	{
		if(mouseSensitivityY < 17)
		{
			mouseSensitivityY++;
		}
	}
	else if(mouseSensitivityY)
	{
		mouseSensitivityY--;
	}
	return true;
}

//---------------------------------------------------------------------------
//
// PROC SCInfo
//
//---------------------------------------------------------------------------

static boolean SCInfo(int option)
{
	InfoType = 1;
	S_StartSound(NULL, sfx_dorcls);
	if(!netgame && !demoplayback)
	{
		paused = true;
	}
	return true;
}

// Set default bindings for unbound Controls.
void H_DefaultBindings()
{
	int			i;
	Control_t	*ctr;
	char		evname[80], cmd[256], buff[256];
	event_t		event;
	
	// Check all Controls.
	for(i=0; controls[i].command[0]; i++)
	{
		ctr = controls + i;
		// If this command is bound to something, skip it.
		sprintf(cmd, "%s%s", ctr->flags & CLF_ACTION? "+" : "",
			ctr->command);
		if(gi.BindingsForCommand(cmd, buff)) continue;

		// This Control has no bindings, set it to the default.
		sprintf(buff, "\"%s\"", ctr->command);
		if(ctr->defKey)
		{
			event.type = ev_keydown;
			event.data1 = ctr->defKey;
			gi.EventBuilder(evname, &event, false);
			sprintf(cmd, "%s %s %s", ctr->flags & CLF_REPEAT? "safebindr" : "safebind",
				evname+1, buff);
			gi.Execute(cmd, true);
		}
		if(ctr->defMouse)
		{
			event.type = ev_mousebdown;
			event.data1 = 1 << (ctr->defMouse-1);
			gi.EventBuilder(evname, &event, false);
			sprintf(cmd, "%s %s %s", ctr->flags & CLF_REPEAT? "safebindr" : "safebind",
				evname+1, buff);
			gi.Execute(cmd, true);
		}
		if(ctr->defJoy)
		{
			event.type = ev_joybdown;
			event.data1 = 1 << (ctr->defJoy-1);
			gi.EventBuilder(evname, &event, false);
			sprintf(cmd, "%s %s %s", ctr->flags & CLF_REPEAT? "safebindr" : "safebind",
				evname+1, buff);
			gi.Execute(cmd, true);
		}
	}
}

//---------------------------------------------------------------------------
//
// FUNC H_PrivilegedResponder
//
//---------------------------------------------------------------------------

int findtoken(char *string, char *token, char *delim)
{
	char *ptr = strtok(string, delim);
	while(ptr)
	{
		if(!stricmp(ptr, token)) return true;
		ptr = strtok(NULL, delim);
	}
	return false;
}

int H_PrivilegedResponder(event_t *event)
{
	// We're interested in key or button down events.
	if(grabbing && (event->type == ev_keydown || event->type == ev_mousebdown 
		|| event->type == ev_joybdown || event->type == ev_povdown))
	{
		// We'll grab this event.
		char cmd[256], buff[256], evname[80];
		boolean del = false;

		// Check for a cancel.
		if(event->type == ev_keydown)
		{
			if(event->data1 == '`') // Tilde clears everything.
			{
				if(grabbing->flags & CLF_ACTION)
					sprintf(cmd, "delbind +%s -%s", grabbing->command,
						grabbing->command);
				else
					sprintf(cmd, "delbind \"%s\"", grabbing->command);
				gi.Execute(cmd, true);
				grabbing = NULL;
				return true;
			}
			else if(event->data1 == DDKEY_ESCAPE)
			{
				grabbing = NULL;
				return true;
			}
		}

		// We shall issue a silent console command, but first we need
		// a textual representation of the event.
		gi.EventBuilder(evname, event, false); // "Deconstruct" into a name.

		// If this binding already exists, remove it.
		sprintf(cmd, "%s%s", grabbing->flags & CLF_ACTION? "+" : "",
			grabbing->command);
		if(gi.BindingsForCommand(cmd, buff))
			if(findtoken(buff, evname, " "))		// Get rid of it?
			{
				del = true;
				strcpy(buff, "");
			}
		if(!del) sprintf(buff, "\"%s\"", grabbing->command);
		sprintf(cmd, "%s %s %s", grabbing->flags & CLF_REPEAT? "bindr" : "bind",
			evname+1, buff);
		gi.Execute(cmd, false);//true);
		// We've finished the grab.
		grabbing = NULL;
		S_StartSound(NULL, sfx_chat);
		return true;
	}

	// Process the screen shot key right away.
	if(ravpic && event->data1 == DDKEY_F1)
	{
		if(event->type == ev_keydown) G_ScreenShot();
		// All F1 events are eaten.
		return true;
	}
	return false;
}

//---------------------------------------------------------------------------
//
// FUNC MN_Responder
//
//---------------------------------------------------------------------------

boolean MN_Responder(event_t *event)
{
	int key;
	int i;
	MenuItem_t *item;
	extern boolean automapactive;
	static boolean shiftdown;
	extern void D_StartTitle(void);
	char *textBuffer;

	if(F_Responder(event)) return true;

	if(event->data1 == DDKEY_RSHIFT)
	{
		shiftdown = (event->type == ev_keydown);
	}
	if(event->type != ev_keydown && event->type != ev_keyrepeat)
	{
		return(false);
	}
	key = event->data1;
	if(InfoType)
	{
		if(shareware)
		{
			InfoType = (InfoType+1)%5;
		}
		else
		{
			InfoType = (InfoType+1)%4;
		}
		if(key == DDKEY_ESCAPE)
		{
			InfoType = 0;
		}
		if(!InfoType)
		{
			paused = false;
			MN_DeactivateMenu();
			SB_state = -1; //refresh the statbar
			gi.Update(DDUF_BORDER);
			menuDark = 0;	// Darkness immediately gone.
		}
		S_StartSound(NULL, sfx_dorcls);
		return(true); //make the info screen eat the keypress
	}

	if(askforquit)
	{
		switch(key)
		{
			case 'y':
				if(askforquit)
				{
					switch(typeofask)
					{
						case 1:
							G_CheckDemoStatus();
							I_Quit();
							break;
						case 2:
							players[consoleplayer].messageTics = 0;
								//set the msg to be cleared
							players[consoleplayer].message = NULL;
							typeofask = 0;
							askforquit = false;
							paused = false;
//							I_SetPalette(W_CacheLumpName("PLAYPAL", PU_CACHE));
							D_StartTitle(); // go to intro/demo mode.
							break;
						case 3:
							P_SetMessage(&players[consoleplayer], "QUICKSAVING....", false);
							FileMenuKeySteal = true;
							SCSaveGame(quicksave-1);
							askforquit = false;
							typeofask = 0;
							//BorderNeedRefresh = true;
							gi.Update(DDUF_BORDER);
							return true;
						case 4:
							P_SetMessage(&players[consoleplayer], "QUICKLOADING....", false);
							SCLoadGame(quickload-1);
							askforquit = false;
							typeofask = 0;
							//BorderNeedRefresh = true;
							gi.Update(DDUF_BORDER);
							return true;
						default:
							return true; // eat the 'y' keypress
					}
				}
				return false;
			case 'n':
			case DDKEY_ESCAPE:
				if(askforquit)
				{
					players[consoleplayer].messageTics = 1; //set the msg to be cleared
					askforquit = false;
					typeofask = 0;
					paused = false;
					gi.Update(DDUF_FULLSCREEN | DDUF_BORDER);
					return true;
				}
				return false;
		}
		return false; // don't let the keys filter thru
	}
	if(MenuActive == false && !chatmodeon)
	{
		/*switch(key)
		{
			case DDKEY_MINUS:
				if(automapactive)
				{ // Don't screen size in automap
					return(false);
				}
				SCScreenSize(LEFT_DIR);
				S_StartSound(NULL, sfx_keyup);
				gi.Update(DDUF_BORDER | DDUF_FULLSCREEN);
				return(true);
			case DDKEY_EQUALS:
				if(automapactive)
				{ // Don't screen size in automap
					return(false);
				}
				SCScreenSize(RIGHT_DIR);
				S_StartSound(NULL, sfx_keyup);
				gi.Update(DDUF_BORDER | DDUF_FULLSCREEN);
				return(true);
#ifndef __NeXT__
			case DDKEY_F1: // help screen
				SCInfo(0); // start up info screens
				MenuActive = true;
				return(true);
			case DDKEY_F2: // save game
				if(gamestate == GS_LEVEL && !demoplayback)
				{
					MenuActive = true;
					FileMenuKeySteal = false;
					MenuTime = 0;
					CurrentMenu = &SaveMenu;
					CurrentItPos = CurrentMenu->oldItPos;
					if(!netgame && !demoplayback)
					{
						paused = true;
					}
					S_StartSound(NULL, sfx_dorcls);
					slottextloaded = false; //reload the slot text, when needed
				}
				return true;
			case DDKEY_F3: // load game
				if(SCNetCheck(2))
				{
					MenuActive = true;
					FileMenuKeySteal = false;
					MenuTime = 0;
					CurrentMenu = &LoadMenu;
					CurrentItPos = CurrentMenu->oldItPos;
					if(!netgame && !demoplayback)
					{
						paused = true;
					}
					S_StartSound(NULL, sfx_dorcls);
					slottextloaded = false; //reload the slot text, when needed
				}
				return true;
			case DDKEY_F4: // volume
				MenuActive = true;
				FileMenuKeySteal = false;
				MenuTime = 0;
				CurrentMenu = &Options2Menu;
				CurrentItPos = CurrentMenu->oldItPos;
				if(!netgame && !demoplayback)
				{
					paused = true;
				}
				S_StartSound(NULL, sfx_dorcls);
				slottextloaded = false; //reload the slot text, when needed
				return true;
			case DDKEY_F5: // F5 isn't used in Heretic. (detail level)
				return true;
			case DDKEY_F6: // quicksave
				if(gamestate == GS_LEVEL && !demoplayback)
				{
					if(!quicksave || quicksave == -1)
					{
						MenuActive = true;
						FileMenuKeySteal = false;
						MenuTime = 0;
						CurrentMenu = &SaveMenu;
						CurrentItPos = CurrentMenu->oldItPos;
						if(!netgame && !demoplayback)
						{
							paused = true;
						}
						S_StartSound(NULL, sfx_dorcls);
						slottextloaded = false; //reload the slot text, when needed
						quicksave = -1;
						P_SetMessage(&players[consoleplayer],
							"CHOOSE A QUICKSAVE SLOT", true);
					}
					else
					{
						askforquit = true;
						typeofask = 3;
						if(!netgame && !demoplayback)
						{
							paused = true;
						}
						S_StartSound(NULL, sfx_chat);
					}
				}
				return true;
			case DDKEY_F7: // endgame
				if(gamestate == GS_LEVEL && !demoplayback)
				{
					S_StartSound(NULL, sfx_chat);
					SCEndGame(0);
				}
				return true;
			case DDKEY_F8: // toggle messages
				SCMessages(0);
				return true;
			case DDKEY_F9: // quickload
				if(!quickload || quickload == -1)
				{
					MenuActive = true;
					FileMenuKeySteal = false;
					MenuTime = 0;
					CurrentMenu = &LoadMenu;
					CurrentItPos = CurrentMenu->oldItPos;
					if(!netgame && !demoplayback)
					{
						paused = true;
					}
					S_StartSound(NULL, sfx_dorcls);
					slottextloaded = false; //reload the slot text, when needed
					quickload = -1;
					P_SetMessage(&players[consoleplayer],
						"CHOOSE A QUICKLOAD SLOT", true);
				}
				else
				{
					askforquit = true;
					if(!netgame && !demoplayback)
					{
						paused = true;
					}
					typeofask = 4;
					S_StartSound(NULL, sfx_chat);
				}
				return true;
			case DDKEY_F10: // quit
				if(gamestate == GS_LEVEL)
				{
					SCQuitGame(0);
					S_StartSound(NULL, sfx_chat);
				}
				return true;
			case DDKEY_F11: // F11 - gamma mode correction
				usegamma++;
				if(usegamma > 4)
				{
					usegamma = 0;
				}
//				I_SetPalette((byte *)W_CacheLumpName("PLAYPAL", PU_CACHE));
				return true;
#endif
		}*/
	}

	if(MenuActive == false)
	{
		if(key == DDKEY_ESCAPE || gamestate == GS_DEMOSCREEN || demoplayback)
		{
			MN_ActivateMenu();
			return(true);
		}
		return(false);
	}
	if(!FileMenuKeySteal)
	{
		int firstVI = CurrentMenu->firstItem, lastVI = firstVI + CurrentMenu->numVisItems-1;
		item = &CurrentMenu->items[CurrentItPos];
		switch(key)
		{
/*			case DDKEY_DOWNARROW:
				do
				{
					if(CurrentItPos+1 > CurrentMenu->itemCount-1)
					{
						CurrentItPos = 0;
					}
					else
					{
						CurrentItPos++;
					}
				} while(CurrentMenu->items[CurrentItPos].type == ITT_EMPTY);
				S_StartSound(NULL, sfx_switch);
				return(true);
				break;
			case DDKEY_UPARROW:
				do
				{
					if(CurrentItPos == 0)
					{
						CurrentItPos = CurrentMenu->itemCount-1;
					}
					else
					{
						CurrentItPos--;
					}
				} while(CurrentMenu->items[CurrentItPos].type == ITT_EMPTY);
				S_StartSound(NULL, sfx_switch);
				return(true);
				break;
			case DDKEY_LEFTARROW:
				if(item->type == ITT_LRFUNC && item->func != NULL)
				{
					item->func(LEFT_DIR);
					S_StartSound(NULL, sfx_keyup);
				}
				return(true);
				break;
			case DDKEY_RIGHTARROW:
				if(item->type == ITT_LRFUNC && item->func != NULL)
				{
					item->func(RIGHT_DIR);
					S_StartSound(NULL, sfx_keyup);
				}
				return(true);
				break;*/
			case DDKEY_DOWNARROW:
				do
				{
					if(CurrentItPos+1 > lastVI)
					{
						CurrentItPos = firstVI;
					}
					else
					{
						CurrentItPos++;
					}
				} while(CurrentMenu->items[CurrentItPos].type == ITT_EMPTY);
				S_StartSound(NULL, sfx_switch);
				return(true);
				break;
			case DDKEY_UPARROW:
				do
				{
					if(CurrentItPos <= firstVI)//0)
					{
						CurrentItPos = lastVI;//CurrentMenu->itemCount-1;
					}
					else
					{
						CurrentItPos--;
					}
				} while(CurrentMenu->items[CurrentItPos].type == ITT_EMPTY);
				S_StartSound(NULL, sfx_switch);
				return(true);
				break;
			case DDKEY_LEFTARROW:
				if(item->type == ITT_LRFUNC && item->func != NULL)
				{
					item->func(LEFT_DIR);
					S_StartSound(NULL, sfx_keyup);
				}
				else
				{
					// Let's try to change to the previous page.
					if(CurrentMenu->firstItem - CurrentMenu->numVisItems >= 0)
					{
						CurrentMenu->firstItem -= CurrentMenu->numVisItems;
						CurrentItPos -= CurrentMenu->numVisItems;
						// Make a sound, too.
						S_StartSound(NULL, sfx_dorcls);
					}
				}
				return(true);
				break;
			case DDKEY_RIGHTARROW:
				if(item->type == ITT_LRFUNC && item->func != NULL)
				{
					item->func(RIGHT_DIR);
					S_StartSound(NULL, sfx_keyup);
				}
				else
				{
					// Move on to the next page, if possible.
					if(CurrentMenu->firstItem + CurrentMenu->numVisItems < 
						CurrentMenu->itemCount)
					{
						CurrentMenu->firstItem += CurrentMenu->numVisItems;
						CurrentItPos += CurrentMenu->numVisItems;
						if(CurrentItPos > CurrentMenu->itemCount-1)
							CurrentItPos = CurrentMenu->itemCount-1;
						S_StartSound(NULL, sfx_dorcls);						
					}
				}
				return(true);
				break;
			case DDKEY_ENTER:
				if(item->type == ITT_SETMENU)
				{
					SetMenu(item->menu);
				}
				else if(item->func != NULL)
				{
					CurrentMenu->oldItPos = CurrentItPos;
					if(item->type == ITT_LRFUNC)
					{
						item->func(RIGHT_DIR);
					}
					else if(item->type == ITT_EFUNC)
					{
						if(item->func(item->option))
						{
							if(item->menu != MENU_NONE)
							{
								SetMenu(item->menu);
							}
						}
					}
				}
				S_StartSound(NULL, sfx_dorcls);
				return(true);
				break;
			case DDKEY_ESCAPE:
				MN_DeactivateMenu();
				return(true);
			case DDKEY_BACKSPACE:
				S_StartSound(NULL, sfx_switch);
				if(CurrentMenu->prevMenu == MENU_NONE)
				{
					MN_DeactivateMenu();
				}
				else
				{
					SetMenu(CurrentMenu->prevMenu);
				}
				return(true);
			default:
/*				for(i = 0; i < CurrentMenu->itemCount; i++)
				{
					if(CurrentMenu->items[i].text)
					{
						if(toupper(key)
							== toupper(CurrentMenu->items[i].text[0]))
						{
							CurrentItPos = i;
							return(true);
						}
					}
				}*/
				for(i = firstVI; i <= lastVI; i++)
				{
					if(CurrentMenu->items[i].text && CurrentMenu->items[i].type != ITT_EMPTY)
					{
						if(toupper(key)
							== toupper(CurrentMenu->items[i].text[0]))
						{
							CurrentItPos = i;
							return(true);
						}
					}
				}
				break;
		}
		return(false);
	}
	else
	{ // Editing file names
		textBuffer = &SlotText[currentSlot][slotptr];
		if(key == DDKEY_BACKSPACE)
		{
			if(slotptr)
			{
				*textBuffer-- = 0;
				*textBuffer = ASCII_CURSOR;
				slotptr--;
			}
			return(true);
		}
		if(key == DDKEY_ESCAPE)
		{
			memset(SlotText[currentSlot], 0, SLOTTEXTLEN+2);
			strcpy(SlotText[currentSlot], oldSlotText);
			SlotStatus[currentSlot]--;
			MN_DeactivateMenu();
			return(true);
		}
		if(key == DDKEY_ENTER)
		{
			SlotText[currentSlot][slotptr] = 0; // clear the cursor
			item = &CurrentMenu->items[CurrentItPos];
			CurrentMenu->oldItPos = CurrentItPos;
			if(item->type == ITT_EFUNC)
			{
				item->func(item->option);
				if(item->menu != MENU_NONE)
				{
					SetMenu(item->menu);
				}
			}
			return(true);
		}
		if(slotptr < SLOTTEXTLEN && key != DDKEY_BACKSPACE)
		{
			if((key >= 'a' && key <= 'z'))
			{
				*textBuffer++ = key-32;
				*textBuffer = ASCII_CURSOR;
				slotptr++;
				return(true);
			}
			if(((key >= '0' && key <= '9') || key == ' '
				|| key == ',' || key == '.' || key == '-')
				&& !shiftdown)
			{
				*textBuffer++ = key;
				*textBuffer = ASCII_CURSOR;
				slotptr++;
				return(true);
			}
			if(shiftdown && key == '1')
			{
				*textBuffer++ = '!';
				*textBuffer = ASCII_CURSOR;
				slotptr++;
				return(true);
			}
		}
		return(true);
	}
	return(false);
}

//---------------------------------------------------------------------------
//
// PROC MN_ActivateMenu
//
//---------------------------------------------------------------------------

void MN_ActivateMenu(void)
{
	if(MenuActive)
	{
		return;
	}
	if(paused)
	{
		S_ResumeSound();
	}
	MenuActive = true;
	FileMenuKeySteal = false;
	MenuTime = 0;
	CurrentMenu = &MainMenu;
	CurrentItPos = CurrentMenu->oldItPos;
	if(!netgame && !demoplayback)
	{
		paused = true;
	}
	S_StartSound(NULL, sfx_dorcls);
	slottextloaded = false; //reload the slot text, when needed
}

//---------------------------------------------------------------------------
//
// PROC MN_DeactivateMenu
//
//---------------------------------------------------------------------------

void MN_DeactivateMenu(void)
{
	CurrentMenu->oldItPos = CurrentItPos;
	MenuActive = false;
	if(!netgame)
	{
		paused = false;
	}
	S_StartSound(NULL, sfx_dorcls);
	if(soundchanged)
	{
		S_SetMaxVolume(true); //recalc the sound curve
		soundchanged = false;
	}
	players[consoleplayer].message = NULL;
	players[consoleplayer].messageTics = 1;
}

//---------------------------------------------------------------------------
//
// PROC MN_DrawInfo
//
//---------------------------------------------------------------------------

void MN_DrawInfo(void)
{
	gi.GL_DrawRawScreen(W_GetNumForName("TITLE") + InfoType);
}


//---------------------------------------------------------------------------
//
// PROC SetMenu
//
//---------------------------------------------------------------------------

static void SetMenu(MenuType_t menu)
{
	CurrentMenu->oldItPos = CurrentItPos;
	CurrentMenu = Menus[menu];
	CurrentItPos = CurrentMenu->oldItPos;
}

//---------------------------------------------------------------------------
//
// PROC DrawSlider
//
//---------------------------------------------------------------------------

static void DrawSlider(Menu_t *menu, int item, int width, int slot)
{
	int		x;
	int		y;

	x = menu->x+24;
	y = menu->y+2+(item * menu->itemHeight);

	gi.GL_SetPatch(W_GetNumForName("M_SLDMD1"));
	gi.GL_DrawRectTiled(x-1, y+1, width*8+2, 13, 8, 13);

	gi.GL_DrawPatchCS(x-32, y, W_GetNumForName("M_SLDLT"));
	gi.GL_DrawPatchCS(x + width*8, y, W_GetNumForName("M_SLDRT"));
	gi.GL_DrawPatchCS(x+4+slot*8, y+7, W_GetNumForName("M_SLDKB"));
}

//---------------------------------------------------------------------------
//
// CCMD CCmdMenuAction
//
//---------------------------------------------------------------------------

int CCmdMenuAction(int argc, char **argv)
{
	// Can we get out of here early?
	if(MenuActive == true || chatmodeon) return true;

	if(!stricmp(argv[0], "infoscreen"))
	{
		SCInfo(0); // start up info screens
		MenuActive = true;
		//fadingOut = false;
	}
	else if(!stricmp(argv[0], "savegame"))
	{
		if(gamestate == GS_LEVEL && !demoplayback)
		{
			MenuActive = true;
			FileMenuKeySteal = false;
			MenuTime = 0;
			CurrentMenu = &SaveMenu;
			CurrentItPos = CurrentMenu->oldItPos;
			if(!netgame && !demoplayback)
			{
				paused = true;
			}
			S_StartSound(NULL, sfx_dorcls);
			slottextloaded = false; //reload the slot text, when needed
		}
	}
	else if(!stricmp(argv[0], "loadgame"))
	{
		if(SCNetCheck(2))
		{
			MenuActive = true;
			FileMenuKeySteal = false;
			MenuTime = 0;
			CurrentMenu = &LoadMenu;
			CurrentItPos = CurrentMenu->oldItPos;
			if(!netgame && !demoplayback)
			{
				paused = true;
			}
			S_StartSound(NULL, sfx_dorcls);
			slottextloaded = false; //reload the slot text, when needed
		}
	}
	else if(!stricmp(argv[0], "soundmenu"))
	{
		MenuActive = true;
		FileMenuKeySteal = false;
		MenuTime = 0;
		CurrentMenu = &Options2Menu;
		CurrentItPos = CurrentMenu->oldItPos;
		if(!netgame && !demoplayback)
		{
			paused = true;
		}
		S_StartSound(NULL, sfx_dorcls);
		slottextloaded = false; //reload the slot text, when needed
	}
/*	else if(!stricmp(argv[0], "suicide"))
	{
		gi.OpenConsole(false);
		MenuActive = false;
		askforquit = true;
		typeofask = 5; // suicide
		return true;
	}*/
	else if(!stricmp(argv[0], "quicksave"))
	{
		if(gamestate == GS_LEVEL && !demoplayback)
		{
			if(!quicksave || quicksave == -1)
			{
				MenuActive = true;
				FileMenuKeySteal = false;
				MenuTime = 0;
				CurrentMenu = &SaveMenu;
				CurrentItPos = CurrentMenu->oldItPos;
				if(!netgame && !demoplayback)
				{
					paused = true;
				}
				S_StartSound(NULL, sfx_dorcls);
				slottextloaded = false; //reload the slot text, when needed
				quicksave = -1;
				P_SetMessage(&players[consoleplayer],
					"CHOOSE A QUICKSAVE SLOT", true);
			}
			else
			{
				askforquit = true;
				typeofask = 3;
				if(!netgame && !demoplayback)
				{
					paused = true;
				}
				S_StartSound(NULL, sfx_chat);
			}
		}
	}
	else if(!stricmp(argv[0], "endgame"))
	{
		if(gamestate == GS_LEVEL && !demoplayback)
		{
			S_StartSound(NULL, sfx_chat);
			SCEndGame(0);
		}
	}
	else if(!stricmp(argv[0], "toggleMsgs"))
	{
		SCMessages(0);
	}
	else if(!stricmp(argv[0], "quickload"))
	{
		if(!quickload || quickload == -1)
		{
			MenuActive = true;
			FileMenuKeySteal = false;
			MenuTime = 0;
			CurrentMenu = &LoadMenu;
			CurrentItPos = CurrentMenu->oldItPos;
			if(!netgame && !demoplayback)
			{
				paused = true;
			}
			S_StartSound(NULL, sfx_dorcls);
			slottextloaded = false; //reload the slot text, when needed
			quickload = -1;
			P_SetMessage(&players[consoleplayer],
				"CHOOSE A QUICKLOAD SLOT", true);
		}
		else
		{
			askforquit = true;
			if(!netgame && !demoplayback)
			{
				paused = true;
			}
			typeofask = 4;
			S_StartSound(NULL, sfx_chat);
		}
	}
	else if(!stricmp(argv[0], "quit"))
	{
		if(gamestate == GS_LEVEL)
		{
			SCQuitGame(0);
			S_StartSound(NULL, sfx_chat);
		}
	}
	else if(!stricmp(argv[0], "toggleGamma"))
	{
		int gamma = gi.Get(DD_GAMMA) + 1;
		char cmd[20];
		if(gamma > 4)
		{
			gamma = 0;
		}
		//SB_PaletteFlash(true); // force change
		// Reset the textures.
		//gi.GL_ClearTextureMem();
		sprintf(cmd, "setgamma %d", gamma);
		gi.Execute(cmd, true);
		/*P_SetMessage(&players[consoleplayer], GammaText[gamma],
			false);*/
	}
	return true;
}