// F_finale.c

#include "DoomDef.h"
#include "R_local.h"
#include "soundst.h"
#include <ctype.h>

int             finalestage;            // 0 = text, 1 = art screen
int             finalecount;

#define TEXTSPEED       3
#define TEXTWAIT        250

char    *e1text = E1TEXT;
char    *e2text = E2TEXT;
char    *e3text = E3TEXT;
char    *e4text = E4TEXT;
char    *e5text = E5TEXT;
char    *finaletext;
char    *finaleflat;

int FontABaseLump;

DGLuint e2texName[2] = { 0, 0 };	// Not loaded yet.

extern boolean automapactive;
extern boolean viewactive;

extern void D_StartTitle(void);

/*
=======================
=
= F_StartFinale
=
=======================
*/

void F_StartFinale (void)
{
	gameaction = ga_nothing;
	gamestate = GS_FINALE;
	viewactive = false;
	automapactive = false;
	players[consoleplayer].messageTics = 1;
	players[consoleplayer].message = NULL;

	switch(gameepisode)
	{
		case 1:
			finaleflat = "FLOOR25";
			finaletext = e1text;
			break;
		case 2:
			finaleflat = "FLATHUH1";
			finaletext = e2text;
			break;
		case 3:
			finaleflat = "FLTWAWA2";
			finaletext = e3text;
			break;
		case 4:
			finaleflat = "FLOOR28";
			finaletext = e4text;
			break;
		case 5:
			finaleflat = "FLOOR08";
			finaletext = e5text;
			break;
	}

	finalestage = 0;
	finalecount = 0;
	FontABaseLump = W_GetNumForName("FONTA_S")+1;

//      S_ChangeMusic(mus_victor, true);
	S_StartSong(mus_cptd, true);
}



boolean F_Responder (event_t *event)
{
	if(event->type != ev_keydown)
	{
		return false;
	}
	if(finalestage == 1 && gameepisode == 2)
	{ // we're showing the water pic, make any key kick to demo mode
		finalestage++;
		/*memset((byte *)0xa0000, 0, SCREENWIDTH*SCREENHEIGHT);
		memset(screen, 0, SCREENWIDTH*SCREENHEIGHT);*/
//		gl.Clear(DGL_COLOR_BUFFER_BIT);
//		I_SetPalette(W_CacheLumpName("PLAYPAL", PU_CACHE));
		return true;
	}
	return false;
}


/*
=======================
=
= F_Ticker
=
=======================
*/

void F_Ticker (void)
{
	finalecount++;
	if (!finalestage && (unsigned)finalecount > strlen (finaletext)*TEXTSPEED + TEXTWAIT)
	{
		finalecount = 0;
		if(!finalestage)
		{
			finalestage = 1;
		}

//              wipegamestate = -1;             // force a wipe
/*
		if (gameepisode == 3)
			S_StartMusic (mus_bunny);
*/
	}
}


/*
=======================
=
= F_TextWrite
=
=======================
*/

//#include "HU_stuff.h"
//extern        patch_t *hu_font[HU_FONTSIZE];

void F_TextWrite (void)
{
//	byte    *src, *dest;
//	int     x,y;
	int     count;
	char    *ch;
	int     c, pnum;
	int     cx, cy;
	patch_t *w;

//
// erase the entire screen to a tiled background
//
/*	src = W_CacheLumpName(finaleflat, PU_CACHE);
	dest = screen;
	for (y=0 ; y<SCREENHEIGHT ; y++)
	{
		for (x=0 ; x<SCREENWIDTH/64 ; x++)
		{
			memcpy (dest, src+((y&63)<<6), 64);
			dest += 64;
		}
		if (SCREENWIDTH&63)
		{
			memcpy (dest, src+((y&63)<<6), SCREENWIDTH&63);
			dest += (SCREENWIDTH&63);
		}
	}*/

	gi.GL_SetFlat(R_FlatNumForName(finaleflat));
	gi.GL_DrawRectTiled(0, 0, SCREENWIDTH, SCREENHEIGHT, 64, 64);

//      V_MarkRect (0, 0, SCREENWIDTH, SCREENHEIGHT);

//
// draw some of the text onto the screen
//
	cx = 20;
	cy = 5;
	ch = finaletext;

	count = (finalecount - 10)/TEXTSPEED;
	if (count < 0) count = 0;
	for ( ; count ; count-- )
	{
		c = *ch++;
		if (!c)
			break;
		if (c == '\n')
		{
			cx = 20;
			cy += 9;
			continue;
		}

		c = toupper(c);
		if (c < 33)
		{
			cx += 5;
			continue;
		}

		pnum = FontABaseLump+c-33;
		w = W_CacheLumpNum(pnum, PU_CACHE);
		if (cx+w->width > SCREENWIDTH) break;
		gi.GL_DrawPatch(cx, cy, pnum);
		cx += w->width;
	}
}

static void DrawCustom320x200(DGLuint t1, DGLuint t2, int offx, int offy, int sel)
{
	gl.Color3f(1, 1, 1);

	if(!sel || sel == 1)
	{
		if(t1) gl.Bind(t1);
		gl.Begin(DGL_QUADS);
			gl.TexCoord2f(0, 0);
			gl.Vertex2f(offx, offy);

			gl.TexCoord2f(1, 0);
			gl.Vertex2f(255+offx, offy);

			gl.TexCoord2f(1, 200.0/256.0);
			gl.Vertex2f(255+offx, 200+offy);

			gl.TexCoord2f(0, 200.0/256.0);
			gl.Vertex2f(offx, 200+offy);
		gl.End();
	}

	if(!sel || sel == 2)
	{
		if(t2) gl.Bind(t2);
		gl.Begin(DGL_QUADS);
			gl.TexCoord2f(0, 0);
			gl.Vertex2f(255+offx, offy);

			gl.TexCoord2f(1, 0);
			gl.Vertex2f(320+offx, offy);

			gl.TexCoord2f(1, 200.0/256.0);
			gl.Vertex2f(320+offx, 200+offy);

			gl.TexCoord2f(0, 200.0/256.0);
			gl.Vertex2f(255+offx, 200+offy);
		gl.End();
	}
}

/*
==================
=
= F_DemonScroll
=
==================
*/

void F_DemonScroll(void)
{
//	byte *p1, *p2;
	int p1, p2;
	static int yval = 0;
	static int nextscroll = 0;

	p1 = W_GetNumForName("FINAL1");
	p2 = W_GetNumForName("FINAL2");
	if(finalecount < 70)
	{
		gi.GL_SetRawImage(p1, 1);
		DrawCustom320x200(0, 0, 0, 0, 1);
		gi.GL_SetRawImage(p1, 2);
		DrawCustom320x200(0, 0, 0, 0, 2);
		nextscroll = finalecount;
		return;
	}
	if(yval < 200)//64000)
	{
		// The upper image.
		gi.GL_SetRawImage(p2, 1);
		DrawCustom320x200(0, 0, 0, -199+yval, 1);
		gi.GL_SetRawImage(p2, 2);
		DrawCustom320x200(0, 0, 0, -199+yval, 2);

		// The lower image.
		gi.GL_SetRawImage(p1, 1);
		DrawCustom320x200(0, 0, 0, yval, 1);
		gi.GL_SetRawImage(p1, 2);
		DrawCustom320x200(0, 0, 0, yval, 2);

		if(finalecount >= nextscroll)
		{
			yval++; //+=SCREENWIDTH;
			nextscroll = finalecount+3;
		}
	}
	else
	{ //else, we'll just sit here and wait, for now
		gi.GL_SetRawImage(p2, 1);
		DrawCustom320x200(0, 0, 0, 0, 1);
		gi.GL_SetRawImage(p2, 2);
		DrawCustom320x200(0, 0, 0, 0, 2);
	}
}

static void GammaColorCopy(byte *dest, int palette_index, byte *palette)
{
	int	i;
	for(i=0; i<3; i++) dest[i] = gammatable[usegamma][palette[palette_index*3 + i]];
}

void F_DrawE2End()
{
	if(!e2texName[0])
	{
		// E2END uses a custom palette. We can't use Doomsday's texture 
		// loading in this case.
		byte *e2pal = W_CacheLumpName("E2PAL", PU_CACHE);
		byte *image = W_CacheLumpName("E2END", PU_CACHE);
		byte leftpart[256*256*3], rightpart[64*256*3];
		int i, k;
		// Load in the texture. E2END is a 320x200 image (palette E2PAL).
		// We'll use two parts, which is the most efficient way.
		memset(leftpart, 0, sizeof(leftpart));
		memset(rightpart, 0, sizeof(rightpart));
		// Convert the image to RGB.
		for(k=0; k<200; k++)
			for(i=0; i<256; i++)
			{
				GammaColorCopy(leftpart + 3*(i + k*256), image[i + k*320], e2pal);
				if(i<64) 
					GammaColorCopy(rightpart + 3*(i + k*64), image[256+i + k*320], e2pal);
			}
		e2texName[0] = gl.NewTexture();
		gl.TexImage(DGL_RGB, 256, 256, 0, leftpart);
		gl.TexParameter(DGL_WRAP_S, DGL_CLAMP);
		e2texName[1] = gl.NewTexture();
		gl.TexImage(DGL_RGB, 64, 256, 0, rightpart);
		gl.TexParameter(DGL_WRAP_S, DGL_CLAMP);
	}
	DrawCustom320x200(e2texName[0], e2texName[1], 0, 0, 0);
}

/*
==================
=
= F_DrawUnderwater
=
==================
*/

void F_DrawUnderwater(void)
{
	static boolean underwawa;
	extern boolean MenuActive;
	extern boolean askforquit;

	switch(finalestage)
	{
		case 1:
			//if(!underwawa)
			//{
			//	underwawa = true;
				/*memset((byte *)0xa0000, 0, SCREENWIDTH*SCREENHEIGHT);
				I_SetPalette(W_CacheLumpName("E2PAL", PU_CACHE));
				memcpy(screen, W_CacheLumpName("E2END", PU_CACHE),
					SCREENWIDTH*SCREENHEIGHT);*/
				//gi.GL_DrawRawScreen(W_GetNumForName("E2END"));
			//}
			F_DrawE2End();
			paused = false;
			MenuActive = false;
			askforquit = false;
			break;
		case 2:
			/*memcpy(screen, W_CacheLumpName("TITLE", PU_CACHE),
				SCREENWIDTH*SCREENHEIGHT);*/
			gi.GL_DrawRawScreen(W_GetNumForName("TITLE"));
			//D_StartTitle(); // go to intro/demo mode.
	}
}

/*
=======================
=
= F_Drawer
=
=======================
*/

void F_Drawer(void)
{
	gi.GL_SetColorAndAlpha(1, 1, 1, 1);

	if (!finalestage)
		F_TextWrite ();
	else
	{
		switch (gameepisode)
		{
			case 1:
				if(shareware)
				{
					//V_DrawRawScreen(W_CacheLumpName("ORDER", PU_CACHE));
					gi.GL_DrawRawScreen(W_GetNumForName("ORDER"));
				}
				else
				{
					//V_DrawRawScreen(W_CacheLumpName("CREDIT", PU_CACHE));
					gi.GL_DrawRawScreen(W_GetNumForName("CREDIT"));
				}
				break;
			case 2:
				F_DrawUnderwater();
				break;
			case 3:
				F_DemonScroll();
				break;
			case 4: // Just show credits screen for extended episodes
			case 5:
				//V_DrawRawScreen(W_CacheLumpName("CREDIT", PU_CACHE));
				gi.GL_DrawRawScreen(W_GetNumForName("CREDIT"));
				break;
		}
	}
	gi.Update(DDUF_FULLSCREEN);
}
