/*
 * $Header: /HexenWorld/HCode/vindictus.hc 2     2/19/98 8:07p Ssengele $
 */

/*
==============================================================================

Q:\art\models\weapons\newass\vindictus.hc

==============================================================================
*/

// For building the model
$cd Q:\art\models\weapons\newass
$origin 0 0 0
$base BASE SKIN
$skin SKIN
$flags 0

//
$frame POLY         

//
$frame power1       power2       power3       power4       power5       
$frame power6       power7       power8       power9       power10      
$frame power11      power12      

//
$frame idle

//
$frame select1      select2      select3      select4      select5      
$frame select6      select7      select8      select9      select10     

//
$frame shoot1       shoot2       shoot3       shoot4       shoot5       
$frame shoot6       shoot7       shoot8       shoot9       shoot10      
$frame shoot11      


void DrawLinks(void)
{
//These seem to lock up game if there are too many of them
	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
	WriteByte (MSG_BROADCAST, TE_STREAM_CHAIN);
	WriteByte (MSG_BROADCAST, 1+STREAM_ATTACHED);
	WriteByte (MSG_BROADCAST, 40);
	WriteEntity (MSG_BROADCAST, self);
	WriteCoord (MSG_BROADCAST, self.origin_x);
	WriteCoord (MSG_BROADCAST, self.origin_y);
	WriteCoord (MSG_BROADCAST, self.origin_z);
	WriteCoord (MSG_BROADCAST, self.view_ofs_x);
	WriteCoord (MSG_BROADCAST, self.view_ofs_y);
	WriteCoord (MSG_BROADCAST, self.view_ofs_z);
}

void() DeactivateGhook =
{
		self.aflag=FALSE;
        sound(self.owner, CHAN_ITEM, "assassin/clink.wav", 1, ATTN_NORM);
//		if(self.hasted)
//			self.owner.attack_finished=time;
		self.think=SUB_Remove;
		thinktime self : 0;
};

void PullBack (void)
{
	if(self.enemy.flags2&FL_ALIVE)
		self.enemy.movetype=self.enemy.oldmovetype;
	self.movetype=MOVETYPE_NOCLIP;
	self.solid=SOLID_NOT;
//	if(self.hasted)
//		self.view_ofs=self.owner.origin+self.owner.view_ofs+'0 0 -6';
	self.velocity=normalize(self.view_ofs-self.origin)*(200+500*self.hasted);
	if(self.cnt==TRUE)
	{
		DrawLinks();
		self.cnt=FALSE;
	}
	else
		self.cnt=TRUE;
	if(vlen(self.origin-self.view_ofs)<36||self.lifetime<time)
		self.think=DeactivateGhook;
	else 
		self.think=PullBack;
	thinktime self : 0.1;
}

void() Yank =
{
local float dist;
local vector dir;
        setorigin (self, self.enemy.origin + self.enemy.mins +(self.enemy.size * 0.5));
        self.velocity = '0 0 0';

        if(self.enemy.v_angle!=self.o_angle)
                self.enemy.v_angle=self.o_angle;

        if(random()<0.2&&random()<0.2)
        {
		        SpawnPuff (self.origin, self.velocity, 10,other);
				sound(other,CHAN_BODY,"assassin/chntear.wav",1,ATTN_NORM);
                self.enemy.effects=EF_MUZZLEFLASH;
        }

		if(self.enemy.health<=7&&self.frags)
	    {
		    T_Damage (self.enemy, self, self.owner, 5000);
			self.lifetime=time+2;
			self.think=PullBack;
			PullBack();
		}
        else
			T_Damage (self.enemy, self, self.owner, self.dmg);

//		if(self.hasted)
//			self.view_ofs=self.owner.origin+self.owner.view_ofs+'0 0 -6';
		if(self.cnt==TRUE)
		{
			DrawLinks();
			self.cnt=FALSE;
		}
		else
			self.cnt=TRUE;

        if(self.enemy.nextthink<time+0.15)
                thinktime self.enemy : 0.15;
        if(self.enemy.attack_finished<time+0.15)
                self.enemy.attack_finished=time + 0.15;
        if(self.enemy.pausetime<time+0.15)
                self.enemy.pausetime=time + 0.15;

		if(self.wait<=time)
		{
			dir=normalize(self.view_ofs - self.origin);
		    dist = vlen (self.origin-self.view_ofs);
		    if (dist <= 100)
			    dir = dir*dist*10;
			if (dist > 100 )
		        dir = dir*100;//*(self.hasted*4+1);
			if(self.enemy.flags&FL_ONGROUND)
	        {
			    self.enemy.flags(-)FL_ONGROUND;
				self.enemy.velocity_z=100;
			}
			self.enemy.velocity = (self.enemy.velocity + dir)*0.5;
		}
		else 
			self.enemy.velocity='0 0 0';

		if(!self.frags||(!self.owner.flags2&FL_ALIVE)||!self.enemy.health||self.enemy.health<=self.health - 100)
		{
			self.lifetime=time+2;
			self.think=PullBack;
	        thinktime self : 0;
		}
		else
		{
			self.think=Yank;
			thinktime self : 0.1;
		}
};

void(entity bound) Grab=
{
        sound(self, CHAN_AUTO, "assassin/chn2flsh.wav", 1, ATTN_NORM);
        setorigin (self, bound.origin);
		T_Damage (other, self, self.owner, 3);
        SpawnPuff (self.origin, self.velocity, 10,other);
		if(!self.frags)
			self.lifetime=time+1;
		else
			self.wait=time+0.5;
		if(self.hasted)
			self.owner.punchangle_x=6;
        self.velocity = '0 0 0';
        self.avelocity = '0 0 0';
        self.origin=bound.origin;
//		if(self.hasted)
//			self.view_ofs=self.owner.origin+self.owner.view_ofs+'0 0 -6';
		self.movedir=normalize(self.origin-self.view_ofs);
        self.enemy=bound;
		bound.oldmovetype=bound.movetype;
		bound.movetype=MOVETYPE_BOUNCE;
		self.o_angle=bound.v_angle;
		self.health=bound.health;

        self.think=Yank;
        thinktime self : 0;
};

void() HookHit =
{
		if(other!=self.enemy&&(self.enemy.flags2&FL_ALIVE))
			return;

		if(other!=world&&!other.takedamage)
			return;

        self.touch = SUB_Null;

		if(other.takedamage)
            Grab(other);
        else
		{
			sound(self,CHAN_AUTO,"assassin/clink.wav",1,ATTN_NORM);
			self.lifetime=time+2;
			self.think=PullBack;
			thinktime self : 0;
		}
};

void HookHome (void)
{
local vector destiny;
	if(self.enemy!=world)
	{
		destiny=self.enemy.origin;
		destiny_z=self.enemy.origin_z+0.5*self.enemy.maxs_z;
		self.velocity=normalize(destiny - self.origin)*350;
	}
	if(self.pain_finished<time)
	{
		sound(self,CHAN_BODY,"assassin/chain.wav",1,ATTN_NORM);
		self.pain_finished=time+0.5;
	}
//	if(self.hasted)
//		self.view_ofs=self.owner.origin+self.owner.view_ofs+'0 0 -6';
	if(self.cnt==TRUE)
	{
		DrawLinks();
		self.cnt=FALSE;
	}
	else
		self.cnt=TRUE;
	if((self.lifetime<time&&!self.frags) || (!self.enemy.health&&self.enemy!=world) )
	{
			self.lifetime=time+2;
			self.think=PullBack;
	        thinktime self : 0;
	}
	else
	{
		self.think=HookHome;
		thinktime self : 0.1;
	}
}


void(vector startpos, vector endpos, entity loser, entity winner,float gibhook) Hook =
{
local entity ghook;

        ghook=spawn();
        sound(self, CHAN_AUTO, "misc/whoosh.wav", 1, ATTN_NORM);
        ghook.movetype=MOVETYPE_FLYMISSILE;
        ghook.solid=SOLID_BBOX;
        ghook.touch=HookHit;
        ghook.classname="hook";
        ghook.speed=8;
        ghook.owner=winner;
		ghook.enemy=loser;
		ghook.aflag=TRUE;
		ghook.view_ofs = startpos;
		ghook.frags=gibhook;
		if(!gibhook)
		{
//			if(self.classname=="player")
//				ghook.hasted=TRUE;
			ghook.lifetime=time+3;
			ghook.dmg=20;
		}
		else
			ghook.dmg=0.25;
		ghook.scale=0.3;

        ghook.movedir = normalize(endpos - startpos);
		ghook.velocity=ghook.movedir*500;
        ghook.angles = vectoangles(ghook.velocity);
		
		ghook.think=HookHome;
		thinktime ghook : 0;

        setmodel(ghook,"models/hook.mdl");
        setorigin (ghook, startpos - ghook.movedir*6);
        setsize(ghook,'0 0 0', '0 0 0');

};

void CubeStopAndChain (void)
{
	local vector org, dir;

	self.enemy.velocity='0 0 0';
	self.enemy.oldmovetype=self.enemy.movetype;
	self.enemy.movetype=MOVETYPE_NONE;

	makevectors(self.enemy.angles);

	org=self.enemy.origin;
	org_z += 0.5*self.enemy.maxs_z;

	dir=org;
	dir+= v_right*random(300);
	dir_z+= random(300);
	traceline(self.enemy.origin,dir,TRUE,self);
	dir=trace_endpos;
	Hook(dir,org,self.enemy,self.owner,TRUE);

	dir=org;
	dir-= v_right*random(300);
	dir_z+= random(300);
	traceline(self.enemy.origin,dir,TRUE,self);
	dir=trace_endpos;
	Hook(dir,org,self.enemy,self.owner,TRUE);

	dir=org;
	dir+= v_right*random(300);
	dir_z+= random(-20,80);
	traceline(self.enemy.origin,dir,TRUE,self);
	dir=trace_endpos;
	Hook(dir,org,self.enemy,self.owner,TRUE);

	dir=org;
	dir-= v_right*random(300);
	dir_z+= random(-20,80);
	traceline(self.enemy.origin,dir,TRUE,self);
	dir=trace_endpos;
	Hook(dir,org,self.enemy,self.owner,TRUE);

	remove(self);
}

void CubeFindEnemy (void)
{
	local vector org;
	local entity loser;

	loser=findradius(self.origin,5000);

	self.enemy=world;
	self.lifetime=5001;
	while(loser)
	{
		if((loser.flags2&FL_ALIVE)&&loser.takedamage&&visible(loser)&&loser.health&&loser!=world&&loser!=self&&loser!=self.owner)
			if(teamplay&&loser.team==self.owner.team)
				bprint("");
			else if(vlen(self.origin-loser.origin)<self.lifetime)
			{
				self.enemy=loser;
				self.lifetime=vlen(self.origin-loser.origin);
			}
		loser=loser.chain;
	}
	if(self.enemy==world)
		MultiExplode();
	else
	{
		org=(self.enemy.absmin+self.enemy.absmax)*0.5;
		Hook(org,self.origin,self.enemy,self.owner,FALSE);
	}
	remove(self);
}

void LatchOn (void)
{
	self.touch=SUB_Null;
	self.velocity='0 0 0';
	if(other.takedamage&&other.movetype&&other.health&&other.solid!=SOLID_BSP)
	{
		self.enemy=other;
		CubeStopAndChain();
	}
	else
		CubeFindEnemy();
}

void FireCube (void)
{
	self.attack_finished=time + 1;
	makevectors(self.v_angle);
	self.punchangle_x=-10;

	newmis=spawn();
	newmis.owner=self;
	newmis.classname="chainball";
	newmis.movetype=MOVETYPE_FLYMISSILE;
	newmis.solid=SOLID_BBOX;
	newmis.dmg=25;

	newmis.velocity=normalize(v_forward)*350;
	newmis.avelocity=RandomVector('360 360 360');
	
	newmis.touch=LatchOn;
	newmis.homerate=0.5;
	newmis.veer=0;
	newmis.think=HomeThink;

	setmodel(newmis,"models/ballchn.mdl");
	setsize(newmis,'0 0 0','0 0 0');
	setorigin(newmis,self.origin+self.proj_ofs+v_forward*16);
}

void() Ass_Vind_Fire;
void() player_assassin_attack;
void() player_assassin_crouch_move;

void()vindictus_select;
/* Old Unpowered weapon- not used anymore
void () TheClaw =
{
local vector org,destiny;
local entity loser;
	self.th_weapon=vindictus_select;
	makevectors(self.v_angle);
	org=self.origin+self.proj_ofs;
	destiny=org+normalize(v_forward)*1000;
	traceline(org,destiny,FALSE,self);
	if(trace_fraction==1.0)
		loser=world;
	else if(trace_ent.takedamage&&trace_ent.health)
	{
		loser=trace_ent;
		destiny=(loser.absmin+loser.absmax)*0.5;
	}
	else
		loser=world;

//FIXME: set the model of the hook to the head of the staff
	Hook(org+v_forward*8,destiny,loser,self,FALSE);
	self.attack_finished=time + 9999;
	self.punchangle_x = -2;
};
*/

void HookWait(void)
{
	DrawLinks();
	self.cnt+=1;
	if(self.cnt>2)
		self.think=SUB_Remove;
	thinktime self : 0.2;
}

void ThrowChain (void)
{
local entity chook;

        chook=spawn();
        chook.movetype=MOVETYPE_BOUNCE;
        chook.solid=SOLID_NOT;
		chook.classname="hook";
        chook.owner=self.owner;
		chook.view_ofs = self.origin;
		chook.scale=0.3;

		chook.movedir_x = random(-1,1);
		chook.movedir_y = random(-1,1);
		chook.movedir_z = random(-1,1);
		chook.speed=random(350,850);
		chook.velocity=normalize(chook.movedir)*chook.speed;
        chook.angles = vectoangles(chook.velocity);
		
		chook.think=HookWait;
		thinktime chook : 0;

        setmodel(chook,"models/hook.mdl");
        setorigin (chook, self.origin);
        setsize(chook,'0 0 0', '0 0 0');
}


void BallExplode (void)
{
	sound (self, CHAN_AUTO, "weapons/explode.wav", 0.5, ATTN_NORM);
	sound (self, CHAN_AUTO, "player/megagib.wav", 0.5, ATTN_NORM);
	self.effects=EF_MUZZLEFLASH;
	if(self.enemy.health&&self.enemy!=world)
	{		
		T_Damage(self.enemy,self,self.owner,50);
		MeatChunks((self.enemy.absmin+self.enemy.absmax)*0.5,5);
	}
	else
		T_RadiusDamage(self,self.owner,75,self);
	particleexplosion(self.origin,11*16+8,50,20);
	ThrowChain();
	ThrowChain();
	ThrowChain();
	if(random()<0.5)
		ThrowChain();
	if(random()<0.5)
		ThrowChain();
	setmodel(self,"models/null.spr");
	BecomeExplosion(CE_LG_EXPLOSION);
}

void BallHit (void)
{
vector org1,org2;
float part_color;

	if(other.classname=="hook"||other.classname=="chainball")
		return;

	self.aflag=FALSE;
	self.touch=SUB_Null;
	self.velocity='0 0 0';
	self.avelocity='0 0 0';
	self.enemy=world;
	self.solid=SOLID_NOT;
	self.movetype=MOVETYPE_NOCLIP;
	if(other.takedamage)//&&other.movetype)
	{
		if (other.thingtype==THINGTYPE_FLESH&&self.classname!="mummy")
			part_color = 8 * 16 + 9;				// Not transluc-Blood red
		else if ((other.thingtype==THINGTYPE_GREYSTONE)	|| (other.thingtype==THINGTYPE_BROWNSTONE))
			part_color = 256 + (1 * 16);			// Gray
		else if (other.thingtype==THINGTYPE_METAL)	
			part_color = 256 + (8 * 15);			// Sparks
		else if (other.thingtype==THINGTYPE_WOOD)	
			part_color = 256 + (5 * 16);			// Wood chunks
		else
			part_color = 256 + (3 * 16) + 4;		// Dust Brown
		org1=normalize(self.o_angle)*100;
		org2=normalize(self.o_angle)*-100;
		particle2(self.origin,self.origin,org1,part_color,5,10);
		particle2(self.origin,org2,self.origin,part_color,6,30);
//		particle(self.origin,org1,part_color,10);
//		particle(self.origin,org2,part_color,30);
	}
	if((other.flags2&FL_ALIVE)||other.classname=="head"||other.classname=="corpse")
	{
		sound(self,CHAN_AUTO,"assassin/chn2flsh.wav",1,ATTN_NORM);
		self.enemy=other;
		org1=(other.absmin+other.absmax)*0.5;
		setorigin(self,org1);
	}	
	BallExplode();
}

void HooksThink (void)
{
	if(!self.owner.aflag)
		remove(self);
	else
	{
		self.think=HooksThink;
		thinktime self : 0.1;
	}
}

void TheOldBallAndChain (void)
{
//FIXME: Sound
entity lastlink;
float hookcounter;
	self.attack_finished=time + 0.3;
	makevectors(self.v_angle);
	self.punchangle_x=-6;
	self.effects(+)EF_MUZZLEFLASH;

	newmis=spawn();
	newmis.owner=self;
	newmis.classname="chainball";
	
	newmis.movetype=MOVETYPE_FLYMISSILE;
	newmis.solid=SOLID_BBOX;
	newmis.drawflags=MLS_ABSLIGHT;
	newmis.abslight=0.5;
	newmis.aflag=TRUE;

	newmis.o_angle=newmis.velocity=normalize(v_forward)*1000;
	newmis.avelocity=RandomVector('360 360 360');
	
	newmis.touch=BallHit;

	setmodel(newmis,"models/ballchn.mdl");
	setsize(newmis,'0 0 0','0 0 0');
	setorigin(newmis,self.origin+self.proj_ofs+v_forward*12);
	
	lastlink=newmis;
	while(hookcounter<3)
	{
	local entity hooks;
		hookcounter+=1;
		hooks=spawn();
		hooks.owner=newmis;
		hooks.movetype=MOVETYPE_NOCLIP;
		hooks.solid=SOLID_NOT;
		hooks.drawflags=MLS_ABSLIGHT;
		hooks.abslight=0.5;
		
		hooks.angles_x=random(360);
		hooks.angles_y=random(360);
		hooks.angles_z=random(360);

		hooks.think=HooksThink;
		thinktime hooks : 0;

		lastlink.movechain=hooks;
		hooks.flags=FL_MOVECHAIN_ANGLE;
		lastlink=hooks;
	
		setmodel(hooks,"models/hook.mdl");
		setsize(hooks,'0 0 0','0 0 0');
		setorigin(hooks,newmis.origin);
	}
}

void () ChainsOfLove =
{
	FireCube();
};

void() Ass_Vind_Fire;

void vindictus_idle (void)
{
	self.weaponframe= $idle;
	self.th_weapon=vindictus_idle;
	if(self.button0&&self.attack_finished<=time)
		Ass_Vind_Fire();
}

void vindictus_shoot (void)
{
	self.wfs=advanceweaponframe($shoot1,$shoot11);
	self.th_weapon=vindictus_shoot;
	if(self.weaponframe==$shoot3)
		TheOldBallAndChain();
	if(self.wfs==WF_CYCLE_WRAPPED)
		vindictus_idle();
}

void vindictus_power (void)
{
	self.wfs=advanceweaponframe($power1,$power12);
	self.th_weapon=vindictus_power;
	if(self.wfs==WF_CYCLE_WRAPPED)
		vindictus_idle();
	else if(self.weaponframe==$power1)
		ChainsOfLove();
}

void Ass_Vind_Fire (void)
{
	if(self.hull==HULL_NORMAL)
		self.think=player_assassin_attack;
	else
		self.think=player_assassin_crouch_move;
			if(self.artifact_active&ART_TOMEOFPOWER)
				self.th_weapon=vindictus_power;
			else
				self.th_weapon=vindictus_shoot;
	thinktime self : 0;
}
	
void vindictus_select (void)
{
	self.th_weapon=vindictus_select;
	self.wfs=advanceweaponframe($select10,$select1);
	self.weaponmodel=("models/vindictus.mdl");
	if(self.weaponframe==$select1)
	{
		self.attack_finished = time - 1;
		vindictus_idle();
	}
}

void vindictus_deselect (void)
{
	self.th_weapon=vindictus_deselect;
	self.wfs=advanceweaponframe($select1,$select10);
	if(self.wfs==WF_CYCLE_WRAPPED)
		W_SetCurrentAmmo();
}
/*
 * $Log: /HexenWorld/HCode/vindictus.hc $
 * 
 * 2     2/19/98 8:07p Ssengele
 * tripmine client effect in--added access to streams in cl_effect
 * 
 * 1     2/04/98 1:59p Rjohnson
 * 
 * 29    7/17/97 6:53p Mgummelt
 * 
 * 28    6/24/97 7:48a Rlove
 * 
 * 27    6/18/97 7:45p Mgummelt
 * 
 * 26    6/18/97 4:19p Mgummelt
 * 
 * 25    6/18/97 4:00p Mgummelt
 * 
 * 24    6/05/97 9:30a Rlove
 * Weapons now have deselect animations
 * 
 */
