/***************************************************************************
 ***                           HEXEN II CTF							 ***
 ***		     Based on Threewave Capture by Zoid.					 ***
 ***************************************************************************/

void() CheckAdminCmd;

/** MODIFIABLE CONSTANTS **/
float TEAM_DEFAULT_PENALTY =    1;      // Default frag penalty
float TEAM_COLOR1       =       7;      //GOLD TEAM	- H2CTF   DONT CHANGE THESE!
float TEAM_COLOR2       =       9;      //SILVER TEAM - H2CTF
float team1shirt;
float team2shirt;

/** Globals **/
entity team1_lastspawn;
entity team2_lastspawn;
float  nextteamupdtime;	    // time until next team update
float last_flag_capture;	// time of last capture
float last_capture_team;	// last team that captured

// Teamplay bitfield entries
float TEAM_HEALTH_PROTECT =      1;      // No health damage from friendly fire
float TEAM_ARMOR_PROTECT =       2;      // No armor damage from friendly fire
float TEAM_ATTACKER_DAMAGE =     4;      // Attacker takes damage from hitting teammates
float TEAM_FRAG_PENALTY =        8;      // One frag penalty for killing teammate
float TEAM_DEATH_PENALTY =       16;     // Die when you kill a teammate.
float TEAM_STATIC_TEAMS =        64;     // Don't allow players to switch teams
float TEAM_CAPTURE_SELECT_TEAM = 128;   // team selection
float TEAM_DISABLE_GRAPPLE = 2048; // team selection
float TEAM_CAPTURE_CAPTURE_BONUS = 15;				 // what you get for capture
float TEAM_CAPTURE_TEAM_BONUS = 10;					 // what your team gets for capture
float TEAM_CAPTURE_RECOVERY_BONUS = 2;				 // what you get for recovery
float TEAM_CAPTURE_FLAG_BONUS = 2;					 // what you get for picking up enemy flag
float TEAM_CAPTURE_FRAG_CARRIER_BONUS = 2;			 // what you get for fragging enemy flag carrier
float TEAM_CAPTURE_FLAG_RETURN_TIME = 60;			 // seconds until auto return
float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_BONUS = 2; // bonus for fraggin someone who has recently hurt your flag carrier
float TEAM_CAPTURE_CARRIER_PROTECT_BONUS = 1;        // bonus for fraggin someone while either you or your target are near your flag carrier
float TEAM_CAPTURE_FLAG_DEFENSE_BONUS = 2;           // bonus for fraggin someone while either you or your target are near your flag
float TEAM_CAPTURE_RETURN_FLAG_ASSIST_BONUS = 1;     // awarded for returning a flag that causes a capture to happen almost immediately
float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_BONUS = 2;    // award for fragging a flag carrier if a capture happens almost immediately
float TEAM_CAPTURE_TARGET_PROTECT_RADIUS = 600;      // the radius around an object being defended where a target will be worth extra frags
float TEAM_CAPTURE_ATTACKER_PROTECT_RADIUS = 600;    // the radius around an object being defended where an attacker will get extra frags when making kills
float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_TIMEOUT = 4;
float TEAM_CAPTURE_CARRIER_FLAG_SINCE_TIMEOUT = 2;
float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_TIMEOUT = 6;
float TEAM_CAPTURE_RETURN_FLAG_ASSIST_TIMEOUT = 4;
float TEAM_CAPTURE_UPDATE_TIME = 120;
float FLAG_AT_BASE = 0;
float FLAG_CARRIED = 1;
float FLAG_DROPPED = 2;



/********************H2CTF TEAM CODE********************/

void(entity who, string s) TeamPlayerUpdate;
void() TeamCaptureResetUpdate;

string(float Team) GetTeamColor = {
	if(Team == 0) return("Blue");
	else if(Team == 1) return(" ");
	else if(Team == 2) return(" ");
	else if(Team == 3) return(" ");
	else if(Team == 4) return(" ");
	else if(Team == 5) return(" ");
	else if(Team == 6) return(" ");
	else if(Team == 7) return("Gold");
	else if(Team == 8) return(" ");
	else if(Team == 9) return("Silver");
	else if(Team == 10) return(" ");
	else if(Team == 11) return(" ");
	else if(Team == 12) return(" ");
	else if(Team == 13) return(" ");
	else if(Team == 14) return(" ");
	return "Unknown";
};


string(float Team) GetCTFTeam = {
	if (Team == TEAM_COLOR1) return "Gold";
	if (Team == TEAM_COLOR2) return "Silver";
	return "";
};


void() TeamPrintSettings = {
	local string s;
	sprint(self,PRINT_MEDIUM, "The following Teamplay options are set:\n");
	if(teamplay < 0) {
		sprint(self, PRINT_MEDIUM, "Frag penalty manually set to ");
		s = ftos(teamplay);
		sprint(self, PRINT_MEDIUM, s);
		sprint(self, PRINT_MEDIUM, "\n");
		return;
	}
	if(!teamplay) {
		sprint(self, PRINT_MEDIUM, "None\n");
		return;
	}
	if(1 == teamplay) {
		sprint(self, PRINT_MEDIUM, "ID's original teamplay 1\n");
		return;
	}
	if(teamplay & TEAM_HEALTH_PROTECT)
		sprint(self, PRINT_MEDIUM, "Health-Protect ");
	if(teamplay & TEAM_ARMOR_PROTECT)
		sprint(self, PRINT_MEDIUM, "Armor-Protect ");
	if(teamplay & TEAM_ATTACKER_DAMAGE)
		sprint(self, PRINT_MEDIUM, "Mirror-Damage ");
	if(teamplay & TEAM_FRAG_PENALTY)
		sprint(self, PRINT_MEDIUM, "Frag-Penalty ");
	if(teamplay & TEAM_DEATH_PENALTY)
		sprint(self, PRINT_MEDIUM, "Death-Penalty ");
	if(teamplay & TEAM_STATIC_TEAMS)
		sprint(self, PRINT_MEDIUM, "Static-Teams ");
	sprint(self, PRINT_MEDIUM, "\n");
};


float(entity targ, entity inflictor, entity attacker, float damage) TeamArmorDam = {
        if ((teamplay < 0) || gamestart)
                return TRUE;
        if( (teamplay & TEAM_ARMOR_PROTECT) && 
			(attacker.lastteam == targ.lastteam) && 
			(attacker != targ) && (targ.lastteam > 0) ) {
                return FALSE;
        }
        return TRUE;
};


float(entity targ, entity inflictor, entity attacker, float damage) TeamHealthDam = {
        if ((teamplay < 0) || gamestart)
                return TRUE;
        if( (attacker.lastteam == targ.lastteam) && 
			(attacker != targ) && (targ.lastteam > 0) ) {
                if( teamplay & TEAM_ATTACKER_DAMAGE )
                {
                     T_Damage(attacker, inflictor, attacker, damage);
                }
                if( teamplay & TEAM_HEALTH_PROTECT )
                {
                     return FALSE;
                }
        }
        return TRUE;
};


float(entity targ, entity attacker) TeamPFrags = {
        if( teamplay < 0 )
                return (-1 * teamplay);
        if( (targ.lastteam > 0) && (targ != attacker) && (targ.lastteam ==
			attacker.lastteam) ) {
                if( teamplay < 0 ) {
                        return ( -1 * teamplay );
                }
                if( teamplay & TEAM_FRAG_PENALTY ){
                        return TEAM_DEFAULT_PENALTY;
                }
        }
        return 0;
};


float(entity targ, entity attacker) TeamFragPenalty = {
        local float f;
        f = TeamPFrags(targ, attacker);
        if( f ) {
            attacker.frags = attacker.frags - f;
            return TRUE;
        }
        return FALSE;
};


void(entity targ, entity attacker) TeamDeathPenalty = {
        if ( teamplay < 0 )
                return;
        if ( (teamplay & TEAM_DEATH_PENALTY) && (targ.lastteam > 0) &&
			(attacker != targ) && (attacker.lastteam == targ.lastteam) ) {
                T_Damage(attacker,attacker,attacker,1000);
                attacker.frags = attacker.frags + 1;
        }
};

float(float color1) TeamColorIsLegal = {
        if( teamplay < 0 )
                return TRUE;2
        if( (color1 == TEAM_COLOR1) && (TEAM_COLOR1 >= 0) )
                return TRUE;
        if( (color1 == TEAM_COLOR2) && (TEAM_COLOR2 >= 0) )
                return TRUE;
};


float(float t) TeamGetShirt = {
	return t - 1;
};


void() TeamCheckTeam = {
local float TEAM1;
local float TEAM2;
local float newcolor;
local float t;
local entity p;
local string n; 
	if( self.lastteam >= 0 ) {
			if(TeamColorIsLegal(self.team)) {
				self.lastteam = self.team;
				return;
			}
	}
	TEAM1 = 0;
	TEAM2 = 0;
	p = find (world, classname, "player");
	while(p) {
		if (p != self) {
			if (p.team == TEAM_COLOR1)
				TEAM1 = TEAM1 + 1;
			else if (p.team == TEAM_COLOR2)
				TEAM2 = TEAM2 + 1;
		}
		p = find(p, classname, "player");
	}
	newcolor = TEAM_COLOR1;
	if (((TEAM2 < TEAM1) || (TEAM2 == TEAM1 && random() < 0.5)))
		newcolor = TEAM_COLOR2;
	stuffcmd(self, "color ");
	t = TeamGetShirt(newcolor);
	n = ftos(t);
        if (n=="6")
        {
		stuffcmd(self, "0");
		stuffcmd(self, " ");
		n = ftos(newcolor);
		stuffcmd(self, n);
	} else if (n=="8")
	{
		stuffcmd(self, n);
		stuffcmd(self, " ");
		n = ftos(newcolor);
		stuffcmd(self, n);
	}
	stuffcmd(self, "\n");
	self.lastteam = newcolor;      // Remember what team we're on
	self.team = newcolor;
};


void() TeamCheckLock = {
local   float   n;
local   string  s;
	if ( teamplay < 0 )
			return;
	if (self.observer || self.do_observer ){
		//if (self.team != 1)
		//	stuffcmd(self, "color 0\n");
		//self.lastteam = 1;
		return;
	}
	if (self.player_flag & TEAM_STUFF_COLOR) {
		self.player_flag = self.player_flag - TEAM_STUFF_COLOR;
		stuffcmd(self, "color ");
		n = TeamGetShirt(self.lastteam);
		s = ftos(n);
        if (s=="6")
        {
		stuffcmd(self, "0");
		stuffcmd(self, " ");
		stuffcmd(self, s);
	} else if (s=="8")
	{
		stuffcmd(self, s);
		stuffcmd(self, " ");
		stuffcmd(self, s);
	}
		stuffcmd(self, "\n");
		return;
	}
	if ( !TeamColorIsLegal(self.team) && (self.team == self.lastteam)) {
		self.lastteam = -1;
	}
	if (self.team != self.lastteam)	{
		if ( (teamplay & TEAM_STATIC_TEAMS) && (self.lastteam >= 0) ) {
			if ( TeamColorIsLegal(self.lastteam) ){
				if (self.suicide_count > 5) {
					sprint(self, PRINT_MEDIUM, "You were told you can't change teams.\nGo play color games somewhere else.\n");
					// stuffcmd(self, "disconnect\n");
                                        msg_entity = self;
                                        WriteByte( MSG_ONE, 2 );
					bprint(PRINT_MEDIUM, self.netname);
					bprint(PRINT_MEDIUM, " got booted for color mischief.\n");
				}
				if (self.killed != 1)
					self.killed = 2;
				self.invincible_finished = 0;
				T_Damage(self,self,self,1000);  // Kill the player
				self.suicide_count = self.suicide_count + 1;
				sprint(self, PRINT_MEDIUM, "You cannot change teams.\n");
				stuffcmd(self, "color ");
				n = TeamGetShirt(self.lastteam);
				s = ftos(n);
        if (s=="6")
        {
		stuffcmd(self, "0");
		stuffcmd(self, " ");
		stuffcmd(self, s);
	} else if (s=="8")
	{
		stuffcmd(self, s);
		stuffcmd(self, " ");
		stuffcmd(self, s);
	}
				stuffcmd(self, "\n");
				self.team = self.lastteam;
				return;
			}
			else {
				self.lastteam = -50;
			}
		}
		if(self.lastteam > 0) {
			if (self.killed != 1)
				self.killed = 2;
			T_Damage(self,self,self,1000);  // Kill the player
		}
		self.frags = 0;                 // Zero out frags
		TeamCheckTeam();
	}
};



/*****************H2CTF FLAG CODE****************/
void(entity flg) RegenFlag = {
	flg.movetype = MOVETYPE_TOSS;
	flg.solid = SOLID_TRIGGER;
	setorigin(flg, flg.oldorigin);
	flg.angles = flg.mangle;
	flg.cnt = FLAG_AT_BASE; 
	flg.owner = world;
	flg.scale = 1;
};

void(entity flg) TeamCaptureReturnFlag = {
local entity p;
	sound(flg, CHAN_BODY, self.noise1,1.0,ATTN_NORM);
	RegenFlag(flg);
	p = find(world, classname, "player");
	while (p != world) {
		if (p.team != flg.team){
			TeamPlayerUpdate(p, "Enemy flag has been returned to base!");
		}
		else if (p.team == flg.team){
			TeamPlayerUpdate(p, "Your flag has been returned to base!");
 		}
		p = find(p, classname, "player");
	}
};

void () TeamCaptureRegenFlags = {
	local entity f;
	f = find(world, classname, "item_flag_gold");
	if (f != world)
		RegenFlag(f);
	f = find(world, classname, "item_flag_silver");
	if (f != world)
		RegenFlag(f);
};

void(entity flg) TeamDropFlag = {
	// local entity item, f, oself;
	local entity p;
	p = flg.owner;
	bprint(PRINT_MEDIUM, p.netname);
	if (p.lastteam == TEAM_COLOR1)
		bprint(PRINT_MEDIUM, " lost the  flag!\n"); 
	else
		bprint(PRINT_MEDIUM, " lost the  flag!\n");
	flg.origin = p.origin - '0 0 24';
	flg.cnt = FLAG_DROPPED;
	flg.velocity_z = 300;
	flg.velocity_x = 0;
	flg.velocity_y = 0;
	flg.flags = FL_ITEM;
	flg.solid = SOLID_TRIGGER;
	flg.movetype = MOVETYPE_TOSS;
	flg.scale = 1.00000;
	setsize(flg, '-16 -16 0', '16 16 74');
	sound (flg, CHAN_VOICE, "weapons/tink1.wav", 1, ATTN_NORM);
	flg.super_time = time + TEAM_CAPTURE_FLAG_RETURN_TIME;
};

void(entity player) TeamCaptureDropFlagOfPlayer = {
	local string kn;
	local entity e;
        if (!(player.player_flag & ITEM_ENEMY_FLAG))
		return;
        if (player.lastteam == TEAM_COLOR1) 
		kn = "item_flag_silver";
	else
		kn = "item_flag_gold";
	player.player_flag = player.player_flag - ITEM_ENEMY_FLAG;
	e = find(world, classname, kn);
        if (e != world)
		TeamDropFlag(e);
};

void() TeamCaptureFlagTouch = {
local entity p;
	if (other.classname != "player")
		return;
	if (other.health <= 0)
		return;
	if (other.team != other.lastteam)
		return; // something is fishy
	if (self.lastteam == other.lastteam) {
		// same team, if the flag is *not* at the base, return
		// it to base.  we overload the 'cnt' field for this
		if (self.cnt == FLAG_AT_BASE) {
			// the flag is at home base.  if the player has the enemy
			// flag, he's just won!
			if (other.player_flag & ITEM_ENEMY_FLAG) {
				bprint(PRINT_MEDIUM, other.netname);
				if (other.team == TEAM_COLOR1)
					bprint(PRINT_MEDIUM, " captured the  flag!\n"); 
				else
					bprint(PRINT_MEDIUM, " captured the  flag!\n"); 
				other.items = other.items - (other.items & (IT_KEY1 | IT_KEY2));
				last_flag_capture = time;
				last_capture_team = other.team;
				sound (other, CHAN_VOICE, "h2ctf/capture1.wav", 1, ATTN_NONE);
				other.frags = other.frags + TEAM_CAPTURE_CAPTURE_BONUS;
				AwardExperience(other,self,3000);
				p = find(world, classname, "player");
				while (p != world) {
					self = p;
					self.killed = 0;
					if (self.lastteam == other.lastteam && self != other)
						self.frags = self.frags + TEAM_CAPTURE_TEAM_BONUS;
					if (self.lastteam != other.lastteam) {
						// *XXX* EXPERT CTF
						// reset the last_hurt_carrier variable in all enemy players, so that you don't get
						// bonuses for defending the flag carrier if the flag carrier has already
						// completed a capture
						self.last_hurt_carrier = -5;
					} else if (self.lastteam == other.lastteam) {
						// done to all players on the capturing team
						// *XXX* EXPERT CTF
						// award extra points for capture assists
						if (self.last_returned_flag + TEAM_CAPTURE_RETURN_FLAG_ASSIST_TIMEOUT > time) {
							bprint(PRINT_MEDIUM, self.netname);
							bprint(PRINT_MEDIUM, " gets an assist for returning his flag!\n");
							self.frags = self.frags + TEAM_CAPTURE_RETURN_FLAG_ASSIST_BONUS;
							AwardExperience(self,other,250);

						}
						if (self.last_fragged_carrier + TEAM_CAPTURE_FRAG_CARRIER_ASSIST_TIMEOUT > time) {
							bprint(PRINT_MEDIUM, self.netname);
							bprint(PRINT_MEDIUM, " gets an assist for fragging the flag carrier!\n");
							self.frags = self.frags + TEAM_CAPTURE_FRAG_CARRIER_ASSIST_BONUS;
							AwardExperience(self,other,250);
						}
					}
					self.player_flag = self.player_flag - (self.player_flag & ITEM_ENEMY_FLAG);
					p = find(p, classname, "player");
				}
				TeamCaptureResetUpdate();
				p = find(world, classname, "player");
				while (p != world) {
					if ((p.lastteam == TEAM_COLOR1 && other.lastteam == TEAM_COLOR2) ||
						(p.lastteam == TEAM_COLOR2 && other.lastteam == TEAM_COLOR1))
						TeamPlayerUpdate(p, "Your flag was captured!");
					else if (p.lastteam == other.lastteam)
						TeamPlayerUpdate(p, "Your team captured the flag!");
					p = find(p, classname, "player");
				}
				TeamCaptureRegenFlags();
				return;
			}
			return; // its at home base already
		}	
		// hey, its not home.  return it by teleporting it back
		bprint(PRINT_MEDIUM, other.netname);
		if (other.team == TEAM_COLOR1)
			bprint(PRINT_MEDIUM, " returned the  flag!\n"); 
		else
			bprint(PRINT_MEDIUM, " returned the  flag!\n"); 
		other.frags = other.frags + TEAM_CAPTURE_RECOVERY_BONUS;
		// *XXX* EXPERT CTF set time when player last returned his flag
		other.last_returned_flag = time;
		TeamCaptureReturnFlag(self);
		AwardExperience(other,self,250);
		return;
	}
	// hey, its not our flag, pick it up
	bprint(PRINT_MEDIUM, other.netname);
	if (other.team == TEAM_COLOR1)
		bprint(PRINT_MEDIUM, " got the  flag!\n"); 
	else
		bprint(PRINT_MEDIUM, " got the  flag!\n"); 
	if (TEAM_CAPTURE_FLAG_BONUS)
		other.frags = other.frags + TEAM_CAPTURE_FLAG_BONUS;
	TeamPlayerUpdate(other, "YOU GOT THE ENEMY FLAG!  RETURN TO BASE!");
	AwardExperience(other,self,250);
	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
	other.player_flag = other.player_flag + ITEM_ENEMY_FLAG;
	other.items = other.items | self.items;
	// *XXX* EXPERT CTF set the time at which the carrier picked up the flag
	other.flag_since = time;
	// pick up the flag
	self.cnt = FLAG_CARRIED;
	self.movetype = MOVETYPE_NOCLIP;
	self.solid = SOLID_NOT;
	self.owner = other;
	p = find(world, classname, "player");
	while (p != world) {
		if (p != other) {
			if ((p.team == TEAM_COLOR1 && other.team == TEAM_COLOR2) ||
				(p.team == TEAM_COLOR2 && other.team == TEAM_COLOR1))
				TeamPlayerUpdate(p, "Your flag has been taken!");
			else if (p.team == other.team)
				TeamPlayerUpdate(p, "Your team has the enemy flag!");
		}
		p = find(p, classname, "player");
	}
};

void() TeamCaptureFlagThink = {
	local entity e;
	local vector v;
	local float f;
	// local string s;
	self.nextthink = time + 0.1;
	if (self.cnt == FLAG_AT_BASE)
		return; // just sitting around waiting to be picked up
	if (self.cnt == FLAG_DROPPED) {
		if (time - self.super_time > TEAM_CAPTURE_FLAG_RETURN_TIME)
			TeamCaptureReturnFlag(self);
		return;
	}
	if (self.cnt != FLAG_CARRIED)
		objerror("Flag in invalid state\n");
	e = self.owner;
	if ((e.classname != "player") || (e.deadflag) ||
		(!(e.player_flag & ITEM_ENEMY_FLAG))) {
		TeamDropFlag(self);
		return;
	}
	makevectors (e.angles);
	v = v_forward;
	v_z = (-1) * v_z; // reverse z component
	f = 14;
	if (self.owner.frame >= 29 && self.owner.frame <= 40) {
		if (self.owner.frame >= 29 && self.owner.frame <= 34) { //axpain
			if      (self.owner.frame == 29) f = f + 2; 
			else if (self.owner.frame == 30) f = f + 8;
			else if (self.owner.frame == 31) f = f + 12;
			else if (self.owner.frame == 32) f = f + 11;
			else if (self.owner.frame == 33) f = f + 10;
			else if (self.owner.frame == 34) f = f + 4;
		} else if (self.owner.frame >= 35 && self.owner.frame <= 40) { // pain
			if      (self.owner.frame == 35) f = f + 2; 
			else if (self.owner.frame == 36) f = f + 10;
			else if (self.owner.frame == 37) f = f + 10;
			else if (self.owner.frame == 38) f = f + 8;
			else if (self.owner.frame == 39) f = f + 4;
			else if (self.owner.frame == 40) f = f + 2;
		}
	} else if (self.owner.frame >= 103 && self.owner.frame <= 118) {
		if      (self.owner.frame >= 103 && self.owner.frame <= 104) f = f + 6;  //nailattack
		else if (self.owner.frame >= 105 && self.owner.frame <= 106) f = f + 6;  //light 
		else if (self.owner.frame >= 107 && self.owner.frame <= 112) f = f + 7;  //rocketattack
		else if (self.owner.frame >= 112 && self.owner.frame <= 118) f = f + 7;  //shotattack
	}
	self.scale = 0.55000;
	self.origin = e.origin - f*v + v_right * 32;  
	self.origin_z = self.origin_z + 20;
	self.angles = e.angles + '0 0 45';
	setorigin (self, self.origin);
	self.nextthink = time + 0.01;
};

entity() TeamCaptureSpawn = {

	if (self.team == TEAM_COLOR1) {
                // bprint(PRINT_MEDIUM, "Respawning at Gold Base...\n");
		team1_lastspawn = find(team1_lastspawn, classname, "info_player_team1");     
		if (team1_lastspawn == world)												 
			team1_lastspawn = find(team1_lastspawn, classname, "info_player_team1");
		return team1_lastspawn;
	} else if (self.team == TEAM_COLOR2) {
                // bprint(PRINT_MEDIUM, "Respawning at Silver Base...\n");
		team2_lastspawn = find(team2_lastspawn, classname, "info_player_team2");
		if (team2_lastspawn == world)
			team2_lastspawn = find(team2_lastspawn, classname, "info_player_team2");
		return team2_lastspawn;
	}

	return world;
};


/*
	From byron@caseware.com Wed Oct 16 18:57:44 1996
	Date: Wed, 16 Oct 1996 21:22:37 -0400
	From: Byron Long <byron@caseware.com>
	To: zoid@mindlink.net
	Subject: Team Status Command (source code included) :-)
	A co-worker of mine wondered if it was possible to add a function to
	your capture the flag code that would give a status report on an
	impulse. I think he may have mailed you, but I wrote a quick version
	myself, which your welcome to use if you like the feature (it offsets
	some of the problems with the chat capabilities in Quake so it seems
	like a worthwhile feature). Feel free to change it
	as necessary.
*/

/*Capture The Flag - Status report by Wonko*/
void() TeamFlagStatusReport = {
local entity flag1, flag2, p;
	flag1 = find (world,classname, "item_flag_gold");
	flag2 = find (world,classname, "item_flag_silver");
	if (self.team != TEAM_COLOR1) {
		p = flag2;			//SWITCHED FOR H2CTF FLAGS
		flag2 = flag1;
		flag1 = p;
	}
	if (flag1 != world && flag1.cnt == FLAG_CARRIED) {
		sprint(self, PRINT_MEDIUM, flag1.owner.netname);
		sprint(self, PRINT_MEDIUM, " has your flag. ");
	} else {
		sprint(self, PRINT_MEDIUM, "Your flag is ");
		if (flag1 == world)
			sprint(self, PRINT_MEDIUM, "missing! ");
		if (flag1.cnt == FLAG_AT_BASE)
			sprint(self, PRINT_MEDIUM, "in your base. ");
		else if (flag1.cnt == FLAG_DROPPED)
			sprint(self, PRINT_MEDIUM, "lying about. ");
		else
			sprint(self, PRINT_MEDIUM, " corrupt. ");
	}
	if (flag2 != world && flag2.cnt == FLAG_CARRIED) {
		if (self == flag2.owner) 
			sprint(self, PRINT_MEDIUM, "You have the enemy flag.\n");
		else {
			sprint(self, PRINT_MEDIUM, flag2.owner.netname);
			sprint(self, PRINT_MEDIUM, " has the enemy flag.\n");
		}
	} else {
		sprint(self, PRINT_MEDIUM, "The enemy flag is ");
		if (flag2 == world)
			sprint(self, PRINT_MEDIUM, "missing!\n");
		if (flag2.cnt == FLAG_AT_BASE)
			sprint(self, PRINT_MEDIUM, "in their base.\n");
		else if (flag2.cnt == FLAG_DROPPED)
			sprint(self, PRINT_MEDIUM, "lying about.\n");
		else
			sprint(self, PRINT_MEDIUM, " corrupt.\n");
	}
};


void() place_flag = {
	self.mdl = self.model;		// so it can be restored on respawn
	self.flags = FL_ITEM;		// make extra wide
	self.solid = SOLID_TRIGGER;
	self.movetype = MOVETYPE_TOSS;	
	self.velocity = '0 0 0';
	self.origin_z = self.origin_z + 50;
	self.think = TeamCaptureFlagThink;
	self.touch = TeamCaptureFlagTouch;
	self.nextthink = time + 0.1;
	self.cnt = FLAG_AT_BASE;
	self.mangle = self.angles;
	self.effects = self.effects | EF_DIMLIGHT;
	if (!droptofloor()) {
		bprint (PRINT_MEDIUM, "Flag fell out of level at ");
		bprint (PRINT_MEDIUM, vtos(self.origin));
		bprint (PRINT_MEDIUM, "\n");
		remove(self);
		return;
	}
	self.oldorigin = self.origin; // save for flag return
};


/****GOLD FLAG****/
void() item_flag_gold = {
	self.team = TEAM_COLOR1;
	self.lastteam = TEAM_COLOR1;
	self.items = IT_KEY2;
	precache_model ("models/ctf_flag.mdl");
	setmodel (self, "models/ctf_flag.mdl");
	self.skin = 1;
	//precache_sound ("h2ctf/return1.wav"); //Fixme: return1.wav
	precache_sound ("h2ctf/alarm1.wav");			// flag taken
	precache_sound ("h2ctf/capture1.wav");			// flag capture
	precache_sound ("h2ctf/return2.wav");
	self.noise = "h2ctf/alarm1.wav";
      self.noise1 = "h2ctf/return2.wav";	
	setsize(self, '-16 -16 0', '16 16 74');
	self.nextthink = time + 0.2;	// items start after other solids
	self.think = place_flag;
};

/****SILVER FLAG****/
void() item_flag_silver = {
	self.team = TEAM_COLOR2;
	self.lastteam = TEAM_COLOR2;
	self.items = IT_KEY1;
	precache_model ("models/ctf_flag.mdl");
	setmodel (self, "models/ctf_flag.mdl");
	self.skin = 0;
	//precache_sound ("h2ctf/return.wav"); //Fixme: return1.wav
	precache_sound ("h2ctf/alarm1.wav");			// flag taken
	precache_sound ("h2ctf/capture1.wav");			// flag capture
	precache_sound ("h2ctf/return2.wav");
	self.noise = "h2ctf/alarm1.wav";
      self.noise1 = "h2ctf/return2.wav";	
	setsize(self, '-16 -16 0', '16 16 74');
	self.nextthink = time + 0.2;	// items start after other solids
	self.think = place_flag;
};



/*******************Raven OBSERVER CODE*********************/

.float oldimpulse;
.float doteamflag;
entity() SelectSpawnPoint;
void ()SetChangeParms;
void() respawn;

float() ChooseClass = {
	centerprint (self, "CHOOSE YOUR Class:@1.Paladin@2.Crusader@3.Necromancer@4.Assassin@5.RANDOM");
	if ( self.impulse == 1 || self.impulse == 2 || self.impulse == 3 || self.impulse == 4 || self.impulse==5) {
		self.observer = 0;
		if (self.impulse == 1) {
                  self.playerclass=1;
			setclass ( self, CLASS_PALADIN);
			}
		if (self.impulse == 2) {
                  self.playerclass=2;
			setclass ( self, CLASS_CRUSADER);
			}
		if (self.impulse == 3) {
                  self.playerclass=3;
			setclass ( self, CLASS_NECROMANCER);
			}
		if (self.impulse == 4) {
                  self.playerclass=4;
		      setclass ( self, CLASS_ASSASSIN);
			}
            if (self.impulse == 5) {
                  self.playerclass=0;
		      setclass ( self, CLASS_NONE);

			}

		self.impulse = 0;
		return TRUE;
	}
	return FALSE;
};

float() ChooseTeam = {
if (teamplay & TEAM_CAPTURE_SELECT_TEAM) {
	if (self.impulse == 1 || self.impulse == 2 || self.impulse == 3) {
		SetChangeParms ();
		self.killed = 0;
		if (self.impulse == 1) {
			self.team = self.lastteam = TEAM_COLOR1;
		} else {
			if (self.impulse == 2) {
				self.team = self.lastteam = TEAM_COLOR2;
			} else {
				self.lastteam = -50;
				TeamCheckTeam();
			}
		}
		if (self.lastteam == TEAM_COLOR1)  {
			bprint(PRINT_MEDIUM, self.netname);
			bprint(PRINT_MEDIUM, " joined  team!\n");			// GOLD
		    
		} else if (self.lastteam == TEAM_COLOR2) {
			bprint(PRINT_MEDIUM, self.netname);
			bprint(PRINT_MEDIUM, " joined  team!\n");		// SILVER
		}
		self.player_flag = self.player_flag | TEAM_STUFF_COLOR;
		if (self.lastteam == TEAM_COLOR1)
                    self.skin = 0;
		else
		    self.skin = 1;
		self.oldskin = self.skin;
		self.player_flag = self.player_flag - (self.player_flag & 65280);
		self.player_flag = self.player_flag | (self.skin * 256);  
		self.impulse = 0;
		return TRUE;
	}
	return FALSE;
} else {
	self.lastteam = -50;
	TeamCheckTeam();
	if (self.lastteam == TEAM_COLOR1)  {
		self.team = self.lastteam = TEAM_COLOR1;
		bprint(PRINT_MEDIUM, self.netname);
		bprint(PRINT_MEDIUM, " joined  team!\n");			// GOLD
	} else if (self.lastteam == TEAM_COLOR2) {
		self.team = self.lastteam = TEAM_COLOR2;
		bprint(PRINT_MEDIUM, self.netname);
		bprint(PRINT_MEDIUM, " joined  team!\n");		// SILVER
	}
	self.player_flag = self.player_flag | TEAM_STUFF_COLOR;
	if (self.lastteam == TEAM_COLOR1)
		self.skin = 0;
	else
	    self.skin = 1;
	self.oldskin = self.skin;

	self.player_flag = self.player_flag - (self.player_flag & 65280);
	self.player_flag = self.player_flag | (self.skin * 256);  
	self.impulse = 0;
	return TRUE;
}
   
};


void () SRavenThink = {
// local entity e;
// local float cont;
local float invcos,nvp,nvpmax,sp,svz;
// local float nv,nvs,nsp;
local vector f,vp,vs;
    self.weaponmodel = "";
	self.weaponframe = 0;
//	//  self.flags = self.flags | FL_ONGROUND;
//	svz = self.velocity_z * 0.75;
  //  self.velocity_z = 0;
//     AdvanceFrame( 96.00000, 104.00000);

    // v_forward is already normalized
//    f_x = v_forward_x; 
//    f_y = v_forward_y; 
//    f_z = 0;
//    invcos = vlen(f); if (invcos) invcos= 1/invcos; else invcos=0;
//    f = f*invcos; // normalize f
//    sp = f * self.velocity;
//    vp = sp*f;
//    nvp = vlen(vp); if (sp<0) nvp = nvp*(-1);
//    vs = self.velocity - vp;
    
//    vp = v_forward * (nvp * invcos);
//    vp_z = vp_z + svz;
//    nvp = vlen(vp);
//   nvpmax = (320 - 100*(v_forward * '0 0 1'));
//    if (nvp > nvpmax) { vp = vp * (nvpmax/nvp); }
    
  //  self.velocity = vp + vs;
  
	// make a raven noise with jump
	if (self.button2) {
		sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);	//Fixme:  Is this right?  Return2.wav is the jumping noise?
	}
    
	if (self.impulse) 
      {   
            if (self.accessparm)  // admin functions
	    {
		CheckAdminCmd();
		self.impulse = 0;
	    } else {
                if ((self.impulse!=1)&&(self.impulse!=2)&&(self.impulse!=3)&&(self.impulse!=4)&&(self.impulse!=128)&&(self.impulse!=132)&&(self.impulse!=179)&&(self.impulse!=245))
                     self.impulse = 0;
            }
	}
	
	if (self.doteamflag == 0) {
		if (ChooseTeam()) {
			self.doteamflag = 1;
			return;
		} else {

	                if ((self.impulse==1)||(self.impulse==2)||(self.impulse==3)||(self.impulse==4)||(self.impulse==128)||(self.impulse==132)||(self.impulse==179)||(self.impulse==245))  
                        {
			        CheckAdminCmd();
			        self.impulse = 0;
		    }
	    }
	}
      if (self.doteamflag == 1 && self.observer==1 ) {
	//	if (ChooseClass ()) {
           		self.observer = 0;

		      respawn ();
	//		return;
	//	}
	}
};

void(entity player) BecomeRaven = {
	self.doteamflag			= 0;
	player.health           = 999;
	player.takedamage       = DAMAGE_NO;
	player.solid            = SOLID_NOT;
	player.movetype         = MOVETYPE_FLY;
	player.deadflag         = DEAD_NO;
	player.weaponmodel      = "";
	player.weaponframe      = 0;
	player.weapon           = 0;
	player.noise1			= "raven/squawk.wav";
	setmodel (player, "models/booberry.mdl");
	setsize(player, '-12 -12 -12', '12 12 12');
	player.view_ofs = '0 0 10';
	player.observer = 1;
	player.do_observer = 0;
	stuffcmd (player, "color 5 5\n");
};


/*****************H2CTF STATUS CODE (from Siege)******************/

void ()ShowTeam = {
	//sprint (self, PRINT_MEDIUM, "team: ");
	if (self.team == 7) {
		centerprint (self,  "team: \n");
		//sprint (self, "\n");
	} else {
		if (self.team == 9) {
			centerprint (self, "team: \n");
		} else {
			centerprint (self,"Observer - no team.\n");
		}
	}
	//	sprint (self, PRINT_MEDIUM, "teammates: ");
	//  sprint (name, class, level, hit points,); 
};


/*************************************
** This is the status bar, mostly   **
**just a straight port of Threewave.**
**Any changes we made are commented.**
**************************-H2CTF*****/


.float laststattime;		// time of last status update
.float motd_count;
.float statstate;			// is the status bar on?
float teamscr1;			    // team 1's teamscr score
float teamscr2;			    // team 2's teamscr score
float lastteamscrtime;		// last time we calculated it

float TEAMSCRTIME = 1;
float PLAYERSTATTIME = 1.75;

void() MOTD = {
	if (self.motd_count < 4) {
		self.motd_count = self.motd_count + 1;
		if (gamestart) {
			centerprint(self, "Welcome to Hexen II CTF \n"); 
			return;
		}
		if (self.team == TEAM_COLOR1)
			centerprint(self, "Welcome to Hexen II CTF.\nYou are on  team\n"); //Gold Team
		else
			centerprint(self, "Welcome to Hexen II CTF.\nYou are on  team"); //Silver Team
		return;
	}
	sprint(self, PRINT_MEDIUM, "Impulse 247 to turn off status bar\n");
	// sprint(self, PRINT_MEDIUM, "Impulse 234 through 243 to set status bar resolution\n");
	// sprint(self, PRINT_MEDIUM, "234:200 235:240 236:300 237:350 238:384 239:400 240:480 241:600 242:768 243:1024\n");
	self.motd_count = 0;
};

void() MOTD_ChooseTeam = {
	if (self.motd_count < 6) {
		self.motd_count = self.motd_count + 1;
		centerprint(self, "CHOOSE YOUR TEAM: 1- 2- JUMP-CAW\n");
		return;
	}
	self.motd_count = 0;
};


void() TeamCaptureCheckUpdate = {
local entity p;
	//if (gamestart)
	//	return; // handled by vote exit  TAKEN OUT - NO VOTING IN H2CTF... YET
	if (lastteamscrtime > time)
		return;
	lastteamscrtime = time + TEAMSCRTIME;
	// count up teamscr
	teamscr1 = teamscr2 = 0;
	p = find(world, classname, "player");
	while (p != world) {
		if (p.lastteam == TEAM_COLOR1)
			teamscr1 = teamscr1 + p.frags;
		else if (p.lastteam == TEAM_COLOR2)
			teamscr2 = teamscr2 + p.frags;
		p = find(p, classname, "player");
	}
};



void() TeamCaptureResetUpdate = {
	lastteamscrtime = 0;
	TeamCaptureCheckUpdate();
};


void() TeamEndScore = {
local string s1;
	if (gamestart)
		return;
	lastteamscrtime = 0;
	TeamCaptureCheckUpdate();
	if (teamscr1 > teamscr2) {
		bprint(PRINT_MEDIUM, " team won the level with ");
		s1 = ftos(teamscr1);
		bprint(PRINT_MEDIUM, s1);
		bprint(PRINT_MEDIUM, " points!\n");
		bprint(PRINT_MEDIUM, " team lost with ");
		s1 = ftos(teamscr2);
		bprint(PRINT_MEDIUM, s1);
		bprint(PRINT_MEDIUM, " points.\n");
	} else if (teamscr1 < teamscr2) {
		bprint(PRINT_MEDIUM, " team won the level with ");
		s1 = ftos(teamscr2);
		bprint(PRINT_MEDIUM, s1);
		bprint(PRINT_MEDIUM, " points!\n");
		bprint(PRINT_MEDIUM, " team lost with ");
		s1 = ftos(teamscr1);
		bprint(PRINT_MEDIUM, s1);
		bprint(PRINT_MEDIUM, " points.\n");
	} else {
		bprint(PRINT_MEDIUM, " and  team tied level with ");
		s1 = ftos(teamscr1);
		bprint(PRINT_MEDIUM, s1);
		bprint(PRINT_MEDIUM, " points!\n");
	}
};


string(entity who) TeamSetStatRes = {
	if (who.statstate > 7) // 768 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 7) // 600 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 6) // 480 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 5) // 400
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 4) // 384 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 3) // 350 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 2) // 300 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 1) // 240 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	// 200 
	return "\n\n\n\n\n\n\n\n\n\n\n\n";
};


string(entity who) TeamSetStatRes2 = {
	if (who.statstate > 7) // 768 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 7) // 600 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 6) // 480 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 5) // 400
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 4) // 384 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 3) // 350 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 2) // 300 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	else if (who.statstate == 1) // 240 
		return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	// 200 
	return "\n\n\n\n\n\n\n\n\n\n\n";
};


void() TeamCapturePlayerUpdate = {
local entity e;
local string n, t, s1, s2, s3, res;
	if (self.laststattime > time)
		return;
	TeamCaptureCheckUpdate();
	self.laststattime = time + PLAYERSTATTIME;
	if (self.motd_count) {
		if (self.observer)
			MOTD_ChooseTeam();
		else
			MOTD();
		return;
	}
	if (self.statstate < 0)
		return;
	
	s1 = " ";      //H2CTF - Took this out for now, as it just takes up room. If something is here it will show up like a rune
	e = find(world, classname, "item_flag_gold");
	if (e.cnt == FLAG_AT_BASE)
		s2 = "..";						 //Gold Flag in home base
	else if (e.cnt == FLAG_CARRIED)
		s2 = "..";					     //Gold Flag in enemy possession
	else
		s2 = "..";                       //Gold Flag lying around

	e = find(world, classname, "item_flag_silver");
	if (e.cnt == FLAG_AT_BASE)
		s3 = ".";						 //Silver Flag in home base
	else if (e.cnt == FLAG_CARRIED)
		s3 = ".";						 //Silver Flag in enemy possession
	else
		s3 = ".";						 //Silver Flag lying around
		
	if (teamscr1 == 0 && teamscr2 == 0) {
		centerprint5(self, res, s1, s2, s3, "                        H2CTF"); //Displayed when noone has captured yet
		return;
	}
	
	if (time < (last_flag_capture + 6))
	{
		if (last_capture_team == TEAM_COLOR1)
		{
			if (teamscr1 > teamscr2) {
				t = " Capture!    ";	//Gold Captured last, and is winning
				n = ftos(teamscr1 - teamscr2);
			} else if (teamscr1 < teamscr2) {
				t = " Capture!   ";	//Gold captured last, but is losing
				n = ftos(teamscr2 - teamscr1);
			} else {
				t = " Capture!  TIED ";		//Gold captured last, game tied
				n = "";
			}
		}
		else
		{
			if (teamscr1 > teamscr2) {
				t = " Capture!   ";   //Silver Captured last, and is losing
				n = ftos(teamscr1 - teamscr2);
			} else if (teamscr1 < teamscr2) {
				t = " Capture!  ";  //Silver Captured last, and is winning
				n = ftos(teamscr2 - teamscr1);
			} else {
				t = " Capture! TIED ";    //Silver Captured last, game tied
				n = "";
			}
		}
	}
	else
	{
		if (teamscr1 > teamscr2) {
			t = "                     ";			//No recent capture, Gold leads
			n = ftos(teamscr1 - teamscr2);
		} else if (teamscr1 < teamscr2) {		//No recent capture, Silver leads
			t = "                   ";
			n = ftos(teamscr2 - teamscr1);
		} else {
			t = "                    TIED";			//No recent capture, game tied
			n = "";
		}
	}
	centerprint7(self, res, s1, s2, s3, "    ", t, n);		//Display results
};


void(entity who, string s1) TeamPlayerUpdate = {
local string n, res;
	TeamCaptureCheckUpdate();
	who.laststattime = time + PLAYERSTATTIME;
	if (who.statstate < 0) {
		centerprint(who, s1);
		return;
	}
	//res = TeamSetStatRes2(who);
	if (teamscr1 == 0 && teamscr2 == 0) {
		centerprint3(who, res, s1, "\n                             H2CTF");  //Displayed if noone has scored
	} else if (teamscr1 > teamscr2) {
		n = ftos(teamscr1 - teamscr2);
		centerprint4(who, res, s1, "\n                              ", n);
	} else if (teamscr1 < teamscr2) {
		n = ftos(teamscr2 - teamscr1);
		centerprint4(who, res, s1, "\n                              ", n);
	} else
		centerprint3(who, res, s1, "\n                             TIED");
};


void(entity who, string s1, string s2) TeamPlayerUpdate2 = {
local string n, res;
	TeamCaptureCheckUpdate();
	who.laststattime = time + PLAYERSTATTIME;
	if (who.statstate < 0) {
		centerprint2(who, s1, s2);
		return;
	}
	//res = TeamSetStatRes2(who);
	if (teamscr1 == 0 && teamscr2 == 0) {
		centerprint4(who, res, s1, s2, "\n                       H2CTF");
		return;
	} else if (teamscr1 > teamscr2) {
		n = ftos(teamscr1 - teamscr2);
		centerprint5(who, res, s1, s2, "\n                        ", n);
	} else if (teamscr1 < teamscr2) {
		n = ftos(teamscr2 - teamscr1);
		centerprint5(who, res, s1, s2, "\n                        ", n);
	} else {
		centerprint4(who, res, s1, s2, "\n                       TIED");
		return;
	}
};

