//---------------------------------------------------------------------------
//Quake
//
//Copyright (c) 1995-96 by Dave Kirsch
//---------------------------------------------------------------------------
//admin - remove server admin functions
//---------------------------------------------------------------------------
//*************************************************************
//Modified by Phayyde Hexen II H2CTF - re engineered for Gaf Central Server
//                                   - re-re-engineered for HWCTF
//*************************************************************

// NOTE:  THE FOLLOWING VALUES ARE THE PASSWORD USED TO ENABLE
// REMOTE ACCESS.
//
// They must be entered in the correct order which gives 256*256*256 or
// 16777216 possible passwords.  If a specified order wasn't given, it
// would only be 768 possibilities.
//
// Remote admin may be DISABLED
// This is done by setting the admin passwords all to -1.
//
// If you wanted to enable it, pick three random numbers (that aren't
// existing impulses) and put 'em here, for example:
//
// To use from a Hexen II client, do a bind like this:
//
// bind p "impulse 179;wait;impulse 131;wait;impulse 157"
// The way it works is after you enter the admin password, do an
// impulse 151/152/153.  You'll get a list of players on the server with their
// numbers.  Send the next impulse with the number of the player
// to act the command on.

// CHANGE THE FOLLOWING THREE -1 NUMBERS TO DISABLE ADMIN COMMANDS, SET -1/-1/-2 To allow everyone to perform admin commands
float	ADMIN_PWD_1	= -1;  // change me to first number of the passwd
float	ADMIN_PWD_2	= -1;  // change me to second number of the passwd
float	ADMIN_PWD_3	= -2;  // change me to third number of the passwd

float	ADMIN_KICK = 151;
float	ADMIN_BLESSING = 152;
float	ADMIN_CHANGEMAP = 153;
float	ADMIN_TIMELIMIT = 154;
float	ADMIN_FRAGLIMIT = 155;
float ADMIN_HOOK = 156;
float ADMIN_HUMILIATE = 157;
float ADMIN_REWARD = 158;

// used for admin to change maps
void(string nmap) AdminChangeLevel =
{
	local entity o;

	bprint(PRINT_HIGH, self.netname);
	bprint(PRINT_HIGH, " has changed the map to ");
	bprint(PRINT_HIGH, nmap);
	bprint(PRINT_HIGH, "\n");

	o = spawn();
	o.map = nmap;
	nextmap = o.map;
	gameover = TRUE;

	o.think = execute_changelevel;
	o.nextthink = time + 0.1;
};

void PrintAdminCommands()
{

	local string st;

	sprint(self, PRINT_HIGH, "Admin Impulse Codes:\n");
		st = ftos(ADMIN_KICK);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to kick\n");
		st = ftos(ADMIN_BLESSING);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to bless a player\n");
		st = ftos(ADMIN_CHANGEMAP);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to change map\n");
		st = ftos(ADMIN_TIMELIMIT);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to set timelimit\n");
		st = ftos(ADMIN_FRAGLIMIT);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to set fraglimit\n");
		st = ftos(ADMIN_HOOK);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to change the hook\n");
		st = ftos(ADMIN_HUMILIATE);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to abuse a player\n");
		st = ftos(ADMIN_REWARD);
		sprint(self, PRINT_HIGH, st);
		sprint(self, PRINT_HIGH, " to reward a player\n");
}

void() CheckAdminCmd =
{
	local float n;
	local entity p;
	local string st;

	if (ADMIN_PWD_1 < 0 || ADMIN_PWD_2 < 0 || ADMIN_PWD_3 < 0 && ADMIN_PWD_3 > -2)
	{
		sprint(self, PRINT_HIGH, "Admin commands disabled!\n");
		return;	//Disabled
	}
	else
		self.accesslvl = 3;
		

	if (self.impulse == ADMIN_PWD_1 && self.accesslvl == 0) {
		self.accesslvl = self.accesslvl + 1;
		return;

	} else if (self.impulse == ADMIN_PWD_2 && self.accesslvl == 1) {
		self.accesslvl = self.accesslvl + 1;
		return;

	} else if (self.impulse == ADMIN_PWD_3 && self.accesslvl == 2) {
		self.accesslvl = self.accesslvl + 1;

		bprint(PRINT_HIGH, self.netname);
		bprint(PRINT_HIGH, " has become a sysop\n");

		PrintAdminCommands ();
	

		self.accessparm = 0;
		return;
	}

	if (self.accesslvl < 3) {
		self.accesslvl = 0;
		self.accessparm = 0;
		return; // must be a sysop beyond this point
	}

	if (self.accessparm == 1) { // kick cmd

		n = self.impulse - 1;
		p = find(world, classname, "player");
		while (p != world && n > 0) {
			p = find(p, classname, "player");
			n = n - 1;
		}

		if (p != world) {
			sprint(p, PRINT_HIGH, "\nYOU HAVE BEEN KICKED.\nDON'T LET THE DOOR HIT YOU ON THE...\ndisconnected\n");
                        msg_entity = p;
                        WriteByte( MSG_ONE, 2 );

			bprint(PRINT_HIGH, p.netname);
			bprint(PRINT_HIGH, " was kicked by ");
			bprint(PRINT_HIGH, self.netname);
			bprint(PRINT_HIGH, "\n");
		} else {
			sprint(self, PRINT_HIGH, "Can't kick #");
			st = ftos(self.impulse);
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, "\n");
		}

		self.accessparm = 0;
		return;

	} else if (self.accessparm == 2) { // bestow a blessing
		n = self.impulse - 1;
		p = find(world, classname, "player");
		while (p != world && n > 0) {
			p = find(p, classname, "player");
			n = n - 1;
		}

		if (p != world) {
			centerprint(p, "YOU HAVE BEEN BLESSED!");
			stuffcmd(p, "bf\n");
                  
                 
			p.items(+)IT_WEAPON1|IT_WEAPON2|IT_WEAPON3|IT_WEAPON4|IT_WEAPON4_1|IT_WEAPON4_2;

			p.bluemana = self.max_mana;
			p.greenmana = self.max_mana;
			p.cnt_summon = 5;
			p.cnt_glyph = 20;
			p.cnt_blast = 2;
			p.cnt_polymorph = 10;
			p.cnt_flight = 2;
			p.cnt_cubeofforce = 10;
			p.cnt_invincibility = 2;
			p.cnt_invisibility = 5;
			p.cnt_haste = 10;
			p.cnt_mana_boost = 10;
			p.cnt_sh_boost = 2;
			p.cnt_h_boost = 10;
			p.cnt_teleport = 10;
			p.cnt_tome = 5;
			p.cnt_torch = 20;

			sprint(self, PRINT_HIGH, "You just blessed ");
                  sprint(self, PRINT_HIGH, p.netname);
                  sprint(self, PRINT_HIGH, ".\n");

		} else {
			sprint(self, PRINT_HIGH, "Can't change #");
			st = ftos(self.impulse);
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, "\n");
		}

		self.accessparm = 0;
		return;

	} else if (self.accessparm == 3) { // select episode

		if (self.impulse == 1) {
			self.accessparm = 4;

			sprint(self, PRINT_HIGH, "Choose Level:\n");
			sprint(self, PRINT_HIGH, "1 Demo1 - Blackmarsh\n");
			sprint(self, PRINT_HIGH, "2 Demo2 - Barbican\n");
			sprint(self, PRINT_HIGH, "3 Demo3 - The Mill\n");
			sprint(self, PRINT_HIGH, "4 Village1 - King's Court\n");
			sprint(self, PRINT_HIGH, "5 Village2 - Inner Courtyard\n");
			sprint(self, PRINT_HIGH, "6 Village3 - Stables\n");
			sprint(self, PRINT_HIGH, "7 Village4 - Palace Entrance\n");
			sprint(self, PRINT_HIGH, "8 Village5 - Forgotten Chapel\n");
			sprint(self, PRINT_HIGH, "9 rider1a - Famine's Domain\n");
			self.impulse = 0;
			return;
		
		} else if (self.impulse == 2) {
			self.accessparm = 5;
			sprint(self, PRINT_HIGH, "Choose Level:\n");
			sprint(self, PRINT_HIGH, "1 Meso1 - Palace of Columns\n");
			sprint(self, PRINT_HIGH, "2 Meso2 - Plaza of the Sun\n");
			sprint(self, PRINT_HIGH, "3 Meso3 - Square of the Stream\n");
			sprint(self, PRINT_HIGH, "4 Meso4 - Tomb of Hi-Priest\n");
			sprint(self, PRINT_HIGH, "5 Meso5 - Obelisk of the Moon\n");
			sprint(self, PRINT_HIGH, "6 Meso6 - Court of 1K Warriors\n");
			sprint(self, PRINT_HIGH, "7 Meso8 - Bridge of Stars\n");
			sprint(self, PRINT_HIGH, "8 Meso9 - Well of Souls\n");
			self.impulse = 0;
			return;

		} else if (self.impulse == 3) {
			self.accessparm = 6;
			sprint(self, PRINT_HIGH, "Choose Level:\n");
			sprint(self, PRINT_HIGH, "1 Egypt1 - Temple of Horus\n");
			sprint(self, PRINT_HIGH, "2 Egypt2 - Ancient Nefertum\n");
			sprint(self, PRINT_HIGH, "3 Egypt3 - Current Nefertum\n");
			sprint(self, PRINT_HIGH, "4 Egypt4 - Palace of Pharoah\n");
			sprint(self, PRINT_HIGH, "5 Egypt5 - Pyramid of Anubis\n");
			sprint(self, PRINT_HIGH, "6 Egypt6 - Temple of Light\n");
			sprint(self, PRINT_HIGH, "7 Egypt7 - Shrine of Naos\n");
			sprint(self, PRINT_HIGH, "8 rider2c - Pestilence's Lair\n");
			self.impulse = 0;
			return;

		} else if (self.impulse == 4) {
			self.accessparm = 7;
			sprint(self, PRINT_HIGH, "Choose Level:\n");
			sprint(self, PRINT_HIGH, "1 Romeric1 - Hall of Heroes\n");
			sprint(self, PRINT_HIGH, "2 Romeric2 - Gardens of Athena\n");
			sprint(self, PRINT_HIGH, "3 Romeric3 - Forum of Zeus\n");
			sprint(self, PRINT_HIGH, "4 Romeric4 - Baths of Demetrios\n");
			sprint(self, PRINT_HIGH, "5 Romeric5 - Temple of Mars\n");
			sprint(self, PRINT_HIGH, "6 Romeric6 - Coliseum of War\n");
			sprint(self, PRINT_HIGH, "7 Romeric7 - Reflecting Pool\n");
			self.impulse = 0;
			return;

		} else if (self.impulse == 5) {
			self.accessparm = 8;

			sprint(self, PRINT_HIGH, "Choose Level:\n");
			sprint(self, PRINT_HIGH, "1 Cath - Cathedral\n");
			sprint(self, PRINT_HIGH, "2 Tower - Tower of the Dark Mage\n");
			sprint(self, PRINT_HIGH, "3 Castle4 - The Underhalls\n");
			sprint(self, PRINT_HIGH, "4 Castle5 - Eidolon's Ordeal\n");
			sprint(self, PRINT_HIGH, "5 Eidolon - Eidolon's Lair\n");
			self.impulse = 0;
			return;
		} else if (self.impulse == 6) {
			self.accessparm = 9;

			sprint(self, PRINT_HIGH, "Choose Level:\n");
			sprint(self, PRINT_HIGH, "1 RavDM1 - Atrium of Immolation\n");
			sprint(self, PRINT_HIGH, "2 RavDM2 - Total Carnage\n");
			sprint(self, PRINT_HIGH, "3 RavDM3 - Reckless Abandon\n");
			sprint(self, PRINT_HIGH, "4 RavDM4 - Temple of RA\n");
			sprint(self, PRINT_HIGH, "5 RavDM5 - Tom Foolery\n");
			self.impulse = 0;
			return;
		} else if (self.impulse == 7) {
			self.accessparm = 10;

			sprint(self, PRINT_HIGH, "Extreme CAUTION:\n");
			sprint(self, PRINT_HIGH, "Server WILL crash if you mess up.\n");
			sprint(self, PRINT_HIGH, "Set your NAME to new level name.\n");
			sprint(self, PRINT_HIGH, "Do NOT include the .bsp extension.\n");
			sprint(self, PRINT_HIGH, "When you are ready, hit\n");
			sprint(self, PRINT_HIGH, "impulse 1.  Level will change.\n");
			self.impulse = 0;
			return;
		}

		sprint(self, PRINT_HIGH, "Invalid Selection\n");
		self.accessparm = 0;
		return;

	} else if (self.accessparm == 4) {

		if (self.impulse == 1)		AdminChangeLevel("demo1");
		else if (self.impulse == 2)	AdminChangeLevel("demo2");
		else if (self.impulse == 3)	AdminChangeLevel("demo3");
		else if (self.impulse == 4)	AdminChangeLevel("village1");
		else if (self.impulse == 5)	AdminChangeLevel("village2");
		else if (self.impulse == 6)	AdminChangeLevel("village3");
		else if (self.impulse == 7)	AdminChangeLevel("village4");
		else if (self.impulse == 8)	AdminChangeLevel("village5");
		else if (self.impulse == 9)	AdminChangeLevel("rider1a");
		else sprint(self, PRINT_HIGH, "Invalid map\n");
		self.impulse = 0;
		self.accessparm = 0;
		return;
			
	} else if (self.accessparm == 5) {

		if (self.impulse == 1)		AdminChangeLevel("meso1");
		else if (self.impulse == 2)	AdminChangeLevel("meso2");
		else if (self.impulse == 3)	AdminChangeLevel("meso3");
		else if (self.impulse == 4)	AdminChangeLevel("meso4");
		else if (self.impulse == 5)	AdminChangeLevel("meso5");
		else if (self.impulse == 6)	AdminChangeLevel("meso6");
		else if (self.impulse == 7)	AdminChangeLevel("meso8");
		else if (self.impulse == 8)	AdminChangeLevel("meso9");
		else sprint(self, PRINT_HIGH, "Invalid map\n");
		self.impulse = 0;
		self.accessparm = 0;
		return;
			
	} else if (self.accessparm == 6) {

		if (self.impulse == 1)		AdminChangeLevel("egypt1");
		else if (self.impulse == 2)	AdminChangeLevel("egypt2");
		else if (self.impulse == 3)	AdminChangeLevel("egypt3");
		else if (self.impulse == 4)	AdminChangeLevel("egypt4");
		else if (self.impulse == 5)	AdminChangeLevel("egypt5");
		else if (self.impulse == 6)	AdminChangeLevel("egypt6");
		else if (self.impulse == 7)	AdminChangeLevel("egypt7");
		else if (self.impulse == 8)	AdminChangeLevel("rider2c");
		else sprint(self, PRINT_HIGH, "Invalid map\n");
		self.impulse = 0;
		self.accessparm = 0;
		return;
			
	} else if (self.accessparm == 7) {

		if (self.impulse == 1)		AdminChangeLevel("romeric1");
		else if (self.impulse == 2)	AdminChangeLevel("romeric2");
		else if (self.impulse == 3)	AdminChangeLevel("romeric3");
		else if (self.impulse == 4)	AdminChangeLevel("romeric4");
		else if (self.impulse == 5)	AdminChangeLevel("romeric5");
		else if (self.impulse == 6)	AdminChangeLevel("romeric6");
		else if (self.impulse == 7)	AdminChangeLevel("romeric7");
		else sprint(self, PRINT_HIGH, "Invalid map\n");
		self.impulse = 0;
		self.accessparm = 0;
		return;
			
	} else if (self.accessparm == 8) {

		if (self.impulse == 1)		AdminChangeLevel("cath");
		else if (self.impulse == 2)	AdminChangeLevel("tower");
		else if (self.impulse == 3)	AdminChangeLevel("castle4");
		else if (self.impulse == 4)	AdminChangeLevel("castle5");
		else if (self.impulse == 5)	AdminChangeLevel("eidolon");
		else sprint(self, PRINT_HIGH, "Invalid map\n");
		self.impulse = 0;
		self.accessparm = 0;
		return;
			
	} else if (self.accessparm == 9) {
		if (self.impulse == 1)		AdminChangeLevel("ravdm1");
		else if (self.impulse == 2)	AdminChangeLevel("ravdm2");
		else if (self.impulse == 3)	AdminChangeLevel("ravdm3");
		else if (self.impulse == 4)	AdminChangeLevel("ravdm4");
		else if (self.impulse == 5)	AdminChangeLevel("ravdm5");
		else sprint(self, PRINT_HIGH, "Invalid map\n");
		self.impulse = 0;
		self.accessparm = 0;
		return;
			
	} else if (self.accessparm == 10) {

		sprint(self, PRINT_HIGH, "Attempting to change level to\n");
		sprint(self, PRINT_HIGH, "map ");
		sprint(self, PRINT_HIGH, self.netname);
		sprint(self, PRINT_HIGH, " via UseName Admin Command.\n");
            AdminChangeLevel(self.netname);

		self.impulse = 0;
		self.accessparm = 0;
		return;

	
	} else if (self.accessparm == 21) { // time limit
		st = ftos(self.impulse);
		localcmd("timelimit ");
		localcmd(st);
		localcmd("\n");
		self.accessparm = 0;
		return;

	} else if (self.accessparm == 22) { // frag limit
		st = ftos(self.impulse);
		localcmd("scorelimit ");
		localcmd(st);
		localcmd("\n");
		self.accessparm = 0;
		return;

	} else if (self.accessparm == 23) { // hook stuff
            hookdam = self.impulse - 1;
		self.accessparm = 0;
		return;

	} else if (self.accessparm == 24) { // Humiliation
		n = self.impulse - 1;
		p = find(world, classname, "player");
		while (p != world && n > 0) {
			p = find(p, classname, "player");
			n = n - 1;
		}

		if (p != world) {
			centerprint(p, "YOU ARE BEING\n\nPUBLICLY HUMILIATED!");
			stuffcmd(p, "bf\n");
                  
			sprint(self, PRINT_HIGH, "You are humiliating ");
                  sprint(self, PRINT_HIGH, p.netname);
                  sprint(self, PRINT_HIGH, ".\n");
                  
			local float temphealth;
                  local string humilcoords;
			temphealth=p.health;
			Polymorph(p);
                  p.scale=0.3;
			other=p;
                  LatchOn();
			p.artifact_active=ART_INVINCIBILITY;
			p.invincible_time = time + 12;
			p.artifact_low(+)ART_INVINCIBILITY;
                  p.health=temphealth;


			bprint(PRINT_HIGH, p.netname);
			bprint(PRINT_HIGH, " is being publicy humiliated (by ");
			bprint(PRINT_HIGH, self.netname);
			bprint(PRINT_HIGH, ")\n");
                  bprint(PRINT_HIGH, "Watch him squirm at ");
			humilcoords = vtos(p.origin);
                  bprint(PRINT_HIGH, humilcoords);
                  bprint(PRINT_HIGH, "\n");
		} else {
			sprint(self, PRINT_HIGH, "Can't humiliate #");
			st = ftos(self.impulse);
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, "\n");
		}

		self.accessparm = 0;
		return;


	} else if (self.accessparm == 25) { // Reward
		n = self.impulse - 1;
		p = find(world, classname, "player");
		while (p != world && n > 0) {
			p = find(p, classname, "player");
			n = n - 1;
		}

		if (p != world) {
			centerprint(p, "YOU HAVE BEEN REWARDED\n\nWITH A RING OF FLIGHT");
			stuffcmd(p, "bf\n");
                  p.cnt_flight+=1;
		} else {
			sprint(self, PRINT_HIGH, "Can't reward #");
			st = ftos(self.impulse);
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, "\n");
		}

		self.accessparm = 0;
		return;


	}




	self.accessparm = 0;

	if (self.impulse == ADMIN_KICK) {

		sprint(self, PRINT_HIGH, "Kick:\n");
		p = find(world, classname, "player");
		n = 1;
		while (p != world) {
			st = ftos(n);
			if (n < 10)
				sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, p.netname);
			sprint(self, PRINT_HIGH, "\n");
			p = find(p, classname, "player");
			n = n + 1;
		}

		self.accessparm = 1;

	} else if (self.impulse == ADMIN_BLESSING) {

		sprint(self, PRINT_HIGH, "Bless:\n");
		p = find(world, classname, "player");
		n = 1;
		while (p != world) {
			st = ftos(n);
			if (n < 10)
				sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, p.netname);
			sprint(self, PRINT_HIGH, "\n");
			p = find(p, classname, "player");
			n = n + 1;
		}

		self.accessparm = 2;

	} else if (self.impulse == ADMIN_CHANGEMAP) {
		sprint(self, PRINT_HIGH, "Select Hub:\n");
		sprint(self, PRINT_HIGH, "1 Blackmarsh\n");
		sprint(self, PRINT_HIGH, "2 Mazaera\n");
		sprint(self, PRINT_HIGH, "3 Thysis\n");
		sprint(self, PRINT_HIGH, "4 Septimus\n");
		sprint(self, PRINT_HIGH, "5 Return to Blackmarsh\n");
		sprint(self, PRINT_HIGH, "6 Deathmatch\n");
		sprint(self, PRINT_HIGH, "7 Use Name\n");

		
		self.accessparm = 3;

	} else if (self.impulse == ADMIN_TIMELIMIT) {
		sprint(self, PRINT_HIGH, "Enter new timelimit via impulse\n");
		self.accessparm = 21;

	} else if (self.impulse == ADMIN_FRAGLIMIT) {
		sprint(self, PRINT_HIGH, "Enter new fraglimit via impulse\n");
		self.accessparm = 22;

	} else if (self.impulse == ADMIN_HOOK) {
		sprint(self, PRINT_HIGH, "Enter new hook setting via impulse\n");
		sprint(self, PRINT_HIGH, "1 - No Hook\n");
		sprint(self, PRINT_HIGH, "Above 2 - Sets damage when hooking a player.\n");
		sprint(self, PRINT_HIGH, "(impulse - 1 = damage)\n");
		sprint(self, PRINT_HIGH, "For example, 51 means 50 damage/second.\n");
		self.accessparm = 23;

	} else if (self.impulse == ADMIN_HUMILIATE) {

		sprint(self, PRINT_HIGH, "Humiliate:\n");
		p = find(world, classname, "player");
		n = 1;
		while (p != world) {
			st = ftos(n);
			if (n < 10)
				sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, p.netname);
			sprint(self, PRINT_HIGH, "\n");
			p = find(p, classname, "player");
			n = n + 1;
		}

		self.accessparm = 24;

	}  else if (self.impulse == ADMIN_REWARD) {

		sprint(self, PRINT_HIGH, "Reward:\n");
		p = find(world, classname, "player");
		n = 1;
		while (p != world) {
			st = ftos(n);
			if (n < 10)
				sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, st);
			sprint(self, PRINT_HIGH, " ");
			sprint(self, PRINT_HIGH, p.netname);
			sprint(self, PRINT_HIGH, "\n");
			p = find(p, classname, "player");
			n = n + 1;
		}

		self.accessparm = 25;

	} 



	self.impulse = 0;
	return;
};


