
float() crandom;	

/*	

PackToss.hc	
This module was written for the Siege mod by Spencer Jones (Phayyde) on 10/06/97
Any player invoking PT_TossBackpack() will throw a glowing backpack
containing the currently selected weapon and a quarter of the mana 
required by that weapon.  If weapon1 is selected, the backpack will 
be empty.  This allows fake backpacks to be thrown as "bait".  
Empty backpacks glow just like full ones do.  This allows a 
player to light up a dark area at no cost.  If this behavior 
is not desirable, it can be changed.  Packs exist for ten minutes.

*/	
	

void() PT_BackpackTouch=	
{		
        // While this touch func is active (for the first 2 seconds)
        // the owner can't get his own pack.  This gives the newly
        // created pack enough time to get away from the owner.  
	if ( (other != self.owner) && (other.classname == "player") )
        {
                // The pack was gobbled up so quickly
                // that the owner didn't even really
                // use a pack.  He just sort of 
                // handed his weapon over. 
                // This encourages precision and proximity
                // when tossing weapons.
                self.owner.backpacks += 1;

                // Consequently, the recipient, didn't get the
                // pack either, so decrement his pack count now
                // BackpackTouch will bump it back up so the
                // net result is no extra backpack for the recipient.
                other.backpacks -=1;

		BackpackTouch();
        }
};		

void() PT_BackpackRemove=		
{		
        // Bag is unstable!  It starts to glow brightly!
        self.effects (+) EF_BRIGHTLIGHT;  // Make it shine.
        // Removing Backpack... 
	self.nextthink = time + 1;	
	self.think = SUB_Remove;	
};		
		
void() PT_BackpackSetup=		
{		
        // Straighten up the pack.
        self.velocity_z = 0;
        self.velocity_x = 90;
        self.velocity_y = 0;
	self.angles = vectoangles(self.velocity);
        self.hull=HULL_POINT;
	setorigin(self, (self.origin + '0 0 40') );
        // self.drawflags(+)SCALE_ORIGIN_BOTTOM;
        // Setup the touch func...
	self.touch = BackpackTouch;	

        // Remove Backpack after 10 minutes... 
	self.nextthink = time + 600;	
	self.think = PT_BackpackRemove;	
};		
		
void() PT_TossBackpack =		
{		
    
    if ( self.backpacks >= 1 ) 
    {
        
// Pack creation and initialization.
	local entity	backpack;
		
	backpack = spawn();	
	backpack.items = backpack.greenmana  = backpack.bluemana = 0; 	
		
		
// Set up the toss velocity.
	makevectors (self.v_angle);	
	backpack.origin = self.origin;	
	backpack.velocity = v_forward*300 + v_up * 500 + crandom()*v_right*10 + crandom()*v_up*10;	
//	backpack.velocity = v_forward*300 + v_up * 500 + crandom()*v_up*10;	
	backpack.avelocity = '300 300 300';	

	backpack.angles = vectoangles(backpack.velocity);	
		
// Fill the pack as appropriate.
	if (self.weapon == IT_WEAPON2)			
	{			
		backpack.items = IT_WEAPON2;		
		self.items = self.items - IT_WEAPON2;	
                if ( self.bluemana >= 4 ) {	
		   backpack.bluemana = rint( self.bluemana / 4 );		
		   self.bluemana = self.bluemana - backpack.bluemana; 	
                }	
		
	}			
	else if (self.weapon == IT_WEAPON3)			
	{			
		backpack.items = IT_WEAPON3;		
		self.items = self.items - IT_WEAPON3;		
                if ( self.greenmana >= 4 ) {	
		   backpack.greenmana = rint(self.greenmana / 4);		
		   self.greenmana = self.greenmana - backpack.greenmana; 	
                }	

	}			
	else if (self.weapon == IT_WEAPON4)			
	{			
		backpack.items = IT_WEAPON4;		
		self.items = self.items - IT_WEAPON4;		
                if ( self.bluemana >= 4 ) {	
		   backpack.bluemana = rint(self.bluemana / 4);		
		   self.bluemana = self.bluemana - backpack.bluemana; 	
                }	
                if ( self.greenmana >= 4 ) {	
		   backpack.greenmana = rint(self.greenmana / 4);		
		   self.greenmana = self.greenmana - backpack.greenmana; 	
                }	
	}  
// else {

// Want different behavior for packs when WEAPON1 is selected?  Here is the place.

//       }

// Set up attributes of the pack.	

	backpack.owner = self;	
	backpack.flags (+) FL_ITEM;	
	backpack.solid = SOLID_TRIGGER;	
	backpack.movetype = MOVETYPE_TOSS;	
	backpack.touch = PT_BackpackTouch;	
		
// This 1 second delay gives the Pack enough time to escape
// the touch radius of the tosser.  
	backpack.nextthink = time + 2;
	backpack.think = PT_BackpackSetup;

	backpack.effects (+) EF_DIMLIGHT;  // Make it glow.

	setmodel (backpack, "models/bag.mdl");
	setsize(backpack, '-16 -16 0', '16 16 56');
        
        // Don't change weapon if we are setting decoys...
        if ( self.weapon != IT_WEAPON1 )
        {
                W_BestWeapon();
	        W_SetCurrentAmmo();	
        }
   
        self.backpacks -= 1;

    } else {
        sprint( self, PRINT_MEDIUM, "Sorry, you have no spare Backpacks.\n");
    }

};