/*
 * Unbsp.c - Uses the routines in the QEU library to extract data
 *           from a Quake BSP file.
 *
 * Do whatever you want with this file, but don't blame me if
 * something doesn't work.  If you manage to destroy your hard disk
 * with it, that's too bad for you...  Use it at your own risks!
 */

#include "qeu.h"
#include "q_misc.h"
#include "q_files.h"
#include "f_bsp.h"

Bool UnEntities(FILE *outf, FILE *bspfile, UInt32 offset, BSPDirPtr dir, char *entfilename);

void main(int argc, char *argv[])
{
  char      *filename = NULL;
  FILE      *file;
  int        ftype;
  BSPDirPtr  dir;
  UInt16     dirsize;
  Bool       view = FALSE;
  char      *dirname = NULL;

  /* read the parameters... */
  for (argv++, argc--; argc && **argv == '-'; argv++, argc--)
    if ((*argv)[1] == 'h')
      {
	fprintf(stderr, "UNBSP %s by Raphael Quinet\n\n", QEU_VERSION);
	fprintf(stderr, "Usage: unbsp [-h] [-v] [-d <directory>] file.bsp [entryname...]\n");
	fprintf(stderr, "       -h  -- display this help screen\n");
	fprintf(stderr, "       -v  -- view the contents of the bsp file without extracting any data\n");
	fprintf(stderr, "       -d  -- use the specified directory for extraction\n");
	fprintf(stderr, "By default, unbsp will extract all entries from the BSP file in a directory\n");
	fprintf(stderr, "which has the same name as the BSP file but the extension '.dir'.  If some\n");
	fprintf(stderr, "names are given after the file name, only these entries will be extracted.\n");
	exit(1);
      }
    else if ((*argv)[1] == 'v')
      view = TRUE;
    else if ((*argv)[1] == 'd' && argc-- > 1)
      dirname = *++argv;
    else
      ProgError("Invalid argument (%s).  Use unbsp -h for help.", *argv);
  if (argc > 0)
    filename = *argv;
  else
    ProgError("Missing argument.  Use unbsp -h for help.");
  if (dirname == NULL)
    dirname = ChangeFileExtension(filename, NULL, "dir");

  /* open the BSP file... */
  file = OpenFileReadMagic(filename, &ftype);
  if (file == NULL)
    ProgError("File not found (%s)", filename);

  if (ftype != FTYPE_BSP)
    ProgError("File is not a BSP file (%s)", filename);

  /* do something... */
  dir = ReadBSPDirectory(file, 0, &dirsize);
  if (dir == NULL)
    ProgError("Cannot read main directory from %s", filename);
  if (view == TRUE)
    DumpBSPDirectory(stdout, dir, dirsize);
  else
    {
      if (UnEntities(stdout, file, 0, dir, "homer.ent") == FALSE)
	ProgError("Could not unpack all entries from %s", filename);
    }
  
  /* close the file and say goodbye */
  fclose(file);
  exit(0);
}
