/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

#ifndef _F_BSP_H_
#define _F_BSP_H_
/*
 * F_BSP.H - Read and write Quake BSP files.
 */

/*
 * The BSPDirectory structure is the structure used by QUAKE to order the
 * chunks in its BSP files.
 */
typedef struct BSPDirectory *BSPDirPtr;
struct BSPDirectory
{
   UInt32 offset;               /* offset to start of data */
   UInt32 size;                 /* byte size of data */
};

BSPDirPtr ReadBSPDirectory(FILE *bspfile, UInt32 offset, UInt16 *dirsize_r);
void      DumpBSPDirectory(FILE *outf, BSPDirPtr dir, UInt16 dirsize);
Bool      UnBSPFile(FILE *outf, FILE *bspfile, UInt32 offset,
		    BSPDirPtr dir, UInt16 dirsize, UInt16 entrynum,
		    char *prefixpath);

#endif /* _F_BSP_H_ */
/* end of file */
