#include <iostreams.h>
#include <fstream.h>

#include "dict2.h"
#include "word.h"


// words class for en/pro-clitics, etc.

Word::Word(char *word) : Item(word)
{
}

void Word::Write(ostream &out)
{
  out << Name() << '\n';
}

void Words::add(char *word)
{
  Words_iter iter(*this);
  Word *found;
  if (!iter.find(word))
    iter.add(new Word(word));
}

void Words::Write(ostream &out)
{
  Words_iter iter(*this);
  iter.first();
  Word *curr;
  while (curr = iter.current()) {
    curr->Write(out);
    iter.next();
  }
  cout.flush();
}

void Words::Read(istream &in)
{
  Words_iter procl_iter(*this);
  procl_iter.ReadWords(in);
}

void Words::Read(char *filename)
{
  ifstream  procl_f(filename);
  Read(procl_f);
}

int Words_iter::ReadWords(istream &in)
{
  char word[256];

  if (Valid()) {
    while (in >> word) {
      add(new Word(word));
    }
    return 1;
  }
  else return 0;
}

